/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.collections.poolable;

import com.singularity.ee.util.collections.poolable.PoolableEntry;
import com.singularity.ee.util.collections.poolable.PoolableEntryFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class PoolingHashMap<K, V>
implements Map<K, V>,
Cloneable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient PoolableEntry<K, V>[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    transient Set<K> keySet = null;
    transient Collection<V> values = null;
    final PoolableEntryFactory<K, V> entryFactory;
    private transient Set<Map.Entry<K, V>> entrySet = null;

    public PoolingHashMap(int initialCapacity, float loadFactor, PoolableEntryFactory<K, V> entryFactory) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new PoolableEntry[capacity];
        this.entryFactory = entryFactory;
    }

    public PoolingHashMap(int initialCapacity, PoolableEntryFactory<K, V> entryFactory) {
        this(initialCapacity, 0.75f, entryFactory);
    }

    public PoolingHashMap(PoolableEntryFactory<K, V> entryFactory) {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new PoolableEntry[16];
        this.entryFactory = entryFactory;
    }

    public PoolingHashMap(Map<? extends K, ? extends V> m, PoolableEntryFactory<K, V> entryFactory) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f, entryFactory);
        super.putAllForCreate(m);
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return this.getForNullKey();
        }
        int hash = PoolingHashMap.hash(key.hashCode());
        PoolableEntry<K, V> e = this.table[PoolingHashMap.indexFor(hash, this.table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    private V getForNullKey() {
        PoolableEntry<K, V> e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    final PoolableEntry<K, V> getEntry(Object key) {
        int hash = key == null ? 0 : PoolingHashMap.hash(key.hashCode());
        PoolableEntry<K, V> e = this.table[PoolingHashMap.indexFor(hash, this.table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            return this.putForNullKey(value);
        }
        int hash = PoolingHashMap.hash(key.hashCode());
        int i = PoolingHashMap.indexFor(hash, this.table.length);
        PoolableEntry<K, V> e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i);
        return null;
    }

    private V putForNullKey(V value) {
        PoolableEntry<K, V> e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(0, null, value, 0);
        return null;
    }

    private void putForCreate(K key, V value) {
        int hash = key == null ? 0 : PoolingHashMap.hash(key.hashCode());
        int i = PoolingHashMap.indexFor(hash, this.table.length);
        PoolableEntry<K, V> e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, key, value, i);
    }

    private void putAllForCreate(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.putForCreate(e.getKey(), e.getValue());
        }
    }

    void resize(int newCapacity) {
        PoolableEntry<K, V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        PoolableEntry[] newTable = new PoolableEntry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(PoolableEntry[] newTable) {
        PoolableEntry<K, V>[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            PoolableEntry next;
            PoolableEntry<K, V> e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = PoolingHashMap.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        PoolableEntry<K, V> e = this.removeEntryForKey(key);
        if (e == null) {
            return null;
        }
        Object value = e.value;
        this.entryFactory.returnEntry(e);
        return value;
    }

    final PoolableEntry<K, V> removeEntryForKey(Object key) {
        PoolableEntry<K, V> prev;
        int hash = key == null ? 0 : PoolingHashMap.hash(key.hashCode());
        int i = PoolingHashMap.indexFor(hash, this.table.length);
        PoolableEntry<K, V> e = prev = this.table[i];
        while (e != null) {
            Object k;
            PoolableEntry next = e.next;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    final PoolableEntry<K, V> removeMapping(Object o) {
        PoolableEntry<K, V> prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)o;
        Object key = entry.getKey();
        int hash = key == null ? 0 : PoolingHashMap.hash(key.hashCode());
        int i = PoolingHashMap.indexFor(hash, this.table.length);
        PoolableEntry<K, V> e = prev = this.table[i];
        while (e != null) {
            PoolableEntry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    @Override
    public void clear() {
        ++this.modCount;
        PoolableEntry<K, V>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            PoolableEntry<K, V> next = tab[i];
            PoolableEntry<K, V> entry = tab[i];
            while (next != null) {
                next = entry.next;
                this.entryFactory.returnEntry(entry);
                entry = next;
            }
            tab[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        PoolableEntry<K, V>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            PoolableEntry<K, V> e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        PoolableEntry<K, V>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            PoolableEntry<K, V> e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Object clone() {
        PoolingHashMap result = null;
        try {
            result = (PoolingHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        result.table = new PoolableEntry[this.table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.putAllForCreate(this);
        return result;
    }

    void addEntry(int hash, K key, V value, int bucketIndex) {
        PoolableEntry<K, V> e = this.table[bucketIndex];
        PoolableEntry<K, V> entry = this.entryFactory.checkoutEntry();
        entry.initialize(hash, key, value, e);
        this.table[bucketIndex] = entry;
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, K key, V value, int bucketIndex) {
        PoolableEntry<K, V> e = this.table[bucketIndex];
        PoolableEntry<K, V> entry = this.entryFactory.checkoutEntry();
        entry.initialize(hash, key, value, e);
        this.table[bucketIndex] = entry;
        ++this.size;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet0();
    }

    private Set<Map.Entry<K, V>> entrySet0() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator<Map.Entry<K, V>> i = this.size > 0 ? this.entrySet0().iterator() : null;
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        if (i != null) {
            while (i.hasNext()) {
                Map.Entry<K, V> e = i.next();
                s.writeObject(e.getKey());
                s.writeObject(e.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new PoolableEntry[numBuckets];
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.putForCreate(key, value);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return PoolingHashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            PoolableEntry candidate = PoolingHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            PoolableEntry entry = PoolingHashMap.this.removeMapping(o);
            PoolingHashMap.this.entryFactory.returnEntry(entry);
            return entry != null;
        }

        @Override
        public int size() {
            return PoolingHashMap.this.size;
        }

        @Override
        public void clear() {
            PoolingHashMap.this.clear();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return PoolingHashMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return PoolingHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return PoolingHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            PoolingHashMap.this.clear();
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return PoolingHashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return PoolingHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return PoolingHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            PoolableEntry entry = PoolingHashMap.this.removeEntryForKey(o);
            PoolingHashMap.this.entryFactory.returnEntry(entry);
            return entry != null;
        }

        @Override
        public void clear() {
            PoolingHashMap.this.clear();
        }
    }

    private final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private final class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private final class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        PoolableEntry<K, V> next;
        int expectedModCount;
        int index;
        PoolableEntry<K, V> current;

        HashIterator() {
            this.expectedModCount = PoolingHashMap.this.modCount;
            if (PoolingHashMap.this.size > 0) {
                PoolableEntry<K, V>[] t = PoolingHashMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final PoolableEntry<K, V> nextEntry() {
            if (PoolingHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            PoolableEntry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.next;
            if (this.next == null) {
                PoolableEntry<K, V>[] t = PoolingHashMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (PoolingHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.current.key;
            this.current = null;
            PoolableEntry entry = PoolingHashMap.this.removeEntryForKey(k);
            this.expectedModCount = PoolingHashMap.this.modCount;
            PoolingHashMap.this.entryFactory.returnEntry(entry);
        }
    }
}

