/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.memory;

import com.singularity.ee.agent.util.reflect.AgentReflectionUtility;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.memory.IMemoryCalculator;
import com.singularity.ee.util.memory.IObjectContentLogger;
import com.singularity.ee.util.memory.IObjectSummaryLogger;
import com.singularity.ee.util.memory.ObjectHistogram;
import java.lang.instrument.Instrumentation;

public abstract class AMemoryCalculator
implements IMemoryCalculator {
    public static final int DEFAULT_MAX_STACK_DEPTH = 500000;
    public static final int DEFAULT_MAX_OBJECTS = 500000;
    public static final int DEFAULT_MAX_OBJECTS_TO_LOG = 5000;
    protected ILogger logger;
    protected Instrumentation instrumentation;
    protected boolean debug;
    protected int stackDepthLimit = 500000;
    protected int objectLimit = 500000;
    protected int objectsToLog = 5000;
    protected boolean enableSummaryLogging;
    protected boolean enableContentLogging;
    protected IObjectSummaryLogger summaryLogger;
    protected IObjectContentLogger contentLogger;
    protected Object root;
    protected String name;
    protected long id;

    public AMemoryCalculator(Instrumentation instrumentation, ILogger logger) {
        this.instrumentation = instrumentation;
        this.logger = logger;
    }

    @Override
    public long deepSize(Object root) {
        return this.deepSize(root, AgentReflectionUtility.getName(root.getClass()), -1L);
    }

    @Override
    public void enableContentSummaryLogging(boolean enable) {
        this.enableSummaryLogging = enable;
    }

    @Override
    public void enableObjectDumpLogging(boolean enable) {
        this.enableContentLogging = enable;
    }

    @Override
    public ObjectHistogram getObjectContentSummary() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSummaryLogger(IObjectSummaryLogger summaryLogger) {
        this.summaryLogger = summaryLogger;
    }

    @Override
    public void setContentLogger(IObjectContentLogger contentLogger) {
        this.contentLogger = contentLogger;
    }

    @Override
    public void setMaxStackDepth(int stackDepthLimit) {
        this.stackDepthLimit = stackDepthLimit;
    }

    @Override
    public void setMaxObjectsToVisit(int objectsToLimit) {
        this.objectLimit = objectsToLimit;
    }

    @Override
    public void setMaxObjectsToLOg(int maxObjectsToLog) {
        this.objectsToLog = maxObjectsToLog;
    }

    @Override
    public long deepSize(Object root, String name, long id) {
        this.root = root;
        this.name = name;
        this.id = id;
        this.debug = this.logger.isDebugEnabled();
        if (root == null) {
            return 0L;
        }
        try {
            return this.calculateSize();
        }
        catch (Throwable e) {
            this.logger.error("Error in computing deep size for " + root.getClass() + " returning 0", e);
            return 0L;
        }
    }

    protected abstract long calculateSize();
}

