/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.memory;

import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.memory.IMemoryCalculator;
import com.singularity.ee.util.memory.IObjectContentLogger;
import com.singularity.ee.util.memory.IObjectSummaryLogger;
import com.singularity.ee.util.memory.calc.AdvancedMemoryCalculator;
import java.lang.instrument.Instrumentation;

public class MemoryCalculatorFactory {
    private IMemoryCalculator advancedCalculator;
    private IMemoryCalculator standardCalculator;
    private IMemoryCalculator depthBoundCalculator;
    private IMemoryCalculator reflectionCalculator;
    private IMemoryCalculator nullCalculator;
    private IMemoryCalculator calculator;

    public MemoryCalculatorFactory(Instrumentation instrumentation, ILogger logger, CalculatorType type) {
        this.initCalculators(instrumentation, logger);
        this.setCalculatorType(type);
    }

    public MemoryCalculatorFactory(Instrumentation instrumentation, ILogger logger, CalculatorType type, IObjectContentLogger contentLogger, IObjectSummaryLogger summaryLogger) {
        this(instrumentation, logger, type);
        this.calculator.setContentLogger(contentLogger);
        this.calculator.setSummaryLogger(summaryLogger);
    }

    private void initCalculators(Instrumentation instrumentation, ILogger logger) {
        this.advancedCalculator = new AdvancedMemoryCalculator(instrumentation, logger);
    }

    public void setCalculatorType(CalculatorType type) {
        switch (type) {
            case ADVANCED: {
                this.calculator = this.advancedCalculator;
                break;
            }
            case STANDARD: {
                this.calculator = this.standardCalculator;
                break;
            }
            case DEPTH_BOUND: {
                this.calculator = this.depthBoundCalculator;
                break;
            }
            case REFLECTION: {
                this.calculator = this.reflectionCalculator;
                break;
            }
            case NULL: {
                this.calculator = this.nullCalculator;
            }
        }
    }

    public IMemoryCalculator getCalculator() {
        return this.calculator;
    }

    public static enum CalculatorType {
        ADVANCED,
        STANDARD,
        DEPTH_BOUND,
        REFLECTION,
        NULL;

    }
}

