/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.memory;

import com.singularity.ee.util.spi.IAgentAtomicInteger;
import com.singularity.ee.util.spi.IAgentAtomicLong;
import java.util.HashMap;
import java.util.Map;

public class ObjectHistogram {
    public static final String SEPARATOR = ":";
    public static final char NEW_LINE = '\n';
    private long id;
    private String name;
    private String className;
    private long size;
    private Map<String, IAgentAtomicInteger> containedObjectCount;
    private Map<String, IAgentAtomicLong> containedObjectSize;
    private String errorMessage;

    public ObjectHistogram(long id, String name, String className, long size, Map<String, IAgentAtomicInteger> containedObjectCount, Map<String, IAgentAtomicLong> containedObjectSize, String errorSummary) {
        this.id = id;
        this.name = name;
        this.className = className;
        this.size = size;
        this.containedObjectCount = containedObjectCount;
        this.containedObjectSize = containedObjectSize;
        this.errorMessage = errorSummary;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public long getSize() {
        return this.size;
    }

    public Map<String, IAgentAtomicInteger> getContainedObjectCount() {
        return this.containedObjectCount;
    }

    public Map<String, String> getContainedObjectDetailAsMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.containedObjectCount.size());
        for (String key : this.containedObjectCount.keySet()) {
            StringBuilder value = new StringBuilder(String.valueOf(this.containedObjectCount.get(key).get())).append(SEPARATOR).append(String.valueOf(this.containedObjectSize.get(key).get()));
            map.put(key, value.toString());
        }
        return map;
    }

    public Map<String, String> getContainedObjectCountAsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : this.containedObjectCount.keySet()) {
            map.put(key, String.valueOf(this.containedObjectCount.get(key).get()));
        }
        return map;
    }

    public Map<String, IAgentAtomicLong> getContainedObjectSize() {
        return this.containedObjectSize;
    }

    public Map<String, String> getContainedObjectSizeAsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : this.containedObjectSize.keySet()) {
            map.put(key, String.valueOf(this.containedObjectSize.get(key).get()));
        }
        return map;
    }

    public String toString() {
        StringBuilder objectLogSummary = new StringBuilder();
        objectLogSummary.append("id " + this.id + ", name " + this.name + ", classname " + this.className);
        objectLogSummary.append("Total Size = ").append(this.getSize());
        objectLogSummary.append('\n').append("Content Summary");
        for (String s : this.getContainedObjectCount().keySet()) {
            objectLogSummary.append('\n').append(s).append(": instance count [").append(this.getContainedObjectCount().get(s)).append("], size in bytes [").append(this.getContainedObjectSize().get(s)).append(']');
        }
        objectLogSummary.append('\n');
        return objectLogSummary.toString();
    }
}

