/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.memory.calc;

import com.singularity.ee.util.collections.ArrayStack;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicIntegerImpl;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicLongImpl;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.memory.AMemoryCalculator;
import com.singularity.ee.util.memory.ObjectHistogram;
import com.singularity.ee.util.memory.calc.ArrayMarker;
import com.singularity.ee.util.memory.calc.CalculatorClassNameConfig;
import com.singularity.ee.util.memory.calc.ContentDumpHelper;
import com.singularity.ee.util.memory.calc.EntryFieldWrapper;
import com.singularity.ee.util.memory.calc.FieldCache;
import com.singularity.ee.util.memory.calc.FieldWrapper;
import com.singularity.ee.util.memory.calc.ObjectLogger;
import com.singularity.ee.util.spi.IAgentAtomicInteger;
import com.singularity.ee.util.spi.IAgentAtomicLong;
import com.singularity.ee.util.string.StringOperations;
import java.lang.instrument.Instrumentation;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class AdvancedMemoryCalculator
extends AMemoryCalculator {
    private static int STRING_BASE_SIZE = 64;
    private static int NUMBER_BASE_SIZE = 24;
    private static int BOOLEAN_BASE_SIZE = 24;
    private static int MAP_ENTRY_BASE_SIZE = 48;
    private static int ATOMIC_REFERENCE_SIZE = 24;
    private boolean noOptimization = false;
    private static final String NEW_LINE = "\n";
    private static final Object DUMMY = new Object();
    private String rootClassName;
    private long totalSize;
    private ArrayStack stack;
    private Map<Object, Object> visited;
    private Map<String, IAgentAtomicInteger> objectCountMap;
    private Map<String, IAgentAtomicLong> objectSizeMap;
    private StringBuilder contentSB;
    private boolean trace;
    private StringBuilder objectLogSummary;
    private FieldCache fieldCache;
    private CalculatorClassNameConfig classConfig;
    private StringBuilder errorSummary;
    private boolean stackLimitReached;
    private int skippedObjectCount;
    private ContentDumpHelper contentDumpHelper;
    private String lastContentDumpFileName;

    public AdvancedMemoryCalculator(Instrumentation instrumentation, ILogger logger) {
        super(instrumentation, logger);
        this.classConfig = new CalculatorClassNameConfig(logger);
        this.fieldCache = new FieldCache(logger, this.classConfig);
        this.visited = new IdentityHashMap<Object, Object>(4096);
        this.objectCountMap = new HashMap<String, IAgentAtomicInteger>();
        this.objectSizeMap = new HashMap<String, IAgentAtomicLong>();
        this.objectLogSummary = new StringBuilder(2048);
        this.errorSummary = new StringBuilder();
        this.stack = new ArrayStack(4096);
        this.contentSB = new StringBuilder(512);
        this.contentDumpHelper = new ContentDumpHelper();
    }

    public void setCustomExcludes(Set<String> customExcludes) {
        this.fieldCache.setCustomExcludes(customExcludes);
    }

    public void setCustomIncludes(Set<String> customIncludes) {
        this.fieldCache.setCustomIncludes(customIncludes);
    }

    public void setNoOptimization(boolean noOptimization) {
        this.noOptimization = noOptimization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final long calculateSize() {
        if (this.root == null) {
            return 0L;
        }
        this.trace = this.logger.isTraceEnabled();
        this.preReset();
        this.totalSize = 0L;
        this.rootClassName = this.root.getClass().getName();
        int maxStackSize = 0;
        if (this.enableContentLogging) {
            this.contentDumpHelper.beforeStartingObjectGraphTraversal(((ObjectLogger)this.contentLogger).getLogsDir(), this.name, this.fieldCache, this.logger);
        }
        if (this.enableSummaryLogging) {
            this.objectLogSummary.setLength(0);
            this.objectLogSummary.append(NEW_LINE).append("Object Content summary of ").append(this.rootClassName).append(" at ").append(new Date()).append(NEW_LINE);
        }
        long startTime = System.currentTimeMillis();
        try {
            Class<?> compType = this.root.getClass().getComponentType();
            if (this.enableContentLogging) {
                this.contentDumpHelper.writeContent(this.root);
            }
            if (compType != null && !compType.isPrimitive()) {
                this.pushToStack(new ArrayMarker(this.root));
                if (this.trace) {
                    this.logger.trace("Pushing " + compType.getSimpleName() + "[]\n");
                }
            } else {
                this.sizeOrPushItObject(this.root);
            }
            while (!this.stack.isEmpty()) {
                if (this.visited.size() > this.objectLimit && this.objectLimit != -1) {
                    this.errorSummary.append("Reached max OBJECT limit of ").append(this.objectLimit).append(", will terminate calculation. Current size ").append(StringOperations.formatInput((long)this.totalSize)).append(", time to compute ").append(System.currentTimeMillis() - startTime).append(". ");
                    break;
                }
                Object obj = this.stack.pop();
                if (this.stack.size() > this.stackDepthLimit && this.stackDepthLimit != -1) {
                    this.stackLimitReached = true;
                    this.logger.info("Reached max STACK depth limit of " + this.stackDepthLimit + " for root " + this.getName() + ", will skip this object " + obj.getClass().getName());
                    continue;
                }
                boolean isArray = false;
                if (obj instanceof ArrayMarker) {
                    obj = ((ArrayMarker)obj).object;
                    isArray = true;
                }
                Class<?> cls = obj.getClass();
                if (!this.fieldCache.isFilteredClass(obj.getClass()) && this.visited.put(obj, DUMMY) != null) continue;
                long size = this.instrumentation.getObjectSize(obj);
                this.incrementSize(obj.getClass(), size);
                if (this.enableContentLogging && this.root != obj) {
                    this.contentDumpHelper.writeContent(obj);
                }
                if (isArray) {
                    Object[] leafArray = (Object[])obj;
                    this.sizeOrPushItArray(leafArray);
                    if (!this.debug || this.stack.size() <= maxStackSize) continue;
                    maxStackSize = this.stack.size();
                    continue;
                }
                FieldWrapper[] fields = this.fieldCache.getAllFilteredDeclaredFields(cls);
                for (int i = fields.length - 1; i >= 0; --i) {
                    FieldWrapper wrapper = fields[i];
                    try {
                        Object val = wrapper.field.get(obj);
                        if (val == null) continue;
                        if (wrapper.isNonPrimitiveArray) {
                            this.pushToStack(new ArrayMarker(val));
                            if (!this.trace) continue;
                            this.logger.trace("Pushing " + wrapper.field + "[]\n");
                            continue;
                        }
                        this.sizeOrPushItObject(val);
                        if (!this.debug || this.stack.size() <= maxStackSize) continue;
                        maxStackSize = this.stack.size();
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        this.logger.error("Exception in accessing the value for " + wrapper, (Throwable)e);
                    }
                }
            }
            if (this.stackLimitReached) {
                this.errorSummary.append("Reached max STACK depth limit of " + this.stackDepthLimit + ". Skipped " + this.skippedObjectCount + " objects from calculation.");
            }
            if (this.errorSummary.length() > 0) {
                this.logger.info("For " + this.getName() + " error in calc : " + this.errorSummary.toString());
            }
            if (this.enableSummaryLogging || this.enableContentLogging) {
                this.logObjectContents(this.name);
            }
        }
        finally {
            if (this.enableContentLogging) {
                this.lastContentDumpFileName = this.contentDumpHelper.getContentDumpFileName();
                this.contentDumpHelper.afterCompletionOfObjectGraphTraversal();
            }
            if (this.debug) {
                this.logDebug(maxStackSize, startTime);
            }
            this.postReset();
        }
        return this.totalSize;
    }

    @Override
    public ObjectHistogram getObjectContentSummary() {
        ObjectHistogram histogram = new ObjectHistogram(this.id, this.name, this.root.getClass().getName(), this.totalSize, new HashMap<String, IAgentAtomicInteger>(this.objectCountMap), new HashMap<String, IAgentAtomicLong>(this.objectSizeMap), this.errorSummary.toString());
        this.preReset();
        return histogram;
    }

    private void preReset() {
        this.objectCountMap.clear();
        this.objectSizeMap.clear();
        this.errorSummary.setLength(0);
        this.skippedObjectCount = 0;
        this.stackLimitReached = false;
    }

    private void postReset() {
        this.visited.clear();
        this.stack.clear();
        this.contentSB.setLength(0);
    }

    private void logDebug(int maxStackSize, long start) {
        this.contentSB.append("## For [").append(this.rootClassName).append("], time [").append(System.currentTimeMillis() - start).append("], bytes [").append(this.totalSize);
        this.contentSB.append("], visited objects [").append(this.visited.size()).append("], max stack size [").append(maxStackSize).append("] ##\n");
        this.logger.debug(this.contentSB.toString());
    }

    private void logObjectContents(String name) {
        if (this.enableSummaryLogging && this.summaryLogger != null) {
            ObjectHistogram summary = new ObjectHistogram(this.id, name, this.root.getClass().getName(), this.totalSize, this.objectCountMap, this.objectSizeMap, this.errorSummary.toString());
            this.summaryLogger.logObjectSummary(summary);
        }
    }

    private void incrementSize(Class cls, long sz) {
        this.incrementSize(cls, sz, 1);
    }

    private void incrementSize(Class cls, long sz, int counter) {
        if (this.trace) {
            this.logger.trace("Incrementing Size " + cls + ", " + sz + ", " + counter);
        }
        this.totalSize += sz;
        if (!this.enableSummaryLogging) {
            return;
        }
        this.incrementSummaryCounters(cls, sz, counter);
    }

    private void incrementSummaryCounters(Class cls, long sz, int counter) {
        String className = this.getClassName(cls);
        IAgentAtomicInteger count = this.objectCountMap.get(className);
        if (count == null) {
            count = new AgentAtomicIntegerImpl(0);
            this.objectCountMap.put(className, count);
        }
        count.addAndGet(counter);
        IAgentAtomicLong size = this.objectSizeMap.get(className);
        if (size == null) {
            size = new AgentAtomicLongImpl(0L);
            this.objectSizeMap.put(className, size);
        }
        size.addAndGet(sz);
    }

    private String getClassName(Class cls) {
        if (cls.getComponentType() != null) {
            return cls.getComponentType().getName() + "[]";
        }
        return cls.getName();
    }

    private void sizeOrPushItArray(Object[] arr) {
        Class<?> type = arr.getClass().getComponentType();
        if (this.noOptimization) {
            this.defaultArrayObjectHandling(arr, type);
            return;
        }
        if (type == FieldCache.hmEntryClazz) {
            this.introspectEntryFields(arr, FieldCache.hmEntryFields);
        } else if (type == FieldCache.htEntryClazz) {
            this.introspectEntryFields(arr, FieldCache.htEntryFields);
        } else if (type == FieldCache.chmEntryClazz) {
            this.introspectEntryFields(arr, FieldCache.chmEntryFields);
        } else if (type == String.class) {
            for (int j = arr.length - 1; j >= 0; --j) {
                Object val = arr[j];
                if (val == null) continue;
                long size = STRING_BASE_SIZE + ((String)val).length() * 2;
                this.incrementSize(String.class, size);
            }
        } else if (type == Boolean.class) {
            this.incrementForArrayType(arr, type, BOOLEAN_BASE_SIZE);
        } else if (Number.class.isAssignableFrom(type)) {
            this.incrementForArrayType(arr, type, NUMBER_BASE_SIZE);
        } else {
            this.defaultArrayObjectHandling(arr, type);
        }
    }

    private void defaultArrayObjectHandling(Object[] arr, Class type) {
        int endInx = 0;
        if (this.stackDepthLimit != -1) {
            int n = endInx = this.stack.size() + arr.length > this.stackDepthLimit ? arr.length - 1 - (this.stackDepthLimit - this.stack.size()) : 0;
        }
        if (endInx > 0) {
            this.logger.info("For [" + this.getName() + "] reached max stack depth limit " + this.stackDepthLimit + " while adding array " + type + " elements. SS " + this.stack.size() + ", AL " + arr.length + ", EI " + endInx + ", To Add " + (arr.length - 1 - endInx));
            this.stackLimitReached = true;
            this.skippedObjectCount += endInx;
        }
        for (int j = arr.length - 1; j >= endInx; --j) {
            Object val = arr[j];
            if (val == null) continue;
            Class<?> cls = val.getClass();
            if (cls == String.class) {
                long size = STRING_BASE_SIZE + ((String)val).length() * 2;
                this.incrementSize(String.class, size);
                continue;
            }
            if (cls == Boolean.class) {
                this.incrementSize(cls, BOOLEAN_BASE_SIZE);
                continue;
            }
            if (Number.class.isAssignableFrom(cls)) {
                this.incrementSize(cls, NUMBER_BASE_SIZE);
                continue;
            }
            if (cls.isArray()) {
                if (!cls.getComponentType().isPrimitive()) {
                    this.pushToStack(new ArrayMarker(val));
                    continue;
                }
                this.incrementSize(cls, this.instrumentation.getObjectSize(val));
                continue;
            }
            this.pushToStack(val);
        }
        if (endInx > 0) {
            this.logger.info("After adding array elements SS " + this.stack.size());
        }
    }

    private void incrementForArrayType(Object[] arr, Class type, int size) {
        for (int j = arr.length - 1; j >= 0; --j) {
            Object val = arr[j];
            if (val == null) continue;
            this.incrementSize(type, size);
        }
    }

    private String getName() {
        StringBuilder sb = new StringBuilder(this.rootClassName + ", name " + this.name + ", id " + this.id);
        return sb.toString();
    }

    private void introspectEntryFields(Object[] arr, EntryFieldWrapper flds) {
        for (int j = arr.length - 1; j >= 0; --j) {
            Object entry = arr[j];
            if (entry == null) continue;
            try {
                this.sizeOrPushItEntry(flds, entry);
                continue;
            }
            catch (IllegalAccessException e) {
                this.logger.error("Error in accessing map entry field " + entry, (Throwable)e);
            }
        }
    }

    private void sizeOrPushItEntry(EntryFieldWrapper fieldWrapper, Object entry) throws IllegalAccessException {
        Object obj;
        this.incrementSize(entry.getClass(), MAP_ENTRY_BASE_SIZE);
        if (fieldWrapper.key != null && (obj = fieldWrapper.key.get(entry)) != null) {
            this.sizeOrPushItObject(obj);
        }
        if (fieldWrapper.value != null && (obj = fieldWrapper.value.get(entry)) != null) {
            this.sizeOrPushItObject(obj);
        }
        if (fieldWrapper.entry != null && (obj = fieldWrapper.entry.get(entry)) != null) {
            this.pushToStack(obj);
        }
    }

    private void pushToStack(Object obj) {
        if (this.classConfig.includeClass(obj.getClass())) {
            if (this.stack.size() <= this.stackDepthLimit && this.stackDepthLimit != -1) {
                this.stack.push(obj);
                if (this.trace) {
                    this.logger.trace("Pushing " + obj.getClass().getSimpleName() + NEW_LINE);
                }
            } else {
                this.stackLimitReached = true;
                ++this.skippedObjectCount;
            }
        }
    }

    private void sizeOrPushItObject(Object val) {
        if (this.noOptimization) {
            this.pushToStack(val);
            return;
        }
        if (val instanceof String) {
            long size = STRING_BASE_SIZE + ((String)val).length() * 2;
            this.incrementSize(String.class, size);
        } else if (val instanceof Number) {
            this.incrementSize(val.getClass(), NUMBER_BASE_SIZE);
        } else if (val instanceof AtomicReference) {
            this.incrementSize(val.getClass(), ATOMIC_REFERENCE_SIZE);
            Object obj = ((AtomicReference)val).get();
            if (obj != null) {
                this.pushToStack(obj);
            }
        } else {
            this.pushToStack(val);
        }
    }

    public String getLastContentDumpFileName() {
        return this.lastContentDumpFileName;
    }
}

