/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.memory.calc;

import com.singularity.ee.util.collections.AdaptableConcurrentHashMap;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.string.StringRegexOperations;
import java.lang.ref.PhantomReference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public class CalculatorClassNameConfig {
    private static Class[] includeClasses = new Class[]{StackTraceElement.class, Throwable.class, String.class, Number.class, Boolean.class, AtomicBoolean.class, StringBuilder.class, StringBuffer.class, WeakReference.class, SoftReference.class, PhantomReference.class, AtomicReference.class, AdaptableConcurrentHashMap.class, Map.class, Collection.class};
    private static String[] includeClassNames = new String[]{"java.lang.Object"};
    private static String[] includePackageEquals = new String[]{"java.util", "java.util.concurrent", "java.util.concurrent.atomic", "java.util.concurrent.locks"};
    private static String[] includePackageStartsWith = new String[]{"org.apache.commons.collections."};
    private static String[] excludePackages = new String[]{"java.", "com.sun.", "sun.", "javax.", "com.bea.", "com.ibm.", "org.", "com.oracle.", "com.tibco", "weblogic.", "ibm.mq.", "activemq.", "fiorano", "oracle.", "org.jboss.", "progress.", "com.evermind", "com.mysql.", "com.microsoft", "com.opensymphony", "jrockit.", "kodo.", "com.pointbase."};
    private static Pattern excludePkgPattern;
    private Set<String> customExcludes = Collections.emptySet();
    private Set<String> customIncludes = Collections.emptySet();
    private AtomicReference<Set<String>> customExcludesRef = new AtomicReference<Set<String>>(this.customExcludes);
    private AtomicReference<Set<String>> customIncludesRef = new AtomicReference<Set<String>>(this.customIncludes);
    private static ConcurrentMap<Class, Object> droppedClasses;
    private static ConcurrentMap<Class, Object> chosenClasses;
    private static Object dummy;
    private ILogger logger;

    CalculatorClassNameConfig(ILogger logger) {
        this.logger = logger;
    }

    public void setCustomExcludes(Set<String> set) {
        this.customExcludesRef.set(set);
    }

    public void setCustomIncludes(Set<String> set) {
        this.customIncludesRef.set(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean includeClass(Class cls) {
        boolean outcome = false;
        String className = cls.getName();
        String pkgName = StringOperations.getPackageName((String)className);
        if (chosenClasses.containsKey(cls)) {
            return true;
        }
        if (droppedClasses.containsKey(cls)) {
            return false;
        }
        try {
            for (Class clazz : includeClasses) {
                if (!clazz.isAssignableFrom(cls)) continue;
                boolean bl = outcome = true;
                return bl;
            }
            for (String string : includeClassNames) {
                if (!className.equals(string)) continue;
                boolean bl = outcome = true;
                return bl;
            }
            for (String string : includePackageEquals) {
                if (!pkgName.equals(string)) continue;
                boolean bl = outcome = true;
                return bl;
            }
            for (String string : includePackageStartsWith) {
                if (!pkgName.startsWith(string)) continue;
                boolean bl = outcome = true;
                return bl;
            }
            Set<String> customIncludes = this.customIncludesRef.get();
            if (customIncludes.size() > 0) {
                for (String customInclude : customIncludes) {
                    if (!className.startsWith(customInclude)) continue;
                    boolean bl = outcome = true;
                    return bl;
                }
            }
            if (excludePkgPattern.matcher(className).matches()) {
                boolean bl = outcome = false;
                return bl;
            }
            Set<String> customExcludes = this.customExcludesRef.get();
            for (String string : customExcludes) {
                if (!className.startsWith(string)) continue;
                boolean bl = outcome = false;
                return bl;
            }
            boolean bl = outcome = true;
            return bl;
        }
        finally {
            if (outcome) {
                if (chosenClasses.putIfAbsent(cls, dummy) == null && this.logger.isTraceEnabled()) {
                    this.logger.trace("Included(+) for deep size calculation " + cls);
                }
            } else if (droppedClasses.putIfAbsent(cls, dummy) == null && this.logger.isTraceEnabled()) {
                this.logger.trace("Excluded(-) for deep size calculation:" + cls);
            }
        }
    }

    static {
        HashSet<String> excludePkgSet = new HashSet<String>();
        for (String excludePackage : excludePackages) {
            excludePkgSet.add(excludePackage);
        }
        excludePkgPattern = StringRegexOperations.compilePattern(excludePkgSet, (boolean)false);
        droppedClasses = new AdaptableConcurrentHashMap();
        chosenClasses = new AdaptableConcurrentHashMap();
        dummy = new Object();
    }
}

