/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.memory.calc;

import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.memory.calc.ArrayMarker;
import com.singularity.ee.util.memory.calc.EntryFieldWrapper;
import com.singularity.ee.util.memory.calc.FieldCache;
import com.singularity.ee.util.memory.calc.FieldWrapper;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class ContentDumpHelper {
    private StringBuilder contentDumpFileName = new StringBuilder();
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat timeFormat;
    private PrintWriter writer;
    private ILogger logger;
    private FieldCache fieldCache;
    private boolean initialized = false;
    private Field _valueField = null;

    void beforeStartingObjectGraphTraversal(String agentRuntimeLogsDir, String registeredNameForObject, FieldCache fieldCache, ILogger logger) {
        this.fieldCache = fieldCache;
        this.logger = logger;
        this.contentDumpFileName = new StringBuilder();
        try {
            if (null == this.dateFormat) {
                this.dateFormat = new SimpleDateFormat("MMMddyyyy");
                this.timeFormat = new SimpleDateFormat("HH_mm_ss");
            }
            this.contentDumpFileName.append(agentRuntimeLogsDir).append(File.separator);
            Date now = new Date();
            this.contentDumpFileName.append("MemoryDump_").append(this.dateFormat.format(now)).append("_").append(this.timeFormat.format(now)).append("_").append(registeredNameForObject).append(".dump");
            this.writer = new PrintWriter(this.contentDumpFileName.toString());
            try {
                Field[] fields;
                for (Field field : fields = StringBuilder.class.getSuperclass().getDeclaredFields()) {
                    if (!"value".equals(field.getName())) continue;
                    this._valueField = field;
                    this._valueField.setAccessible(true);
                    break;
                }
            }
            catch (Throwable fields) {
                // empty catch block
            }
            this.initialized = true;
            logger.info("Initialized content dump writer to file [" + this.contentDumpFileName.toString() + "]");
        }
        catch (Exception e) {
            this.initialized = false;
            logger.error("Error occurred while accessing file [" + this.contentDumpFileName.toString() + "], exception : ", (Throwable)e);
            try {
                this.closeAnyIOStreams();
            }
            catch (Exception e1) {
                logger.warn("Unable to close stream for file [" + this.contentDumpFileName.toString() + "], exception : ", (Throwable)e1);
            }
        }
    }

    void afterCompletionOfObjectGraphTraversal() {
        if (!this.initialized) {
            return;
        }
        if (this.contentDumpFileName != null) {
            this.logger.info("Writing object content dump to [" + this.contentDumpFileName.toString() + "]");
        }
        this.contentDumpFileName = null;
        this.closeAnyIOStreams();
    }

    public String getContentDumpFileName() {
        if (this.contentDumpFileName != null) {
            return this.contentDumpFileName.toString();
        }
        return null;
    }

    void writeContent(Object obj) {
        try {
            this._writeContent(obj);
        }
        catch (Throwable e) {
            this.logger.error("Error occurred while writing content dump, ", e);
        }
    }

    void _writeContent(Object obj) {
        if (!this.initialized) {
            return;
        }
        if (null == obj) {
            return;
        }
        StringBuilder sb = new StringBuilder(256);
        int level = 1;
        this.indent(sb, level);
        Class<?> cls = obj.getClass();
        if (obj instanceof ArrayMarker) {
            cls = ((ArrayMarker)obj).object.getClass();
            obj = ((ArrayMarker)obj).object;
        }
        if (cls.isArray()) {
            if (!cls.getComponentType().isPrimitive()) {
                Object[] arr = (Object[])obj;
                Class<?> type = arr.getClass().getComponentType();
                sb.append("Object : ").append("<").append(System.identityHashCode(arr)).append(">").append(" (").append(cls).append(" )");
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(sb.toString());
                }
                this.writeEntry(this.writer, sb, false);
                for (int i = 0; i < arr.length; ++i) {
                    Object a = arr[i];
                    if (null == a) continue;
                    if (type == FieldCache.hmEntryClazz) {
                        this.dumpEntry(a, this.writer, sb, FieldCache.hmEntryFields, level + 1);
                    } else if (type == FieldCache.htEntryClazz) {
                        this.dumpEntry(a, this.writer, sb, FieldCache.htEntryFields, level + 1);
                    } else if (type == FieldCache.chmEntryClazz) {
                        this.dumpEntry(a, this.writer, sb, FieldCache.chmEntryFields, level + 1);
                    } else if (a instanceof Character || a instanceof String || a instanceof Number || a instanceof Boolean || a instanceof AtomicBoolean) {
                        this.indent(sb, level + 1);
                        sb.append(a).append(" : ").append(" ( ").append(a.getClass()).append(" )");
                    } else if (a.getClass().isArray() && a.getClass().getComponentType().isPrimitive()) {
                        this.indent(sb, level + 1);
                        sb.append("Object : ").append("<").append(System.identityHashCode(a)).append(">").append(" (").append(a.getClass()).append(" )");
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("cls name [" + a.getClass() + "]");
                        }
                        this.writeEntry(this.writer, sb, false);
                        int len = Array.getLength(a);
                        int maxInARow = 30;
                        int inARow = 0;
                        for (int m = 0; m < len; ++m) {
                            if (inARow > maxInARow) {
                                inARow = 0;
                                this.writeEntry(this.writer, sb, false);
                            }
                            this.indent(sb, level + 1);
                            Object elem = Array.get(a, m);
                            sb.append(elem).append(",");
                            inARow += 2;
                        }
                    } else {
                        this.indent(sb, level + 1);
                        sb.append("Object : ").append("<").append(System.identityHashCode(a)).append(">").append(" (").append(a.getClass()).append(" )");
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace(sb.toString());
                        }
                    }
                    this.writeEntry(this.writer, sb, false);
                }
            } else {
                sb.append("Object : ").append("<").append(System.identityHashCode(obj)).append(">").append(" (").append(cls).append(" )");
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("cls name [" + cls + "]");
                }
                this.writeEntry(this.writer, sb, false);
                int len = Array.getLength(obj);
                int maxInARow = 30;
                int inARow = 0;
                for (int i = 0; i < len; ++i) {
                    if (inARow > maxInARow) {
                        inARow = 0;
                        this.writeEntry(this.writer, sb, false);
                    }
                    this.indent(sb, level + 1);
                    Object a = Array.get(obj, i);
                    sb.append(a).append(",");
                    inARow += 2;
                }
            }
        } else if (obj instanceof Character || obj instanceof String || obj instanceof Number || obj instanceof Boolean || obj instanceof AtomicBoolean) {
            sb.append(obj).append(" : ").append(" ( ").append(obj.getClass()).append(" )");
        } else {
            FieldWrapper[] fields;
            sb.append("Object : ").append("<").append(System.identityHashCode(obj)).append(">").append(" (").append(cls).append(" )");
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(sb.toString());
            }
            this.writeEntry(this.writer, sb, false);
            for (FieldWrapper wrapper : fields = this.fieldCache.getAllFilteredDeclaredFields(cls)) {
                wrapper.field.setAccessible(true);
                try {
                    Object a = wrapper.field.get(obj);
                    if (null == a || a instanceof AtomicReference && null == (a = ((AtomicReference)a).get())) continue;
                    this.indent(sb, level + 1);
                    if (a instanceof Character || a instanceof String || a instanceof Number || a instanceof Boolean || a instanceof AtomicBoolean) {
                        sb.append(wrapper.field.getName()).append(" : ").append(a).append(" ( ").append(a.getClass()).append(" )");
                    } else {
                        sb.append(wrapper.field.getName()).append(" : ").append("<").append(System.identityHashCode(a)).append(">").append(" (").append(a.getClass()).append(" )");
                    }
                    this.writeEntry(this.writer, sb, false);
                }
                catch (IllegalAccessException e) {
                    this.logger.warn("Exception while accessing field [" + wrapper + "], ", (Throwable)e);
                }
            }
        }
        this.writeEntry(this.writer, sb, true);
    }

    private void indent(StringBuilder sb, int level) {
        for (int j = 0; j < 2 * level; ++j) {
            sb.append(" ");
        }
    }

    private void dumpEntry(Object entry, PrintWriter writer, StringBuilder sb, EntryFieldWrapper entryFields, int level) {
        try {
            this.indent(sb, level);
            Object key = entryFields.key.get(entry);
            if (null != key) {
                if (key instanceof Character || key instanceof String || key instanceof Number) {
                    sb.append("key : ").append(key).append(" ( ").append(key.getClass()).append(" )");
                } else {
                    sb.append("key : < ").append(System.identityHashCode(key)).append(" >").append(" ( ").append(key.getClass()).append(" )");
                }
            }
            this.writeEntry(writer, sb, false);
            this.indent(sb, level);
            Object value = entryFields.value.get(entry);
            if (null != value) {
                if (value instanceof Character || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof AtomicBoolean) {
                    sb.append("value : ").append(value).append(" ( ").append(value.getClass()).append(" )");
                } else {
                    sb.append("value : < ").append(System.identityHashCode(value)).append(" >").append(" ( ").append(value.getClass()).append(" )");
                }
            }
            this.writeEntry(writer, sb, false);
        }
        catch (IllegalAccessException e) {
            this.logger.warn("Exception handling map entry[" + entry + "], ", (Throwable)e);
        }
    }

    private void writeEntry(PrintWriter writer, StringBuilder sb, boolean isEnd) {
        boolean written = false;
        try {
            if (null != this._valueField) {
                char[] __value = (char[])this._valueField.get(sb);
                writer.write(__value, 0, sb.length());
                written = true;
            }
        }
        catch (Throwable __value) {
            // empty catch block
        }
        if (!written) {
            char[] temp = new char[sb.length()];
            sb.getChars(0, sb.length(), temp, 0);
            writer.write(temp);
        }
        writer.println();
        if (isEnd) {
            writer.println("------------------------------------------------------------------------------------------------------");
        }
        sb.setLength(0);
    }

    private void closeAnyIOStreams() {
        if (null != this.writer) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
    }
}

