/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.memory.calc;

import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.memory.AMemoryCalculator;
import java.lang.instrument.Instrumentation;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Stack;

public class DepthBoundMemoryCalculator
extends AMemoryCalculator {
    private static final String ROOT = "Root";
    private static final String ARRAY = "Array";
    private static final int DEFAULT_CLASS_DEPTH = 5;

    public DepthBoundMemoryCalculator(Instrumentation instrumentation, ILogger logger) {
        super(instrumentation, logger);
    }

    @Override
    protected long calculateSize() {
        int maxDepth = 5;
        boolean traceEnabled = this.logger.isTraceEnabled();
        int currentDepth = 1;
        HashSet<Integer> visited = new HashSet<Integer>();
        Stack<TargetObject> objectsToSize = new Stack<TargetObject>();
        objectsToSize.push(new TargetObject(this.root, currentDepth, ROOT));
        long totalSize = 0L;
        if (traceEnabled) {
            this.debugPrint("\n######################");
        }
        while (!objectsToSize.isEmpty()) {
            TargetObject targetObject = (TargetObject)objectsToSize.pop();
            Object obj = targetObject.reference.get();
            if (obj == null) continue;
            currentDepth = targetObject.depth;
            if (!visited.add(System.identityHashCode(obj))) continue;
            long size = this.instrumentation.getObjectSize(obj);
            totalSize += size;
            if (currentDepth == maxDepth) continue;
            Class<?> cls = obj.getClass();
            Class<?> compType = cls.getComponentType();
            if (compType != null && !compType.isPrimitive()) {
                for (Object leafElem : (Object[])obj) {
                    if (leafElem == null) continue;
                    objectsToSize.push(new TargetObject(leafElem, currentDepth, ARRAY));
                }
            }
            while (cls != null && currentDepth != maxDepth) {
                if (traceEnabled) {
                    String fldType = compType == null ? cls.getName() : "[" + compType.getName() + "]";
                    this.debugPrint(currentDepth + " at " + targetObject.name + ", " + fldType);
                }
                for (Field fld : cls.getDeclaredFields()) {
                    Class<?> fieldClass = fld.getType();
                    if (fieldClass.isPrimitive()) continue;
                    fld.setAccessible(true);
                    try {
                        Object val = fld.get(obj);
                        if (val == null) continue;
                        objectsToSize.push(new TargetObject(val, currentDepth, fld.getName()));
                    }
                    catch (IllegalAccessException e) {
                        this.logger.error("Error in accessing " + fld.getName() + " in " + cls, (Throwable)e);
                    }
                }
                cls = cls.getSuperclass();
                ++currentDepth;
            }
        }
        if (traceEnabled) {
            this.debugPrint("###################### \n");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("In " + this.getClass().getName() + " for " + this.root.getClass().getName() + " size [" + totalSize + "]");
        }
        return totalSize;
    }

    private void debugPrint(String s) {
        this.logger.debug(s);
    }

    class TargetObject {
        Reference<Object> reference;
        int depth;
        String name;

        TargetObject(Object obj, int depth, String name) {
            this.reference = new WeakReference<Object>(obj);
            this.depth = depth;
            this.name = name;
        }
    }
}

