/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.memory.calc;

import com.singularity.ee.util.collections.AdaptableConcurrentHashMap;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.memory.calc.CalculatorClassNameConfig;
import com.singularity.ee.util.memory.calc.EntryFieldWrapper;
import com.singularity.ee.util.memory.calc.FieldWrapper;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class FieldCache {
    static AtomicBoolean initialized = new AtomicBoolean(false);
    static final String HASHTABLE_ENTRY = "java.util.Hashtable$Entry";
    static final String HASHMAP_ENTRY = "java.util.HashMap$Entry";
    static final String HASHMAP_ENTRY_JAVA_18 = "java.util.HashMap$Node";
    static final String CONCURRENT_HASHMAP_ENTRY = "java.util.concurrent.ConcurrentHashMap$HashEntry";
    static final String CONCURRENT_HASHMAP_SEGMENT = "java.util.concurrent.ConcurrentHashMap$Segment";
    static final String CONCURRENT_HASHMAP_ENTRY_JAVA_18 = "java.util.concurrent.ConcurrentHashMap$Node";
    static final String REENTRANT_LOCK_SYNC = "java.util.concurrent.locks.ReentrantLock$Sync";
    static final String REENTRANT_LOCK_NFSYNC = "java.util.concurrent.locks.ReentrantLock$NonfairSync";
    static final String REENTRANT_LOCK_FSYNC = "java.util.concurrent.locks.ReentrantLock$FairSync";
    static Class htEntryClazz = null;
    static Class hmEntryClazz = null;
    static Class chmEntryClazz = null;
    static Class chmSegmentClazz = null;
    static Class rlNonfairSync = null;
    static Class rlFairSync = null;
    static IdentityHashMap<Class, Object> filteredClasses = new IdentityHashMap(16);
    static EntryFieldWrapper htEntryFields = null;
    static EntryFieldWrapper hmEntryFields = null;
    static EntryFieldWrapper chmEntryFields = null;
    static Map<Class, Object> forbiddenClasses = new AdaptableConcurrentHashMap();
    private static Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static FieldWrapper[] EMPTY_FIELD_WRAPPER = new FieldWrapper[0];
    private static Object DUMMY = new Object();
    private CalculatorClassNameConfig classConfig;
    private ILogger logger;
    private static Map<Class, FieldWrapper[]> fldCache = new AdaptableConcurrentHashMap();

    FieldCache(ILogger iLogger, CalculatorClassNameConfig classNameConfig) {
        this.logger = iLogger;
        this.classConfig = classNameConfig;
        if (!initialized.compareAndSet(false, true)) {
            return;
        }
        try {
            this.initEntryClassAndFields();
            filteredClasses.put(htEntryClazz, null);
            filteredClasses.put(hmEntryClazz, null);
            filteredClasses.put(chmEntryClazz, null);
            filteredClasses.put(chmSegmentClazz, null);
            filteredClasses.put(rlNonfairSync, null);
            filteredClasses.put(rlFairSync, null);
            filteredClasses.put(rlNonfairSync, null);
            filteredClasses.put(BigInteger.class, null);
            filteredClasses.put(BigDecimal.class, null);
        }
        catch (Exception e) {
            this.logger.error("Error in initializing map field cache", (Throwable)e);
        }
    }

    boolean isFilteredClass(Class cls) {
        return filteredClasses.containsKey(cls) || this.getAllFilteredDeclaredFields(cls).length == 0;
    }

    void setCustomExcludes(Set<String> customExcludes) {
        this.classConfig.setCustomExcludes(customExcludes);
    }

    void setCustomIncludes(Set<String> customIncludes) {
        this.classConfig.setCustomIncludes(customIncludes);
    }

    void initEntryClassAndFields() throws IllegalAccessException {
        this.set(Hashtable.class.getDeclaredFields());
        this.set(HashMap.class.getDeclaredFields());
        this.set(ConcurrentHashMap.class.getDeclaredFields());
        this.set(TreeMap.class.getDeclaredFields());
        this.set(ReentrantLock.class.getDeclaredFields());
    }

    private void set(Field[] fields) throws IllegalAccessException {
        for (Field fld : fields) {
            fld.setAccessible(true);
            Class<?> type = fld.getType();
            if (type.isArray()) {
                if (type.getComponentType().getName().equals(HASHTABLE_ENTRY)) {
                    htEntryClazz = type.getComponentType();
                    htEntryFields = new EntryFieldWrapper();
                    this.initEntryFields(this.getKeyValueNextFields(htEntryClazz), htEntryFields);
                    continue;
                }
                if (type.getComponentType().getName().equals(HASHMAP_ENTRY) || type.getComponentType().getName().equals(HASHMAP_ENTRY_JAVA_18)) {
                    hmEntryClazz = type.getComponentType();
                    hmEntryFields = new EntryFieldWrapper();
                    this.initEntryFields(this.getKeyValueNextFields(hmEntryClazz), hmEntryFields);
                    continue;
                }
                if (type.getComponentType().getName().equals(CONCURRENT_HASHMAP_ENTRY) || type.getComponentType().getName().equals(CONCURRENT_HASHMAP_ENTRY_JAVA_18)) {
                    chmEntryClazz = type.getComponentType();
                    chmEntryFields = new EntryFieldWrapper();
                    this.initEntryFields(chmEntryClazz.getDeclaredFields(), chmEntryFields);
                    continue;
                }
                if (!type.getComponentType().getName().equals(CONCURRENT_HASHMAP_SEGMENT)) continue;
                chmSegmentClazz = type.getComponentType();
                this.set(chmSegmentClazz.getDeclaredFields());
                continue;
            }
            if (!fld.getType().getName().equals(REENTRANT_LOCK_SYNC)) continue;
            Object val = fld.get(new ReentrantLock(true));
            if (val.getClass().getName().equals(REENTRANT_LOCK_FSYNC)) {
                rlFairSync = val.getClass();
            }
            if (!(val = fld.get(new ReentrantLock(false))).getClass().getName().equals(REENTRANT_LOCK_NFSYNC)) continue;
            rlNonfairSync = val.getClass();
        }
    }

    Field[] getKeyValueNextFields(Class cls) {
        Field[] sfields = cls.getSuperclass().getDeclaredFields();
        Field[] cfields = cls.getDeclaredFields();
        Field[] _fields = new Field[sfields.length + cfields.length];
        System.arraycopy(sfields, 0, _fields, 0, sfields.length);
        System.arraycopy(cfields, 0, _fields, sfields.length, cfields.length);
        return _fields;
    }

    private void initEntryFields(Field[] entryFlds, EntryFieldWrapper fldWrapper) {
        for (Field entryFld : entryFlds) {
            entryFld.setAccessible(true);
            if (entryFld.getName().equals("key")) {
                fldWrapper.key = entryFld;
                continue;
            }
            if (entryFld.getName().equals("value")) {
                fldWrapper.value = entryFld;
                continue;
            }
            if (!entryFld.getName().equals("next")) continue;
            fldWrapper.entry = entryFld;
        }
    }

    FieldWrapper[] getAllFilteredDeclaredFields(Class cls) {
        FieldWrapper[] fields = fldCache.get(cls);
        if (fields == null) {
            fields = this._getAllFilteredDeclaredFields(cls);
            fldCache.put(cls, fields);
        }
        return fields;
    }

    private FieldWrapper[] _getAllFilteredDeclaredFields(Class cls) {
        if (forbiddenClasses.containsKey(cls)) {
            return EMPTY_FIELD_WRAPPER;
        }
        ArrayList<FieldWrapper> allFields = new ArrayList<FieldWrapper>();
        while (cls != null) {
            if (cls != Reference.class) {
                Field[] fields = EMPTY_FIELD_ARRAY;
                try {
                    fields = cls.getDeclaredFields();
                }
                catch (Throwable t) {
                    this.logger.warn("Couldn't get declared fields for class " + cls + ". Error : " + t);
                    forbiddenClasses.put(cls, DUMMY);
                }
                for (Field field : fields) {
                    if (Modifier.isStatic(field.getModifiers()) || field.getName().startsWith("this$")) continue;
                    field.setAccessible(true);
                    FieldWrapper fieldWrapper = null;
                    Class<?> fieldClass = field.getType();
                    Class<?> compType = fieldClass.getComponentType();
                    if (compType != null && !compType.isPrimitive() && !Enum.class.isAssignableFrom(compType) && this.classConfig.includeClass(compType)) {
                        fieldWrapper = new FieldWrapper(field, true);
                    } else if (!fieldClass.isPrimitive() && !Enum.class.isAssignableFrom(fieldClass) && this.classConfig.includeClass(fieldClass)) {
                        fieldWrapper = new FieldWrapper(field, false);
                    }
                    if (fieldWrapper == null) continue;
                    allFields.add(fieldWrapper);
                }
            }
            cls = cls.getSuperclass();
        }
        return allFields.toArray(new FieldWrapper[allFields.size()]);
    }
}

