/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.memory.calc;

import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.memory.AMemoryCalculator;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class MemoryCalculator
extends AMemoryCalculator {
    public MemoryCalculator(Instrumentation in, ILogger logger) {
        super(in, logger);
    }

    @Override
    protected long calculateSize() {
        HashMap<Integer, Object> visited = new HashMap<Integer, Object>();
        Stack<Object> stack = new Stack<Object>();
        long result = this.internalSizeOf(this.root, stack, visited);
        while (!stack.isEmpty()) {
            result += this.internalSizeOf(stack.pop(), stack, visited);
        }
        visited.clear();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("In " + this.getClass().getName() + " for " + this.root.getClass().getName() + " size [" + result + "]");
        }
        return result;
    }

    private long internalSizeOf(Object obj, Stack<Object> stack, Map<Integer, Object> visited) {
        int hc = System.identityHashCode(obj);
        if (obj == null || visited.containsKey(hc)) {
            return 0L;
        }
        visited.put(hc, null);
        long result = 0L;
        result += this.instrumentation.getObjectSize(obj);
        Class<?> clazz = obj.getClass();
        if (clazz.isArray()) {
            if (clazz.getName().length() != 2) {
                int length = Array.getLength(obj);
                for (int i = 0; i < length; ++i) {
                    stack.add(Array.get(obj, i));
                }
            }
            return result;
        }
        int currentDepth = 1;
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive()) continue;
                field.setAccessible(true);
                try {
                    Object objectToAdd = field.get(obj);
                    if (objectToAdd == null) continue;
                    stack.add(objectToAdd);
                }
                catch (IllegalAccessException ex) {
                    this.logger.warn("Error in accessing " + field, (Throwable)ex);
                }
            }
            if (currentDepth == this.stackDepthLimit) break;
            clazz = clazz.getSuperclass();
            ++currentDepth;
        }
        return result;
    }
}

