/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.memory.calc;

import com.singularity.ee.util.io.FileUtil;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.memory.IObjectContentLogger;
import com.singularity.ee.util.memory.IObjectSummaryLogger;
import com.singularity.ee.util.memory.ObjectHistogram;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class ObjectLogger
implements IObjectContentLogger,
IObjectSummaryLogger {
    private ILogger logger;
    public static final char NEW_LINE = '\n';
    public static final char TAB = '\t';
    public static final String NULL = "NULL";
    private static SimpleDateFormat dateFormat;
    private static SimpleDateFormat timeFormat;
    private String logDir;
    private static long MAX_FILE_SIZE;
    private long maxFileSize = MAX_FILE_SIZE;

    public ObjectLogger(ILogger logger, String logDir) {
        this.logger = logger;
        this.logDir = logDir;
    }

    public String getLogsDir() {
        return this.logDir;
    }

    @Override
    public void setMaxFileSize(long size) {
        this.maxFileSize = size;
    }

    @Override
    public void logObjectContent(Object root, String name, long id, Set<Collection<Object>> collectionContents, Set<Map<Object, Object>> mapContents) {
        String fileName = this.init(name);
        if (null != name) {
            this.logCollection(name, fileName, collectionContents);
            this.logMaps(name, fileName, mapContents);
        }
    }

    @Override
    public void logObjectSummary(ObjectHistogram summary) {
        StringBuilder objectLogSummary = new StringBuilder();
        objectLogSummary.append("Total Size = ").append(summary.getSize());
        objectLogSummary.append('\n').append("Content Summary");
        for (String s : summary.getContainedObjectCount().keySet()) {
            objectLogSummary.append('\n').append(s).append(": instance count [").append(summary.getContainedObjectCount().get(s)).append("], size in bytes [").append(summary.getContainedObjectSize().get(s)).append(']');
        }
        objectLogSummary.append('\n');
        this.logSummary(summary.getName(), objectLogSummary);
    }

    private String init(String objName) {
        String name;
        try {
            if (null == dateFormat) {
                dateFormat = new SimpleDateFormat("MMMddyyyy");
                timeFormat = new SimpleDateFormat("HH_mm_ss");
            }
            StringBuilder contentDumpFileName = new StringBuilder();
            Date currentDate = new Date();
            contentDumpFileName.append("MemoryDump_").append(dateFormat.format(currentDate)).append("_").append(timeFormat.format(currentDate)).append("_").append(objName).append(".txt");
            name = FileUtil.sanitizeToValidFilePath((String)contentDumpFileName.toString());
            File f = new File(this.logDir, name);
            long size = f.length();
            if (size > this.maxFileSize) {
                this.logger.info("Object log file for [" + name + "] has reached max limit [" + MAX_FILE_SIZE + "], deleting current file and creating a new file.");
                boolean success = f.delete();
                if (!success) {
                    this.logger.info("Failed to delete Object log file [" + f.getAbsolutePath() + "]");
                } else if (f.createNewFile()) {
                    this.logger.warn("Failed to create new file " + f);
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in initializing Object Logger ", t);
            return null;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logSummary(String name, StringBuilder sb) {
        RandomAccessFile raf = null;
        try {
            File f = new File(this.logDir, name);
            raf = new RandomAccessFile(f, "rw");
            raf.seek(raf.length());
            raf.write(sb.toString().getBytes());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    this.logger.error("Error while closing file for " + name, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCollection(String objName, String fileName, Set<Collection<Object>> collections) {
        RandomAccessFile raf = null;
        try {
            File f = new File(this.logDir, fileName);
            StringBuilder sb = new StringBuilder();
            sb.append('\n');
            raf = new RandomAccessFile(f, "rw");
            raf.seek(raf.length());
            sb.append(new Date()).append('\n');
            sb.append("Logging collection instances of the object [").append(objName).append("], Total number of Collections = ").append(collections.size()).append('\n');
            raf.write(sb.toString().getBytes());
            try {
                for (Collection<Object> col : collections) {
                    if (col.size() == 0) continue;
                    sb.setLength(0);
                    sb.append("Class :").append(col.getClass().getName()).append(", Size :").append(col.size());
                    sb.append('\n');
                    raf.write(sb.toString().getBytes());
                    for (Object entry : col) {
                        sb.setLength(0);
                        if (null == entry) {
                            entry = NULL;
                        }
                        sb.append(entry).append('\n');
                        raf.write(sb.toString().getBytes());
                    }
                }
            }
            catch (ConcurrentModificationException e) {
                this.logger.info("Colletion object being logged was concurrently modified by application, aborting logging");
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in dumping contents of the collections in object " + objName, t);
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    this.logger.error("Error while closing file for " + objName, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMaps(String objName, String fileName, Set<Map<Object, Object>> maps) {
        RandomAccessFile raf = null;
        try {
            File f = new File(this.logDir, fileName);
            StringBuilder sb = new StringBuilder();
            sb.append('\n');
            raf = new RandomAccessFile(f, "rw");
            raf.seek(raf.length());
            sb.append(new Date()).append('\n');
            sb.append("Logging map instances of the object [").append(objName).append("], Total number of Maps = ").append(maps.size()).append('\n');
            raf.write(sb.toString().getBytes());
            try {
                for (Map<Object, Object> m : maps) {
                    if (m.size() == 0) continue;
                    sb.setLength(0);
                    sb.append("Class :").append(m.getClass().getName()).append(", Size :").append(m.size());
                    sb.append('\n');
                    raf.write(sb.toString().getBytes());
                    for (Map.Entry<Object, Object> entry : m.entrySet()) {
                        sb.setLength(0);
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (null == key) {
                            key = NULL;
                        }
                        if (null == value) {
                            value = NULL;
                        }
                        try {
                            sb.append(key).append(",").append(value).append('\n');
                        }
                        catch (NullPointerException e) {
                            continue;
                        }
                        raf.write(sb.toString().getBytes());
                    }
                }
            }
            catch (ConcurrentModificationException e) {
                this.logger.info("Map object being logged was concurrently modified by application, aborting logging");
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in dumping contents of the maps in object " + objName, t);
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    this.logger.error("Error while closing file for " + objName, (Throwable)e);
                }
            }
        }
    }

    static {
        MAX_FILE_SIZE = 100000000L;
    }
}

