/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.memory.calc;

import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.memory.AMemoryCalculator;
import com.singularity.ee.util.memory.calc.MemorySizes;
import java.lang.instrument.Instrumentation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public final class ReflectionMemoryCalculator
extends AMemoryCalculator {
    private static final MemorySizes sizes = new MemorySizes();

    public ReflectionMemoryCalculator(Instrumentation instrumentation, ILogger logger) {
        super(instrumentation, logger);
    }

    @Override
    protected long calculateSize() {
        HashMap<Integer, Object> visited = new HashMap<Integer, Object>();
        Stack<WeakReference<Object>> objectsToSize = new Stack<WeakReference<Object>>();
        objectsToSize.add(new WeakReference<Object>(this.root));
        long result = 0L;
        while (!objectsToSize.isEmpty()) {
            result += this.sizeOf(((WeakReference)objectsToSize.pop()).get(), visited, objectsToSize);
        }
        visited.clear();
        return result;
    }

    private long sizeOf(Object obj, Map<Integer, Object> visited, Stack<WeakReference<Object>> objectsToSize) {
        Class<?> clazz;
        int hc = System.identityHashCode(obj);
        if (obj == null || visited.containsKey(hc)) {
            return 0L;
        }
        visited.put(hc, null);
        long result = 0L;
        if (clazz.isArray()) {
            return this.sizeOfArray(obj, visited, objectsToSize);
        }
        for (clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers())) continue;
                if (fields[i].getType().isPrimitive()) {
                    result += (long)sizes.getPrimitiveFieldSize(fields[i].getType());
                    continue;
                }
                result += (long)sizes.getPointerSize();
                fields[i].setAccessible(true);
                try {
                    Object toSize = fields[i].get(obj);
                    if (toSize == null) continue;
                    objectsToSize.add(new WeakReference<Object>(toSize));
                    continue;
                }
                catch (IllegalAccessException ex) {
                    this.logger.error("Error in accessing " + fields[i], (Throwable)ex);
                }
            }
        }
        return this.roundUpToNearestEightBytes(result += (long)sizes.getClassSize());
    }

    private long roundUpToNearestEightBytes(long result) {
        if (result % 8L != 0L) {
            result += 8L - result % 8L;
        }
        return result;
    }

    protected long sizeOfArray(Object obj, Map<Integer, Object> visited, Stack<WeakReference<Object>> objectsToSize) {
        long result = 16L;
        int length = Array.getLength(obj);
        if (length != 0) {
            Class<?> arrayElementClazz = obj.getClass().getComponentType();
            if (arrayElementClazz.isPrimitive()) {
                result += (long)(length * sizes.getPrimitiveArrayElementSize(arrayElementClazz));
            } else {
                for (int i = 0; i < length; ++i) {
                    result += (long)sizes.getPointerSize() + this.sizeOf(Array.get(obj, i), visited, objectsToSize);
                }
            }
        }
        return result;
    }
}

