/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.reflect;

import java.util.Arrays;

public class ClassCacheHashKey {
    String className;
    String methodName;
    Class[] methodParams;

    public ClassCacheHashKey(String className, String methodName, Class[] methodParams) {
        this.className = className;
        this.methodName = methodName;
        this.methodParams = methodParams;
    }

    public String getClassAndMethodName() {
        return this.className + "." + this.methodName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassCacheHashKey that = (ClassCacheHashKey)o;
        if (!this.className.equals(that.className)) {
            return false;
        }
        if (!this.methodName.equals(that.methodName)) {
            return false;
        }
        return Arrays.equals(this.methodParams, that.methodParams);
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + (this.methodParams != null ? Arrays.hashCode(this.methodParams) : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[className='").append(this.className).append('\'');
        sb.append(", methodName='").append(this.methodName).append('\'');
        sb.append(", methodParams=").append(this.methodParams == null ? "null" : Arrays.asList(this.methodParams).toString());
        sb.append(']');
        return sb.toString();
    }
}

