/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.reflect;

import com.singularity.ee.util.collections.ConcurrentReferenceHashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentMap;

public class ReflectionUtilityCommon {
    private static final ConcurrentMap<Class<?>, String> mapOfSimpleClassNames = new ConcurrentReferenceHashMap();

    private ReflectionUtilityCommon() {
    }

    public static String getClassSimpleName(Class<?> methodClass) {
        String returnString = (String)mapOfSimpleClassNames.get(methodClass);
        if (returnString == null) {
            returnString = methodClass.getSimpleName();
            mapOfSimpleClassNames.put(methodClass, returnString);
        }
        return returnString;
    }

    public static boolean isAnonymousClass(Class aClass) {
        return aClass.isAnonymousClass();
    }

    public static String getClassFullName(Object invokedObject, String className) {
        return className;
    }

    public static String getClassCanonicalName(Class aClass) {
        return aClass.getCanonicalName();
    }

    public static String getName(Class aClass) {
        return aClass.getName();
    }

    public static String getExceptionFullName(Class aClass) {
        return ReflectionUtilityCommon.getName(aClass);
    }

    public static String getPackageName(Class aClass) {
        return aClass.getPackage().getName();
    }

    public static <T> T[] newArray(T obj, int size) {
        return (Object[])Array.newInstance(obj.getClass(), size);
    }

    public static boolean isArray(Class aClass) {
        return aClass.isArray();
    }

    public static ClassLoader getClassLoader(Object obj) {
        return obj.getClass().getClassLoader();
    }

    public static <T> T createEmptyProxyClass(ClassLoader classLoader, Class clazz) {
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        });
    }

    public static Object invokeStaticMethod(Class clazz, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return clazz.getMethod(methodName, new Class[0]).invoke(null, new Object[0]);
    }

    public static boolean isNumber(Object obj) {
        return obj instanceof Number;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationClass) {
        for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            T annotation = currentClazz.getAnnotation(annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }
}

