/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.java9;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class JarPackageCache {
    private final File jarFile;

    JarPackageCache(URL url) {
        this.jarFile = new File(url.getFile());
    }

    List<String> getCachedPackages() {
        List<String> returnList = null;
        try {
            File cacheFile = this.getCachedPackageFileName();
            if (cacheFile != null && cacheFile.exists()) {
                returnList = this.validateAndLoadCacheFile(cacheFile);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        return returnList;
    }

    private File getCachedPackageFileName() {
        File cacheFile = null;
        if (this.jarFile.exists()) {
            File parentDirectory = this.jarFile.getParentFile();
            String jarFileSimpleName = this.jarFile.getName();
            if (jarFileSimpleName.endsWith(".jar")) {
                String cacheFileSimpleName = jarFileSimpleName.substring(0, jarFileSimpleName.length() - 4) + ".cached.packages.txt";
                cacheFile = new File(parentDirectory, cacheFileSimpleName);
            }
        }
        return cacheFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> validateAndLoadCacheFile(File cacheFile) throws IOException {
        ArrayList<String> packageList = null;
        long lastModificationTime = this.jarFile.lastModified();
        try (BufferedReader br = null;){
            long lastModTimeFromFile;
            br = new BufferedReader(new FileReader(cacheFile));
            String firstLine = br.readLine();
            if (firstLine != null && lastModificationTime == (lastModTimeFromFile = Long.parseLong(firstLine = firstLine.trim()))) {
                String nextLine;
                packageList = new ArrayList<String>();
                while ((nextLine = br.readLine()) != null) {
                    if ((nextLine = nextLine.trim()).length() <= 0) continue;
                    packageList.add(nextLine);
                }
            }
        }
        return packageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createCacheFile(Collection<String> packageNames) {
        if (this.jarFile.exists()) {
            long lastModificationTime = this.jarFile.lastModified();
            File cacheFile = this.getCachedPackageFileName();
            BufferedWriter bw = null;
            boolean error = false;
            try {
                bw = new BufferedWriter(new FileWriter(cacheFile));
                bw.write(Long.toString(lastModificationTime) + "\n");
                for (String nextPackage : packageNames) {
                    bw.write(nextPackage + "\n");
                }
            }
            catch (IOException e) {
                error = true;
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                        error = true;
                    }
                }
            }
            if (error && cacheFile.exists() && !cacheFile.delete()) {
                System.err.println(String.format("Delete of file '%s' failed", cacheFile.getAbsolutePath()));
            }
        }
    }
}

