/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.java9;

import com.singularity.ee.agent.appagent.java9.IJava9UtilBoot;
import com.singularity.ee.agent.appagent.java9.JarPackageCache;
import com.singularity.ee.agent.util.io.Console;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.module.FindException;
import java.lang.module.ModuleDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jdk.internal.module.Modules;

public class Java9Util
implements IJava9UtilBoot {
    private static final String PKG_JDK_INTERNAL_ACCESS = "jdk.internal.access";
    private static final String PKG_JDK_INTERNAL_MISC = "jdk.internal.misc";
    private static final String PKG_JDK_INTERNAL_MODULE = "jdk.internal.module";
    private static final String PKG_JAVA_LANG_REFLECT = "java.lang.reflect";
    private static final String ALL_UNNAMED = "ALL-UNNAMED";
    private final Module thisModule;
    private final Module baseModule;
    private Instrumentation instrumentation;
    private volatile ModuleLayer systemBootLayer;
    private volatile boolean errorGettingSystemBootLayer;
    private volatile Object getJavaLangAccessObj;
    private volatile Method addExportsToAllMethod;
    private static final String META_INF_PREFIX = "META-INF/";
    private volatile ClassLoader java9PlatformClassLoader;
    private volatile boolean errorGettingPlatformClassLoader;

    public Java9Util(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        this.thisModule = Java9Util.class.getModule();
        this.baseModule = Object.class.getModule();
    }

    public boolean bootStrap(boolean isJava11_0_6Plus) {
        HashMap<String, Set<Module>> extraExports = new HashMap<String, Set<Module>>();
        HashMap<String, Set<Module>> extraOpens = new HashMap<String, Set<Module>>();
        HashSet<Module> moduleSet = new HashSet<Module>();
        moduleSet.add(this.thisModule);
        extraExports.put(PKG_JDK_INTERNAL_MISC, moduleSet);
        extraExports.put(PKG_JDK_INTERNAL_MODULE, moduleSet);
        if (isJava11_0_6Plus && this.baseModule.getPackages().contains(PKG_JDK_INTERNAL_ACCESS)) {
            extraExports.put(PKG_JDK_INTERNAL_ACCESS, moduleSet);
        }
        extraOpens.put(PKG_JAVA_LANG_REFLECT, moduleSet);
        Module baseModule = (Module)this.getBaseModule();
        this.instrumentation.redefineModule(baseModule, Collections.emptySet(), extraExports, extraOpens, Collections.emptySet(), Collections.emptyMap());
        return true;
    }

    public Object getThisModule() {
        return this.thisModule;
    }

    public Object getBaseModule() {
        return this.baseModule;
    }

    public Object getModuleForClass(Class<?> clazz) {
        return clazz.getModule();
    }

    public boolean addExportsAndOpens(Object module, Map<String, Set<Object>> exports, Map<String, Set<Object>> opens) {
        Map<String, Set<Module>> exportMap = exports;
        Map<String, Set<Module>> openMap = opens;
        this.instrumentation.redefineModule((Module)module, Collections.emptySet(), exportMap, openMap, Collections.emptySet(), Collections.emptyMap());
        return true;
    }

    public boolean addReads(Object fromModule, Object toModule) {
        HashSet<Module> toSet = new HashSet<Module>();
        toSet.add((Module)toModule);
        this.instrumentation.redefineModule((Module)fromModule, toSet, Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet(), Collections.emptyMap());
        return true;
    }

    public boolean addReads(Object fromModule, Set<String> toModules) {
        HashSet<Module> toSet = new HashSet<Module>();
        for (String nextModuleName : toModules) {
            if (ALL_UNNAMED.equals(nextModuleName)) {
                Modules.addReadsAllUnnamed((Module)fromModule);
                break;
            }
            Object moduleToRead = this.locateModuleByName(nextModuleName);
            if (moduleToRead != null) {
                toSet.add((Module)moduleToRead);
                continue;
            }
            Console.out().println("Module " + nextModuleName + " not found");
        }
        this.instrumentation.redefineModule((Module)fromModule, toSet, Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet(), Collections.emptyMap());
        return true;
    }

    public boolean addUses(Object fromModule, Set<Class<?>> usedClasses, Map<Class<?>, List<Class<?>>> provides) {
        this.instrumentation.redefineModule((Module)fromModule, Collections.emptySet(), Collections.emptyMap(), Collections.emptyMap(), usedClasses, provides);
        return true;
    }

    private ModuleDescriptor createModuleDescriptor(URL[] classPath, String moduleName, String[] requires) {
        HashSet<String> packages = new HashSet<String>();
        for (URL nextURL : classPath) {
            try {
                Java9Util.getPackageNames(nextURL, packages);
            }
            catch (IOException e) {
                System.err.println("Warning: " + e + " while getting package names from " + nextURL);
            }
        }
        ModuleDescriptor.Builder moduleDescriptorBuilder = ModuleDescriptor.newModule(moduleName);
        moduleDescriptorBuilder = moduleDescriptorBuilder.packages(packages);
        for (String nextRequire : requires) {
            moduleDescriptorBuilder = moduleDescriptorBuilder.requires(nextRequire);
        }
        return moduleDescriptorBuilder.build();
    }

    public Object createModuleFromClassLoader(URLClassLoader classLoader, String moduleName, String[] requiredModules, String[] exports) throws URISyntaxException {
        URL[] classPath = classLoader.getURLs();
        ModuleDescriptor modDesc = this.createModuleDescriptor(classPath, moduleName, requiredModules);
        Module module = Modules.defineModule(classLoader, modDesc, classPath[0].toURI());
        Object thisModule = this.getThisModule();
        HashMap<String, Set<Object>> exportMap = new HashMap<String, Set<Object>>();
        HashSet<Object> thisModuleSet = new HashSet<Object>();
        thisModuleSet.add(thisModule);
        for (String nextExport : exports) {
            exportMap.put(nextExport, thisModuleSet);
        }
        this.addExportsAndOpens(module, exportMap, Collections.EMPTY_MAP);
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getPackageNames(URL url, Set<String> packageSet) throws IOException {
        JarPackageCache jarPackageCache = new JarPackageCache(url);
        List<String> cachedPackages = jarPackageCache.getCachedPackages();
        if (cachedPackages != null) {
            packageSet.addAll(cachedPackages);
        } else {
            HashSet<String> discoveredPackageNames = new HashSet<String>();
            File urlFile = new File(url.getFile());
            if (urlFile.getName().endsWith(".jar") || urlFile.getName().endsWith(".zip")) {
                try (JarFile jarFile = new JarFile(urlFile);){
                    String lastPackage = null;
                    Enumeration<JarEntry> jarEntries = jarFile.entries();
                    while (jarEntries.hasMoreElements()) {
                        String packge;
                        int indexOfLastDelim;
                        JarEntry jarEntry = jarEntries.nextElement();
                        String name = jarEntry.getName();
                        if (jarEntry.isDirectory() || !name.endsWith(".class") || name.toUpperCase().startsWith(META_INF_PREFIX) || (indexOfLastDelim = (name = name.substring(0, name.length() - 6)).lastIndexOf(47)) <= 0 || (packge = name.substring(0, indexOfLastDelim).replace('/', '.')).equals(lastPackage)) continue;
                        discoveredPackageNames.add(packge);
                        lastPackage = packge;
                    }
                    packageSet.addAll(discoveredPackageNames);
                    jarPackageCache.createCacheFile(discoveredPackageNames);
                }
            }
        }
    }

    public void addReadsToClassModule(Object m1, Class<?> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object fromModule = m1;
        Object toModule = this.getModuleForClass(clazz);
        this.addReads(fromModule, toModule);
    }

    public void addOpensFromClass(Class<?> clazz, String pkg, Object module1) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object toModule = module1;
        Object fromModule = this.getModuleForClass(clazz);
        HashMap<String, Set<Object>> openMap = new HashMap<String, Set<Object>>();
        HashSet<Object> toModuleSet = new HashSet<Object>();
        toModuleSet.add(toModule);
        openMap.put(pkg, toModuleSet);
        this.addExportsAndOpens(fromModule, Collections.EMPTY_MAP, openMap);
    }

    public void addExportsFromClass(Class<?> clazz, String pkg, Object modObject) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object toModule = modObject;
        Object fromModule = this.getModuleForClass(clazz);
        this.addExportsFromModule(fromModule, pkg, toModule);
    }

    public void addExportsFromModule(Object fromModule, String pkg, Object toModule) {
        HashMap<String, Set<Object>> exportMap = new HashMap<String, Set<Object>>();
        HashSet<Object> toModuleSet = new HashSet<Object>();
        toModuleSet.add(toModule);
        exportMap.put(pkg, toModuleSet);
        this.addExportsAndOpens(fromModule, exportMap, Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExportsToAll(Object modAsObject, String[] packages) {
        try {
            if (this.addExportsToAllMethod == null) {
                Java9Util java9Util = this;
                synchronized (java9Util) {
                    if (this.addExportsToAllMethod == null) {
                        Class<?> sharedSecretsClass;
                        try {
                            sharedSecretsClass = Class.forName("jdk.internal.misc.SharedSecrets");
                        }
                        catch (ClassNotFoundException e) {
                            sharedSecretsClass = Class.forName("jdk.internal.access.SharedSecrets");
                        }
                        Method getJavaLangAccessMethod = sharedSecretsClass.getMethod("getJavaLangAccess", new Class[0]);
                        getJavaLangAccessMethod.setAccessible(true);
                        this.getJavaLangAccessObj = getJavaLangAccessMethod.invoke(null, new Object[0]);
                        this.addExportsToAllMethod = this.getJavaLangAccessObj.getClass().getMethod("addExportsToAllUnnamed", Module.class, String.class);
                        this.addExportsToAllMethod.setAccessible(true);
                    }
                }
            }
            Module module = (Module)modAsObject;
            for (String nextPackage : packages) {
                this.addExportsToAllMethod.invoke(this.getJavaLangAccessObj, module, nextPackage);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public Object locateModuleByName(String moduleName) {
        Module module;
        try {
            module = Modules.loadModule(moduleName);
        }
        catch (FindException e) {
            module = null;
        }
        return module;
    }

    private ModuleLayer getSystemBootLayer() {
        if (this.systemBootLayer == null && !this.errorGettingSystemBootLayer) {
            try {
                Field bootLayerField = System.class.getDeclaredField("bootLayer");
                bootLayerField.setAccessible(true);
                this.systemBootLayer = (ModuleLayer)bootLayerField.get(null);
            }
            catch (Exception e) {
                this.errorGettingSystemBootLayer = true;
                e.printStackTrace(System.err);
            }
        }
        return this.systemBootLayer;
    }

    public ClassLoader getPlatformClassLoader() {
        return ClassLoader.getPlatformClassLoader();
    }

    public String getModuleName(Object module) {
        return ((Module)module).getName();
    }
}

