/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.singularity.ee.agent.util.log4j.ADShadedLogger;
import io.grpc.internal.GrpcUtil;
import io.grpc.okhttp.internal.OptionalMethod;
import io.grpc.okhttp.internal.Platform;
import io.grpc.okhttp.internal.Protocol;
import io.grpc.okhttp.internal.Util;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

class OkHttpProtocolNegotiator {
    private static final ADShadedLogger logger = ADShadedLogger.getLogger((String)OkHttpProtocolNegotiator.class.getName());
    private static final Platform DEFAULT_PLATFORM = Platform.get();
    private static OkHttpProtocolNegotiator NEGOTIATOR = OkHttpProtocolNegotiator.createNegotiator(OkHttpProtocolNegotiator.class.getClassLoader());
    protected final Platform platform;

    @VisibleForTesting
    OkHttpProtocolNegotiator(Platform platform) {
        this.platform = Preconditions.checkNotNull(platform, "platform");
    }

    public static OkHttpProtocolNegotiator get() {
        return NEGOTIATOR;
    }

    @VisibleForTesting
    static OkHttpProtocolNegotiator createNegotiator(ClassLoader loader) {
        boolean android = true;
        try {
            loader.loadClass("com.android.org.conscrypt.OpenSSLSocketImpl");
        }
        catch (ClassNotFoundException e1) {
            logger.log(Level.FINE, "Unable to find Conscrypt. Skipping", (Throwable)e1);
            try {
                loader.loadClass("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl");
            }
            catch (ClassNotFoundException e2) {
                logger.log(Level.FINE, "Unable to find any OpenSSLSocketImpl. Skipping", (Throwable)e2);
                android = false;
            }
        }
        return android ? new AndroidNegotiator(DEFAULT_PLATFORM) : new OkHttpProtocolNegotiator(DEFAULT_PLATFORM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String negotiate(SSLSocket sslSocket, String hostname, @Nullable List<Protocol> protocols) throws IOException {
        if (protocols != null) {
            this.configureTlsExtensions(sslSocket, hostname, protocols);
        }
        try {
            sslSocket.startHandshake();
            String negotiatedProtocol = this.getSelectedProtocol(sslSocket);
            if (negotiatedProtocol == null) {
                throw new RuntimeException("TLS ALPN negotiation failed with protocols: " + protocols);
            }
            String string = negotiatedProtocol;
            return string;
        }
        finally {
            this.platform.afterHandshake(sslSocket);
        }
    }

    protected void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        this.platform.configureTlsExtensions(sslSocket, hostname, protocols);
    }

    public String getSelectedProtocol(SSLSocket socket) {
        return this.platform.getSelectedProtocol(socket);
    }

    private static String[] protocolIds(List<Protocol> protocols) {
        ArrayList<String> result = new ArrayList<String>();
        for (Protocol protocol : protocols) {
            result.add(protocol.toString());
        }
        return result.toArray(new String[0]);
    }

    @VisibleForTesting
    static boolean isValidHostName(String name) {
        if (name.contains("_")) {
            return false;
        }
        try {
            GrpcUtil.checkAuthority(name);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @VisibleForTesting
    static final class AndroidNegotiator
    extends OkHttpProtocolNegotiator {
        private static final OptionalMethod<Socket> SET_USE_SESSION_TICKETS = new OptionalMethod(null, "setUseSessionTickets", Boolean.TYPE);
        private static final OptionalMethod<Socket> SET_HOSTNAME = new OptionalMethod(null, "setHostname", String.class);
        private static final OptionalMethod<Socket> GET_ALPN_SELECTED_PROTOCOL = new OptionalMethod(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
        private static final OptionalMethod<Socket> SET_ALPN_PROTOCOLS = new OptionalMethod(null, "setAlpnProtocols", byte[].class);
        private static final OptionalMethod<Socket> GET_NPN_SELECTED_PROTOCOL = new OptionalMethod(byte[].class, "getNpnSelectedProtocol", new Class[0]);
        private static final OptionalMethod<Socket> SET_NPN_PROTOCOLS = new OptionalMethod(null, "setNpnProtocols", byte[].class);
        private static final Method SSL_SOCKETS_IS_SUPPORTED_SOCKET;
        private static final Method SSL_SOCKETS_SET_USE_SESSION_TICKET;
        private static final Method SET_APPLICATION_PROTOCOLS;
        private static final Method GET_APPLICATION_PROTOCOLS;
        private static final Method GET_APPLICATION_PROTOCOL;
        private static final Method SET_SERVER_NAMES;
        private static final Constructor<?> SNI_HOST_NAME;

        AndroidNegotiator(Platform platform) {
            super(platform);
        }

        @Override
        public String negotiate(SSLSocket sslSocket, String hostname, List<Protocol> protocols) throws IOException {
            String negotiatedProtocol = this.getSelectedProtocol(sslSocket);
            if (negotiatedProtocol == null) {
                negotiatedProtocol = super.negotiate(sslSocket, hostname, protocols);
            }
            return negotiatedProtocol;
        }

        @Override
        protected void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
            Object[] protocolNames = OkHttpProtocolNegotiator.protocolIds(protocols);
            SSLParameters sslParams = sslSocket.getSSLParameters();
            try {
                Object[] configuredProtocols;
                if (hostname != null && AndroidNegotiator.isValidHostName(hostname)) {
                    if (SSL_SOCKETS_IS_SUPPORTED_SOCKET != null && ((Boolean)SSL_SOCKETS_IS_SUPPORTED_SOCKET.invoke(null, sslSocket)).booleanValue()) {
                        SSL_SOCKETS_SET_USE_SESSION_TICKET.invoke(null, sslSocket, true);
                    } else {
                        SET_USE_SESSION_TICKETS.invokeOptionalWithoutCheckedException(sslSocket, true);
                    }
                    if (SET_SERVER_NAMES != null && SNI_HOST_NAME != null) {
                        SET_SERVER_NAMES.invoke((Object)sslParams, Collections.singletonList(SNI_HOST_NAME.newInstance(hostname)));
                    } else {
                        SET_HOSTNAME.invokeOptionalWithoutCheckedException(sslSocket, hostname);
                    }
                }
                boolean alpnEnabled = false;
                if (GET_APPLICATION_PROTOCOL != null) {
                    try {
                        GET_APPLICATION_PROTOCOL.invoke((Object)sslSocket, new Object[0]);
                        SET_APPLICATION_PROTOCOLS.invoke((Object)sslParams, new Object[]{protocolNames});
                        alpnEnabled = true;
                    }
                    catch (InvocationTargetException e) {
                        Throwable targetException = e.getTargetException();
                        if (targetException instanceof UnsupportedOperationException) {
                            logger.log(Level.FINER, "setApplicationProtocol unsupported, will try old methods");
                        }
                        throw e;
                    }
                }
                sslSocket.setSSLParameters(sslParams);
                if (alpnEnabled && GET_APPLICATION_PROTOCOLS != null && Arrays.equals(protocolNames, configuredProtocols = (String[])GET_APPLICATION_PROTOCOLS.invoke((Object)sslSocket.getSSLParameters(), new Object[0]))) {
                    return;
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            Object[] parameters = new Object[]{Platform.concatLengthPrefixed(protocols)};
            if (this.platform.getTlsExtensionType() == Platform.TlsExtensionType.ALPN_AND_NPN) {
                SET_ALPN_PROTOCOLS.invokeWithoutCheckedException(sslSocket, parameters);
            }
            if (this.platform.getTlsExtensionType() == Platform.TlsExtensionType.NONE) {
                throw new RuntimeException("We can not do TLS handshake on this Android version, please install the Google Play Services Dynamic Security Provider to use TLS");
            }
            SET_NPN_PROTOCOLS.invokeWithoutCheckedException(sslSocket, parameters);
        }

        @Override
        public String getSelectedProtocol(SSLSocket socket) {
            if (GET_APPLICATION_PROTOCOL != null) {
                try {
                    return (String)GET_APPLICATION_PROTOCOL.invoke((Object)socket, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    if (targetException instanceof UnsupportedOperationException) {
                        logger.log(Level.FINER, "Socket unsupported for getApplicationProtocol, will try old methods");
                    }
                    throw new RuntimeException(e);
                }
            }
            if (this.platform.getTlsExtensionType() == Platform.TlsExtensionType.ALPN_AND_NPN) {
                try {
                    byte[] alpnResult = (byte[])GET_ALPN_SELECTED_PROTOCOL.invokeWithoutCheckedException(socket, new Object[0]);
                    if (alpnResult != null) {
                        return new String(alpnResult, Util.UTF_8);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Failed calling getAlpnSelectedProtocol()", (Throwable)e);
                }
            }
            if (this.platform.getTlsExtensionType() != Platform.TlsExtensionType.NONE) {
                try {
                    byte[] npnResult = (byte[])GET_NPN_SELECTED_PROTOCOL.invokeWithoutCheckedException(socket, new Object[0]);
                    if (npnResult != null) {
                        return new String(npnResult, Util.UTF_8);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Failed calling getNpnSelectedProtocol()", (Throwable)e);
                }
            }
            return null;
        }

        static {
            Method setApplicationProtocolsMethod = null;
            Method getApplicationProtocolsMethod = null;
            Method getApplicationProtocolMethod = null;
            Method sslSocketsIsSupportedSocketMethod = null;
            Method sslSocketsSetUseSessionTicketsMethod = null;
            try {
                Class<SSLParameters> sslParameters = SSLParameters.class;
                setApplicationProtocolsMethod = sslParameters.getMethod("setApplicationProtocols", String[].class);
                getApplicationProtocolsMethod = sslParameters.getMethod("getApplicationProtocols", new Class[0]);
                getApplicationProtocolMethod = SSLSocket.class.getMethod("getApplicationProtocol", new Class[0]);
                Class<?> sslSockets = Class.forName("android.net.ssl.SSLSockets");
                sslSocketsIsSupportedSocketMethod = sslSockets.getMethod("isSupportedSocket", SSLSocket.class);
                sslSocketsSetUseSessionTicketsMethod = sslSockets.getMethod("setUseSessionTickets", SSLSocket.class, Boolean.TYPE);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.FINER, "Failed to find Android 10.0+ APIs", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.log(Level.FINER, "Failed to find Android 10.0+ APIs", (Throwable)e);
            }
            SET_APPLICATION_PROTOCOLS = setApplicationProtocolsMethod;
            GET_APPLICATION_PROTOCOLS = getApplicationProtocolsMethod;
            GET_APPLICATION_PROTOCOL = getApplicationProtocolMethod;
            SSL_SOCKETS_IS_SUPPORTED_SOCKET = sslSocketsIsSupportedSocketMethod;
            SSL_SOCKETS_SET_USE_SESSION_TICKET = sslSocketsSetUseSessionTicketsMethod;
            Method setServerNamesMethod = null;
            Constructor<?> sniHostNameConstructor = null;
            try {
                setServerNamesMethod = SSLParameters.class.getMethod("setServerNames", List.class);
                sniHostNameConstructor = Class.forName("javax.net.ssl.SNIHostName").getConstructor(String.class);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.FINER, "Failed to find Android 7.0+ APIs", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.log(Level.FINER, "Failed to find Android 7.0+ APIs", (Throwable)e);
            }
            SET_SERVER_NAMES = setServerNamesMethod;
            SNI_HOST_NAME = sniHostNameConstructor;
        }
    }
}

