/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.resources;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class HostResource {
    private static final Resource INSTANCE = HostResource.buildResource();

    public static Resource get() {
        return INSTANCE;
    }

    static Resource buildResource() {
        AttributesBuilder attributes = Attributes.builder();
        try {
            attributes.put(ResourceAttributes.HOST_NAME, InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        String hostArch = null;
        try {
            hostArch = System.getProperty("os.arch");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (hostArch != null) {
            attributes.put(ResourceAttributes.HOST_ARCH, hostArch);
        }
        return Resource.create(attributes.build(), "https://opentelemetry.io/schemas/1.20.0");
    }

    private HostResource() {
    }
}

