/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.resources;

import com.google.auto.service.AutoService;
import com.singularity.ee.agent.util.log4j.ADShadedLogger;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.instrumentation.resources.ProcessArguments;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ConditionalResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.annotation.Nullable;

@AutoService(value={ResourceProvider.class})
public final class JarServiceNameDetector
implements ConditionalResourceProvider {
    private static final ADShadedLogger logger = ADShadedLogger.getLogger((String)JarServiceNameDetector.class.getName());
    private final Supplier<String[]> getProcessHandleArguments;
    private final Function<String, String> getSystemProperty;
    private final Predicate<Path> fileExists;

    public JarServiceNameDetector() {
        this(ProcessArguments::getProcessArguments, System::getProperty, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
    }

    JarServiceNameDetector(Supplier<String[]> getProcessHandleArguments, Function<String, String> getSystemProperty, Predicate<Path> fileExists) {
        this.getProcessHandleArguments = getProcessHandleArguments;
        this.getSystemProperty = getSystemProperty;
        this.fileExists = fileExists;
    }

    @Override
    public Resource createResource(ConfigProperties config) {
        Path jarPath = this.getJarPathFromProcessHandle();
        if (jarPath == null) {
            jarPath = this.getJarPathFromSunCommandLine();
        }
        if (jarPath == null) {
            return Resource.empty();
        }
        String serviceName = JarServiceNameDetector.getServiceName(jarPath);
        logger.log(Level.FINE, "Auto-detected service name from the jar file name: {0}", (Object)serviceName);
        return Resource.create(Attributes.of(ResourceAttributes.SERVICE_NAME, serviceName));
    }

    @Override
    public boolean shouldApply(ConfigProperties config, Resource existing) {
        String serviceName = config.getString("otel.service.name");
        Map<String, String> resourceAttributes = config.getMap("otel.resource.attributes");
        return serviceName == null && !resourceAttributes.containsKey(ResourceAttributes.SERVICE_NAME.getKey()) && "unknown_service:java".equals(existing.getAttribute(ResourceAttributes.SERVICE_NAME));
    }

    @Nullable
    private Path getJarPathFromProcessHandle() {
        String[] javaArgs = this.getProcessHandleArguments.get();
        for (int i = 0; i < javaArgs.length; ++i) {
            if (!"-jar".equals(javaArgs[i]) || i >= javaArgs.length - 1) continue;
            return Paths.get(javaArgs[i + 1], new String[0]);
        }
        return null;
    }

    @Nullable
    private Path getJarPathFromSunCommandLine() {
        Path path;
        String programArguments = this.getSystemProperty.apply("sun.java.command");
        if (programArguments == null) {
            return null;
        }
        int next = 0;
        do {
            int nextSpace;
            if ((nextSpace = programArguments.indexOf(32, next)) == -1) {
                return this.pathIfExists(programArguments);
            }
            path = this.pathIfExists(programArguments.substring(0, nextSpace));
            next = nextSpace + 1;
        } while (path == null);
        return path;
    }

    @Nullable
    private Path pathIfExists(String programArguments) {
        Path candidate;
        try {
            candidate = Paths.get(programArguments, new String[0]);
        }
        catch (InvalidPathException e) {
            return null;
        }
        return this.fileExists.test(candidate) ? candidate : null;
    }

    private static String getServiceName(Path jarPath) {
        String jarName = jarPath.getFileName().toString();
        int dotIndex = jarName.lastIndexOf(".");
        return dotIndex == -1 ? jarName : jarName.substring(0, dotIndex);
    }

    @Override
    public int order() {
        return 1000;
    }
}

