/*
 * Copyright (c) AppDynamics, Inc., and its affiliates
 * 2017
 * All Rights Reserved
 * THIS IS UNPUBLISHED PROPRIETARY CODE OF APPDYNAMICS, INC.
 * The copyright notice above does not evidence any actual or intended publication of such source code
 */

package com.appdynamics.agent.toproto;

import appdynamics.pb.Common;
import com.singularity.ee.controller.api.dto.NameValuePair;

/**
 *
 */
public final class CommonProtobufs {

    public static NameValuePair convertNameValuePair(Common.NameValuePair proto) {
        final String unicodeValue = proto.getValue();
        final String name = proto.getName();
        return new NameValuePair(name, unicodeValue);
    }

    public static void convertNameValuePair(Common.NameValuePair.Builder proto, NameValuePair dto) {
        proto.setName(dto.getName());
        proto.setValue(dto.getValue());
    }

    public static Common.NameValuePair convertNameValuePair(NameValuePair dto) {
        final Common.NameValuePair.Builder proto = Common.NameValuePair.newBuilder();
        convertNameValuePair(proto, dto);
        return proto.build();
    }


}
