/*
 * Copyright (c) AppDynamics, Inc., and its affiliates
 * 2017
 * All Rights Reserved
 * THIS IS UNPUBLISHED PROPRIETARY CODE OF APPDYNAMICS, INC.
 * The copyright notice above does not evidence any actual or intended publication of such source code
 */

package com.appdynamics.agent.toproto;

import appdynamics.pb.Common;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatch;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatchType;

/**
 *
 */
public class StringMatchProtobufs {
    /**
     * Convert a {@link StringMatch} to a {@link Common.StringMatchCondition.Builder}.
     * @param pattern {@link StringMatch} to convert.
     * @return A new {@link Common.StringMatchCondition.Builder} containing all the relavent information
     * from the specified {@link StringMatch}.
     */
    public static Common.StringMatchCondition.Builder constructPStringMatchCondition(StringMatch pattern) {
        if (pattern == null) {
            return null;
        }
        Common.StringMatchCondition.Builder matchCondition = Common.StringMatchCondition.newBuilder();
        matchCondition.setIsNot(pattern.isInverse());
        Common.StringMatchCondition.Type type = constructPStringMatchType(pattern.getMatchType());
        matchCondition.setType(type);
        if (type.equals(Common.StringMatchCondition.Type.IS_IN_LIST)) {
            for (String listValue : pattern.getInList()) {
                matchCondition.addMatchStrings(listValue);
            }
        } else if (!type.equals(Common.StringMatchCondition.Type.IS_NOT_EMPTY)) {
            matchCondition.addMatchStrings(pattern.getMatchPattern());
        }
        return matchCondition;
    }

    private static Common.StringMatchCondition.Type constructPStringMatchType(StringMatchType matchType) {
        switch (matchType) {
            case STARTSWITH:
                return Common.StringMatchCondition.Type.STARTS_WITH;
            case ENDSWITH:
                return Common.StringMatchCondition.Type.ENDS_WITH;
            case CONTAINS:
                return Common.StringMatchCondition.Type.CONTAINS;
            case EQUALS:
                return Common.StringMatchCondition.Type.EQUALS;
            case REGEX:
                return Common.StringMatchCondition.Type.MATCHES_REGEX;
            case INLIST:
                return Common.StringMatchCondition.Type.IS_IN_LIST;
            case NOT_EMPTY:
                return Common.StringMatchCondition.Type.IS_NOT_EMPTY;
        }
        //TODO insert a logger error statement here
        return null;
    }
}
