/*
 * Copyright (c) AppDynamics, Inc., and its affiliates
 * 2017
 * All Rights Reserved
 * THIS IS UNPUBLISHED PROPRIETARY CODE OF APPDYNAMICS, INC.
 * The copyright notice above does not evidence any actual or intended publication of such source code
 */

package com.appdynamics.agent.toproto;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import appdynamics.pb.Common;
import appdynamics.pb.EPType;
import appdynamics.pb.PHPAgentProtobufs;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionEntryPointTypeString;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.CustomMatchPointDefinition;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.DiscoveryNamingConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ExcludeRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.IMatchPointRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.MatchPointDiscoveryConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatch;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.TransactionMatchPointConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.HTTPMethod;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.CookieMatchData;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.HTTPParameterMatchData;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.ParameterMatchType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.http.servlet.ServletMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.nodeJS.web.NodeJSWebMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.php.cli.PHPCLIScriptInvocationMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.php.drupal.PHPDrupalPageCallbackMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.php.mvc.PHPMVCActionMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.php.webservices.PHPWebServiceMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.php.wordpress.PHPWordpressPageTemplateMatchRule;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ruby.rails.RubyRailsMatchRule;

/**
 *
 */
public class EntryPointProtobufs {

    public static void fillInPHPWebTxMatchPointConfig(
            appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder builder,
            TransactionMatchPointConfig matchPointConfig) {
        addTransactionMatchPointConfigToTransactionConfigBuilder(builder,
                EPType.EntryPointType.PHP_WEB,
                matchPointConfig,
                HttpMatchPointMatchConditionConverter.INSTANCE);
    }

    public static void addNormalTransactionMatchPointConfigToTransactionConfigBuilder(
            PHPAgentProtobufs.TransactionConfig.Builder txConfig,
            TransactionMatchPointConfig origTxConfig) {
        appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder matchPointConfig =
                txConfig.getHttpBuilder();
        fillInPHPWebTxMatchPointConfig(matchPointConfig, origTxConfig);
    }

    public static void fillInNodeJSWebTxMatchPointConfig(
            appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder builder,
            TransactionMatchPointConfig matchPointConfig) {
        addTransactionMatchPointConfigToTransactionConfigBuilder(builder,
                EPType.EntryPointType.NODEJS_WEB,
                matchPointConfig,
                NodeJSMatchPointMatchConditionConverter.INSTANCE);
    }

    public static void addWebTransactionMatchPointConfigToTransactionConfigBuilder(
            PHPAgentProtobufs.TransactionConfig.Builder txConfig,
            TransactionMatchPointConfig origTxConfig) {
        appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder matchPointConfig =
                txConfig.getNodejsWebBuilder();
        fillInNodeJSWebTxMatchPointConfig(matchPointConfig, origTxConfig);
    }

    public static void fillInNativeTxMatchPointConfig(
            appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder builder,
            TransactionMatchPointConfig matchPointConfig) {
        addTransactionMatchPointConfigToTransactionConfigBuilder(builder,
                EPType.EntryPointType.WEB,
                matchPointConfig,
                HttpMatchPointMatchConditionConverter.INSTANCE);
    }

    public static void addNativeTransactionMatchPointConfigToTransactionConfigBuilder(
            PHPAgentProtobufs.TransactionConfig.Builder txConfig,
            TransactionMatchPointConfig origTxConfig) {
        appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder matchPointConfig =
                txConfig.getWebBuilder();
        fillInNativeTxMatchPointConfig(matchPointConfig, origTxConfig);
    }

    public static void fillInNativeWebTxMatchPointConfig(
            appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder builder,
            TransactionMatchPointConfig matchPointConfig) {
        addTransactionMatchPointConfigToTransactionConfigBuilder(builder,
                EPType.EntryPointType.WEB,
                matchPointConfig,
                HttpMatchPointMatchConditionConverter.INSTANCE);
    }

    public static void addNativeWebTransactionMatchPointConfigToTransactionConfigBuilder(
            PHPAgentProtobufs.TransactionConfig.Builder txConfig,
            TransactionMatchPointConfig origTxConfig) {
        appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder matchPointConfig =
                txConfig.getWebBuilder();
        fillInNativeWebTxMatchPointConfig(matchPointConfig, origTxConfig);
    }

    public static void fillInPythonWebTxMatchPointConfig(
            appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder builder,
            TransactionMatchPointConfig matchPointConfig) {
        addTransactionMatchPointConfigToTransactionConfigBuilder(builder,
                EPType.EntryPointType.PYTHON_WEB,
                matchPointConfig,
                HttpMatchPointMatchConditionConverter.INSTANCE);
    }

    public static void fillInRubyWebTxMatchPointConfig(
            appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder builder,
            TransactionMatchPointConfig matchPointConfig) {
        addTransactionMatchPointConfigToTransactionConfigBuilder(builder,
                EPType.EntryPointType.RUBY_WEB,
                matchPointConfig,
                HttpMatchPointMatchConditionConverter.INSTANCE);
    }

    public static void fillInRubyRailsTxMatchPointConfig(
            appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder builder,
            TransactionMatchPointConfig matchPointConfig) {
        addTransactionMatchPointConfigToTransactionConfigBuilder(builder,
                EPType.EntryPointType.RUBY_RAILS,
                matchPointConfig,
                RailsMatchPointMatchConditionConverter.INSTANCE);
    }

    public static void addPythonWebTxMatchPointCfgToTxCfgBuilder(PHPAgentProtobufs.TransactionConfig.Builder txConfig,
                                                                 TransactionMatchPointConfig origTxConfig) {
        appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder matchPointConfig =
                txConfig.getPythonWebBuilder();
        fillInPythonWebTxMatchPointConfig(matchPointConfig, origTxConfig);
    }


    private static appdynamics.pb.TransactionMatchPointConfig.HTTPMethod convertHTTPMethod(HTTPMethod method) {
        if (method == null) {
            return null;
        }

        switch (method) {
            case GET:
                return appdynamics.pb.TransactionMatchPointConfig.HTTPMethod.GET;
            case POST:
                return appdynamics.pb.TransactionMatchPointConfig.HTTPMethod.POST;
            case PUT:
                return appdynamics.pb.TransactionMatchPointConfig.HTTPMethod.PUT;
            case DELETE:
                return appdynamics.pb.TransactionMatchPointConfig.HTTPMethod.DELETE;
            default:
                return null;
        }
    }

    public static void fillInPHPMVCTxMatchPointConfig(
            appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder builder,
            TransactionMatchPointConfig matchPointConfig) {
        addTransactionMatchPointConfigToTransactionConfigBuilder(builder,
                EPType.EntryPointType.PHP_MVC,
                matchPointConfig,
                MVCMatchPointMatchConditionConverter.INSTANCE);
    }

    public static void addMVCTransactionMatchPointConfigToTransactionConfigBuilder(
            PHPAgentProtobufs.TransactionConfig.Builder txConfig,
            TransactionMatchPointConfig origTxConfig) {
        appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder matchPointConfig =
                txConfig.getMvcBuilder();
        fillInPHPMVCTxMatchPointConfig(matchPointConfig, origTxConfig);
    }

    public static void fillInPHPDrupalTxMatchPointConfig(
            appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder builder,
            TransactionMatchPointConfig matchPointConfig) {
        addTransactionMatchPointConfigToTransactionConfigBuilder(builder,
                EPType.EntryPointType.PHP_DRUPAL,
                matchPointConfig,
                DrupalMatchPointMatchConditionConverter.INSTANCE);
    }

    public static void addDrupalTransactionMatchPointConfigToTransactionConfigBuilder(
            PHPAgentProtobufs.TransactionConfig.Builder txConfig, TransactionMatchPointConfig origTxConfig) {
        appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder matchPointConfig =
                txConfig.getDrupalBuilder();
        fillInPHPDrupalTxMatchPointConfig(matchPointConfig, origTxConfig);
    }

    public static void fillInPHPWordpressTxMatchPointConfig(
            appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder builder,
            TransactionMatchPointConfig matchPointConfig) {
        addTransactionMatchPointConfigToTransactionConfigBuilder(builder,
                EPType.EntryPointType.PHP_WORDPRESS,
                matchPointConfig,
                WordpressMatchPointMatchConditionConverter.INSTANCE);
    }

    public static void addWordpressTransactionMatchPointConfigToTransactionConfigBuilder(
            PHPAgentProtobufs.TransactionConfig.Builder txConfig, TransactionMatchPointConfig origTxConfig) {
        appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder matchPointConfig =
                txConfig.getWordpressBuilder();
        fillInPHPWordpressTxMatchPointConfig(matchPointConfig, origTxConfig);
    }

    public static void fillInPHPCLITxMatchPointConfig(
            appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder builder,
            TransactionMatchPointConfig matchPointConfig) {
        addTransactionMatchPointConfigToTransactionConfigBuilder(builder,
                EPType.EntryPointType.PHP_CLI,
                matchPointConfig,
                CLIMatchPointMatchConditionConverter.INSTANCE);
    }

    public static void addCLITransactionMatchPointConfigToTransactionConfigBuilder(
            PHPAgentProtobufs.TransactionConfig.Builder txConfig, TransactionMatchPointConfig origTxConfig) {
        appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder matchPointConfig =
                txConfig.getCliBuilder();
        fillInPHPCLITxMatchPointConfig(matchPointConfig, origTxConfig);
    }

    public static void fillInPHPWebServiceTxMatchPointConfig(
            appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder builder,
            TransactionMatchPointConfig matchPointConfig) {
        addTransactionMatchPointConfigToTransactionConfigBuilder(builder,
                EPType.EntryPointType.PHP_WEB_SERVICE,
                matchPointConfig,
                WebServiceMatchPointMatchConditionConverter.INSTANCE);
    }

    public static void addWebServiceTransactionMatchPointConfigToTransactionConfigBuilder(
            PHPAgentProtobufs.TransactionConfig.Builder txConfig, TransactionMatchPointConfig origTxConfig) {
        appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder matchPointConfig =
                txConfig.getWebserviceBuilder();
        fillInPHPWebServiceTxMatchPointConfig(matchPointConfig, origTxConfig);
    }

    private static void constructMatchPointConfig(
            appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder matchPointConfig,
            EPType.EntryPointType entryPointType,
            TransactionMatchPointConfig origTxConfig,
            IEntryPointMatchConditionConverter conditionConverter) {
        matchPointConfig.setEntryPointType(entryPointType);

        final MatchPointDiscoveryConfig discoveryConfig = origTxConfig.getDiscoveryConfig();
        if (discoveryConfig == null) {
            // EVIL!!!!
            // If the proxy supports an entry point type that the controller does not yet support, then
            // we need to disable the entry point.
            matchPointConfig.setEnabled(false);
            return;
        }
        final DiscoveryNamingConfig namingConfig = discoveryConfig.getNamingConfig();

        final appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Discovery.Builder discovery =
                matchPointConfig.getDiscoveryConfigBuilder();

        final appdynamics.pb.TransactionMatchPointConfig.NamingScheme.Builder namingScheme =
                discovery.getNamingSchemeBuilder();

        namingScheme.setType(namingConfig.getNamingSchemeType());
        for (NameValuePair origNVPair : namingConfig.getProperties()) {
            CommonProtobufs.convertNameValuePair(namingScheme.addPropertiesBuilder(), origNVPair);
        }

        discovery.setEnabled(discoveryConfig.isEnabled());

        matchPointConfig.setEnabled(origTxConfig.isEnabled());

        ExcludeRule[] excludes = discoveryConfig.getExcludes();
        if (excludes != null) {
            for (ExcludeRule exclude : excludes) {
                conditionConverter.convert(discovery, exclude);
            }
        }
    }

    /**
     * Update a specified {@link appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder} with information translated from
     * a specified {@link TransactionMatchPointConfig}.
     * <p>
     * If the specified {@link TransactionMatchPointConfig} can not be translated to a {@link appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder}
     * because the php agent does not support whatever {@link String} entry point type the specified
     * {@link TransactionMatchPointConfig} is, then this method does nothing.
     * </p>
     * @param matchPointConfig {@link appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder} to update with configuration
     * from the specified {@link TransactionMatchPointConfig},
     * @param entryPointType {@link EPType.EntryPointType} that is being configured.
     * @param origTxConfig {@link TransactionMatchPointConfig} to translate.
     * @param customMatchPointRuleConverter delegate interface to translate match point rules to protobuf.
     */
    private static void addTransactionMatchPointConfigToTransactionConfigBuilder(
            appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder matchPointConfig,
            EPType.EntryPointType entryPointType,
            TransactionMatchPointConfig origTxConfig,
            IEntryPointMatchConditionConverter customMatchPointRuleConverter) {
        constructMatchPointConfig(matchPointConfig, entryPointType, origTxConfig, customMatchPointRuleConverter);
        final ArrayList<CustomMatchPointDefinition> customDefinitions =
                origTxConfig.getCustomMatchPointDefinitionsAsArrayList();
        if (customDefinitions != null) {
            for (CustomMatchPointDefinition customMatchPointDefinition : customDefinitions) {
                customMatchPointRuleConverter.convert(matchPointConfig, customMatchPointDefinition);
            }
        }
    }

    public static List<Common.NameValuePair> constructPProps(Map<String, String> props) {
        List<Common.NameValuePair> nameValuePairList = new ArrayList<Common.NameValuePair>();
        if (props == null) {
            return nameValuePairList;
        }
        for (Map.Entry<String, String> entry : props.entrySet()) {
            Common.NameValuePair.Builder nvp = Common.NameValuePair.newBuilder();
            nvp.setName(entry.getKey());
            nvp.setValue(entry.getValue());
            nameValuePairList.add(nvp.build());
        }
        return nameValuePairList;
    }

    private static void convertAndAddCookieMatchData(
            appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.HTTPMatchRule.Builder rule,
            CookieMatchData cookieMatchData) {
        if (cookieMatchData == null) {
            return;
        }
        final StringMatch key = cookieMatchData.getName();
        if (key == null) {
            return;
        }
        if (cookieMatchData.getMatchType() == ParameterMatchType.CHECK_FOR_EXISTENCE) {
            appdynamics.pb.TransactionMatchPointConfig.KeyValueMatch.Builder keyValueMatch = rule.addCookiesBuilder();
            keyValueMatch.setType(appdynamics.pb.TransactionMatchPointConfig.KeyValueMatch.Type.CHECK_FOR_EXISTENCE);
            keyValueMatch.setKey(StringMatchProtobufs.constructPStringMatchCondition(key));
            return;
        }
        final StringMatch value = cookieMatchData.getValue();
        if (value == null) {
            return;
        }
        appdynamics.pb.TransactionMatchPointConfig.KeyValueMatch.Builder keyValueMatch = rule.addCookiesBuilder();
        keyValueMatch.setType(appdynamics.pb.TransactionMatchPointConfig.KeyValueMatch.Type.COMPARE_VALUE);
        keyValueMatch.setKey(StringMatchProtobufs.constructPStringMatchCondition(key));
        keyValueMatch.setValue(StringMatchProtobufs.constructPStringMatchCondition(value));
    }

    private static void convertAndCookieMatchData(
            appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.HTTPMatchRule.Builder rule,
            CookieMatchData[] cookieMatchDatas) {
        for (int i = 0; i < cookieMatchDatas.length; ++i) {
            convertAndAddCookieMatchData(rule, cookieMatchDatas[i]);
        }
    }

    private static void convertAndAddHeaderMatchData(
            appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.HTTPMatchRule.Builder rule,
            HTTPParameterMatchData headerMatchData) {
        if (headerMatchData == null) {
            return;
        }
        final StringMatch key = headerMatchData.getName();
        if (key == null) {
            return;
        }
        if (headerMatchData.getMatchType() == ParameterMatchType.CHECK_FOR_EXISTENCE) {
            appdynamics.pb.TransactionMatchPointConfig.KeyValueMatch.Builder keyValueMatch = rule.addHeadersBuilder();
            keyValueMatch.setType(appdynamics.pb.TransactionMatchPointConfig.KeyValueMatch.Type.CHECK_FOR_EXISTENCE);
            keyValueMatch.setKey(StringMatchProtobufs.constructPStringMatchCondition(key));
            return;
        }
        final StringMatch value = headerMatchData.getValue();
        if (value == null) {
            return;
        }
        appdynamics.pb.TransactionMatchPointConfig.KeyValueMatch.Builder keyValueMatch = rule.addHeadersBuilder();
        keyValueMatch.setType(appdynamics.pb.TransactionMatchPointConfig.KeyValueMatch.Type.COMPARE_VALUE);
        keyValueMatch.setKey(StringMatchProtobufs.constructPStringMatchCondition(key));
        keyValueMatch.setValue(StringMatchProtobufs.constructPStringMatchCondition(value));
    }

    private static void convertAndAddHeaderMatchData(
            appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.HTTPMatchRule.Builder rule,
            HTTPParameterMatchData[] headerMatchDatas) {
        for (HTTPParameterMatchData headerMatchData : headerMatchDatas) {
            convertAndAddHeaderMatchData(rule, headerMatchData);
        }
    }

    private static void convertAndAddHTTPParameterMatchData(
            appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.HTTPMatchRule.Builder rule,
            HTTPParameterMatchData httpParameterMatchData) {
        if (httpParameterMatchData == null) {
            return;
        }
        final StringMatch key = httpParameterMatchData.getName();
        if (key == null) {
            return;
        }
        if (httpParameterMatchData.getMatchType() == ParameterMatchType.CHECK_FOR_EXISTENCE) {
            appdynamics.pb.TransactionMatchPointConfig.KeyValueMatch.Builder keyValueMatch = rule.addParamsBuilder();
            keyValueMatch.setType(appdynamics.pb.TransactionMatchPointConfig.KeyValueMatch.Type.CHECK_FOR_EXISTENCE);
            keyValueMatch.setKey(StringMatchProtobufs.constructPStringMatchCondition(key));
            return;
        }
        final StringMatch value = httpParameterMatchData.getValue();
        if (value == null) {
            return;
        }
        appdynamics.pb.TransactionMatchPointConfig.KeyValueMatch.Builder keyValueMatch = rule.addParamsBuilder();
        keyValueMatch.setType(appdynamics.pb.TransactionMatchPointConfig.KeyValueMatch.Type.COMPARE_VALUE);
        keyValueMatch.setKey(StringMatchProtobufs.constructPStringMatchCondition(key));
        keyValueMatch.setValue(StringMatchProtobufs.constructPStringMatchCondition(value));
    }

    private static void convertAndAddHTTPParameterMatchData(
            appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.HTTPMatchRule.Builder rule,
            HTTPParameterMatchData[] httpParameterMatchDatas) {
        for (HTTPParameterMatchData httpParameterMatchData : httpParameterMatchDatas) {
            convertAndAddHTTPParameterMatchData(rule, httpParameterMatchData);
        }
    }

    /**
     * Converts {@link String} to {@link EPType.EntryPointType}.
     * <p>
     * {@link String} values that do not have a corresponding
     * {@link EPType.EntryPointType} will cause this method to return null.
     * </p>
     * @param entryPointType {@link String} value of entry point type to translate to a {@link EPType.EntryPointType}.
     * @return The {@link EPType.EntryPointType} that corresponds to the specified
     * {@link String}, or null if no such {@link EPType.EntryPointType} value exists.
     */
    public static EPType.EntryPointType getPTransactionEntryType(String entryPointType) {
        if (entryPointType != null) {
            if (entryPointType.equals(TransactionEntryPointTypeString.PHP_WEB)) {
                return EPType.EntryPointType.PHP_WEB;
            } else if (entryPointType.equals(TransactionEntryPointTypeString.PHP_MVC)) {
                return EPType.EntryPointType.PHP_MVC;
            } else if (entryPointType.equals(TransactionEntryPointTypeString.PHP_DRUPAL)) {
                return EPType.EntryPointType.PHP_DRUPAL;
            } else if (entryPointType.equals(TransactionEntryPointTypeString.PHP_WORDPRESS)) {
                return EPType.EntryPointType.PHP_WORDPRESS;
            } else if (entryPointType.equals(TransactionEntryPointTypeString.PHP_CLI)) {
                return EPType.EntryPointType.PHP_CLI;
            } else if (entryPointType.equals(TransactionEntryPointTypeString.PHP_WEB_SERVICE)) {
                return EPType.EntryPointType.PHP_WEB_SERVICE;
            } else if (entryPointType.equals(TransactionEntryPointTypeString.NODEJS_WEB)) {
                return EPType.EntryPointType.NODEJS_WEB;
            } else if (entryPointType.equals(TransactionEntryPointTypeString.WEB)) {
                return EPType.EntryPointType.WEB;
            } else if (entryPointType.equals(TransactionEntryPointTypeString.PYTHON_WEB)) {
                return EPType.EntryPointType.PYTHON_WEB;
            } else if (entryPointType.equals(TransactionEntryPointTypeString.RUBY_WEB)) {
                return EPType.EntryPointType.RUBY_WEB;
            } else if (entryPointType.equals(TransactionEntryPointTypeString.RUBY_RAILS)) {
                return EPType.EntryPointType.RUBY_RAILS;
            }
        }
        return null;
    }

    private static interface IEntryPointMatchConditionConverter {
        void convert(appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder matchPointConfig,
                     CustomMatchPointDefinition customMatch);

        void convert(appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Discovery.Builder discovery,
                     ExcludeRule exclude);
    }


    private static abstract class AEntryPointMatchConditionConverter<T extends IMatchPointRule>
            implements IEntryPointMatchConditionConverter {
        public final void convert(appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Builder matchPointConfig,
                                  CustomMatchPointDefinition customMatch) {
            final T matchPointRule = (T) customMatch.getMatchPointRule();
            // Skip rules that are disabled, no point in telling the C++ code about
            // them until they are enabled.
            if (!matchPointRule.isEnabled()) {
                return;
            }

            final String btName = customMatch.getBusinessTransactionName();
            if (btName == null) {
                return;
            }

            final appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.CustomMatch.Builder customMatchBuilder =
                    matchPointConfig.addCustomDefinitionsBuilder();
            customMatchBuilder.setId(customMatch.getId());
            customMatchBuilder.setBtName(btName);
            customMatchBuilder.setPriority(matchPointRule.getPriority());
            final appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.Builder condition =
                    customMatchBuilder.getConditionBuilder();
            convertEntryPointMatchCondition(condition, matchPointRule);
        }

        public void convert(appdynamics.pb.TransactionMatchPointConfig.MatchPointConfig.Discovery.Builder discovery,
                            ExcludeRule exclude) {
            final T matchPointRule = (T) exclude.getMatchPointRule();
            if (!matchPointRule.isEnabled()) {
                return;
            }

            final appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.Builder excludeBuilder =
                    discovery.addExcludesBuilder();
            convertEntryPointMatchCondition(excludeBuilder, matchPointRule);
        }

        abstract void convertEntryPointMatchCondition(
                appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.Builder condition,
                T matchPointRule);
    }


    private static final class HttpMatchPointMatchConditionConverter
            extends AEntryPointMatchConditionConverter<ServletMatchRule> {
        static HttpMatchPointMatchConditionConverter INSTANCE = new HttpMatchPointMatchConditionConverter();

        @Override
        void convertEntryPointMatchCondition(
                appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.Builder condition,
                ServletMatchRule matchPointRule) {
            appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.HTTPMatchRule.Builder rule =
                    condition.getHttpBuilder();

            final appdynamics.pb.TransactionMatchPointConfig.HTTPMethod method =
                    convertHTTPMethod(matchPointRule.getHttpMethod());
            if (method != null) {
                rule.setMethod(method);
            }

            final Common.StringMatchCondition.Builder uriStringMatchCondition =
                    StringMatchProtobufs.constructPStringMatchCondition(matchPointRule.getUri());
            if (uriStringMatchCondition != null) {
                rule.setUri(uriStringMatchCondition);
            }

            HTTPParameterMatchData[] parameters = matchPointRule.getParameters();
            if ((parameters != null) && (parameters.length > 0)) {
                convertAndAddHTTPParameterMatchData(rule, parameters);
            }

            HTTPParameterMatchData[] headers = matchPointRule.getHeaders();
            if ((headers != null) && (headers.length > 0)) {
                convertAndAddHeaderMatchData(rule, headers);
            }

            final StringMatch hostStringMatch = matchPointRule.getHost();
            if (hostStringMatch != null) {
                Common.StringMatchCondition.Builder hostStringMatchCondition =
                        StringMatchProtobufs.constructPStringMatchCondition(hostStringMatch);
                rule.setHost(hostStringMatchCondition);
            }

            final StringMatch portStringMatch = matchPointRule.getPort();
            if (portStringMatch != null) {
                Common.StringMatchCondition.Builder portStringMatchCondition =
                        StringMatchProtobufs.constructPStringMatchCondition(portStringMatch);
                rule.setPort(portStringMatchCondition);
            }

            CookieMatchData[] cookies = matchPointRule.getCookies();
            if ((cookies != null) && (cookies.length > 0)) {
                convertAndCookieMatchData(rule, cookies);
            }

            if (matchPointRule.getRuleProperties() != null) {
                for (NameValuePair propertyNVPair : matchPointRule.getRuleProperties()) {
                    final Common.NameValuePair.Builder nvPair =
                            rule.addPropertiesBuilder();
                    CommonProtobufs.convertNameValuePair(nvPair, propertyNVPair);
                }
            }
        }
    }


    private static final class NodeJSMatchPointMatchConditionConverter
            extends AEntryPointMatchConditionConverter<NodeJSWebMatchRule> {
        static NodeJSMatchPointMatchConditionConverter INSTANCE = new NodeJSMatchPointMatchConditionConverter();

        @Override
        void convertEntryPointMatchCondition(
                appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.Builder condition,
                NodeJSWebMatchRule matchPointRule) {
            appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.HTTPMatchRule.Builder rule =
                    condition.getHttpBuilder();

            final appdynamics.pb.TransactionMatchPointConfig.HTTPMethod method =
                    convertHTTPMethod(matchPointRule.getHttpMethod());
            if (method != null) {
                rule.setMethod(method);
            }

            final Common.StringMatchCondition.Builder uriStringMatchCondition =
                    StringMatchProtobufs.constructPStringMatchCondition(matchPointRule.getUri());
            if (uriStringMatchCondition != null) {
                rule.setUri(uriStringMatchCondition);
            }

            HTTPParameterMatchData[] parameters = matchPointRule.getParameters();
            if ((parameters != null) && (parameters.length > 0)) {
                convertAndAddHTTPParameterMatchData(rule, parameters);
            }

            HTTPParameterMatchData[] headers = matchPointRule.getHeaders();
            if ((headers != null) && (headers.length > 0)) {
                convertAndAddHeaderMatchData(rule, headers);
            }

            final StringMatch hostStringMatch = matchPointRule.getHost();
            if (hostStringMatch != null) {
                Common.StringMatchCondition.Builder hostStringMatchCondition =
                        StringMatchProtobufs.constructPStringMatchCondition(hostStringMatch);
                rule.setHost(hostStringMatchCondition);
            }

            final StringMatch portStringMatch = matchPointRule.getPort();
            if (portStringMatch != null) {
                Common.StringMatchCondition.Builder portStringMatchCondition =
                        StringMatchProtobufs.constructPStringMatchCondition(portStringMatch);
                rule.setPort(portStringMatchCondition);
            }

            CookieMatchData[] cookies = matchPointRule.getCookies();
            if ((cookies != null) && (cookies.length > 0)) {
                convertAndCookieMatchData(rule, cookies);
            }

            if (matchPointRule.getRuleProperties() != null) {
                for (NameValuePair propertyNVPair : matchPointRule.getRuleProperties()) {
                    CommonProtobufs.convertNameValuePair(rule.addPropertiesBuilder(), propertyNVPair);
                }
            }
        }
    }


    private static final class MVCMatchPointMatchConditionConverter
            extends AEntryPointMatchConditionConverter<PHPMVCActionMatchRule> {
        static MVCMatchPointMatchConditionConverter INSTANCE = new MVCMatchPointMatchConditionConverter();

        @Override
        void convertEntryPointMatchCondition(
                appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.Builder condition,
                PHPMVCActionMatchRule matchPointRule) {
            final appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.MVCMatchRule.Builder rule =
                    condition.getMvcBuilder();
            final StringMatch actionClass = matchPointRule.getActionClassName();
            if (actionClass != null) {
                final Common.StringMatchCondition.Builder actionClassStringMatchCondition =
                        StringMatchProtobufs.constructPStringMatchCondition(actionClass);
                rule.setController(actionClassStringMatchCondition);
            }
            final StringMatch actionName = matchPointRule.getActionName();
            if (actionName != null) {
                final Common.StringMatchCondition.Builder actionNameStringMatchCondition =
                        StringMatchProtobufs.constructPStringMatchCondition(actionName);
                rule.setAction(actionNameStringMatchCondition);
            }
            final StringMatch methodName = matchPointRule.getMethodName();
            if (methodName != null) {
                // This is really gross, but since we use the same DTO for a Java Struts match
                // rule as for a PHP MVC match rule, we re-use the "method name" field as the
                // "module name" in PHP MVC.
                final Common.StringMatchCondition.Builder methodNameStringMatchCondition =
                        StringMatchProtobufs.constructPStringMatchCondition(methodName);
                rule.setModule(methodNameStringMatchCondition);
            }
        }
    }

    private static final class RailsMatchPointMatchConditionConverter
            extends AEntryPointMatchConditionConverter<RubyRailsMatchRule> {
        static RailsMatchPointMatchConditionConverter INSTANCE = new RailsMatchPointMatchConditionConverter();

        @Override
        void convertEntryPointMatchCondition(appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.Builder condition,
                                             RubyRailsMatchRule matchPointRule) {
            final appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.RailsMatchRule.Builder rule =
                    condition.getRailsBuilder();
            final StringMatch controllerName = matchPointRule.getControllerName();
            if (controllerName != null) {
                final Common.StringMatchCondition.Builder controllerStringMatchCondition =
                        StringMatchProtobufs.constructPStringMatchCondition(controllerName);
                rule.setController(controllerStringMatchCondition);
            }
            final StringMatch actionName = matchPointRule.getActionName();
            if (actionName != null) {
                final Common.StringMatchCondition.Builder actionNameStringMatchCondition =
                        StringMatchProtobufs.constructPStringMatchCondition(actionName);
                rule.setAction(actionNameStringMatchCondition);
            }
        }
    }

    private static final class CLIMatchPointMatchConditionConverter
            extends AEntryPointMatchConditionConverter<PHPCLIScriptInvocationMatchRule> {
        static CLIMatchPointMatchConditionConverter INSTANCE = new CLIMatchPointMatchConditionConverter();

        @Override
        void convertEntryPointMatchCondition(
                appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.Builder condition,
                PHPCLIScriptInvocationMatchRule matchPointRule) {
            final appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.CLIMatchRule.Builder rule =
                    condition.getCliBuilder();
            final StringMatch scriptName = matchPointRule.getScriptName();
            if (scriptName != null) {
                final Common.StringMatchCondition.Builder scriptNameStringMatchCondition =
                        StringMatchProtobufs.constructPStringMatchCondition(scriptName);
                rule.setScriptName(scriptNameStringMatchCondition);
            }
        }
    }


    private static final class WebServiceMatchPointMatchConditionConverter
            extends AEntryPointMatchConditionConverter<PHPWebServiceMatchRule> {
        static WebServiceMatchPointMatchConditionConverter INSTANCE = new WebServiceMatchPointMatchConditionConverter();

        @Override
        void convertEntryPointMatchCondition(
                appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.Builder condition,
                PHPWebServiceMatchRule matchPointRule) {
            final appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.WebServiceMatchRule.Builder rule =
                    condition.getWebserviceBuilder();
            final StringMatch serviceName = matchPointRule.getWebServiceName();
            if (serviceName != null) {
                final Common.StringMatchCondition.Builder serviceNameCondition =
                        StringMatchProtobufs.constructPStringMatchCondition(serviceName);
                rule.setServiceName(serviceNameCondition);
            }

            final StringMatch operationName = matchPointRule.getOperationName();
            if (operationName != null) {
                final Common.StringMatchCondition.Builder operationNameCondition =
                        StringMatchProtobufs.constructPStringMatchCondition(operationName);
                rule.setOperationName(operationNameCondition);
            }
        }
    }


    private static final class DrupalMatchPointMatchConditionConverter
            extends AEntryPointMatchConditionConverter<PHPDrupalPageCallbackMatchRule> {
        static DrupalMatchPointMatchConditionConverter INSTANCE = new DrupalMatchPointMatchConditionConverter();

        @Override
        void convertEntryPointMatchCondition(
                appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.Builder condition,
                PHPDrupalPageCallbackMatchRule matchPointRule) {
            final appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.DrupalMatchRule.Builder rule =
                    condition.getDrupalBuilder();
            final StringMatch pageCallback = matchPointRule.getPageCallbackName();
            if (pageCallback != null) {
                final Common.StringMatchCondition.Builder pageCallbackStringMatchCondition =
                        StringMatchProtobufs.constructPStringMatchCondition(pageCallback);
                rule.setPageCallbackName(pageCallbackStringMatchCondition);
            }
        }
    }


    private static final class WordpressMatchPointMatchConditionConverter
            extends AEntryPointMatchConditionConverter<PHPWordpressPageTemplateMatchRule> {
        static WordpressMatchPointMatchConditionConverter INSTANCE = new WordpressMatchPointMatchConditionConverter();

        @Override
        void convertEntryPointMatchCondition(
                appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.Builder condition,
                PHPWordpressPageTemplateMatchRule matchPointRule) {
            final appdynamics.pb.TransactionMatchPointConfig.EntryPointMatchCondition.WordpressMatchRule.Builder rule =
                    condition.getWordpressBuilder();
            final StringMatch pageTemplateName = matchPointRule.getPageTemplateName();
            if (pageTemplateName != null) {
                final Common.StringMatchCondition.Builder pageTemplateNameStringMatchCondition =
                        StringMatchProtobufs.constructPStringMatchCondition(pageTemplateName);
                rule.setPageTemplateName(pageTemplateNameStringMatchCondition);
            }
        }
    }
}
