import { IConstruct } from './construct-compat';
/**
 * Represents an Aspect.
 *
 * @stability stable
 */
export interface IAspect {
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(node: IConstruct): void;
}
/**
 * Aspects can be applied to CDK tree scopes and can operate on the tree before synthesis.
 *
 * @stability stable
 */
export declare class Aspects {
    private readonly scope;
    /**
     * Returns the `Aspects` object associated with a construct scope.
     *
     * @param scope The scope for which these aspects will apply.
     * @stability stable
     */
    static of(scope: IConstruct): Aspects;
    private constructor();
    /**
     * Adds an aspect to apply this scope before synthesis.
     *
     * @param aspect The aspect to add.
     * @stability stable
     */
    add(aspect: IAspect): void;
    /**
     * The list of aspects which were directly applied on this scope.
     *
     * @stability stable
     */
    get aspects(): IAspect[];
}
