# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDataSafePrivateEndpointsResult',
    'AwaitableGetDataSafePrivateEndpointsResult',
    'get_data_safe_private_endpoints',
    'get_data_safe_private_endpoints_output',
]

@pulumi.output_type
class GetDataSafePrivateEndpointsResult:
    """
    A collection of values returned by getDataSafePrivateEndpoints.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, data_safe_private_endpoints=None, display_name=None, filters=None, id=None, state=None, vcn_id=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if data_safe_private_endpoints and not isinstance(data_safe_private_endpoints, list):
            raise TypeError("Expected argument 'data_safe_private_endpoints' to be a list")
        pulumi.set(__self__, "data_safe_private_endpoints", data_safe_private_endpoints)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="dataSafePrivateEndpoints")
    def data_safe_private_endpoints(self) -> Sequence['outputs.GetDataSafePrivateEndpointsDataSafePrivateEndpointResult']:
        """
        The list of data_safe_private_endpoints.
        """
        return pulumi.get(self, "data_safe_private_endpoints")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the private endpoint.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDataSafePrivateEndpointsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the private endpoint.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[str]:
        """
        The OCID of the VCN.
        """
        return pulumi.get(self, "vcn_id")


class AwaitableGetDataSafePrivateEndpointsResult(GetDataSafePrivateEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataSafePrivateEndpointsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            data_safe_private_endpoints=self.data_safe_private_endpoints,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            vcn_id=self.vcn_id)


def get_data_safe_private_endpoints(access_level: Optional[str] = None,
                                    compartment_id: Optional[str] = None,
                                    compartment_id_in_subtree: Optional[bool] = None,
                                    display_name: Optional[str] = None,
                                    filters: Optional[Sequence[pulumi.InputType['GetDataSafePrivateEndpointsFilterArgs']]] = None,
                                    state: Optional[str] = None,
                                    vcn_id: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataSafePrivateEndpointsResult:
    """
    This data source provides the list of Data Safe Private Endpoints in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of Data Safe private endpoints.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_safe_private_endpoints = oci.DataSafe.get_data_safe_private_endpoints(compartment_id=var["compartment_id"],
        access_level=var["data_safe_private_endpoint_access_level"],
        compartment_id_in_subtree=var["data_safe_private_endpoint_compartment_id_in_subtree"],
        display_name=var["data_safe_private_endpoint_display_name"],
        state=var["data_safe_private_endpoint_state"],
        vcn_id=oci_core_vcn["test_vcn"]["id"])
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str display_name: A filter to return only resources that match the specified display name.
    :param str state: A filter to return only resources that match the specified lifecycle state.
    :param str vcn_id: A filter to return only resources that match the specified VCN OCID.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['vcnId'] = vcn_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getDataSafePrivateEndpoints:getDataSafePrivateEndpoints', __args__, opts=opts, typ=GetDataSafePrivateEndpointsResult).value

    return AwaitableGetDataSafePrivateEndpointsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        data_safe_private_endpoints=pulumi.get(__ret__, 'data_safe_private_endpoints'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'))


@_utilities.lift_output_func(get_data_safe_private_endpoints)
def get_data_safe_private_endpoints_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                           compartment_id: Optional[pulumi.Input[str]] = None,
                                           compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                           display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                           filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDataSafePrivateEndpointsFilterArgs']]]]] = None,
                                           state: Optional[pulumi.Input[Optional[str]]] = None,
                                           vcn_id: Optional[pulumi.Input[Optional[str]]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDataSafePrivateEndpointsResult]:
    """
    This data source provides the list of Data Safe Private Endpoints in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of Data Safe private endpoints.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_safe_private_endpoints = oci.DataSafe.get_data_safe_private_endpoints(compartment_id=var["compartment_id"],
        access_level=var["data_safe_private_endpoint_access_level"],
        compartment_id_in_subtree=var["data_safe_private_endpoint_compartment_id_in_subtree"],
        display_name=var["data_safe_private_endpoint_display_name"],
        state=var["data_safe_private_endpoint_state"],
        vcn_id=oci_core_vcn["test_vcn"]["id"])
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str display_name: A filter to return only resources that match the specified display name.
    :param str state: A filter to return only resources that match the specified lifecycle state.
    :param str vcn_id: A filter to return only resources that match the specified VCN OCID.
    """
    ...
