# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class DeviceGroupCheckTypeDto(BaseModel):
    """
    DeviceGroupCheckTypeDto
    """ # noqa: E501
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    group: Optional[DeviceGroupTypeDto] = None
    id: Union[Annotated[float, Field(strict=True, ge=1)], Annotated[int, Field(strict=True, ge=1)]]
    key: Optional[StrictStr] = None
    metrics: Optional[Dict[str, Any]] = None
    purge_at: Optional[datetime] = Field(default=None, alias="purgeAt")
    reason: Optional[StrictStr] = None
    result: Optional[StrictStr] = None
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    valid_till: Optional[datetime] = Field(default=None, alias="validTill")
    __properties: ClassVar[List[str]] = ["createdAt", "group", "id", "key", "metrics", "purgeAt", "reason", "result", "updatedAt", "validTill"]

    @field_validator('result')
    def result_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FAILED', 'NOK', 'OK']):
            raise ValueError("must be one of enum values ('FAILED', 'NOK', 'OK')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeviceGroupCheckTypeDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of group
        if self.group:
            _dict['group'] = self.group.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeviceGroupCheckTypeDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createdAt": obj.get("createdAt"),
            "group": DeviceGroupTypeDto.from_dict(obj["group"]) if obj.get("group") is not None else None,
            "id": obj.get("id"),
            "key": obj.get("key"),
            "metrics": obj.get("metrics"),
            "purgeAt": obj.get("purgeAt"),
            "reason": obj.get("reason"),
            "result": obj.get("result"),
            "updatedAt": obj.get("updatedAt"),
            "validTill": obj.get("validTill")
        })
        return _obj

from neops_workflow_engine_client.models.device_group_type_dto import DeviceGroupTypeDto
# TODO: Rewrite to not use raise_errors
DeviceGroupCheckTypeDto.model_rebuild(raise_errors=False)

