# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from neops_workflow_engine_client.models.base_entity_dto import BaseEntityDto
from neops_workflow_engine_client.models.device_execution_result_type_dto import DeviceExecutionResultTypeDto
from typing import Optional, Set
from typing_extensions import Self

class DeviceGroupTypeDto(BaseModel):
    """
    DeviceGroupTypeDto
    """ # noqa: E501
    id: Union[Annotated[float, Field(strict=True, ge=1)], Annotated[int, Field(strict=True, ge=1)]]
    active_lock_counts: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="activeLockCounts")
    check_elements: Optional[List[DeviceGroupCheckTypeDto]] = Field(default=None, alias="checkElements")
    checks: Optional[Dict[str, Any]] = None
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    device_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="deviceCount")
    device_group_execution_results: Optional[List[DeviceExecutionResultTypeDto]] = Field(default=None, alias="deviceGroupExecutionResults")
    devices: Optional[List[BaseEntityDto]] = None
    fact_elements: Optional[List[DeviceGroupFactTypeDto]] = Field(default=None, alias="factElements")
    facts: Optional[Dict[str, Any]] = None
    is_read_locked: Optional[StrictBool] = Field(default=None, alias="isReadLocked")
    is_write_locked: Optional[StrictBool] = Field(default=None, alias="isWriteLocked")
    location: Optional[Dict[str, Any]] = None
    permission: Optional[Union[StrictFloat, StrictInt]] = None
    permission_flags: Optional[List[StrictStr]] = Field(default=None, alias="permissionFlags")
    role_permissions: Optional[List[RoleDeviceGroupTypeDto]] = Field(default=None, alias="rolePermissions")
    title: Optional[StrictStr] = None
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "activeLockCounts", "checkElements", "checks", "createdAt", "deletedAt", "deviceCount", "deviceGroupExecutionResults", "devices", "factElements", "facts", "isReadLocked", "isWriteLocked", "location", "permission", "permissionFlags", "rolePermissions", "title", "updatedAt", "name", "description"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeviceGroupTypeDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in check_elements (list)
        _items = []
        if self.check_elements:
            for _item_check_elements in self.check_elements:
                if _item_check_elements:
                    _items.append(_item_check_elements.to_dict())
            _dict['checkElements'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in device_group_execution_results (list)
        _items = []
        if self.device_group_execution_results:
            for _item_device_group_execution_results in self.device_group_execution_results:
                if _item_device_group_execution_results:
                    _items.append(_item_device_group_execution_results.to_dict())
            _dict['deviceGroupExecutionResults'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in devices (list)
        _items = []
        if self.devices:
            for _item_devices in self.devices:
                if _item_devices:
                    _items.append(_item_devices.to_dict())
            _dict['devices'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in fact_elements (list)
        _items = []
        if self.fact_elements:
            for _item_fact_elements in self.fact_elements:
                if _item_fact_elements:
                    _items.append(_item_fact_elements.to_dict())
            _dict['factElements'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in role_permissions (list)
        _items = []
        if self.role_permissions:
            for _item_role_permissions in self.role_permissions:
                if _item_role_permissions:
                    _items.append(_item_role_permissions.to_dict())
            _dict['rolePermissions'] = _items
        # set to None if facts (nullable) is None
        # and model_fields_set contains the field
        if self.facts is None and "facts" in self.model_fields_set:
            _dict['facts'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeviceGroupTypeDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "activeLockCounts": obj.get("activeLockCounts"),
            "checkElements": [DeviceGroupCheckTypeDto.from_dict(_item) for _item in obj["checkElements"]] if obj.get("checkElements") is not None else None,
            "checks": obj.get("checks"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt"),
            "deviceCount": obj.get("deviceCount"),
            "deviceGroupExecutionResults": [DeviceExecutionResultTypeDto.from_dict(_item) for _item in obj["deviceGroupExecutionResults"]] if obj.get("deviceGroupExecutionResults") is not None else None,
            "devices": [BaseEntityDto.from_dict(_item) for _item in obj["devices"]] if obj.get("devices") is not None else None,
            "factElements": [DeviceGroupFactTypeDto.from_dict(_item) for _item in obj["factElements"]] if obj.get("factElements") is not None else None,
            "facts": obj.get("facts"),
            "isReadLocked": obj.get("isReadLocked"),
            "isWriteLocked": obj.get("isWriteLocked"),
            "location": obj.get("location"),
            "permission": obj.get("permission"),
            "permissionFlags": obj.get("permissionFlags"),
            "rolePermissions": [RoleDeviceGroupTypeDto.from_dict(_item) for _item in obj["rolePermissions"]] if obj.get("rolePermissions") is not None else None,
            "title": obj.get("title"),
            "updatedAt": obj.get("updatedAt"),
            "name": obj.get("name"),
            "description": obj.get("description")
        })
        return _obj

from neops_workflow_engine_client.models.device_group_check_type_dto import DeviceGroupCheckTypeDto
from neops_workflow_engine_client.models.device_group_fact_type_dto import DeviceGroupFactTypeDto
from neops_workflow_engine_client.models.role_device_group_type_dto import RoleDeviceGroupTypeDto
# TODO: Rewrite to not use raise_errors
DeviceGroupTypeDto.model_rebuild(raise_errors=False)

