# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from neops_workflow_engine_client.models.base_entity_dto import BaseEntityDto
from neops_workflow_engine_client.models.device_check_type_dto import DeviceCheckTypeDto
from neops_workflow_engine_client.models.device_config_type_dto import DeviceConfigTypeDto
from neops_workflow_engine_client.models.device_execution_result_type_dto import DeviceExecutionResultTypeDto
from neops_workflow_engine_client.models.device_execution_type_dto import DeviceExecutionTypeDto
from neops_workflow_engine_client.models.device_fact_type_dto import DeviceFactTypeDto
from neops_workflow_engine_client.models.device_group_type_dto import DeviceGroupTypeDto
from neops_workflow_engine_client.models.platform_type_dto import PlatformTypeDto
from typing import Optional, Set
from typing_extensions import Self

class DeviceTypeDto(BaseModel):
    """
    DeviceTypeDto
    """ # noqa: E501
    id: Union[Annotated[float, Field(strict=True, ge=1)], Annotated[int, Field(strict=True, ge=1)]]
    active_lock_counts: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="activeLockCounts")
    check_elements: Optional[List[DeviceCheckTypeDto]] = Field(default=None, alias="checkElements")
    password: Optional[StrictStr] = None
    checks: Optional[StrictStr] = None
    config_versions: Optional[List[DeviceConfigTypeDto]] = Field(default=None, alias="configVersions")
    connection_options: Optional[StrictStr] = Field(default=None, alias="connectionOptions")
    connection_state: Optional[StrictStr] = Field(default=None, alias="connectionState")
    controller: Optional[BaseEntityDto] = None
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    current_configuration: Optional[StrictStr] = Field(default=None, alias="currentConfiguration")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    device_execution: Optional[List[DeviceExecutionTypeDto]] = Field(default=None, alias="deviceExecution")
    device_execution_results: Optional[List[DeviceExecutionResultTypeDto]] = Field(default=None, alias="deviceExecutionResults")
    devices: Optional[List[BaseEntityDto]] = None
    external_reference: Optional[StrictStr] = Field(default=None, alias="externalReference")
    fact_elements: Optional[List[DeviceFactTypeDto]] = Field(default=None, alias="factElements")
    facts: Optional[Dict[str, Any]] = None
    first_seen_at: Optional[datetime] = Field(default=None, alias="firstSeenAt")
    group_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="groupCount")
    groups: Optional[List[DeviceGroupTypeDto]] = None
    hostname: Optional[StrictStr] = None
    interface_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="interfaceCount")
    interfaces: Optional[List[BaseEntityDto]] = None
    inventory_updated_at: Optional[datetime] = Field(default=None, alias="inventoryUpdatedAt")
    ip: Optional[StrictStr] = None
    is_read_locked: Optional[StrictBool] = Field(default=None, alias="isReadLocked")
    is_write_locked: Optional[StrictBool] = Field(default=None, alias="isWriteLocked")
    last_configuration: Optional[StrictStr] = Field(default=None, alias="lastConfiguration")
    model: Optional[StrictStr] = None
    permission: Optional[Union[StrictFloat, StrictInt]] = None
    permission_flags: Optional[List[StrictStr]] = Field(default=None, alias="permissionFlags")
    platform: Optional[PlatformTypeDto] = None
    serial: Optional[StrictStr] = None
    software_release: Optional[StrictStr] = Field(default=None, alias="softwareRelease")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    username: Optional[StrictStr] = None
    vendor: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "activeLockCounts", "checkElements", "password", "checks", "configVersions", "connectionOptions", "connectionState", "controller", "createdAt", "currentConfiguration", "deletedAt", "deviceExecution", "deviceExecutionResults", "devices", "externalReference", "factElements", "facts", "firstSeenAt", "groupCount", "groups", "hostname", "interfaceCount", "interfaces", "inventoryUpdatedAt", "ip", "isReadLocked", "isWriteLocked", "lastConfiguration", "model", "permission", "permissionFlags", "platform", "serial", "softwareRelease", "updatedAt", "username", "vendor"]

    @field_validator('connection_state')
    def connection_state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['AUTHFAILURE', 'NEW', 'NOSSH', 'OK', 'UNREACHABLE']):
            raise ValueError("must be one of enum values ('AUTHFAILURE', 'NEW', 'NOSSH', 'OK', 'UNREACHABLE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeviceTypeDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in check_elements (list)
        _items = []
        if self.check_elements:
            for _item_check_elements in self.check_elements:
                if _item_check_elements:
                    _items.append(_item_check_elements.to_dict())
            _dict['checkElements'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in config_versions (list)
        _items = []
        if self.config_versions:
            for _item_config_versions in self.config_versions:
                if _item_config_versions:
                    _items.append(_item_config_versions.to_dict())
            _dict['configVersions'] = _items
        # override the default output from pydantic by calling `to_dict()` of controller
        if self.controller:
            _dict['controller'] = self.controller.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in device_execution (list)
        _items = []
        if self.device_execution:
            for _item_device_execution in self.device_execution:
                if _item_device_execution:
                    _items.append(_item_device_execution.to_dict())
            _dict['deviceExecution'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in device_execution_results (list)
        _items = []
        if self.device_execution_results:
            for _item_device_execution_results in self.device_execution_results:
                if _item_device_execution_results:
                    _items.append(_item_device_execution_results.to_dict())
            _dict['deviceExecutionResults'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in devices (list)
        _items = []
        if self.devices:
            for _item_devices in self.devices:
                if _item_devices:
                    _items.append(_item_devices.to_dict())
            _dict['devices'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in fact_elements (list)
        _items = []
        if self.fact_elements:
            for _item_fact_elements in self.fact_elements:
                if _item_fact_elements:
                    _items.append(_item_fact_elements.to_dict())
            _dict['factElements'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in groups (list)
        _items = []
        if self.groups:
            for _item_groups in self.groups:
                if _item_groups:
                    _items.append(_item_groups.to_dict())
            _dict['groups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in interfaces (list)
        _items = []
        if self.interfaces:
            for _item_interfaces in self.interfaces:
                if _item_interfaces:
                    _items.append(_item_interfaces.to_dict())
            _dict['interfaces'] = _items
        # override the default output from pydantic by calling `to_dict()` of platform
        if self.platform:
            _dict['platform'] = self.platform.to_dict()
        # set to None if active_lock_counts (nullable) is None
        # and model_fields_set contains the field
        if self.active_lock_counts is None and "active_lock_counts" in self.model_fields_set:
            _dict['activeLockCounts'] = None

        # set to None if check_elements (nullable) is None
        # and model_fields_set contains the field
        if self.check_elements is None and "check_elements" in self.model_fields_set:
            _dict['checkElements'] = None

        # set to None if password (nullable) is None
        # and model_fields_set contains the field
        if self.password is None and "password" in self.model_fields_set:
            _dict['password'] = None

        # set to None if checks (nullable) is None
        # and model_fields_set contains the field
        if self.checks is None and "checks" in self.model_fields_set:
            _dict['checks'] = None

        # set to None if config_versions (nullable) is None
        # and model_fields_set contains the field
        if self.config_versions is None and "config_versions" in self.model_fields_set:
            _dict['configVersions'] = None

        # set to None if connection_options (nullable) is None
        # and model_fields_set contains the field
        if self.connection_options is None and "connection_options" in self.model_fields_set:
            _dict['connectionOptions'] = None

        # set to None if connection_state (nullable) is None
        # and model_fields_set contains the field
        if self.connection_state is None and "connection_state" in self.model_fields_set:
            _dict['connectionState'] = None

        # set to None if controller (nullable) is None
        # and model_fields_set contains the field
        if self.controller is None and "controller" in self.model_fields_set:
            _dict['controller'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['createdAt'] = None

        # set to None if current_configuration (nullable) is None
        # and model_fields_set contains the field
        if self.current_configuration is None and "current_configuration" in self.model_fields_set:
            _dict['currentConfiguration'] = None

        # set to None if deleted_at (nullable) is None
        # and model_fields_set contains the field
        if self.deleted_at is None and "deleted_at" in self.model_fields_set:
            _dict['deletedAt'] = None

        # set to None if device_execution (nullable) is None
        # and model_fields_set contains the field
        if self.device_execution is None and "device_execution" in self.model_fields_set:
            _dict['deviceExecution'] = None

        # set to None if device_execution_results (nullable) is None
        # and model_fields_set contains the field
        if self.device_execution_results is None and "device_execution_results" in self.model_fields_set:
            _dict['deviceExecutionResults'] = None

        # set to None if devices (nullable) is None
        # and model_fields_set contains the field
        if self.devices is None and "devices" in self.model_fields_set:
            _dict['devices'] = None

        # set to None if external_reference (nullable) is None
        # and model_fields_set contains the field
        if self.external_reference is None and "external_reference" in self.model_fields_set:
            _dict['externalReference'] = None

        # set to None if fact_elements (nullable) is None
        # and model_fields_set contains the field
        if self.fact_elements is None and "fact_elements" in self.model_fields_set:
            _dict['factElements'] = None

        # set to None if facts (nullable) is None
        # and model_fields_set contains the field
        if self.facts is None and "facts" in self.model_fields_set:
            _dict['facts'] = None

        # set to None if first_seen_at (nullable) is None
        # and model_fields_set contains the field
        if self.first_seen_at is None and "first_seen_at" in self.model_fields_set:
            _dict['firstSeenAt'] = None

        # set to None if group_count (nullable) is None
        # and model_fields_set contains the field
        if self.group_count is None and "group_count" in self.model_fields_set:
            _dict['groupCount'] = None

        # set to None if groups (nullable) is None
        # and model_fields_set contains the field
        if self.groups is None and "groups" in self.model_fields_set:
            _dict['groups'] = None

        # set to None if hostname (nullable) is None
        # and model_fields_set contains the field
        if self.hostname is None and "hostname" in self.model_fields_set:
            _dict['hostname'] = None

        # set to None if interface_count (nullable) is None
        # and model_fields_set contains the field
        if self.interface_count is None and "interface_count" in self.model_fields_set:
            _dict['interfaceCount'] = None

        # set to None if interfaces (nullable) is None
        # and model_fields_set contains the field
        if self.interfaces is None and "interfaces" in self.model_fields_set:
            _dict['interfaces'] = None

        # set to None if inventory_updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.inventory_updated_at is None and "inventory_updated_at" in self.model_fields_set:
            _dict['inventoryUpdatedAt'] = None

        # set to None if ip (nullable) is None
        # and model_fields_set contains the field
        if self.ip is None and "ip" in self.model_fields_set:
            _dict['ip'] = None

        # set to None if is_read_locked (nullable) is None
        # and model_fields_set contains the field
        if self.is_read_locked is None and "is_read_locked" in self.model_fields_set:
            _dict['isReadLocked'] = None

        # set to None if is_write_locked (nullable) is None
        # and model_fields_set contains the field
        if self.is_write_locked is None and "is_write_locked" in self.model_fields_set:
            _dict['isWriteLocked'] = None

        # set to None if last_configuration (nullable) is None
        # and model_fields_set contains the field
        if self.last_configuration is None and "last_configuration" in self.model_fields_set:
            _dict['lastConfiguration'] = None

        # set to None if model (nullable) is None
        # and model_fields_set contains the field
        if self.model is None and "model" in self.model_fields_set:
            _dict['model'] = None

        # set to None if permission (nullable) is None
        # and model_fields_set contains the field
        if self.permission is None and "permission" in self.model_fields_set:
            _dict['permission'] = None

        # set to None if permission_flags (nullable) is None
        # and model_fields_set contains the field
        if self.permission_flags is None and "permission_flags" in self.model_fields_set:
            _dict['permissionFlags'] = None

        # set to None if platform (nullable) is None
        # and model_fields_set contains the field
        if self.platform is None and "platform" in self.model_fields_set:
            _dict['platform'] = None

        # set to None if serial (nullable) is None
        # and model_fields_set contains the field
        if self.serial is None and "serial" in self.model_fields_set:
            _dict['serial'] = None

        # set to None if software_release (nullable) is None
        # and model_fields_set contains the field
        if self.software_release is None and "software_release" in self.model_fields_set:
            _dict['softwareRelease'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updatedAt'] = None

        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        # set to None if vendor (nullable) is None
        # and model_fields_set contains the field
        if self.vendor is None and "vendor" in self.model_fields_set:
            _dict['vendor'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeviceTypeDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "activeLockCounts": obj.get("activeLockCounts"),
            "checkElements": [DeviceCheckTypeDto.from_dict(_item) for _item in obj["checkElements"]] if obj.get("checkElements") is not None else None,
            "password": obj.get("password"),
            "checks": obj.get("checks"),
            "configVersions": [DeviceConfigTypeDto.from_dict(_item) for _item in obj["configVersions"]] if obj.get("configVersions") is not None else None,
            "connectionOptions": obj.get("connectionOptions"),
            "connectionState": obj.get("connectionState"),
            "controller": BaseEntityDto.from_dict(obj["controller"]) if obj.get("controller") is not None else None,
            "createdAt": obj.get("createdAt"),
            "currentConfiguration": obj.get("currentConfiguration"),
            "deletedAt": obj.get("deletedAt"),
            "deviceExecution": [DeviceExecutionTypeDto.from_dict(_item) for _item in obj["deviceExecution"]] if obj.get("deviceExecution") is not None else None,
            "deviceExecutionResults": [DeviceExecutionResultTypeDto.from_dict(_item) for _item in obj["deviceExecutionResults"]] if obj.get("deviceExecutionResults") is not None else None,
            "devices": [BaseEntityDto.from_dict(_item) for _item in obj["devices"]] if obj.get("devices") is not None else None,
            "externalReference": obj.get("externalReference"),
            "factElements": [DeviceFactTypeDto.from_dict(_item) for _item in obj["factElements"]] if obj.get("factElements") is not None else None,
            "facts": obj.get("facts"),
            "firstSeenAt": obj.get("firstSeenAt"),
            "groupCount": obj.get("groupCount"),
            "groups": [DeviceGroupTypeDto.from_dict(_item) for _item in obj["groups"]] if obj.get("groups") is not None else None,
            "hostname": obj.get("hostname"),
            "interfaceCount": obj.get("interfaceCount"),
            "interfaces": [BaseEntityDto.from_dict(_item) for _item in obj["interfaces"]] if obj.get("interfaces") is not None else None,
            "inventoryUpdatedAt": obj.get("inventoryUpdatedAt"),
            "ip": obj.get("ip"),
            "isReadLocked": obj.get("isReadLocked"),
            "isWriteLocked": obj.get("isWriteLocked"),
            "lastConfiguration": obj.get("lastConfiguration"),
            "model": obj.get("model"),
            "permission": obj.get("permission"),
            "permissionFlags": obj.get("permissionFlags"),
            "platform": PlatformTypeDto.from_dict(obj["platform"]) if obj.get("platform") is not None else None,
            "serial": obj.get("serial"),
            "softwareRelease": obj.get("softwareRelease"),
            "updatedAt": obj.get("updatedAt"),
            "username": obj.get("username"),
            "vendor": obj.get("vendor")
        })
        return _obj


