# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class EntityCreateDto(BaseModel):
    """
    EntityCreateDto
    """ # noqa: E501
    operation: StrictStr = Field(description="Type of update operation (discriminator)")
    entity: StrictStr = Field(description="Entity type to operate on")
    id: Union[Annotated[float, Field(strict=True, ge=1)], Annotated[int, Field(strict=True, ge=1)]] = Field(description="Unique identifier of the new entity")
    data: Dict[str, Any] = Field(description="Data for the new entity - allows arbitrary object structure")
    identifier_fields: Optional[List[StrictStr]] = Field(default=None, description="List of fields to map existing entities to avoid duplicates", alias="identifierFields")
    skip_if_identifier_exists: Optional[StrictBool] = Field(default=False, description="If true, the create operation will be skipped if an existing entity is found", alias="skipIfIdentifierExists")
    __properties: ClassVar[List[str]] = ["operation", "entity", "id", "data", "identifierFields", "skipIfIdentifierExists"]

    @field_validator('operation')
    def operation_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['create', 'delete', 'patch']):
            raise ValueError("must be one of enum values ('create', 'delete', 'patch')")
        return value

    @field_validator('entity')
    def entity_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['global', 'device', 'interface', 'group', 'client']):
            raise ValueError("must be one of enum values ('global', 'device', 'interface', 'group', 'client')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EntityCreateDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EntityCreateDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "operation": obj.get("operation") if obj.get("operation") is not None else 'create',
            "entity": obj.get("entity"),
            "id": obj.get("id"),
            "data": obj.get("data"),
            "identifierFields": obj.get("identifierFields"),
            "skipIfIdentifierExists": obj.get("skipIfIdentifierExists") if obj.get("skipIfIdentifierExists") is not None else False
        })
        return _obj


