# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from neops_workflow_engine_client.models.entity_patch_dto_value import EntityPatchDtoValue
from typing import Optional, Set
from typing_extensions import Self

class EntityPatchDto(BaseModel):
    """
    EntityPatchDto
    """ # noqa: E501
    operation: StrictStr = Field(description="Type of update operation (discriminator)")
    entity: StrictStr = Field(description="Entity type to operate on")
    id: Union[Annotated[float, Field(strict=True, ge=1)], Annotated[int, Field(strict=True, ge=1)]] = Field(description="Unique identifier of the new entity")
    path: StrictStr = Field(description="JSON path to the property being updated (e.g. \"facts.interfaces.eth0.status\")")
    value: Optional[EntityPatchDtoValue] = None
    __properties: ClassVar[List[str]] = ["operation", "entity", "id", "path", "value"]

    @field_validator('operation')
    def operation_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['create', 'delete', 'patch']):
            raise ValueError("must be one of enum values ('create', 'delete', 'patch')")
        return value

    @field_validator('entity')
    def entity_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['global', 'device', 'interface', 'group', 'client']):
            raise ValueError("must be one of enum values ('global', 'device', 'interface', 'group', 'client')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EntityPatchDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of value
        if self.value:
            _dict['value'] = self.value.to_dict()
        # set to None if value (nullable) is None
        # and model_fields_set contains the field
        if self.value is None and "value" in self.model_fields_set:
            _dict['value'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EntityPatchDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "operation": obj.get("operation") if obj.get("operation") is not None else 'patch',
            "entity": obj.get("entity"),
            "id": obj.get("id"),
            "path": obj.get("path"),
            "value": EntityPatchDtoValue.from_dict(obj["value"]) if obj.get("value") is not None else None
        })
        return _obj


