# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from neops_workflow_engine_client.models.workflow_execution_parameters import WorkflowExecutionParameters
from typing import Optional, Set
from typing_extensions import Self

class ExecuteWorkflowDto(BaseModel):
    """
    ExecuteWorkflowDto
    """ # noqa: E501
    workflow: Annotated[str, Field(strict=True)] = Field(description="A SemVer identifier of the workflow to run, will resolve to the highest version that matches the semantic version")
    workflow_execution_id: Optional[StrictStr] = Field(default=None, description="if not set, the workflow engine will assign a random UUID", alias="workflowExecutionId")
    execute_on_parameters: WorkflowExecutionParameters = Field(description="Execute on parameters determine which entities are handled by the workflow", alias="executeOnParameters")
    parameters: Dict[str, Any] = Field(description="Execution parameters that are used alongside the context to run function blocks")
    __properties: ClassVar[List[str]] = ["workflow", "workflowExecutionId", "executeOnParameters", "parameters"]

    @field_validator('workflow')
    def workflow_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([^\/:-]+)\/([^\/:-]+):\d+(\.\d+)?(\.\d+)?$", value):
            raise ValueError(r"must validate the regular expression /^([^\/:-]+)\/([^\/:-]+):\d+(\.\d+)?(\.\d+)?$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExecuteWorkflowDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of execute_on_parameters
        if self.execute_on_parameters:
            _dict['executeOnParameters'] = self.execute_on_parameters.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExecuteWorkflowDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "workflow": obj.get("workflow"),
            "workflowExecutionId": obj.get("workflowExecutionId"),
            "executeOnParameters": WorkflowExecutionParameters.from_dict(obj["executeOnParameters"]) if obj.get("executeOnParameters") is not None else None,
            "parameters": obj.get("parameters")
        })
        return _obj


