# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from neops_workflow_engine_client.models.base_entity_dto import BaseEntityDto
from typing import Optional, Set
from typing_extensions import Self

class InterfaceTypeDto(BaseModel):
    """
    InterfaceTypeDto
    """ # noqa: E501
    id: Union[Annotated[float, Field(strict=True, ge=1)], Annotated[int, Field(strict=True, ge=1)]]
    name: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    check_elements: Optional[Dict[str, Any]] = Field(default=None, alias="checkElements")
    checks: Optional[Dict[str, Any]] = None
    client_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="clientCount")
    clients: Optional[List[Dict[str, Any]]] = None
    config_versions: Optional[List[Dict[str, Any]]] = Field(default=None, alias="configVersions")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    current_configuration: Optional[StrictStr] = Field(default=None, alias="currentConfiguration")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    description: Optional[StrictStr] = None
    device: Optional[BaseEntityDto] = None
    fact_elements: Optional[List[Dict[str, Any]]] = Field(default=None, alias="factElements")
    facts: Optional[Dict[str, Any]] = None
    ifindex: Optional[Union[StrictFloat, StrictInt]] = None
    interface: Optional[BaseEntityDto] = None
    interface_execution_results: Optional[List[Dict[str, Any]]] = Field(default=None, alias="interfaceExecutionResults")
    last_configuration: Optional[StrictStr] = Field(default=None, alias="lastConfiguration")
    name_sorting: Optional[StrictStr] = Field(default=None, alias="nameSorting")
    neighbor_for_deletion: Optional[Dict[str, Any]] = Field(default=None, alias="neighborForDeletion")
    permission: Optional[Union[StrictFloat, StrictInt]] = None
    permission_flags: Optional[List[StrictStr]] = Field(default=None, alias="permissionFlags")
    state: Optional[StrictStr] = None
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    __properties: ClassVar[List[str]] = ["id", "name", "status", "checkElements", "checks", "clientCount", "clients", "configVersions", "createdAt", "currentConfiguration", "deletedAt", "description", "device", "factElements", "facts", "ifindex", "interface", "interfaceExecutionResults", "lastConfiguration", "nameSorting", "neighborForDeletion", "permission", "permissionFlags", "state", "updatedAt"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ADMINISTRATIVE_SHUTDOWN', 'DOWN', 'ERROR_DISABLED', 'UP']):
            raise ValueError("must be one of enum values ('ADMINISTRATIVE_SHUTDOWN', 'DOWN', 'ERROR_DISABLED', 'UP')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InterfaceTypeDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of device
        if self.device:
            _dict['device'] = self.device.to_dict()
        # override the default output from pydantic by calling `to_dict()` of interface
        if self.interface:
            _dict['interface'] = self.interface.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if client_count (nullable) is None
        # and model_fields_set contains the field
        if self.client_count is None and "client_count" in self.model_fields_set:
            _dict['clientCount'] = None

        # set to None if clients (nullable) is None
        # and model_fields_set contains the field
        if self.clients is None and "clients" in self.model_fields_set:
            _dict['clients'] = None

        # set to None if config_versions (nullable) is None
        # and model_fields_set contains the field
        if self.config_versions is None and "config_versions" in self.model_fields_set:
            _dict['configVersions'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['createdAt'] = None

        # set to None if current_configuration (nullable) is None
        # and model_fields_set contains the field
        if self.current_configuration is None and "current_configuration" in self.model_fields_set:
            _dict['currentConfiguration'] = None

        # set to None if deleted_at (nullable) is None
        # and model_fields_set contains the field
        if self.deleted_at is None and "deleted_at" in self.model_fields_set:
            _dict['deletedAt'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if device (nullable) is None
        # and model_fields_set contains the field
        if self.device is None and "device" in self.model_fields_set:
            _dict['device'] = None

        # set to None if fact_elements (nullable) is None
        # and model_fields_set contains the field
        if self.fact_elements is None and "fact_elements" in self.model_fields_set:
            _dict['factElements'] = None

        # set to None if ifindex (nullable) is None
        # and model_fields_set contains the field
        if self.ifindex is None and "ifindex" in self.model_fields_set:
            _dict['ifindex'] = None

        # set to None if interface (nullable) is None
        # and model_fields_set contains the field
        if self.interface is None and "interface" in self.model_fields_set:
            _dict['interface'] = None

        # set to None if interface_execution_results (nullable) is None
        # and model_fields_set contains the field
        if self.interface_execution_results is None and "interface_execution_results" in self.model_fields_set:
            _dict['interfaceExecutionResults'] = None

        # set to None if last_configuration (nullable) is None
        # and model_fields_set contains the field
        if self.last_configuration is None and "last_configuration" in self.model_fields_set:
            _dict['lastConfiguration'] = None

        # set to None if name_sorting (nullable) is None
        # and model_fields_set contains the field
        if self.name_sorting is None and "name_sorting" in self.model_fields_set:
            _dict['nameSorting'] = None

        # set to None if permission (nullable) is None
        # and model_fields_set contains the field
        if self.permission is None and "permission" in self.model_fields_set:
            _dict['permission'] = None

        # set to None if permission_flags (nullable) is None
        # and model_fields_set contains the field
        if self.permission_flags is None and "permission_flags" in self.model_fields_set:
            _dict['permissionFlags'] = None

        # set to None if state (nullable) is None
        # and model_fields_set contains the field
        if self.state is None and "state" in self.model_fields_set:
            _dict['state'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updatedAt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InterfaceTypeDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "status": obj.get("status"),
            "checkElements": obj.get("checkElements"),
            "checks": obj.get("checks"),
            "clientCount": obj.get("clientCount"),
            "clients": obj.get("clients"),
            "configVersions": obj.get("configVersions"),
            "createdAt": obj.get("createdAt"),
            "currentConfiguration": obj.get("currentConfiguration"),
            "deletedAt": obj.get("deletedAt"),
            "description": obj.get("description"),
            "device": BaseEntityDto.from_dict(obj["device"]) if obj.get("device") is not None else None,
            "factElements": obj.get("factElements"),
            "facts": obj.get("facts"),
            "ifindex": obj.get("ifindex"),
            "interface": BaseEntityDto.from_dict(obj["interface"]) if obj.get("interface") is not None else None,
            "interfaceExecutionResults": obj.get("interfaceExecutionResults"),
            "lastConfiguration": obj.get("lastConfiguration"),
            "nameSorting": obj.get("nameSorting"),
            "neighborForDeletion": obj.get("neighborForDeletion"),
            "permission": obj.get("permission"),
            "permissionFlags": obj.get("permissionFlags"),
            "state": obj.get("state"),
            "updatedAt": obj.get("updatedAt")
        })
        return _obj


