# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from neops_workflow_engine_client.models.job_execution_context_dto import JobExecutionContextDto
from typing import Optional, Set
from typing_extensions import Self

class JobDefinitionDto(BaseModel):
    """
    JobDefinitionDto
    """ # noqa: E501
    function_block_id: StrictStr = Field(description="ID of the resolved function block that will execute this job", alias="functionBlockId")
    job_id: StrictStr = Field(description="Unique identifier for this job instance", alias="jobId")
    step_label: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Label of the workflow step this job belongs to @pattern ^[\\w_]+$", alias="stepLabel")
    parameters: Dict[str, Any] = Field(description="Input parameters for the job execution")
    context: JobExecutionContextDto = Field(description="Execution context containing devices, interfaces etc.")
    type: StrictStr = Field(description="Type of job")
    run_on: StrictStr = Field(alias="runOn")
    entity_id: Optional[Union[StrictFloat, StrictInt]] = Field(alias="entityId")
    __properties: ClassVar[List[str]] = ["functionBlockId", "jobId", "stepLabel", "parameters", "context", "type", "runOn", "entityId"]

    @field_validator('step_label')
    def step_label_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(?!parameters$)(?!context$)(?!steps$)\w+$", value):
            raise ValueError(r"must validate the regular expression /^(?!parameters$)(?!context$)(?!steps$)\w+$/")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['acquire', 'execute', 'rollback']):
            raise ValueError("must be one of enum values ('acquire', 'execute', 'rollback')")
        return value

    @field_validator('run_on')
    def run_on_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['global', 'device', 'interface', 'group', 'client']):
            raise ValueError("must be one of enum values ('global', 'device', 'interface', 'group', 'client')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JobDefinitionDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of context
        if self.context:
            _dict['context'] = self.context.to_dict()
        # set to None if entity_id (nullable) is None
        # and model_fields_set contains the field
        if self.entity_id is None and "entity_id" in self.model_fields_set:
            _dict['entityId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JobDefinitionDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "functionBlockId": obj.get("functionBlockId"),
            "jobId": obj.get("jobId"),
            "stepLabel": obj.get("stepLabel"),
            "parameters": obj.get("parameters"),
            "context": JobExecutionContextDto.from_dict(obj["context"]) if obj.get("context") is not None else None,
            "type": obj.get("type"),
            "runOn": obj.get("runOn"),
            "entityId": obj.get("entityId")
        })
        return _obj


