# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from neops_workflow_engine_client.models.device_group_type_dto import DeviceGroupTypeDto
from neops_workflow_engine_client.models.device_type_dto import DeviceTypeDto
from neops_workflow_engine_client.models.interface_type_dto import InterfaceTypeDto
from typing import Optional, Set
from typing_extensions import Self

class JobExecutionContextDto(BaseModel):
    """
    JobExecutionContextDto
    """ # noqa: E501
    devices: List[DeviceTypeDto] = Field(description="List of devices involved in the job execution")
    device_groups: List[DeviceGroupTypeDto] = Field(description="List of device groups involved in the job execution", alias="deviceGroups")
    interfaces: List[InterfaceTypeDto] = Field(description="List of interfaces involved in the job execution")
    __properties: ClassVar[List[str]] = ["devices", "deviceGroups", "interfaces"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JobExecutionContextDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in devices (list)
        _items = []
        if self.devices:
            for _item_devices in self.devices:
                if _item_devices:
                    _items.append(_item_devices.to_dict())
            _dict['devices'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in device_groups (list)
        _items = []
        if self.device_groups:
            for _item_device_groups in self.device_groups:
                if _item_device_groups:
                    _items.append(_item_device_groups.to_dict())
            _dict['deviceGroups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in interfaces (list)
        _items = []
        if self.interfaces:
            for _item_interfaces in self.interfaces:
                if _item_interfaces:
                    _items.append(_item_interfaces.to_dict())
            _dict['interfaces'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JobExecutionContextDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "devices": [DeviceTypeDto.from_dict(_item) for _item in obj["devices"]] if obj.get("devices") is not None else None,
            "deviceGroups": [DeviceGroupTypeDto.from_dict(_item) for _item in obj["deviceGroups"]] if obj.get("deviceGroups") is not None else None,
            "interfaces": [InterfaceTypeDto.from_dict(_item) for _item in obj["interfaces"]] if obj.get("interfaces") is not None else None
        })
        return _obj


