# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from neops_workflow_engine_client.models.job_execution_result_db_updates_dto import JobExecutionResultDbUpdatesDto
from typing import Optional, Set
from typing_extensions import Self

class JobExecutionResultDto(BaseModel):
    """
    JobExecutionResultDto
    """ # noqa: E501
    db_updates: Optional[JobExecutionResultDbUpdatesDto] = Field(default=None, alias="dbUpdates")
    success: StrictBool
    message: Optional[StrictStr] = None
    data: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["dbUpdates", "success", "message", "data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JobExecutionResultDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of db_updates
        if self.db_updates:
            _dict['dbUpdates'] = self.db_updates.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JobExecutionResultDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dbUpdates": JobExecutionResultDbUpdatesDto.from_dict(obj["dbUpdates"]) if obj.get("dbUpdates") is not None else None,
            "success": obj.get("success"),
            "message": obj.get("message"),
            "data": obj.get("data")
        })
        return _obj


