# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class JobLogDto(BaseModel):
    """
    JobLogDto
    """ # noqa: E501
    workflow_id: Annotated[str, Field(strict=True)] = Field(description="Unique semantic version identifier of the workflow this log belongs to", alias="workflowId")
    job_id: StrictStr = Field(description="Unique identifier of the job this log belongs to", alias="jobId")
    function_block_id: Annotated[str, Field(strict=True)] = Field(description="Unique semantic version identifier of the function block this log that generated this log", alias="functionBlockId")
    log_entry: StrictStr = Field(description="The actual log message content", alias="logEntry")
    log_level: StrictStr = Field(description="Severity level of the log (e.g. 'info', 'warn', 'error')", alias="logLevel")
    timestamp: datetime = Field(description="When the log entry was created")
    __properties: ClassVar[List[str]] = ["workflowId", "jobId", "functionBlockId", "logEntry", "logLevel", "timestamp"]

    @field_validator('workflow_id')
    def workflow_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([^\/:-]+)\/([^\/:-]+):\d+(\.\d+)?(\.\d+)?$", value):
            raise ValueError(r"must validate the regular expression /^([^\/:-]+)\/([^\/:-]+):\d+(\.\d+)?(\.\d+)?$/")
        return value

    @field_validator('function_block_id')
    def function_block_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([^\/:-]+)\/([^\/:-]+):\d+(\.\d+)?(\.\d+)?$", value):
            raise ValueError(r"must validate the regular expression /^([^\/:-]+)\/([^\/:-]+):\d+(\.\d+)?(\.\d+)?$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JobLogDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JobLogDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "workflowId": obj.get("workflowId"),
            "jobId": obj.get("jobId"),
            "functionBlockId": obj.get("functionBlockId"),
            "logEntry": obj.get("logEntry"),
            "logLevel": obj.get("logLevel"),
            "timestamp": obj.get("timestamp")
        })
        return _obj


