# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from neops_workflow_engine_client.models.job_execution_result_dto import JobExecutionResultDto
from neops_workflow_engine_client.models.job_result_dto_acquires_inner import JobResultDtoAcquiresInner
from typing import Optional, Set
from typing_extensions import Self

class JobResultDto(BaseModel):
    """
    JobResultDto
    """ # noqa: E501
    job_execution_id: StrictStr = Field(description="Unique identifier of the job execution this result belongs to", alias="jobExecutionId")
    status: StrictStr = Field(description="Final status of the job execution")
    result: JobExecutionResultDto = Field(description="Detailed execution results including any device/group updates")
    acquires: Optional[List[JobResultDtoAcquiresInner]] = None
    __properties: ClassVar[List[str]] = ["jobExecutionId", "status", "result", "acquires"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['success', 'success-ack', 'failed', 'failed-ack']):
            raise ValueError("must be one of enum values ('success', 'success-ack', 'failed', 'failed-ack')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JobResultDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of result
        if self.result:
            _dict['result'] = self.result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in acquires (list)
        _items = []
        if self.acquires:
            for _item_acquires in self.acquires:
                if _item_acquires:
                    _items.append(_item_acquires.to_dict())
            _dict['acquires'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JobResultDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "jobExecutionId": obj.get("jobExecutionId"),
            "status": obj.get("status"),
            "result": JobExecutionResultDto.from_dict(obj["result"]) if obj.get("result") is not None else None,
            "acquires": [JobResultDtoAcquiresInner.from_dict(_item) for _item in obj["acquires"]] if obj.get("acquires") is not None else None
        })
        return _obj


