# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class RegisterFunctionBlockDto(BaseModel):
    """
    RegisterFunctionBlockDto
    """ # noqa: E501
    name: StrictStr = Field(description="The name of the versionable entity")
    package: StrictStr = Field(description="The package/namespace the versionable entity belongs to")
    major_version: Union[StrictFloat, StrictInt] = Field(description="Major version number (following semantic versioning)", alias="majorVersion")
    minor_version: Union[StrictFloat, StrictInt] = Field(description="Minor version number (following semantic versioning)", alias="minorVersion")
    patch_version: Union[StrictFloat, StrictInt] = Field(description="Patch version number (following semantic versioning)", alias="patchVersion")
    worker_id: Optional[StrictStr] = Field(default=None, description="Optional worker UUID to associate this function block with", alias="workerId")
    description: StrictStr = Field(description="Human-readable description of the function block's purpose")
    run_on: Optional[StrictStr] = Field(default=None, description="Type of entity this function block operates on (device, interface, etc)", alias="runOn")
    fb_type: StrictStr = Field(description="The function block's type", alias="fbType")
    markdown_help_text: Optional[StrictStr] = Field(default='', description="Help text in markdown format for documentation", alias="markdownHelpText")
    deprecated: Optional[StrictBool] = Field(default=None, description="Whether this function block is deprecated")
    parameter_json_schema: Dict[str, Any] = Field(description="JSON schema defining the function block's input parameters", alias="parameterJsonSchema")
    result_data_json_schema: Dict[str, Any] = Field(description="JSON schema defining the function block's input parameters", alias="resultDataJsonSchema")
    is_idempotent: Optional[StrictBool] = Field(default=False, description="Whether the function block produces the same result given same inputs", alias="isIdempotent")
    is_pure: Optional[StrictBool] = Field(default=False, description="Whether the function block has no side effects", alias="isPure")
    __properties: ClassVar[List[str]] = ["name", "package", "majorVersion", "minorVersion", "patchVersion", "workerId", "description", "runOn", "fbType", "markdownHelpText", "deprecated", "parameterJsonSchema", "resultDataJsonSchema", "isIdempotent", "isPure"]

    @field_validator('fb_type')
    def fb_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['configure', 'facts', 'check', 'execute', 'none']):
            raise ValueError("must be one of enum values ('configure', 'facts', 'check', 'execute', 'none')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RegisterFunctionBlockDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RegisterFunctionBlockDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "package": obj.get("package"),
            "majorVersion": obj.get("majorVersion"),
            "minorVersion": obj.get("minorVersion"),
            "patchVersion": obj.get("patchVersion"),
            "workerId": obj.get("workerId"),
            "description": obj.get("description"),
            "runOn": obj.get("runOn"),
            "fbType": obj.get("fbType"),
            "markdownHelpText": obj.get("markdownHelpText") if obj.get("markdownHelpText") is not None else '',
            "deprecated": obj.get("deprecated"),
            "parameterJsonSchema": obj.get("parameterJsonSchema"),
            "resultDataJsonSchema": obj.get("resultDataJsonSchema"),
            "isIdempotent": obj.get("isIdempotent") if obj.get("isIdempotent") is not None else False,
            "isPure": obj.get("isPure") if obj.get("isPure") is not None else False
        })
        return _obj


