# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class RoleDeviceGroupTypeDto(BaseModel):
    """
    RoleDeviceGroupTypeDto
    """ # noqa: E501
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    device_group: Optional[DeviceGroupTypeDto] = Field(default=None, alias="deviceGroup")
    id: Union[Annotated[float, Field(strict=True, ge=1)], Annotated[int, Field(strict=True, ge=1)]]
    permission: Optional[Union[StrictFloat, StrictInt]] = None
    permission_all_flags: Optional[List[StrictStr]] = Field(default=None, alias="permissionAllFlags")
    permission_flags: Optional[List[StrictStr]] = Field(default=None, alias="permissionFlags")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    __properties: ClassVar[List[str]] = ["createdAt", "deviceGroup", "id", "permission", "permissionAllFlags", "permissionFlags", "updatedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RoleDeviceGroupTypeDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of device_group
        if self.device_group:
            _dict['deviceGroup'] = self.device_group.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RoleDeviceGroupTypeDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createdAt": obj.get("createdAt"),
            "deviceGroup": DeviceGroupTypeDto.from_dict(obj["deviceGroup"]) if obj.get("deviceGroup") is not None else None,
            "id": obj.get("id"),
            "permission": obj.get("permission"),
            "permissionAllFlags": obj.get("permissionAllFlags"),
            "permissionFlags": obj.get("permissionFlags"),
            "updatedAt": obj.get("updatedAt")
        })
        return _obj

from neops_workflow_engine_client.models.device_group_type_dto import DeviceGroupTypeDto
# TODO: Rewrite to not use raise_errors
RoleDeviceGroupTypeDto.model_rebuild(raise_errors=False)

