# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from neops_workflow_engine_client.models.cron_configuration import CronConfiguration
from neops_workflow_engine_client.models.repeat_configuration import RepeatConfiguration
from neops_workflow_engine_client.models.retry_configuration import RetryConfiguration
from neops_workflow_engine_client.models.root_workflow_steps_inner import RootWorkflowStepsInner
from neops_workflow_engine_client.models.workflow_config import WorkflowConfig
from neops_workflow_engine_client.models.workflow_reference_acquire_inner import WorkflowReferenceAcquireInner
from neops_workflow_engine_client.models.workflow_reference_assert_inner import WorkflowReferenceAssertInner
from typing import Optional, Set
from typing_extensions import Self

class RootWorkflow(BaseModel):
    """
    RootWorkflow
    """ # noqa: E501
    label: Annotated[str, Field(strict=True)]
    description: Optional[StrictStr] = None
    retry_config: Optional[RetryConfiguration] = Field(default=None, alias="retryConfig")
    continue_on_error: Optional[StrictBool] = Field(default=None, alias="continueOnError")
    delay: Optional[Union[StrictFloat, StrictInt]] = None
    parameters: Dict[str, Any]
    raw_parameters: Dict[str, Any] = Field(alias="rawParameters")
    run_on: Optional[StrictStr] = Field(default=None, alias="runOn")
    var_assert: Optional[List[WorkflowReferenceAssertInner]] = Field(default=None, description="Optional list of assertions that must be satisfied for the step to execute. If any condition evaluates to false, the step will fail.", alias="assert")
    acquire: List[WorkflowReferenceAcquireInner]
    repeat_config: Optional[RepeatConfiguration] = Field(default=None, alias="repeatConfig")
    type: StrictStr
    name: StrictStr
    config: WorkflowConfig
    steps: List[RootWorkflowStepsInner]
    package: StrictStr
    major_version: Union[StrictFloat, StrictInt] = Field(alias="majorVersion")
    minor_version: Union[StrictFloat, StrictInt] = Field(alias="minorVersion")
    patch_version: Union[StrictFloat, StrictInt] = Field(alias="patchVersion")
    seed_entity: StrictStr = Field(alias="seedEntity")
    cron: Optional[List[CronConfiguration]] = None
    hide_for_execution: Optional[StrictBool] = Field(default=None, alias="hideForExecution")
    parameter_schema: Dict[str, Any] = Field(alias="parameterSchema")
    __properties: ClassVar[List[str]] = ["label", "description", "retryConfig", "continueOnError", "delay", "parameters", "rawParameters", "runOn", "assert", "acquire", "repeatConfig", "type", "name", "config", "steps", "package", "majorVersion", "minorVersion", "patchVersion", "seedEntity", "cron", "hideForExecution", "parameterSchema"]

    @field_validator('label')
    def label_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(?!parameters$)(?!context$)(?!steps$)\w+$", value):
            raise ValueError(r"must validate the regular expression /^(?!parameters$)(?!context$)(?!steps$)\w+$/")
        return value

    @field_validator('run_on')
    def run_on_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['global', 'device', 'interface', 'group', 'client']):
            raise ValueError("must be one of enum values ('global', 'device', 'interface', 'group', 'client')")
        return value

    @field_validator('seed_entity')
    def seed_entity_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['global', 'device', 'interface', 'group', 'client']):
            raise ValueError("must be one of enum values ('global', 'device', 'interface', 'group', 'client')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RootWorkflow from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of retry_config
        if self.retry_config:
            _dict['retryConfig'] = self.retry_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in var_assert (list)
        _items = []
        if self.var_assert:
            for _item_var_assert in self.var_assert:
                if _item_var_assert:
                    _items.append(_item_var_assert.to_dict())
            _dict['assert'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in acquire (list)
        _items = []
        if self.acquire:
            for _item_acquire in self.acquire:
                if _item_acquire:
                    _items.append(_item_acquire.to_dict())
            _dict['acquire'] = _items
        # override the default output from pydantic by calling `to_dict()` of repeat_config
        if self.repeat_config:
            _dict['repeatConfig'] = self.repeat_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item_steps in self.steps:
                if _item_steps:
                    _items.append(_item_steps.to_dict())
            _dict['steps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cron (list)
        _items = []
        if self.cron:
            for _item_cron in self.cron:
                if _item_cron:
                    _items.append(_item_cron.to_dict())
            _dict['cron'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RootWorkflow from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "label": obj.get("label"),
            "description": obj.get("description"),
            "retryConfig": RetryConfiguration.from_dict(obj["retryConfig"]) if obj.get("retryConfig") is not None else None,
            "continueOnError": obj.get("continueOnError"),
            "delay": obj.get("delay"),
            "parameters": obj.get("parameters"),
            "rawParameters": obj.get("rawParameters"),
            "runOn": obj.get("runOn"),
            "assert": [WorkflowReferenceAssertInner.from_dict(_item) for _item in obj["assert"]] if obj.get("assert") is not None else None,
            "acquire": [WorkflowReferenceAcquireInner.from_dict(_item) for _item in obj["acquire"]] if obj.get("acquire") is not None else None,
            "repeatConfig": RepeatConfiguration.from_dict(obj["repeatConfig"]) if obj.get("repeatConfig") is not None else None,
            "type": obj.get("type"),
            "name": obj.get("name"),
            "config": WorkflowConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "steps": [RootWorkflowStepsInner.from_dict(_item) for _item in obj["steps"]] if obj.get("steps") is not None else None,
            "package": obj.get("package"),
            "majorVersion": obj.get("majorVersion"),
            "minorVersion": obj.get("minorVersion"),
            "patchVersion": obj.get("patchVersion"),
            "seedEntity": obj.get("seedEntity"),
            "cron": [CronConfiguration.from_dict(_item) for _item in obj["cron"]] if obj.get("cron") is not None else None,
            "hideForExecution": obj.get("hideForExecution"),
            "parameterSchema": obj.get("parameterSchema")
        })
        return _obj


