# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class WorkerRegistrationResponseDto(BaseModel):
    """
    WorkerRegistrationResponseDto
    """ # noqa: E501
    uuid: StrictStr = Field(description="Unique identifier for the worker")
    version: StrictStr = Field(description="Worker software version")
    name: Optional[StrictStr] = Field(default=None, description="Optional human-readable name/label")
    ip_address: Optional[StrictStr] = Field(default=None, description="Optional IP address of the worker", alias="ipAddress")
    is_online: StrictBool = Field(description="Whether the worker is currently online", alias="isOnline")
    last_ping_at: datetime = Field(description="Timestamp of the last ping/heartbeat", alias="lastPingAt")
    created_at: datetime = Field(description="Timestamp when the worker was registered", alias="createdAt")
    updated_at: datetime = Field(description="Timestamp when the worker was last updated", alias="updatedAt")
    __properties: ClassVar[List[str]] = ["uuid", "version", "name", "ipAddress", "isOnline", "lastPingAt", "createdAt", "updatedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkerRegistrationResponseDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkerRegistrationResponseDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "uuid": obj.get("uuid"),
            "version": obj.get("version"),
            "name": obj.get("name"),
            "ipAddress": obj.get("ipAddress"),
            "isOnline": obj.get("isOnline"),
            "lastPingAt": obj.get("lastPingAt"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt")
        })
        return _obj


