# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class WorkflowEntryDto(BaseModel):
    """
    WorkflowEntryDto
    """ # noqa: E501
    uuid: StrictStr = Field(description="Workflow execution UUID")
    workflow_id: StrictStr = Field(description="Identifier of the workflow definition", alias="workflowId")
    workflow_name: StrictStr = Field(description="Human-readable workflow name", alias="workflowName")
    status: StrictStr
    reason: Optional[StrictStr] = Field(default=None, description="Reason for the current status")
    __properties: ClassVar[List[str]] = ["uuid", "workflowId", "workflowName", "status", "reason"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['new', 'valid', 'blocked_waiting', 'ready', 'resource_discovery', 'resources_discovered', 'scheduled', 'locking', 'locked', 'running', 'error', 'rollback', 'completed', 'failed_unsafe', 'failed_safe', 'completed_ack', 'failed_safe_ack', 'failed_unsafe_ack']):
            raise ValueError("must be one of enum values ('new', 'valid', 'blocked_waiting', 'ready', 'resource_discovery', 'resources_discovered', 'scheduled', 'locking', 'locked', 'running', 'error', 'rollback', 'completed', 'failed_unsafe', 'failed_safe', 'completed_ack', 'failed_safe_ack', 'failed_unsafe_ack')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowEntryDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowEntryDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "uuid": obj.get("uuid"),
            "workflowId": obj.get("workflowId"),
            "workflowName": obj.get("workflowName"),
            "status": obj.get("status"),
            "reason": obj.get("reason")
        })
        return _obj


