# coding: utf-8

"""
    Neops Workflow Engine

    Neops workflow engine API documentation

    The version of the OpenAPI document: develop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from neops_workflow_engine_client.models.entity_acquire_by_elastic_query import EntityAcquireByElasticQuery
from neops_workflow_engine_client.models.entity_acquire_by_expansion import EntityAcquireByExpansion
from neops_workflow_engine_client.models.entity_acquire_context import EntityAcquireContext
from neops_workflow_engine_client.models.entity_acquire_reference import EntityAcquireReference
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

WORKFLOWREFERENCEACQUIREINNER_ONE_OF_SCHEMAS = ["EntityAcquireByElasticQuery", "EntityAcquireByExpansion", "EntityAcquireContext", "EntityAcquireReference"]

class WorkflowReferenceAcquireInner(BaseModel):
    """
    WorkflowReferenceAcquireInner
    """
    # data type: EntityAcquireByElasticQuery
    oneof_schema_1_validator: Optional[EntityAcquireByElasticQuery] = None
    # data type: EntityAcquireByExpansion
    oneof_schema_2_validator: Optional[EntityAcquireByExpansion] = None
    # data type: EntityAcquireReference
    oneof_schema_3_validator: Optional[EntityAcquireReference] = None
    # data type: EntityAcquireContext
    oneof_schema_4_validator: Optional[EntityAcquireContext] = None
    actual_instance: Optional[Union[EntityAcquireByElasticQuery, EntityAcquireByExpansion, EntityAcquireContext, EntityAcquireReference]] = None
    one_of_schemas: Set[str] = { "EntityAcquireByElasticQuery", "EntityAcquireByExpansion", "EntityAcquireContext", "EntityAcquireReference" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = WorkflowReferenceAcquireInner.model_construct()
        error_messages = []
        match = 0
        # validate data type: EntityAcquireByElasticQuery
        if not isinstance(v, EntityAcquireByElasticQuery):
            error_messages.append(f"Error! Input type `{type(v)}` is not `EntityAcquireByElasticQuery`")
        else:
            match += 1
        # validate data type: EntityAcquireByExpansion
        if not isinstance(v, EntityAcquireByExpansion):
            error_messages.append(f"Error! Input type `{type(v)}` is not `EntityAcquireByExpansion`")
        else:
            match += 1
        # validate data type: EntityAcquireReference
        if not isinstance(v, EntityAcquireReference):
            error_messages.append(f"Error! Input type `{type(v)}` is not `EntityAcquireReference`")
        else:
            match += 1
        # validate data type: EntityAcquireContext
        if not isinstance(v, EntityAcquireContext):
            error_messages.append(f"Error! Input type `{type(v)}` is not `EntityAcquireContext`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in WorkflowReferenceAcquireInner with oneOf schemas: EntityAcquireByElasticQuery, EntityAcquireByExpansion, EntityAcquireContext, EntityAcquireReference. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in WorkflowReferenceAcquireInner with oneOf schemas: EntityAcquireByElasticQuery, EntityAcquireByExpansion, EntityAcquireContext, EntityAcquireReference. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into EntityAcquireByElasticQuery
        try:
            instance.actual_instance = EntityAcquireByElasticQuery.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into EntityAcquireByExpansion
        try:
            instance.actual_instance = EntityAcquireByExpansion.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into EntityAcquireReference
        try:
            instance.actual_instance = EntityAcquireReference.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into EntityAcquireContext
        try:
            instance.actual_instance = EntityAcquireContext.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into WorkflowReferenceAcquireInner with oneOf schemas: EntityAcquireByElasticQuery, EntityAcquireByExpansion, EntityAcquireContext, EntityAcquireReference. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into WorkflowReferenceAcquireInner with oneOf schemas: EntityAcquireByElasticQuery, EntityAcquireByExpansion, EntityAcquireContext, EntityAcquireReference. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], EntityAcquireByElasticQuery, EntityAcquireByExpansion, EntityAcquireContext, EntityAcquireReference]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


