"""
Copyright (c) 2023, Zscaler Inc.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
"""

from zscaler.oneapi_object import ZscalerObject


class MalwareSettings(ZscalerObject):
    """
    A class for MalwareSettings objects.
    """

    def __init__(self, config=None):
        """
        Initialize the MalwareSettings model based on API response.

        Args:
            config (dict): A dictionary representing the configuration.
        """
        super().__init__(config)

        if config:
            self.virus_blocked = config["virusBlocked"] if "virusBlocked" in config else False
            self.virus_capture = config["virusCapture"] if "virusCapture" in config else False
            self.unwanted_applications_blocked = (
                config["unwantedApplicationsBlocked"] if "unwantedApplicationsBlocked" in config else False
            )
            self.unwanted_applications_capture = (
                config["unwantedApplicationsCapture"] if "unwantedApplicationsCapture" in config else False
            )
            self.trojan_blocked = config["trojanBlocked"] if "trojanBlocked" in config else False
            self.trojan_capture = config["trojanCapture"] if "trojanCapture" in config else False
            self.worm_blocked = config["wormBlocked"] if "wormBlocked" in config else False
            self.worm_capture = config["wormCapture"] if "wormCapture" in config else False
            self.adware_blocked = config["adwareBlocked"] if "adwareBlocked" in config else False
            self.adware_capture = config["adwareCapture"] if "adwareCapture" in config else False
            self.spyware_blocked = config["spywareBlocked"] if "spywareBlocked" in config else False
            self.spyware_capture = config["spywareCapture"] if "spywareCapture" in config else False
            self.ransomware_blocked = config["ransomwareBlocked"] if "ransomwareBlocked" in config else False
            self.ransomware_capture = config["ransomwareCapture"] if "ransomwareCapture" in config else False
            self.remote_access_tool_blocked = (
                config["remoteAccessToolBlocked"] if "remoteAccessToolBlocked" in config else False
            )
            self.remote_access_tool_capture = (
                config["remoteAccessToolCapture"] if "remoteAccessToolCapture" in config else False
            )
        else:
            self.virus_blocked = False
            self.virus_capture = False
            self.unwanted_applications_blocked = False
            self.unwanted_applications_capture = False
            self.trojan_blocked = False
            self.trojan_capture = False
            self.worm_blocked = False
            self.worm_capture = False
            self.adware_blocked = False
            self.adware_capture = False
            self.spyware_blocked = False
            self.spyware_capture = False
            self.ransomware_blocked = False
            self.ransomware_capture = False
            self.remote_access_tool_blocked = False
            self.remote_access_tool_capture = False

    def request_format(self):
        """
        Return the object as a dictionary in the format expected for API requests.
        """
        parent_req_format = super().request_format()
        current_obj_format = {
            "virusBlocked": self.virus_blocked,
            "virusCapture": self.virus_capture,
            "unwantedApplicationsBlocked": self.unwanted_applications_blocked,
            "unwantedApplicationsCapture": self.unwanted_applications_capture,
            "trojanBlocked": self.trojan_blocked,
            "trojanCapture": self.trojan_capture,
            "wormBlocked": self.worm_blocked,
            "wormCapture": self.worm_capture,
            "adwareBlocked": self.adware_blocked,
            "adwareCapture": self.adware_capture,
            "spywareBlocked": self.spyware_blocked,
            "spywareCapture": self.spyware_capture,
            "ransomwareBlocked": self.ransomware_blocked,
            "ransomwareCapture": self.ransomware_capture,
            "remoteAccessToolBlocked": self.remote_access_tool_blocked,
            "remoteAccessToolCapture": self.remote_access_tool_capture,
        }
        parent_req_format.update(current_obj_format)
        return parent_req_format
