# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 0.3.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from across.sdk.v1.models.alt_az_constraint import AltAzConstraint
from across.sdk.v1.models.earth_limb_constraint import EarthLimbConstraint
from across.sdk.v1.models.moon_angle_constraint import MoonAngleConstraint
from across.sdk.v1.models.saa_polygon_constraint import SAAPolygonConstraint
from across.sdk.v1.models.sun_angle_constraint import SunAngleConstraint
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

INSTRUMENTCONSTRAINTSINNER_ONE_OF_SCHEMAS = ["AltAzConstraint", "EarthLimbConstraint", "MoonAngleConstraint", "SAAPolygonConstraint", "SunAngleConstraint"]

class InstrumentConstraintsInner(BaseModel):
    """
    InstrumentConstraintsInner
    """
    # data type: EarthLimbConstraint
    oneof_schema_1_validator: Optional[EarthLimbConstraint] = None
    # data type: MoonAngleConstraint
    oneof_schema_2_validator: Optional[MoonAngleConstraint] = None
    # data type: SunAngleConstraint
    oneof_schema_3_validator: Optional[SunAngleConstraint] = None
    # data type: SAAPolygonConstraint
    oneof_schema_4_validator: Optional[SAAPolygonConstraint] = None
    # data type: AltAzConstraint
    oneof_schema_5_validator: Optional[AltAzConstraint] = None
    actual_instance: Optional[Union[AltAzConstraint, EarthLimbConstraint, MoonAngleConstraint, SAAPolygonConstraint, SunAngleConstraint]] = None
    one_of_schemas: Set[str] = { "AltAzConstraint", "EarthLimbConstraint", "MoonAngleConstraint", "SAAPolygonConstraint", "SunAngleConstraint" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = InstrumentConstraintsInner.model_construct()
        error_messages = []
        match = 0
        # validate data type: EarthLimbConstraint
        if not isinstance(v, EarthLimbConstraint):
            error_messages.append(f"Error! Input type `{type(v)}` is not `EarthLimbConstraint`")
        else:
            match += 1
        # validate data type: MoonAngleConstraint
        if not isinstance(v, MoonAngleConstraint):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MoonAngleConstraint`")
        else:
            match += 1
        # validate data type: SunAngleConstraint
        if not isinstance(v, SunAngleConstraint):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SunAngleConstraint`")
        else:
            match += 1
        # validate data type: SAAPolygonConstraint
        if not isinstance(v, SAAPolygonConstraint):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SAAPolygonConstraint`")
        else:
            match += 1
        # validate data type: AltAzConstraint
        if not isinstance(v, AltAzConstraint):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AltAzConstraint`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in InstrumentConstraintsInner with oneOf schemas: AltAzConstraint, EarthLimbConstraint, MoonAngleConstraint, SAAPolygonConstraint, SunAngleConstraint. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in InstrumentConstraintsInner with oneOf schemas: AltAzConstraint, EarthLimbConstraint, MoonAngleConstraint, SAAPolygonConstraint, SunAngleConstraint. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("name")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `name` in the input.")

        # check if data type is `AltAzConstraint`
        if _data_type == "Altitude/Azimuth Avoidance":
            instance.actual_instance = AltAzConstraint.from_json(json_str)
            return instance

        # check if data type is `EarthLimbConstraint`
        if _data_type == "Earth Limb":
            instance.actual_instance = EarthLimbConstraint.from_json(json_str)
            return instance

        # check if data type is `MoonAngleConstraint`
        if _data_type == "Moon Angle":
            instance.actual_instance = MoonAngleConstraint.from_json(json_str)
            return instance

        # check if data type is `SAAPolygonConstraint`
        if _data_type == "South Atlantic Anomaly":
            instance.actual_instance = SAAPolygonConstraint.from_json(json_str)
            return instance

        # check if data type is `SunAngleConstraint`
        if _data_type == "Sun Angle":
            instance.actual_instance = SunAngleConstraint.from_json(json_str)
            return instance

        # check if data type is `AltAzConstraint`
        if _data_type == "AltAzConstraint":
            instance.actual_instance = AltAzConstraint.from_json(json_str)
            return instance

        # check if data type is `EarthLimbConstraint`
        if _data_type == "EarthLimbConstraint":
            instance.actual_instance = EarthLimbConstraint.from_json(json_str)
            return instance

        # check if data type is `MoonAngleConstraint`
        if _data_type == "MoonAngleConstraint":
            instance.actual_instance = MoonAngleConstraint.from_json(json_str)
            return instance

        # check if data type is `SAAPolygonConstraint`
        if _data_type == "SAAPolygonConstraint":
            instance.actual_instance = SAAPolygonConstraint.from_json(json_str)
            return instance

        # check if data type is `SunAngleConstraint`
        if _data_type == "SunAngleConstraint":
            instance.actual_instance = SunAngleConstraint.from_json(json_str)
            return instance

        # deserialize data into EarthLimbConstraint
        try:
            instance.actual_instance = EarthLimbConstraint.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MoonAngleConstraint
        try:
            instance.actual_instance = MoonAngleConstraint.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SunAngleConstraint
        try:
            instance.actual_instance = SunAngleConstraint.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SAAPolygonConstraint
        try:
            instance.actual_instance = SAAPolygonConstraint.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AltAzConstraint
        try:
            instance.actual_instance = AltAzConstraint.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into InstrumentConstraintsInner with oneOf schemas: AltAzConstraint, EarthLimbConstraint, MoonAngleConstraint, SAAPolygonConstraint, SunAngleConstraint. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into InstrumentConstraintsInner with oneOf schemas: AltAzConstraint, EarthLimbConstraint, MoonAngleConstraint, SAAPolygonConstraint, SunAngleConstraint. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], AltAzConstraint, EarthLimbConstraint, MoonAngleConstraint, SAAPolygonConstraint, SunAngleConstraint]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


