from norminette.i18n import _

errors = {
    "SPC_INSTEAD_TAB": _("Spaces at beginning of line"),
    "TAB_INSTEAD_SPC": _("Found tab when expecting space"),
    "CONSECUTIVE_SPC": _("Two or more consecutives spaces"),
    "CONSECUTIVE_WS": _("Two or more consecutives white spaces"),
    "SPC_BFR_OPERATOR": _("missing space before operator"),
    "SPC_AFTER_OPERATOR": _("missing space after operator"),
    "NO_SPC_BFR_OPR": _("extra space before operator"),
    "NO_SPC_AFR_OPR": _("extra space after operator"),
    "SPC_AFTER_PAR": _("Missing space after parenthesis (brace/bracket)"),
    "SPC_BFR_PAR": _("Missing space before parenthesis (brace/bracket)"),
    "NO_SPC_AFR_PAR": _("Extra space after parenthesis (brace/bracket)"),
    "NO_SPC_BFR_PAR": _("Extra space before parenthesis (brace/bracket)"),
    "SPC_AFTER_POINTER": _("space after pointer"),
    "SPC_LINE_START": _("Unexpected space/tab at line start"),
    "SPC_BFR_POINTER": _("bad spacing before pointer"),
    "SPACE_BEFORE_FUNC": _("Found space when expecting tab before function name"),
    "TOO_MANY_TABS_FUNC": _("extra tabs before function name"),
    "TOO_MANY_TABS_TD": _("extra tabs before typedef name"),
    "MISSING_TAB_FUNC": _("missing tab before function name"),
    "MISSING_TAB_VAR": _("missing tab before variable name"),
    "MISSING_TAB_TYPDEF": _("Missing tab before typedef name"),
    "TOO_MANY_TAB_VAR": _("extra tab before variable name"),
    "LINE_TOO_LONG": _("line too long"),
    "EXP_PARENTHESIS": _("Expected parenthesis"),
    "MISSING_IDENTIFIER": _("missing type qualifier or identifier in function arguments"),
    "FORBIDDEN_CHAR_NAME": _("user defined identifiers should contain only lowercase characters, \
digits or '_'"),
    "TOO_FEW_TAB": _("Missing tabs for indent level"),
    "TOO_MANY_TAB": _("Extra tabs for indent level"),
    "TOO_MANY_WS": _("Extra whitespaces for indent level"),
    "SPACE_REPLACE_TAB": _("Found space when expecting tab"),
    "TAB_REPLACE_SPACE": _("Found tab when expecting space"),
    "TOO_MANY_LINES": _("Function has more than 25 lines"),
    "SPACE_EMPTY_LINE": _("Space on empty line"),
    "SPC_BEFORE_NL": _("Space before newline"),
    "TOO_MANY_INSTR": _("Too many instructions on a single line"),
    "PREPROC_NO_SPACE": _("Missing space after preprocessor directive"),
    "PREPROC_UKN_STATEMENT": _("Unrecognized preprocessor statement"),
    "PREPROC_START_LINE": _("Preprocessor statement not at the beginning of the line"),
    "PREPROC_CONSTANT": _("Preprocessor statement must only contain constant defines"),
    "PREPROC_EXPECTED_EOL": _("Expected EOL after preprocessor statement"),
    "PREPROC_BAD_IF": _("If preprocessor statement without endif"),
    "PREPROC_BAD_ELIF": _("Elif preprocessor statement without if or elif"),
    "PREPROC_BAD_IFDEF": _("Ifdef preprocessor statement without endif"),
    "PREPROC_BAD_IFNDEF": _("Ifndef preprocessor statement without endif"),
    "PREPROC_BAD_ELSE": _("Else preprocessor statement without if or elif"),
    "PREPROC_BAD_ENDIF": _("Endif preprocessor statement without if, elif or else"),
    "PREPROC_BAD_INDENT": _("Bad preprocessor indentation"),
    "PREPROC_MULTLINE": _("Multiline preprocessor statement is forbidden"),
    "PREPOC_ONLY_GLOBAL": _("Preprocessor statements are only allowed in the global scope"),
    "USER_DEFINED_TYPEDEF": _("User defined typedef must start with t_"),
    "STRUCT_TYPE_NAMING": _("Structure name must start with s_"),
    "ENUM_TYPE_NAMING": _("Enum name must start with e_"),
    "UNION_TYPE_NAMING": _("Union name must start with u_"),
    "GLOBAL_VAR_NAMING": _("Global variable must start with g_"),
    "NO_TAB_BF_TYPEDEF": _("Missing whitespace before typedef name"),
    "GLOBAL_VAR_DETECTED": _("Global variable present in file. Make sure it is a reasonable choice."),
    "EOL_OPERATOR": _("Logic operator at the end of line"),
    "EMPTY_LINE_FILE_START": _("Empty line at start of file"),
    "EMPTY_LINE_FUNCTION": _("Empty line in function"),
    "EMPTY_LINE_EOF": _("Empty line at end of file"),
    "WRONG_SCOPE_VAR": _("Variable declared in incorrect scope"),
    "IMPLICIT_VAR_TYPE": _("Missing type in variable declaration"),
    "VAR_DECL_START_FUNC": _("Variable declaration not at start of function"),
    "TOO_MANY_VARS_FUNC": _("Too many variables declarations in a function"),
    "TOO_MANY_FUNCS": _("Too many functions in file"),
    "BRACE_SHOULD_EOL": _("Expected newline after brace"),
    "CONSECUTIVE_NEWLINES": _("Consecutive newlines"),
    "NEWLINE_PRECEDES_FUNC": _("Functions must be separated by a newline"),
    "NL_AFTER_VAR_DECL": _("Variable declarations must be followed by a newline"),
    "NL_AFTER_PREPROC": _("Preprocessor statement must be followed by a newline"),
    "MULT_ASSIGN_LINE": _("Multiple assignations on a single line"),
    "MULT_DECL_LINE": _("Multiple declarations on a single line"),
    "DECL_ASSIGN_LINE": _("Declaration and assignation on a single line"),
    "FORBIDDEN_CS": _("Forbidden control structure"),
    "SPACE_AFTER_KW": _("Missing space after keyword"),
    "RETURN_PARENTHESIS": _("Return value must be in parenthesis"),
    "EXP_SEMI_COLON": _("Expected semicolon"),
    "EXP_TAB": _("Expected tab"),
    "NO_ARGS_VOID": _("Empty function argument requires void"),
    "MISALIGNED_VAR_DECL": _("Misaligned variable declaration"),
    "MISALIGNED_FUNC_DECL": _("Misaligned function declaration"),
    "WRONG_SCOPE_COMMENT": _("Comment is invalid in this scope"),
    "MACRO_NAME_CAPITAL": _("Macro name must be capitalized"),
    "MACRO_FUNC_FORBIDDEN": _("Macro functions are forbidden"),
    "ASSIGN_IN_CONTROL": _("Assignment in control structure"),
    "VLA_FORBIDDEN": _("Variable length array forbidden"),
    "TOO_MANY_ARGS": _("Function has more than 4 arguments"),
    "INCLUDE_HEADER_ONLY": _(".c file includes are forbidden"),
    "INCLUDE_START_FILE": _("Include must be at the start of file"),
    "HEADER_PROT_ALL": _("Header protection must include all the instructions"),
    "HEADER_PROT_ALL_AF": _("Instructions after header protection are forbidden"),
    "HEADER_PROT_NAME": _("Wrong header protection name"),
    "HEADER_PROT_UPPER": _("Header protection must be in uppercase"),
    "HEADER_PROT_MULT": _("Multiple header protections, only one is allowed"),
    "HEADER_PROT_NODEF": _("Header protection not containing #define"),
    "TERNARY_FBIDDEN": _("Ternaries are forbidden"),
    "TOO_MANY_VALS": _("Too many values on define"),
    "NEWLINE_IN_DECL": _("Newline in declaration"),
    "MULT_IN_SINGLE_INSTR": _("Multiple instructions in single line control structure"),
    "NEWLINE_DEFINE": _("Newline in define"),
    "MISSING_TYPEDEF_ID": _("Missing identifier in typedef declaration"),
    "LABEL_FBIDDEN": _("Label statements are forbidden"),
    "GOTO_FBIDDEN": _("Goto statements are forbidden"),
    "PREPROC_GLOBAL": _("Preprocessors can only be used in the global scope"),
    "WRONG_SCOPE_FCT": _("Function prototype in incorrect scope"),
    "WRONG_SCOPE": _("Statement is in incorrect scope"),
    "INCORRECT_DEFINE": _("Incorrect values in define"),
    "BRACE_NEWLINE": _("Expected newline before brace"),
    "EXP_NEWLINE": _("Expected newline after control structure"),
    "ARG_TYPE_UKN": _("Unrecognized variable type"),
    "COMMENT_ON_INSTR": _("Comment must be on its own line or at end of a line"),
    "COMMA_START_LINE": _("Comma at line start"),
    "MIXED_SPACE_TAB": _("Mixed spaces and tabs"),
    "ATTR_EOL": _("Function attribute must be at the end of line"),
    "INVALID_HEADER": _("Missing or invalid 42 header"),
    "INCLUDE_MISSING_SP": _("Missing space between include and filename"),
    "TYPE_NOT_GLOBAL": _("Enums, structs and unions need to be defined only in global scope"),
    "FORBIDDEN_TYPEDEF": _("Typedef declaration are not allowed in .c files"),
    "FORBIDDEN_STRUCT": _("Struct declaration are not allowed in .c files"),
    "FORBIDDEN_UNION": _("Union declaration are not allowed in .c files"),
    "FORBIDDEN_ENUM": _("Enum declaration are not allowed in .c files"),
    "UNEXPECTED_EOF_CHR": _("Unexpected end of file (EOF) while parsing a char"),
    "UNEXPECTED_EOL_CHR": _("Unexpected end of line (EOL) while parsing a char"),
    "UNEXPECTED_EOF_MC": _("Unexpected end of file (EOF) while parsing a multiline comment"),
    "UNEXPECTED_EOF_STR": _("Unexpected end of file (EOF) while parsing a string"),
    "EMPTY_CHAR": _("Empty character constant"),
    "CHAR_AS_STRING": _("Character constants can have only one character"),
    "INVALID_SUFFIX": _("This suffix is invalid"),
    "BAD_FLOAT_SUFFIX": _("Invalid suffix for float/double literal constant"),
    "INVALID_BIN_INT": _("Invalid binary integer literal"),
    "INVALID_OCT_INT": _("Invalid octal integer literal"),
    "INVALID_HEX_INT": _("Invalid hexadecimal integer literal"),
    "MAXIMAL_MUNCH": _("Potential maximal munch detected"),
    "NO_HEX_DIGITS": _("No hexadecimal digits followed by the \\x"),
    "UNKNOWN_ESCAPE": _("Unknown escape sequence"),
    "BAD_EXPONENT": _("Exponent has no digits"),
    "MULTIPLE_DOTS": _("Multiple dots in float constant"),
    "MULTIPLE_X": _("Multiple 'x' in hexadecimal float constant"),
}
