# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetConnectionsResult',
    'AwaitableGetConnectionsResult',
    'get_connections',
    'get_connections_output',
]

@pulumi.output_type
class GetConnectionsResult:
    """
    A collection of values returned by getConnections.
    """
    def __init__(__self__, assignable_deployment_id=None, assignable_deployment_type=None, assigned_deployment_id=None, compartment_id=None, connection_collections=None, connection_types=None, display_name=None, filters=None, id=None, state=None, technology_types=None):
        if assignable_deployment_id and not isinstance(assignable_deployment_id, str):
            raise TypeError("Expected argument 'assignable_deployment_id' to be a str")
        pulumi.set(__self__, "assignable_deployment_id", assignable_deployment_id)
        if assignable_deployment_type and not isinstance(assignable_deployment_type, str):
            raise TypeError("Expected argument 'assignable_deployment_type' to be a str")
        pulumi.set(__self__, "assignable_deployment_type", assignable_deployment_type)
        if assigned_deployment_id and not isinstance(assigned_deployment_id, str):
            raise TypeError("Expected argument 'assigned_deployment_id' to be a str")
        pulumi.set(__self__, "assigned_deployment_id", assigned_deployment_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_collections and not isinstance(connection_collections, list):
            raise TypeError("Expected argument 'connection_collections' to be a list")
        pulumi.set(__self__, "connection_collections", connection_collections)
        if connection_types and not isinstance(connection_types, list):
            raise TypeError("Expected argument 'connection_types' to be a list")
        pulumi.set(__self__, "connection_types", connection_types)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if technology_types and not isinstance(technology_types, list):
            raise TypeError("Expected argument 'technology_types' to be a list")
        pulumi.set(__self__, "technology_types", technology_types)

    @property
    @pulumi.getter(name="assignableDeploymentId")
    def assignable_deployment_id(self) -> Optional[str]:
        return pulumi.get(self, "assignable_deployment_id")

    @property
    @pulumi.getter(name="assignableDeploymentType")
    def assignable_deployment_type(self) -> Optional[str]:
        return pulumi.get(self, "assignable_deployment_type")

    @property
    @pulumi.getter(name="assignedDeploymentId")
    def assigned_deployment_id(self) -> Optional[str]:
        return pulumi.get(self, "assigned_deployment_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionCollections")
    def connection_collections(self) -> Sequence['outputs.GetConnectionsConnectionCollectionResult']:
        """
        The list of connection_collection.
        """
        return pulumi.get(self, "connection_collections")

    @property
    @pulumi.getter(name="connectionTypes")
    def connection_types(self) -> Optional[Sequence[str]]:
        """
        The connection type.
        """
        return pulumi.get(self, "connection_types")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetConnectionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Possible lifecycle states for connection.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="technologyTypes")
    def technology_types(self) -> Optional[Sequence[str]]:
        """
        The technology type.
        """
        return pulumi.get(self, "technology_types")


class AwaitableGetConnectionsResult(GetConnectionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionsResult(
            assignable_deployment_id=self.assignable_deployment_id,
            assignable_deployment_type=self.assignable_deployment_type,
            assigned_deployment_id=self.assigned_deployment_id,
            compartment_id=self.compartment_id,
            connection_collections=self.connection_collections,
            connection_types=self.connection_types,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            technology_types=self.technology_types)


def get_connections(assignable_deployment_id: Optional[str] = None,
                    assignable_deployment_type: Optional[str] = None,
                    assigned_deployment_id: Optional[str] = None,
                    compartment_id: Optional[str] = None,
                    connection_types: Optional[Sequence[str]] = None,
                    display_name: Optional[str] = None,
                    filters: Optional[Sequence[pulumi.InputType['GetConnectionsFilterArgs']]] = None,
                    state: Optional[str] = None,
                    technology_types: Optional[Sequence[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionsResult:
    """
    This data source provides the list of Connections in Oracle Cloud Infrastructure Golden Gate service.

    Lists the Connections in the compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_connections = oci.GoldenGate.get_connections(compartment_id=compartment_id,
        assignable_deployment_id=test_deployment["id"],
        assignable_deployment_type=connection_assignable_deployment_type,
        assigned_deployment_id=test_deployment["id"],
        connection_types=connection_connection_type,
        display_name=connection_display_name,
        state=connection_state,
        technology_types=connection_technology_type)
    ```


    :param str assignable_deployment_id: Filters for compatible connections which can be, but currently not assigned to the deployment specified by its id.
    :param str assignable_deployment_type: Filters for connections which can be assigned to the latest version of the specified deployment type.
    :param str assigned_deployment_id: The OCID of the deployment which for the connection must be assigned.
    :param str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
    :param Sequence[str] connection_types: The array of connection types.
    :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param str state: A filter to return only connections having the 'lifecycleState' given.
    :param Sequence[str] technology_types: The array of technology types.
    """
    __args__ = dict()
    __args__['assignableDeploymentId'] = assignable_deployment_id
    __args__['assignableDeploymentType'] = assignable_deployment_type
    __args__['assignedDeploymentId'] = assigned_deployment_id
    __args__['compartmentId'] = compartment_id
    __args__['connectionTypes'] = connection_types
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['technologyTypes'] = technology_types
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getConnections:getConnections', __args__, opts=opts, typ=GetConnectionsResult).value

    return AwaitableGetConnectionsResult(
        assignable_deployment_id=pulumi.get(__ret__, 'assignable_deployment_id'),
        assignable_deployment_type=pulumi.get(__ret__, 'assignable_deployment_type'),
        assigned_deployment_id=pulumi.get(__ret__, 'assigned_deployment_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connection_collections=pulumi.get(__ret__, 'connection_collections'),
        connection_types=pulumi.get(__ret__, 'connection_types'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        technology_types=pulumi.get(__ret__, 'technology_types'))


@_utilities.lift_output_func(get_connections)
def get_connections_output(assignable_deployment_id: Optional[pulumi.Input[Optional[str]]] = None,
                           assignable_deployment_type: Optional[pulumi.Input[Optional[str]]] = None,
                           assigned_deployment_id: Optional[pulumi.Input[Optional[str]]] = None,
                           compartment_id: Optional[pulumi.Input[str]] = None,
                           connection_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                           display_name: Optional[pulumi.Input[Optional[str]]] = None,
                           filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetConnectionsFilterArgs']]]]] = None,
                           state: Optional[pulumi.Input[Optional[str]]] = None,
                           technology_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectionsResult]:
    """
    This data source provides the list of Connections in Oracle Cloud Infrastructure Golden Gate service.

    Lists the Connections in the compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_connections = oci.GoldenGate.get_connections(compartment_id=compartment_id,
        assignable_deployment_id=test_deployment["id"],
        assignable_deployment_type=connection_assignable_deployment_type,
        assigned_deployment_id=test_deployment["id"],
        connection_types=connection_connection_type,
        display_name=connection_display_name,
        state=connection_state,
        technology_types=connection_technology_type)
    ```


    :param str assignable_deployment_id: Filters for compatible connections which can be, but currently not assigned to the deployment specified by its id.
    :param str assignable_deployment_type: Filters for connections which can be assigned to the latest version of the specified deployment type.
    :param str assigned_deployment_id: The OCID of the deployment which for the connection must be assigned.
    :param str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
    :param Sequence[str] connection_types: The array of connection types.
    :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param str state: A filter to return only connections having the 'lifecycleState' given.
    :param Sequence[str] technology_types: The array of technology types.
    """
    ...
