# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/03_run_bifrostecolipostkma.ipynb.

# %% auto 0
__all__ = ['tools', 'bifrostecolipostkma', 'generate_bifrostecolipostkma_commands', 'cli']

# %% ../nbs/03_run_bifrostecolipostkma.ipynb 3
# Standard libs to be used in the notebook
import os
import re
import sys
import shutil
import subprocess
from pathlib import Path

# Common to nbdev template
# add into settings.ini, requirements, package name is python-dotenv, for conda build ensure `conda config --add channels conda-forge`
import dotenv  # for loading config from .env files, https://pypi.org/project/python-dotenv/
import envyaml  # Allows to loads env vars into a yaml file, https://github.com/thesimj/envyaml
import fastcore  # To add functionality related to nbdev development, https://github.com/fastai/fastcore/
import fastcore.script
from fastcore.script import call_parse


# Project specific libraries
from . import core, helpers

# %% ../nbs/03_run_bifrostecolipostkma.ipynb 5
# Get and check requirements
tools = ["kma"]
helpers.tools_are_present(tools)

# %% ../nbs/03_run_bifrostecolipostkma.ipynb 7
def bifrostecolipostkma(
    sampleid: str,
    read1: Path,
    read2: Path,
    stbit: str,
    database_path: Path,
    kma_path: Path,
    output_dir: Path,
) -> str:
    """A function that generates a command for 1 sample."""
    # Get the full paths of relative paths
    read1 = os.path.abspath(read1)
    read2 = os.path.abspath(read2)
    database_path = os.path.abspath(database_path)
    kma_path = os.path.abspath(kma_path)
    output_dir = os.path.abspath(output_dir)

    # Note the bifrostecolipostkma command will create output folders if they don't exist. This includes parent directories.
    command = f"""
    python3 {core.PACKAGE_DIR}/scripts/bifrostecolipostkma.py -i {sampleid} -R1 {read1} -R2 {read2} -stbit {stbit} -db {database_path} -k {kma_path} -o {output_dir}
    """.strip()

    # This is where one would normally run it with subprocess or such but am utilizing linux commands in Notebooks as the alternative.
    return command

# %% ../nbs/03_run_bifrostecolipostkma.ipynb 8
def generate_bifrostecolipostkma_commands(
    input_dir: Path,
    sample_sheet: str,
    output_dir: Path,
    database_path: Path,
    kma_path: Path,
):
    """A function that generates commands for many samples in a folder."""
    commands = []
    # with open(fastqs_to_bifrostecolipostkma_file_path, 'r') as f:
    #     fastqs = [line.strip() for line in f if not line.startswith("#")]
    metadata = helpers.process_sample_sheet(input_dir, sample_sheet)
    fastqs = helpers.find_fastqs(input_dir)
    metadata = helpers.add_fastqs_to_metadata(metadata, fastqs)
    stbit = helpers.get_stbit("")
    metadata = helpers.add_stbit_to_metadata(metadata, stbit)
    for sample_dict in metadata:
        try:
            sampleid = sample_dict["SampleID"]
            read1 = sample_dict["R1"]
            read2 = sample_dict["R2"]
            stbit = sample_dict["STBIT"]
            organism = sample_dict["Organism"]
            if (organism == "Ecoli") or (organism == "E. coli"):
                commands.append(
                    bifrostecolipostkma(
                        sampleid,
                        read1,
                        read2,
                        stbit,
                        database_path,
                        kma_path,
                        output_dir,
                    )
                )
        except KeyError as err:
            # print(f"Warning: SampleID {sampleid} is missing {err}.")
            pass
    return commands

# %% ../nbs/03_run_bifrostecolipostkma.ipynb 11
# This are the command line options for FBI_run_bifrostecolipostkma
# Add 'FBI_run_bifrostpostkma' into settings.ini
@call_parse
def cli(
    input: Path = None,  # Path to input folder that contains the .fastq.gz files
    sample_sheet: str = None,  # Name of the sample_sheet file
    output: Path = None,  # Path to the output directory
    db_path: Path = None,  # Path to db folder that contains the indexed database files e.g., file.comp.b, file.fsa, file.index.db, file.lenght.b, file.name, file.seq.b
    kma_path: Path = None,  # Path to kma program
    command_file: str = None,  # Path to file to write commands to
    execute: bool = True,  # Run commands in command file
    to_stdout: bool = False,  # If true, will write to stdout instead of file, mutually exclusive with output_file
    overwrite: bool = False,  # If true, will overwrite output_file if it exists
    config_file: str = None,  # Config file to overwrite default settings, arg parse values will override config file values,
) -> None:
    """This program takes as input a folder containing fastq.gz files and a sample_sheet containing
    \nSampleID	Organism	SupplyingLab
    \necoli1  Ecoli FBI
    \nand allows you to run bifrostecolipostkma.py on all Ecoli samples.
    """
    config = core.get_config(config_file)  # Set env vars and get config variables

    if input is not None:
        config["run_bifrostecolipostkma"]["input"]["dir"] = input
    if sample_sheet is not None:
        config["run_bifrostecolipostkma"]["input"]["sample_sheet"] = sample_sheet
    if output is not None:
        config["run_bifrostecolipostkma"]["output"]["dir"] = output
    if db_path is not None:
        config["run_bifrostecolipostkma"]["db_path"] = db_path
    if kma_path is not None:
        config["run_bifrostecolipostkma"]["kma_path"] = kma_path
    if command_file is not None:
        config["run_bifrostecolipostkma"]["output"]["command_file"] = command_file
    if to_stdout is True:
        config["run_bifrostecolipostkma"]["output"]["to_stdout"] = True
    if overwrite is True:
        config["run_bifrostecolipostkma"]["output"]["overwrite"] = True

    # generate_bifrostecolipostkma_commands(INPUT_DIR, SAMPLE_SHEET, OUTPUT_DIR, DB_PATH, KMA_PATH)
    commands = generate_bifrostecolipostkma_commands(
        config["run_bifrostecolipostkma"]["input"]["dir"],
        config["run_bifrostecolipostkma"]["input"]["sample_sheet"],
        config["run_bifrostecolipostkma"]["output"]["dir"],
        config["run_bifrostecolipostkma"]["db_path"],
        config["run_bifrostecolipostkma"]["kma_path"],
    )
    helpers.write_list_to_file(
        commands,
        config["run_bifrostecolipostkma"]["output"]["command_file"],
        overwrite=config["run_bifrostecolipostkma"]["output"]["overwrite"],
        to_stdout=config["run_bifrostecolipostkma"]["output"]["to_stdout"],
    )

    # For running make sure command is present
    if execute and helpers.tools_are_present(["kma"]):
        helpers.execute_commands_from_file(
            config["run_bifrostecolipostkma"]["output"]["command_file"]
        )
        # core.notification(config["demultiplex_runs"]["notification"] )
