# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import httpx
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.request_options import RequestOptions
from .environment import PulseEnvironment
from .raw_client import AsyncRawPulse, RawPulse
from .types.extract_async_response import ExtractAsyncResponse
from .types.extract_json_input_experimental_schema import ExtractJsonInputExperimentalSchema
from .types.extract_json_input_schema import ExtractJsonInputSchema
from .types.extract_json_input_storage import ExtractJsonInputStorage
from .types.extract_json_input_structured_output import ExtractJsonInputStructuredOutput
from .types.extract_response import ExtractResponse

if typing.TYPE_CHECKING:
    from .jobs.client import AsyncJobsClient, JobsClient
    from .webhooks.client import AsyncWebhooksClient, WebhooksClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class Pulse:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : PulseEnvironment
        The environment to use for requests from the client. from .environment import PulseEnvironment



        Defaults to PulseEnvironment.DEFAULT



    api_key : str
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from pulse import Pulse

    client = Pulse(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: PulseEnvironment = PulseEnvironment.DEFAULT,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._raw_client = RawPulse(client_wrapper=self._client_wrapper)
        self._jobs: typing.Optional[JobsClient] = None
        self._webhooks: typing.Optional[WebhooksClient] = None

    @property
    def with_raw_response(self) -> RawPulse:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPulse
        """
        return self._raw_client

    def extract(
        self,
        *,
        file_url: str,
        structured_output: typing.Optional[ExtractJsonInputStructuredOutput] = OMIT,
        schema: typing.Optional[ExtractJsonInputSchema] = OMIT,
        experimental_schema: typing.Optional[ExtractJsonInputExperimentalSchema] = OMIT,
        schema_prompt: typing.Optional[str] = OMIT,
        custom_prompt: typing.Optional[str] = OMIT,
        chunking: typing.Optional[str] = OMIT,
        chunk_size: typing.Optional[int] = OMIT,
        pages: typing.Optional[str] = OMIT,
        extract_figure: typing.Optional[bool] = OMIT,
        figure_description: typing.Optional[bool] = OMIT,
        return_html: typing.Optional[bool] = OMIT,
        thinking: typing.Optional[bool] = OMIT,
        storage: typing.Optional[ExtractJsonInputStorage] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtractResponse:
        """
        The primary endpoint for the Pulse API. Parses uploaded documents or remote
        file URLs and returns rich markdown content with optional structured data
        extraction based on user-provided schemas and extraction options.

        Parameters
        ----------
        file_url : str
            Public or pre-signed URL that Pulse will download and extract.

        structured_output : typing.Optional[ExtractJsonInputStructuredOutput]
            Recommended method for schema-guided extraction. Contains the schema and optional prompt in a single object.

        schema : typing.Optional[ExtractJsonInputSchema]
            (Deprecated) JSON schema describing structured data to extract. Use structuredOutput instead. Accepts either a JSON object or a stringified JSON representation.

        experimental_schema : typing.Optional[ExtractJsonInputExperimentalSchema]
            (Deprecated) Experimental schema definition used for feature flagged behaviour. Accepts either a JSON object or a stringified JSON representation.

        schema_prompt : typing.Optional[str]
            (Deprecated) Natural language prompt for schema-guided extraction. Use structuredOutput.schemaPrompt instead.

        custom_prompt : typing.Optional[str]
            (Deprecated) Custom instructions that augment the default extraction behaviour.

        chunking : typing.Optional[str]
            Comma-separated list of chunking strategies to apply (for example `semantic,header,page,recursive`).

        chunk_size : typing.Optional[int]
            Override for maximum characters per chunk when chunking is enabled.

        pages : typing.Optional[str]
            Page range filter supporting segments such as `1-2` or mixed ranges like `1-2,5`.

        extract_figure : typing.Optional[bool]
            Toggle to enable figure extraction in results.

        figure_description : typing.Optional[bool]
            Toggle to generate descriptive captions for extracted figures.

        return_html : typing.Optional[bool]
            Whether to include HTML representation alongside markdown in the response.

        thinking : typing.Optional[bool]
            (Deprecated) Enables expanded rationale output for debugging.

        storage : typing.Optional[ExtractJsonInputStorage]
            Options for persisting extraction artifacts. When enabled (default), artifacts are saved to storage and a database record is created.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtractResponse
            Synchronous extraction result

        Examples
        --------
        from pulse import Pulse

        client = Pulse(
            api_key="YOUR_API_KEY",
        )
        client.extract(
            file_url="fileUrl",
        )
        """
        _response = self._raw_client.extract(
            file_url=file_url,
            structured_output=structured_output,
            schema=schema,
            experimental_schema=experimental_schema,
            schema_prompt=schema_prompt,
            custom_prompt=custom_prompt,
            chunking=chunking,
            chunk_size=chunk_size,
            pages=pages,
            extract_figure=extract_figure,
            figure_description=figure_description,
            return_html=return_html,
            thinking=thinking,
            storage=storage,
            request_options=request_options,
        )
        return _response.data

    def extract_async(
        self,
        *,
        file_url: str,
        structured_output: typing.Optional[ExtractJsonInputStructuredOutput] = OMIT,
        schema: typing.Optional[ExtractJsonInputSchema] = OMIT,
        experimental_schema: typing.Optional[ExtractJsonInputExperimentalSchema] = OMIT,
        schema_prompt: typing.Optional[str] = OMIT,
        custom_prompt: typing.Optional[str] = OMIT,
        chunking: typing.Optional[str] = OMIT,
        chunk_size: typing.Optional[int] = OMIT,
        pages: typing.Optional[str] = OMIT,
        extract_figure: typing.Optional[bool] = OMIT,
        figure_description: typing.Optional[bool] = OMIT,
        return_html: typing.Optional[bool] = OMIT,
        thinking: typing.Optional[bool] = OMIT,
        storage: typing.Optional[ExtractJsonInputStorage] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtractAsyncResponse:
        """
        Starts an asynchronous extraction job. The request mirrors the
        synchronous options but returns immediately with a job identifier that
        clients can poll for completion status.

        Parameters
        ----------
        file_url : str
            Public or pre-signed URL that Pulse will download and extract.

        structured_output : typing.Optional[ExtractJsonInputStructuredOutput]
            Recommended method for schema-guided extraction. Contains the schema and optional prompt in a single object.

        schema : typing.Optional[ExtractJsonInputSchema]
            (Deprecated) JSON schema describing structured data to extract. Use structuredOutput instead. Accepts either a JSON object or a stringified JSON representation.

        experimental_schema : typing.Optional[ExtractJsonInputExperimentalSchema]
            (Deprecated) Experimental schema definition used for feature flagged behaviour. Accepts either a JSON object or a stringified JSON representation.

        schema_prompt : typing.Optional[str]
            (Deprecated) Natural language prompt for schema-guided extraction. Use structuredOutput.schemaPrompt instead.

        custom_prompt : typing.Optional[str]
            (Deprecated) Custom instructions that augment the default extraction behaviour.

        chunking : typing.Optional[str]
            Comma-separated list of chunking strategies to apply (for example `semantic,header,page,recursive`).

        chunk_size : typing.Optional[int]
            Override for maximum characters per chunk when chunking is enabled.

        pages : typing.Optional[str]
            Page range filter supporting segments such as `1-2` or mixed ranges like `1-2,5`.

        extract_figure : typing.Optional[bool]
            Toggle to enable figure extraction in results.

        figure_description : typing.Optional[bool]
            Toggle to generate descriptive captions for extracted figures.

        return_html : typing.Optional[bool]
            Whether to include HTML representation alongside markdown in the response.

        thinking : typing.Optional[bool]
            (Deprecated) Enables expanded rationale output for debugging.

        storage : typing.Optional[ExtractJsonInputStorage]
            Options for persisting extraction artifacts. When enabled (default), artifacts are saved to storage and a database record is created.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtractAsyncResponse
            Asynchronous extraction job accepted

        Examples
        --------
        from pulse import Pulse

        client = Pulse(
            api_key="YOUR_API_KEY",
        )
        client.extract_async(
            file_url="fileUrl",
        )
        """
        _response = self._raw_client.extract_async(
            file_url=file_url,
            structured_output=structured_output,
            schema=schema,
            experimental_schema=experimental_schema,
            schema_prompt=schema_prompt,
            custom_prompt=custom_prompt,
            chunking=chunking,
            chunk_size=chunk_size,
            pages=pages,
            extract_figure=extract_figure,
            figure_description=figure_description,
            return_html=return_html,
            thinking=thinking,
            storage=storage,
            request_options=request_options,
        )
        return _response.data

    @property
    def jobs(self):
        if self._jobs is None:
            from .jobs.client import JobsClient  # noqa: E402

            self._jobs = JobsClient(client_wrapper=self._client_wrapper)
        return self._jobs

    @property
    def webhooks(self):
        if self._webhooks is None:
            from .webhooks.client import WebhooksClient  # noqa: E402

            self._webhooks = WebhooksClient(client_wrapper=self._client_wrapper)
        return self._webhooks


class AsyncPulse:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : PulseEnvironment
        The environment to use for requests from the client. from .environment import PulseEnvironment



        Defaults to PulseEnvironment.DEFAULT



    api_key : str
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from pulse import AsyncPulse

    client = AsyncPulse(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: PulseEnvironment = PulseEnvironment.DEFAULT,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._raw_client = AsyncRawPulse(client_wrapper=self._client_wrapper)
        self._jobs: typing.Optional[AsyncJobsClient] = None
        self._webhooks: typing.Optional[AsyncWebhooksClient] = None

    @property
    def with_raw_response(self) -> AsyncRawPulse:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPulse
        """
        return self._raw_client

    async def extract(
        self,
        *,
        file_url: str,
        structured_output: typing.Optional[ExtractJsonInputStructuredOutput] = OMIT,
        schema: typing.Optional[ExtractJsonInputSchema] = OMIT,
        experimental_schema: typing.Optional[ExtractJsonInputExperimentalSchema] = OMIT,
        schema_prompt: typing.Optional[str] = OMIT,
        custom_prompt: typing.Optional[str] = OMIT,
        chunking: typing.Optional[str] = OMIT,
        chunk_size: typing.Optional[int] = OMIT,
        pages: typing.Optional[str] = OMIT,
        extract_figure: typing.Optional[bool] = OMIT,
        figure_description: typing.Optional[bool] = OMIT,
        return_html: typing.Optional[bool] = OMIT,
        thinking: typing.Optional[bool] = OMIT,
        storage: typing.Optional[ExtractJsonInputStorage] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtractResponse:
        """
        The primary endpoint for the Pulse API. Parses uploaded documents or remote
        file URLs and returns rich markdown content with optional structured data
        extraction based on user-provided schemas and extraction options.

        Parameters
        ----------
        file_url : str
            Public or pre-signed URL that Pulse will download and extract.

        structured_output : typing.Optional[ExtractJsonInputStructuredOutput]
            Recommended method for schema-guided extraction. Contains the schema and optional prompt in a single object.

        schema : typing.Optional[ExtractJsonInputSchema]
            (Deprecated) JSON schema describing structured data to extract. Use structuredOutput instead. Accepts either a JSON object or a stringified JSON representation.

        experimental_schema : typing.Optional[ExtractJsonInputExperimentalSchema]
            (Deprecated) Experimental schema definition used for feature flagged behaviour. Accepts either a JSON object or a stringified JSON representation.

        schema_prompt : typing.Optional[str]
            (Deprecated) Natural language prompt for schema-guided extraction. Use structuredOutput.schemaPrompt instead.

        custom_prompt : typing.Optional[str]
            (Deprecated) Custom instructions that augment the default extraction behaviour.

        chunking : typing.Optional[str]
            Comma-separated list of chunking strategies to apply (for example `semantic,header,page,recursive`).

        chunk_size : typing.Optional[int]
            Override for maximum characters per chunk when chunking is enabled.

        pages : typing.Optional[str]
            Page range filter supporting segments such as `1-2` or mixed ranges like `1-2,5`.

        extract_figure : typing.Optional[bool]
            Toggle to enable figure extraction in results.

        figure_description : typing.Optional[bool]
            Toggle to generate descriptive captions for extracted figures.

        return_html : typing.Optional[bool]
            Whether to include HTML representation alongside markdown in the response.

        thinking : typing.Optional[bool]
            (Deprecated) Enables expanded rationale output for debugging.

        storage : typing.Optional[ExtractJsonInputStorage]
            Options for persisting extraction artifacts. When enabled (default), artifacts are saved to storage and a database record is created.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtractResponse
            Synchronous extraction result

        Examples
        --------
        import asyncio

        from pulse import AsyncPulse

        client = AsyncPulse(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.extract(
                file_url="fileUrl",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.extract(
            file_url=file_url,
            structured_output=structured_output,
            schema=schema,
            experimental_schema=experimental_schema,
            schema_prompt=schema_prompt,
            custom_prompt=custom_prompt,
            chunking=chunking,
            chunk_size=chunk_size,
            pages=pages,
            extract_figure=extract_figure,
            figure_description=figure_description,
            return_html=return_html,
            thinking=thinking,
            storage=storage,
            request_options=request_options,
        )
        return _response.data

    async def extract_async(
        self,
        *,
        file_url: str,
        structured_output: typing.Optional[ExtractJsonInputStructuredOutput] = OMIT,
        schema: typing.Optional[ExtractJsonInputSchema] = OMIT,
        experimental_schema: typing.Optional[ExtractJsonInputExperimentalSchema] = OMIT,
        schema_prompt: typing.Optional[str] = OMIT,
        custom_prompt: typing.Optional[str] = OMIT,
        chunking: typing.Optional[str] = OMIT,
        chunk_size: typing.Optional[int] = OMIT,
        pages: typing.Optional[str] = OMIT,
        extract_figure: typing.Optional[bool] = OMIT,
        figure_description: typing.Optional[bool] = OMIT,
        return_html: typing.Optional[bool] = OMIT,
        thinking: typing.Optional[bool] = OMIT,
        storage: typing.Optional[ExtractJsonInputStorage] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtractAsyncResponse:
        """
        Starts an asynchronous extraction job. The request mirrors the
        synchronous options but returns immediately with a job identifier that
        clients can poll for completion status.

        Parameters
        ----------
        file_url : str
            Public or pre-signed URL that Pulse will download and extract.

        structured_output : typing.Optional[ExtractJsonInputStructuredOutput]
            Recommended method for schema-guided extraction. Contains the schema and optional prompt in a single object.

        schema : typing.Optional[ExtractJsonInputSchema]
            (Deprecated) JSON schema describing structured data to extract. Use structuredOutput instead. Accepts either a JSON object or a stringified JSON representation.

        experimental_schema : typing.Optional[ExtractJsonInputExperimentalSchema]
            (Deprecated) Experimental schema definition used for feature flagged behaviour. Accepts either a JSON object or a stringified JSON representation.

        schema_prompt : typing.Optional[str]
            (Deprecated) Natural language prompt for schema-guided extraction. Use structuredOutput.schemaPrompt instead.

        custom_prompt : typing.Optional[str]
            (Deprecated) Custom instructions that augment the default extraction behaviour.

        chunking : typing.Optional[str]
            Comma-separated list of chunking strategies to apply (for example `semantic,header,page,recursive`).

        chunk_size : typing.Optional[int]
            Override for maximum characters per chunk when chunking is enabled.

        pages : typing.Optional[str]
            Page range filter supporting segments such as `1-2` or mixed ranges like `1-2,5`.

        extract_figure : typing.Optional[bool]
            Toggle to enable figure extraction in results.

        figure_description : typing.Optional[bool]
            Toggle to generate descriptive captions for extracted figures.

        return_html : typing.Optional[bool]
            Whether to include HTML representation alongside markdown in the response.

        thinking : typing.Optional[bool]
            (Deprecated) Enables expanded rationale output for debugging.

        storage : typing.Optional[ExtractJsonInputStorage]
            Options for persisting extraction artifacts. When enabled (default), artifacts are saved to storage and a database record is created.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtractAsyncResponse
            Asynchronous extraction job accepted

        Examples
        --------
        import asyncio

        from pulse import AsyncPulse

        client = AsyncPulse(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.extract_async(
                file_url="fileUrl",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.extract_async(
            file_url=file_url,
            structured_output=structured_output,
            schema=schema,
            experimental_schema=experimental_schema,
            schema_prompt=schema_prompt,
            custom_prompt=custom_prompt,
            chunking=chunking,
            chunk_size=chunk_size,
            pages=pages,
            extract_figure=extract_figure,
            figure_description=figure_description,
            return_html=return_html,
            thinking=thinking,
            storage=storage,
            request_options=request_options,
        )
        return _response.data

    @property
    def jobs(self):
        if self._jobs is None:
            from .jobs.client import AsyncJobsClient  # noqa: E402

            self._jobs = AsyncJobsClient(client_wrapper=self._client_wrapper)
        return self._jobs

    @property
    def webhooks(self):
        if self._webhooks is None:
            from .webhooks.client import AsyncWebhooksClient  # noqa: E402

            self._webhooks = AsyncWebhooksClient(client_wrapper=self._client_wrapper)
        return self._webhooks


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: PulseEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
