# EFFECT-EDC Forms Reference
## Table of contents


<a href="#user-content-1000">**1000.**</a>
1. <a href="#user-content-arv-history">Arv History</a>
2. <a href="#user-content-participant-history">Participant History</a>
3. <a href="#user-content-vital-signs">Vital Signs</a>
4. <a href="#user-content-mental-status">Mental Status</a>
5. <a href="#user-content-signs-and-symptoms">Signs And Symptoms</a>
6. <a href="#user-content-study-medication-baseline">Study Medication (Baseline)</a>
7. <a href="#user-content-blood-result-fbc">Blood Result: Fbc</a>
8. <a href="#user-content-blood-result-chemistry">Blood Result: Chemistry</a>
9. <a href="#user-content-chest-x-ray">Chest X-Ray</a>
10. <a href="#user-content-lumbar-puncturecsf">Lumbar Puncture/Csf</a>
11. <a href="#user-content-tb-diagnostics">Tb Diagnostics</a>
12. <a href="#user-content-health-economics">Health Economics</a>
13. <a href="#user-content-clinical-note">Clinical Note</a>
14. <a href="#user-content-adherence-day-1">Adherence: Day 1</a>

<a href="#user-content-1003">**1003.**</a>
1. <a href="#user-content-vital-signs-1">Vital Signs</a>
2. <a href="#user-content-mental-status-1">Mental Status</a>
3. <a href="#user-content-signs-and-symptoms-1">Signs And Symptoms</a>
4. <a href="#user-content-significant-diagnoses">Significant Diagnoses</a>
5. <a href="#user-content-chest-x-ray-1">Chest X-Ray</a>
6. <a href="#user-content-lumbar-puncturecsf-1">Lumbar Puncture/Csf</a>
7. <a href="#user-content-tb-diagnostics-1">Tb Diagnostics</a>
8. <a href="#user-content-adherence-on-study">Adherence: On Study</a>

<a href="#user-content-1009">**1009.**</a>
1. <a href="#user-content-vital-signs-2">Vital Signs</a>
2. <a href="#user-content-mental-status-2">Mental Status</a>
3. <a href="#user-content-signs-and-symptoms-2">Signs And Symptoms</a>
4. <a href="#user-content-significant-diagnoses-1">Significant Diagnoses</a>
5. <a href="#user-content-chest-x-ray-2">Chest X-Ray</a>
6. <a href="#user-content-lumbar-puncturecsf-2">Lumbar Puncture/Csf</a>
7. <a href="#user-content-tb-diagnostics-2">Tb Diagnostics</a>
8. <a href="#user-content-adherence-on-study-1">Adherence: On Study</a>

<a href="#user-content-1014">**1014.**</a>
1. <a href="#user-content-study-medication">Study Medication</a>
2. <a href="#user-content-vital-signs-3">Vital Signs</a>
3. <a href="#user-content-mental-status-3">Mental Status</a>
4. <a href="#user-content-signs-and-symptoms-3">Signs And Symptoms</a>
5. <a href="#user-content-significant-diagnoses-2">Significant Diagnoses</a>
6. <a href="#user-content-arv-treatment">Arv Treatment</a>
7. <a href="#user-content-participant-treatment">Participant Treatment</a>
8. <a href="#user-content-blood-result-fbc-1">Blood Result: Fbc</a>
9. <a href="#user-content-chest-x-ray-3">Chest X-Ray</a>
10. <a href="#user-content-lumbar-puncturecsf-3">Lumbar Puncture/Csf</a>
11. <a href="#user-content-tb-diagnostics-3">Tb Diagnostics</a>
12. <a href="#user-content-clinical-note-1">Clinical Note</a>
13. <a href="#user-content-adherence-day-14">Adherence: Day 14</a>

<a href="#user-content-1028">**1028.**</a>
1. <a href="#user-content-vital-signs-4">Vital Signs</a>
2. <a href="#user-content-mental-status-4">Mental Status</a>
3. <a href="#user-content-signs-and-symptoms-4">Signs And Symptoms</a>
4. <a href="#user-content-significant-diagnoses-3">Significant Diagnoses</a>
5. <a href="#user-content-chest-x-ray-4">Chest X-Ray</a>
6. <a href="#user-content-lumbar-puncturecsf-4">Lumbar Puncture/Csf</a>
7. <a href="#user-content-tb-diagnostics-4">Tb Diagnostics</a>
8. <a href="#user-content-adherence-day-14-1">Adherence: Day 14+</a>

<a href="#user-content-1070">**1070.**</a>
1. <a href="#user-content-study-medication-1">Study Medication</a>
2. <a href="#user-content-vital-signs-5">Vital Signs</a>
3. <a href="#user-content-mental-status-5">Mental Status</a>
4. <a href="#user-content-signs-and-symptoms-5">Signs And Symptoms</a>
5. <a href="#user-content-significant-diagnoses-4">Significant Diagnoses</a>
6. <a href="#user-content-chest-x-ray-5">Chest X-Ray</a>
7. <a href="#user-content-lumbar-puncturecsf-5">Lumbar Puncture/Csf</a>
8. <a href="#user-content-tb-diagnostics-5">Tb Diagnostics</a>
9. <a href="#user-content-adherence-day-14-2">Adherence: Day 14+</a>

<a href="#user-content-1112">**1112.**</a>
1. <a href="#user-content-vital-signs-6">Vital Signs</a>
2. <a href="#user-content-mental-status-6">Mental Status</a>
3. <a href="#user-content-signs-and-symptoms-6">Signs And Symptoms</a>
4. <a href="#user-content-significant-diagnoses-5">Significant Diagnoses</a>
5. <a href="#user-content-chest-x-ray-6">Chest X-Ray</a>
6. <a href="#user-content-lumbar-puncturecsf-6">Lumbar Puncture/Csf</a>
7. <a href="#user-content-tb-diagnostics-6">Tb Diagnostics</a>
8. <a href="#user-content-adherence-day-14-3">Adherence: Day 14+</a>

<a href="#user-content-1168">**1168.**</a>
1. <a href="#user-content-vital-signs-7">Vital Signs</a>
2. <a href="#user-content-mental-status-7">Mental Status</a>
3. <a href="#user-content-signs-and-symptoms-7">Signs And Symptoms</a>
4. <a href="#user-content-significant-diagnoses-6">Significant Diagnoses</a>
5. <a href="#user-content-chest-x-ray-7">Chest X-Ray</a>
6. <a href="#user-content-lumbar-puncturecsf-7">Lumbar Puncture/Csf</a>
7. <a href="#user-content-tb-diagnostics-7">Tb Diagnostics</a>
8. <a href="#user-content-health-economics-1">Health Economics</a>
9. <a href="#user-content-adherence-day-14-4">Adherence: Day 14+</a>


### 1000

#### Arv History
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_arvhistory
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_arvhistory
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: HIV Diagnosis**

**3.0.** Date HIV diagnosis first known
- db_table: effect_subject_arvhistory
- column: hiv_dx_date
- type: DateField
- format: YYYY-MM-DD
---

**4.0.** Is this date estimated?

&nbsp;&nbsp;&nbsp;&nbsp; *If the exact date is not known, please indicate which part of the date is estimated.*
- db_table: effect_subject_arvhistory
- column: hiv_dx_date_estimated
- type: CharField
- length: 25
- responses:
  - `-`: *No*
  - `D`: *Yes, estimated the Day*
  - `MD`: *Yes, estimated Month and Day*
  - `YMD`: *Yes, estimated Year, Month and Day*
---

**Section: ARV treatment and monitoring**

**5.0.** Was the participant on ART <u>at time of</u> CrAg test?

&nbsp;&nbsp;&nbsp;&nbsp; *Also applies if ART started on the day of CrAg test (Test and Treat) or since CrAg test, but before enrolment.*
- db_table: effect_subject_arvhistory
- column: on_art_at_crag
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Was the participant on ART <u>prior</u> to CrAg test?
- db_table: effect_subject_arvhistory
- column: ever_on_art
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** When did the participant <u>start</u> ART for the first time?
- db_table: effect_subject_arvhistory
- column: initial_art_date
- type: DateField
- format: YYYY-MM-DD
---

**8.0.** Is this ART start date estimated?

&nbsp;&nbsp;&nbsp;&nbsp; *If the exact date is not known, please indicate which part of the date is estimated.*
- db_table: effect_subject_arvhistory
- column: initial_art_date_estimated
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `not_estimated`: *No*
  - `D`: *Yes, estimated the Day*
  - `MD`: *Yes, estimated Month and Day*
  - `YMD`: *Yes, estimated Year, Month and Day*
---

**9.0.** Which drugs were prescribed for their <u>first</u> (or <u>only</u>) ART regimen?
- db_table: effect_subject_arvhistory
- column: initial_art_regimen
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `ABC_3TC/FTC`: *ABC + 3TC/FTC*
  - `ABC_3TC_ATV_r`: *ABC + 3TC + ATV/r*
  - `ABC_3TC_DTG`: *ABC + 3TC + DTG*
  - `ABC_3TC_EFV`: *ABC + 3TC + EFV*
  - `ABC_3TC_LPV_r`: *ABC + 3TC + LPV/r*
  - `AZT_3TC_ATV_r`: *AZT + 3TC + ATV/r*
  - `AZT_3TC_DTG`: *AZT + 3TC + DTG*
  - `AZT_3TC_EFV`: *AZT + 3TC + EFV*
  - `AZT_3TC_LPV_r`: *AZT + 3TC + LPV/r*
  - `AZT_3TC_NVP`: *AZT + 3TC + NVP*
  - `AZT_FTC/3TC`: *AZT + FTC/3TC*
  - `D4T_3TC_NVP`: *D4T + 3TC + NVP*
  - `DTG_ABC/3TC_ATV_r`: *DTG + (ABC/3TC) + ATV/r*
  - `TDF_3TC_ATV_r`: *TDF + 3TC + ATV/r*
  - `TDF_3TC_DTG`: *TDF + 3TC + DTG*
  - `TDF_3TC_EFV`: *TDF + 3TC + EFV*
  - `TDF_3TC_LPV_r`: *TDF + 3TC + LPV/r*
  - `TDF_3TC_NVP`: *TDF + 3TC + NVP*
  - `TDF_FTC/3TC`: *TDF + FTC/3TC*
  - `TDF_FTC_ATV_r`: *TDF + FTC + ATV/r*
  - `TDF_FTC_DTG`: *TDF + FTC + DTG*
  - `TDF_FTC_EFV`: *TDF + FTC + EFV*
  - `TDF_FTC_LPV_r`: *TDF + FTC + LPV/r*
  - `TDF_FTC_NVP`: *TDF + FTC + NVP*
  - `ZDV_3TC_EFV`: *ZDV + 3TC + EFV*
  - `ZDV_3TC_NVP`: *ZDV + 3TC + NVP*
  - `ZDV_LPV_NVP`: *ZDV + LPV + NVP*
  - `EFV`: *EFV*
  - `NVP`: *NVP*
  - `DTG`: *DTG*
  - `ATZ_r`: *ATZ/r*
  - `DRV_r`: *DRV/r*
  - `lopinavir_r`: *Lopinavir/r*
  - `abacavir`: *Abacavir*
  - `unknown`: *Unknown*
  - `OTHER`: *Other, please specify below ...*
---

**9.1.** If other, please specify ...
- db_table: effect_subject_arvhistory
- column: initial_art_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**10.0.** Has the participant ever <u>switched</u> ART regimen?
- db_table: effect_subject_arvhistory
- column: has_switched_art_regimen
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** If switched, when was their <u>current or most recent</u> ART regimen started?
- db_table: effect_subject_arvhistory
- column: current_art_date
- type: DateField
- format: YYYY-MM-DD
---

**12.0.** If switched, is the current ART start date estimated?

&nbsp;&nbsp;&nbsp;&nbsp; *If the exact date is not known, please indicate which part of the date is estimated.*
- db_table: effect_subject_arvhistory
- column: current_art_date_estimated
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `not_estimated`: *No*
  - `D`: *Yes, estimated the Day*
  - `MD`: *Yes, estimated Month and Day*
  - `YMD`: *Yes, estimated Year, Month and Day*
---

**13.0.** If switched, what is their current (or most recent) ART regimen?
- db_table: effect_subject_arvhistory
- column: current_art_regimen
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `ABC_3TC/FTC`: *ABC + 3TC/FTC*
  - `ABC_3TC_ATV_r`: *ABC + 3TC + ATV/r*
  - `ABC_3TC_DTG`: *ABC + 3TC + DTG*
  - `ABC_3TC_EFV`: *ABC + 3TC + EFV*
  - `ABC_3TC_LPV_r`: *ABC + 3TC + LPV/r*
  - `AZT_3TC_ATV_r`: *AZT + 3TC + ATV/r*
  - `AZT_3TC_DTG`: *AZT + 3TC + DTG*
  - `AZT_3TC_EFV`: *AZT + 3TC + EFV*
  - `AZT_3TC_LPV_r`: *AZT + 3TC + LPV/r*
  - `AZT_3TC_NVP`: *AZT + 3TC + NVP*
  - `AZT_FTC/3TC`: *AZT + FTC/3TC*
  - `D4T_3TC_NVP`: *D4T + 3TC + NVP*
  - `DTG_ABC/3TC_ATV_r`: *DTG + (ABC/3TC) + ATV/r*
  - `TDF_3TC_ATV_r`: *TDF + 3TC + ATV/r*
  - `TDF_3TC_DTG`: *TDF + 3TC + DTG*
  - `TDF_3TC_EFV`: *TDF + 3TC + EFV*
  - `TDF_3TC_LPV_r`: *TDF + 3TC + LPV/r*
  - `TDF_3TC_NVP`: *TDF + 3TC + NVP*
  - `TDF_FTC/3TC`: *TDF + FTC/3TC*
  - `TDF_FTC_ATV_r`: *TDF + FTC + ATV/r*
  - `TDF_FTC_DTG`: *TDF + FTC + DTG*
  - `TDF_FTC_EFV`: *TDF + FTC + EFV*
  - `TDF_FTC_LPV_r`: *TDF + FTC + LPV/r*
  - `TDF_FTC_NVP`: *TDF + FTC + NVP*
  - `ZDV_3TC_EFV`: *ZDV + 3TC + EFV*
  - `ZDV_3TC_NVP`: *ZDV + 3TC + NVP*
  - `ZDV_LPV_NVP`: *ZDV + LPV + NVP*
  - `EFV`: *EFV*
  - `NVP`: *NVP*
  - `DTG`: *DTG*
  - `ATZ_r`: *ATZ/r*
  - `DRV_r`: *DRV/r*
  - `lopinavir_r`: *Lopinavir/r*
  - `abacavir`: *Abacavir*
  - `unknown`: *Unknown*
  - `OTHER`: *Other, please specify below ...*
---

**13.1.** If other, please specify ...
- db_table: effect_subject_arvhistory
- column: current_art_regimen_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: ART adherence**

**14.0.** Has the participant <u>now</u> defaulted from their <u>current</u> ART regimen?

&nbsp;&nbsp;&nbsp;&nbsp; *Defaulted means no ART for at least one month.*
- db_table: effect_subject_arvhistory
- column: has_defaulted
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** If `defaulted`, on what date did they default from their <u>current</u> ART regimen?
- db_table: effect_subject_arvhistory
- column: defaulted_date
- type: DateField
- format: YYYY-MM-DD
---

**16.0.** Is the `defaulted` date estimated?

&nbsp;&nbsp;&nbsp;&nbsp; *If the exact date is not known, please indicate which part of the date is estimated.*
- db_table: effect_subject_arvhistory
- column: defaulted_date_estimated
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `not_estimated`: *No*
  - `D`: *Yes, estimated the Day*
  - `MD`: *Yes, estimated Month and Day*
  - `YMD`: *Yes, estimated Year, Month and Day*
---

**17.0.** If the participant is currently on ART, are they <u>adherent</u> to their <u>current</u> ART regimen?
- db_table: effect_subject_arvhistory
- column: is_adherent
- type: CharField
- length: 10
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `defaulted`: *Defaulted*
  - `N/A`: *Not applicable*
---

**18.0.** If not `adherent`, how many doses missed in the last month?
- db_table: effect_subject_arvhistory
- column: art_doses_missed
- type: IntegerField
---

**Section: ART decision**

**19.0.** What decision was made at enrolment regarding their <u>current</u> ART regimen?
- db_table: effect_subject_arvhistory
- column: art_decision
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `art_continued`: *ART continued*
  - `art_stopped`: *ART stopped*
---

**Section: Viral load**

**20.0.** Is the last viral load result available?
- db_table: effect_subject_arvhistory
- column: has_viral_load_result
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**21.0.** Viral load result

&nbsp;&nbsp;&nbsp;&nbsp; *copies/mL*
- db_table: effect_subject_arvhistory
- column: viral_load_result
- type: DecimalField
---

**22.0.** Viral load date
- db_table: effect_subject_arvhistory
- column: viral_load_date
- type: DateField
- format: YYYY-MM-DD
---

**23.0.** Is the viral load date estimated?

&nbsp;&nbsp;&nbsp;&nbsp; *If the exact date is not known, please indicate which part of the date is estimated.*
- db_table: effect_subject_arvhistory
- column: viral_load_date_estimated
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `not_estimated`: *No*
  - `D`: *Yes, estimated the Day*
  - `MD`: *Yes, estimated Month and Day*
  - `YMD`: *Yes, estimated Year, Month and Day*
---

**Section: CD4 count**

**24.0.** CD4 result

&nbsp;&nbsp;&nbsp;&nbsp; *cells/μL*
- db_table: effect_subject_arvhistory
- column: cd4_value
- type: IntegerField
---

**25.0.** CD4 date
- db_table: effect_subject_arvhistory
- column: cd4_date
- type: DateField
- format: YYYY-MM-DD
---

**26.0.** Is the CD4 date estimated?

&nbsp;&nbsp;&nbsp;&nbsp; *If the exact date is not known, please indicate which part of the date is estimated.*
- db_table: effect_subject_arvhistory
- column: cd4_date_estimated
- type: CharField
- length: 25
- responses:
  - `-`: *No*
  - `D`: *Yes, estimated the Day*
  - `MD`: *Yes, estimated Month and Day*
  - `YMD`: *Yes, estimated Year, Month and Day*
---


#### Participant History
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_participanthistory
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_participanthistory
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Inpatient status**

**3.0.** Is the participant currently an inpatient?

&nbsp;&nbsp;&nbsp;&nbsp; *(answer NO if admission purely for screening LP)*
- db_table: effect_subject_participanthistory
- column: inpatient
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, what is the indication for admission?
- db_table: effect_subject_participanthistory
- column: admission_indication
- type: CharField
- length: 50
- responses: *free text*
---

**Section: Fluconazole**

**5.0.** Fluconazole taken within 1 week prior to randomization?
- db_table: effect_subject_participanthistory
- column: flucon_1w_prior_rando
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** If YES, number of days Fluconazole taken:
- db_table: effect_subject_participanthistory
- column: flucon_days
- type: IntegerField
---

**7.0.** If YES, Fluconazole dose (if taken < 1 week prior to randomisation):

&nbsp;&nbsp;&nbsp;&nbsp; *in mg/d*
- db_table: effect_subject_participanthistory
- column: flucon_dose
- type: CharField
- length: 25
- responses:
  - `1200_mg_d`: *Fluconazole, 1200 mg/d*
  - `800_mg_d`: *Fluconazole, 800 mg/d*
  - `OTHER`: *Other (specify dose and reason below ...)*
  - `N/A`: *Not applicable*
---

**7.1.** Other Fluconazole dose (if taken < 1 week prior to randomisation):

&nbsp;&nbsp;&nbsp;&nbsp; *in mg/d*
- db_table: effect_subject_participanthistory
- column: flucon_dose_other
- type: IntegerField
---

**7.2.** Other Fluconazole dose reason:
- db_table: effect_subject_participanthistory
- column: flucon_dose_other_reason
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Neurological**

**8.0.** Is there any reported neurological abnormality following examination by a medical practitioner?

&nbsp;&nbsp;&nbsp;&nbsp; *Must be confirmed as not related to CM*
- db_table: effect_subject_participanthistory
- column: reported_neuro_abnormality
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** Details of neurological abnormality?
- db_table: effect_subject_participanthistory
- column: neuro_abnormality_details
- type: TextField
---

**Section: TB diagnosis**

**10.0.** Previous diagnosis of Tuberculosis?
- db_table: effect_subject_participanthistory
- column: tb_prev_dx
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If YES, give date
- db_table: effect_subject_participanthistory
- column: tb_dx_date
- type: DateField
- format: YYYY-MM-DD
---

**12.0.** If YES, is this date estimated?

&nbsp;&nbsp;&nbsp;&nbsp; *If the exact date is not known, please indicate which part of the date is estimated.*
- db_table: effect_subject_participanthistory
- column: tb_dx_date_estimated
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `not_estimated`: *No*
  - `D`: *Yes, estimated the Day*
  - `MD`: *Yes, estimated Month and Day*
  - `YMD`: *Yes, estimated Year, Month and Day*
---

**13.0.** If YES, site of TB?
- db_table: effect_subject_participanthistory
- column: tb_site
- type: CharField
- length: 15
- responses:
  - `pulmonary`: *Pulmonary*
  - `extra_pulmonary`: *Extra-pulmonary*
  - `both`: *Both*
  - `N/A`: *Not applicable*
---

**Section: TB prevention/treatment**

**14.0.** Is the participant currently taking TB treatment?

&nbsp;&nbsp;&nbsp;&nbsp; *Includes treatment for active TB, latent TB, and TB prevention. Select YES if started today.*
- db_table: effect_subject_participanthistory
- column: on_tb_tx
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**15.0.** If YES, please specify type?

&nbsp;&nbsp;&nbsp;&nbsp; *If 'Active TB' please specify treatment below ...*
- db_table: effect_subject_participanthistory
- column: tb_tx_type
- type: CharField
- length: 15
- responses:
  - `active_tb`: *Active TB*
  - `latent_tb`: *Latent TB (HR: Isoniazid + Rifampicin)*
  - `ipt`: *IPT (Isoniazid Preventive Therapy)*
  - `N/A`: *Not applicable*
---

**16.0.** If 'Active TB', which treatment?
- db_table: effect_subject_participanthistory
- column: active_tb_tx
- type: ManyToManyField
- responses: *Select all that apply*
  - `AM`: *Am - Amikacin*
  - `BDQ`: *BDQ - Bedaquiline*
  - `CFZ`: *CFZ - Clofazimine*
  - `DLM`: *DLM - Delamanid*
  - `E`: *E - Ethambutol*
  - `H`: *H - Isoniazid*
  - `HR`: *HR - Isoniazid + Rifampicin*
  - `HRZE`: *HRZE - Isoniazid + Rifampicin + Pyrazinamide + Ethambutol*
  - `LFX`: *LFX - Levofloxacin*
  - `LZD`: *LZD - Linezolid*
  - `MPM`: *Mpm - Meropenem*
  - `PAS`: *PAS - Para-aminosalicylic acid*
  - `PTO`: *PTO - Prothionamide*
  - `S`: *S - Streptomycin*
  - `TRD`: *TRD - Terizidone*
  - `Z`: *Z - Pyrazinamide*
  - `OTHER`: *Other, please specify below ...*
---

**Section: Other opportunistic infections**

**17.0.** Previous opportunistic infection other than TB?
- db_table: effect_subject_participanthistory
- column: previous_oi
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**18.0.** If YES, specify opportunistic infection name?
- db_table: effect_subject_participanthistory
- column: previous_oi_name
- type: CharField
- length: 35
- responses: *free text*
---

**19.0.** If YES, what was the date of the previous opportunistic infection diagnosis?
- db_table: effect_subject_participanthistory
- column: previous_oi_dx_date
- type: DateField
- format: YYYY-MM-DD
---

**Section: Other medication**

**20.0.** Other medication?
- db_table: effect_subject_participanthistory
- column: any_medications
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**21.0.** specify medications
- db_table: effect_subject_participanthistory
- column: specify_medications
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `TMP-SMX`: *TMP-SMX*
  - `steroids`: *Steroids, please specify type and dose below ...*
  - `actrapid`: *Actrapid*
  - `actrophane`: *Actrophane*
  - `allopurinol`: *Allopurinol*
  - `amitriptyline`: *Amitriptyline*
  - `amlodipine`: *Amlodipine*
  - `atenalol`: *Atenalol*
  - `atorvastatin`: *Atorvastatin*
  - `budesonide`: *Budesonide*
  - `budesonide_formoterol`: *Budesonide/Formoterol (Symbicord)*
  - `carbamazepine`: *Carbamazepine*
  - `carvedilol`: *Carvedilol*
  - `cetirizine`: *Cetirizine (Texa)*
  - `chlorpheniramine`: *Chlorpheniramine (Allergex)*
  - `chlorpromazine`: *Chlorpromazine*
  - `citalopram`: *Citalopram*
  - `clozapine`: *Clozapine*
  - `colchecine`: *Colchecine*
  - `diclofenac`: *Diclofenac (Voltaren)*
  - `doxazosin`: *Doxazosin (Cardura)*
  - `enalapril`: *Enalapril*
  - `fluanxil`: *Fluanxil*
  - `fluoxetine`: *Fluoxetine (Prozac)*
  - `follic_acid`: *Follic Acid*
  - `furosemide`: *Furosemide (Lasix)*
  - `glimepiride`: *Glimepiride*
  - `hctz`: *HCTZ (Ridaq)*
  - `humalog`: *Humalog*
  - `ibuprofen`: *Ibuprofen*
  - `lamotriginepyridoxine`: *LamotriginePyridoxine*
  - `iron`: *Iron (FeSO4/ FeGluconate)*
  - `lamotrigine`: *Lamotrigine*
  - `lansoprazole`: *Lansoprazole*
  - `loperamide`: *Loperamide (Imodium)*
  - `losartan`: *Losartan*
  - `metformin`: *Metformin*
  - `montelukaust`: *Montelukaust*
  - `nystatin`: *Nystatin*
  - `olanzapine`: *Olanzapine*
  - `omeprazole`: *Omeprazole*
  - `pantoprazole`: *Pantoprazole*
  - `paracetamol`: *Paracetamol*
  - `phenytoin`: *Phenytoin*
  - `pioglitazone`: *Pioglitazone*
  - `prednisone`: *Prednisone*
  - `protophane`: *Protophane*
  - `pyridoxine`: *Pyridoxine*
  - `quetiapine`: *Quetiapine*
  - `ranitidine`: *Ranitidine*
  - `risperidone`: *Risperidone*
  - `salbutamol`: *Salbutamol*
  - `salmeterol_fluticasone`: *Salmeterol/Fluticasone (Foxair/Sereflo)*
  - `simvastatin`: *Simvastatin*
  - `spirinolactone`: *Spirinolactone*
  - `tramadol`: *Tramadol*
  - `valproate`: *Valproate (Epilim)*
  - `venlafaxine`: *Venlafaxine*
  - `vitamin_c`: *Vitamin C*
  - `OTHER`: *Other medication, please specify below ...*
---

**21.1.** If STEROID, specify type and dose of steroid ...
- db_table: effect_subject_participanthistory
- column: specify_steroid_other
- type: TextField
- length: 150
---

**21.2.** If OTHER, specify ...
- db_table: effect_subject_participanthistory
- column: specify_medications_other
- type: TextField
- length: 150
---


#### Vital Signs
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_vitalsigns
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_vitalsigns
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vital signs**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: effect_subject_vitalsigns
- column: weight
- type: DecimalField
---

**4.0.** Is the weight estimated or measured?
- db_table: effect_subject_vitalsigns
- column: weight_measured_or_est
- type: CharField
- length: 25
- responses:
  - `measured`: *Measured (weighed)*
  - `estimated`: *Estimated*
---

**5.0.** Blood pressure: systolic

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: effect_subject_vitalsigns
- column: sys_blood_pressure
- type: IntegerField
---

**6.0.** Blood pressure: diastolic

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: effect_subject_vitalsigns
- column: dia_blood_pressure
- type: IntegerField
---

**7.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: effect_subject_vitalsigns
- column: heart_rate
- type: IntegerField
---

**8.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: effect_subject_vitalsigns
- column: respiratory_rate
- type: IntegerField
---

**9.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celsius*
- db_table: effect_subject_vitalsigns
- column: temperature
- type: DecimalField
---

**10.0.** Abnormal lung exam:
- db_table: effect_subject_vitalsigns
- column: abnormal_lung_exam
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Action**

**11.0.** action identifier
- db_table: effect_subject_vitalsigns
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**12.0.** action item
- db_table: effect_subject_vitalsigns
- column: action_item
- type: ForeignKey
---

**13.0.** parent action item
- db_table: effect_subject_vitalsigns
- column: parent_action_item
- type: ForeignKey
---

**14.0.** related action item
- db_table: effect_subject_vitalsigns
- column: related_action_item
- type: ForeignKey
---

**Section: Reporting**

**15.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_vitalsigns
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**16.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_vitalsigns
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Mental Status
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_mentalstatus
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_mentalstatus
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Mental status**

**3.0.** Recent seizure (<72 hours)?
- db_table: effect_subject_mentalstatus
- column: recent_seizure
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** Behaviour change?
- db_table: effect_subject_mentalstatus
- column: behaviour_change
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**5.0.** Confusion?
- db_table: effect_subject_mentalstatus
- column: confusion
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Does the participant require help from anybody for everyday activities?

&nbsp;&nbsp;&nbsp;&nbsp; *Answer only at scheduled Week 10 and Month 6 visits*
- db_table: effect_subject_mentalstatus
- column: require_help
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.1.** Has the illness left the participant with any other problems?

&nbsp;&nbsp;&nbsp;&nbsp; *Answer only at scheduled Week 10 and Month 6 visits*
- db_table: effect_subject_mentalstatus
- column: any_other_problems
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**7.0.** Modified Rankin Score
- db_table: effect_subject_mentalstatus
- column: modified_rankin_score
- type: CharField
- length: 15
- responses:
  - `0`: *[0] No symptoms*
  - `1`: *[1] No significant disability. Able to carry out usual activities, despite some symptoms.*
  - `2`: *[2] Slight disability. Able to look after own affairs without assistance, but unable to carry out all previous activities.*
  - `3`: *[3] Moderate disability. Requires some help, but able to walk unassisted.*
  - `4`: *[4] Moderately severe disability. Unable to attend to own bodily needs without assistance, and unable to walk unassisted.*
  - `5`: *[5] Severe disability. Requires constant nursing care and attention, bedridden, incontinent.*
  - `6`: *[6] Dead*
---

**8.0.** ECOG score
- db_table: effect_subject_mentalstatus
- column: ecog_score
- type: CharField
- length: 15
- responses:
  - `0`: *[0] Fully active, able to carry on all pre-disease performance without restriction*
  - `1`: *[1] Restricted in physically strenuous activity but ambulatory and able to carry out work of a light or sedentary nature, e.g., light house work, office work*
  - `2`: *[2] Ambulatory and capable of all self-care but unable to carry out any work activities; up and about more than 50% of waking hours *
  - `3`: *[3] Capable of only limited self-care; confined to bed or chair more than 50% of waking hours*
  - `4`: *[4] Completely disabled; cannot carry on any self-care; totally confined to bed or chair*
  - `5`: *[5] Deceased*
---

**9.0.** Glasgow Coma Score

&nbsp;&nbsp;&nbsp;&nbsp; */15*
- db_table: effect_subject_mentalstatus
- column: glasgow_coma_score
- type: IntegerField
---

**Section: Reporting**

**10.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_mentalstatus
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_mentalstatus
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Signs And Symptoms
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_signsandsymptoms
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_signsandsymptoms
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Signs and symptoms**

**3.0.** Are there any signs or symptoms to report, since last contact with trial team?
- db_table: effect_subject_signsandsymptoms
- column: any_sx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `unknown`: *Unknown*
---

**4.0.** Is participant currently experiencing any of the following signs/symptoms?
- db_table: effect_subject_signsandsymptoms
- column: current_sx
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `cough`: *Cough*
  - `diarrhoea`: *Diarrhoea*
  - `double_vision`: *Double vision*
  - `drowsiness`: *Drowsiness*
  - `fever`: *Fever*
  - `focal_weakness`: *Focal weakness*
  - `headache`: *Headache*
  - `hearing_loss`: *Hearing loss*
  - `jaundice`: *Jaundice*
  - `nausea`: *Nausea*
  - `night_sweats`: *Night sweats*
  - `CN_VI_palsy_left`: *Neuro - Cranial Nerve VI palsy (left)*
  - `CN_VI_palsy_right`: *Neuro - Cranial Nerve VI palsy (right)*
  - `CN_VII_palsy_left`: *Neuro - Cranial Nerve VII palsy (left)*
  - `CN_VII_palsy_right`: *Neuro - Cranial Nerve VII palsy (right)*
  - `cn_palsy_left_other`: *Neuro - Other cranial nerve palsy (left), please specify below ...*
  - `cn_palsy_right_other`: *Neuro - Other cranial nerve palsy (right), please specify below ...*
  - `focal_seizures_left`: *Neuro - Focal seizures (left)*
  - `focal_seizures_right`: *Neuro - Focal seizures (right)*
  - `hemiplegia_left`: *Neuro - Hemiplegia (left)*
  - `hemiplegia_right`: *Neuro - Hemiplegia (right)*
  - `meningism`: *Neuro - Meningism*
  - `papilloedema`: *Neuro - Papilloedema*
  - `visual_field_disturbance`: *Neuro - Visual field disturbance*
  - `focal_neurologic_deficit_other`: *Neuro - Other focal neurologic deficit, please specify below ...*
  - `shortness_of_breath`: *Shortness of breath*
  - `skin_lesions`: *Skin lesions*
  - `visual_loss`: *Visual loss*
  - `vomiting`: *Vomiting*
  - `weight_loss`: *Weight loss*
  - `OTHER`: *Other sign(s)/symptom(s), please specify below ...*
---

**4.1.** If other, please specify ...

&nbsp;&nbsp;&nbsp;&nbsp; *If more than one, separate each with a comma (,).*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_other
- type: TextField
---

**5.0.** Are any of the signs or symptoms related to cryptococcal meningitis (CM)?
- db_table: effect_subject_signsandsymptoms
- column: cm_sx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.0.** For these signs/symptoms, were any Grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.</br>*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_gte_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `cough`: *Cough*
  - `diarrhoea`: *Diarrhoea*
  - `double_vision`: *Double vision*
  - `drowsiness`: *Drowsiness*
  - `fever`: *Fever*
  - `focal_weakness`: *Focal weakness*
  - `headache`: *Headache*
  - `hearing_loss`: *Hearing loss*
  - `jaundice`: *Jaundice*
  - `nausea`: *Nausea*
  - `night_sweats`: *Night sweats*
  - `CN_VI_palsy_left`: *Neuro - Cranial Nerve VI palsy (left)*
  - `CN_VI_palsy_right`: *Neuro - Cranial Nerve VI palsy (right)*
  - `CN_VII_palsy_left`: *Neuro - Cranial Nerve VII palsy (left)*
  - `CN_VII_palsy_right`: *Neuro - Cranial Nerve VII palsy (right)*
  - `cn_palsy_left_other`: *Neuro - Other cranial nerve palsy (left), please specify below ...*
  - `cn_palsy_right_other`: *Neuro - Other cranial nerve palsy (right), please specify below ...*
  - `focal_seizures_left`: *Neuro - Focal seizures (left)*
  - `focal_seizures_right`: *Neuro - Focal seizures (right)*
  - `hemiplegia_left`: *Neuro - Hemiplegia (left)*
  - `hemiplegia_right`: *Neuro - Hemiplegia (right)*
  - `meningism`: *Neuro - Meningism*
  - `papilloedema`: *Neuro - Papilloedema*
  - `visual_field_disturbance`: *Neuro - Visual field disturbance*
  - `focal_neurologic_deficit_other`: *Neuro - Other focal neurologic deficit, please specify below ...*
  - `shortness_of_breath`: *Shortness of breath*
  - `skin_lesions`: *Skin lesions*
  - `visual_loss`: *Visual loss*
  - `vomiting`: *Vomiting*
  - `weight_loss`: *Weight loss*
  - `OTHER`: *Other sign(s)/symptom(s), please specify below ...*
---

**6.1.** If other, please specify ...

&nbsp;&nbsp;&nbsp;&nbsp; *If more than one, separate each with a comma (,).*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_gte_g3_other
- type: TextField
---

**Section: Additional details**

**7.0.** If participant currently has headache, for what duration have they had it for

&nbsp;&nbsp;&nbsp;&nbsp; *In days and/or hours.  Note: 1 day equivalent to 24 hours.</br> Format is `DDdHHh`, `DDd` or `HHh`. For example 1d23h, 15d9h ... or 20d, or 5h ...*
- db_table: effect_subject_signsandsymptoms
- column: headache_duration
- type: CharField
- length: 7
- responses: *free text*
---

**7.1.** If other cranial nerve palsy (left), please specify ...
- db_table: effect_subject_signsandsymptoms
- column: cn_palsy_left_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.2.** If other cranial nerve palsy (right), please specify ...
- db_table: effect_subject_signsandsymptoms
- column: cn_palsy_right_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.3.** If other focal neurologic deficit, please specify ...
- db_table: effect_subject_signsandsymptoms
- column: focal_neurologic_deficit_other
- type: CharField
- length: 35
- responses: *free text*
---

**8.0.** If visual field loss, please provide details ...
- db_table: effect_subject_signsandsymptoms
- column: visual_field_loss
- type: TextField
---

**Section: Investigations**

**9.0.** Was an X-ray performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'Chest X-ray' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: xray_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**10.0.** Was a lumbar puncture performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'Lumbar Puncture/CSF' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: lp_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Was a urinary LAM performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'TB Diagnostics' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: urinary_lam_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Reporting**

**12.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_signsandsymptoms
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_signsandsymptoms
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Calculated values**

**14.0.** calculated headache duration
- db_table: effect_subject_signsandsymptoms
- column: calculated_headache_duration
- type: DurationField
---

**Section: Action**

**15.0.** action identifier
- db_table: effect_subject_signsandsymptoms
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**16.0.** action item
- db_table: effect_subject_signsandsymptoms
- column: action_item
- type: ForeignKey
---

**17.0.** parent action item
- db_table: effect_subject_signsandsymptoms
- column: parent_action_item
- type: ForeignKey
---

**18.0.** related action item
- db_table: effect_subject_signsandsymptoms
- column: related_action_item
- type: ForeignKey
---


#### Study Medication (Baseline)
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.

*Additional instructions*: Please ensure the baseline Vital Signs form has been completed for participant <strong>before</strong> starting this form.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Fluconazole**

**3.0.** Was the participant started on Fluconazole?
- db_table: effect_subject_studymedication
- column: flucon_initiated
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, please explain
- db_table: effect_subject_studymedication
- column: flucon_not_initiated_reason
- type: TextField
- length: 250
---

**5.0.** Date and time first fluconazole dose administered
- db_table: effect_subject_studymedication
- column: flucon_dose_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**6.0.** Fluconazole dose

&nbsp;&nbsp;&nbsp;&nbsp; *in mg/d*
- db_table: effect_subject_studymedication
- column: flucon_dose
- type: IntegerField
---

**7.0.** First fluconazole dose administered
- db_table: effect_subject_studymedication
- column: flucon_next_dose
- type: CharField
- length: 15
- responses:
  - `today`: *Today*
  - `tomorrow`: *Tomorrow*
  - `N/A`: *Not applicable*
---

**8.0.** Fluconazole notes (if any)
- db_table: effect_subject_studymedication
- column: flucon_notes
- type: TextField
- length: 250
---

**Section: Flucytosine**

**9.0.** Was the participant started on Flucytosine?
- db_table: effect_subject_studymedication
- column: flucyt_initiated
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**10.0.** If NO, please explain
- db_table: effect_subject_studymedication
- column: flucyt_not_initiated_reason
- type: TextField
- length: 250
---

**11.0.** Date and time first flucytosine dose administered
- db_table: effect_subject_studymedication
- column: flucyt_dose_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**12.0.** Flucytosine dose expected

&nbsp;&nbsp;&nbsp;&nbsp; *in mg/d. Validate against weight and rando arm 100mg/kg, round down to nearest 500mg total e.g. 47kg = 4700mg, participant gets 4500mg daily*
- db_table: effect_subject_studymedication
- column: flucyt_dose_expected
- type: IntegerField
---

**13.0.** Flucytosine dose prescribed

&nbsp;&nbsp;&nbsp;&nbsp; *in mg/d*
- db_table: effect_subject_studymedication
- column: flucyt_dose
- type: IntegerField
---

**14.0.** Dose at 04:00

&nbsp;&nbsp;&nbsp;&nbsp; *in mg*
- db_table: effect_subject_studymedication
- column: flucyt_dose_0400
- type: IntegerField
---

**15.0.** Dose at 10:00

&nbsp;&nbsp;&nbsp;&nbsp; *in mg*
- db_table: effect_subject_studymedication
- column: flucyt_dose_1000
- type: IntegerField
---

**16.0.** Dose at 16:00

&nbsp;&nbsp;&nbsp;&nbsp; *in mg*
- db_table: effect_subject_studymedication
- column: flucyt_dose_1600
- type: IntegerField
---

**17.0.** Dose at 22:00

&nbsp;&nbsp;&nbsp;&nbsp; *in mg*
- db_table: effect_subject_studymedication
- column: flucyt_dose_2200
- type: IntegerField
---

**18.0.** First flucytosine dose administered
- db_table: effect_subject_studymedication
- column: flucyt_next_dose
- type: CharField
- length: 5
- responses:
  - `0400`: *at 04:00*
  - `1000`: *at 10:00*
  - `1600`: *at 16:00*
  - `2200`: *at 22:00*
  - `N/A`: *Not applicable*
---

**19.0.** Flucytosine notes (if any)
- db_table: effect_subject_studymedication
- column: flucyt_notes
- type: TextField
- length: 250
---


#### Blood Result: Fbc
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_bloodresultsfbc
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_bloodresultsfbc
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Requisition and Result Date**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_bloodresultsfbc
- column: requisition
- type: ForeignKey
---

**4.0.** Result assay date and time
- db_table: effect_subject_bloodresultsfbc
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Haemoglobin**

**5.0.** Haemoglobin
- db_table: effect_subject_bloodresultsfbc
- column: haemoglobin_value
- type: DecimalField
---

**6.0.** units
- db_table: effect_subject_bloodresultsfbc
- column: haemoglobin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**7.0.** abnormal
- db_table: effect_subject_bloodresultsfbc
- column: haemoglobin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: effect_subject_bloodresultsfbc
- column: haemoglobin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: WBC**

**9.0.** WBC
- db_table: effect_subject_bloodresultsfbc
- column: wbc_value
- type: DecimalField
---

**10.0.** units
- db_table: effect_subject_bloodresultsfbc
- column: wbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**11.0.** abnormal
- db_table: effect_subject_bloodresultsfbc
- column: wbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: effect_subject_bloodresultsfbc
- column: wbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Platelets**

**13.0.** Platelets
- db_table: effect_subject_bloodresultsfbc
- column: platelets_value
- type: DecimalField
---

**14.0.** units
- db_table: effect_subject_bloodresultsfbc
- column: platelets_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**15.0.** abnormal
- db_table: effect_subject_bloodresultsfbc
- column: platelets_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: effect_subject_bloodresultsfbc
- column: platelets_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Neutrophil absolute count**

**17.0.** Neutrophil (abs)
- db_table: effect_subject_bloodresultsfbc
- column: neutrophil_value
- type: DecimalField
---

**18.0.** units
- db_table: effect_subject_bloodresultsfbc
- column: neutrophil_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
---

**19.0.** abnormal
- db_table: effect_subject_bloodresultsfbc
- column: neutrophil_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: effect_subject_bloodresultsfbc
- column: neutrophil_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Neutrophils differential count**

**21.0.** Neutrophil (diff)
- db_table: effect_subject_bloodresultsfbc
- column: neutrophil_diff_value
- type: DecimalField
---

**22.0.** units
- db_table: effect_subject_bloodresultsfbc
- column: neutrophil_diff_units
- type: CharField
- length: 15
- responses:
  - `%`: *%*
---

**23.0.** abnormal
- db_table: effect_subject_bloodresultsfbc
- column: neutrophil_diff_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: effect_subject_bloodresultsfbc
- column: neutrophil_diff_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Lymphocyte absolute count**

**25.0.** Lymphocyte (abs)
- db_table: effect_subject_bloodresultsfbc
- column: lymphocyte_value
- type: DecimalField
---

**26.0.** units
- db_table: effect_subject_bloodresultsfbc
- column: lymphocyte_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
---

**27.0.** abnormal
- db_table: effect_subject_bloodresultsfbc
- column: lymphocyte_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: effect_subject_bloodresultsfbc
- column: lymphocyte_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Lymphocyte differential count**

**29.0.** Lymphocyte (diff)
- db_table: effect_subject_bloodresultsfbc
- column: lymphocyte_diff_value
- type: DecimalField
---

**30.0.** units
- db_table: effect_subject_bloodresultsfbc
- column: lymphocyte_diff_units
- type: CharField
- length: 15
- responses:
  - `%`: *%*
---

**31.0.** abnormal
- db_table: effect_subject_bloodresultsfbc
- column: lymphocyte_diff_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**32.0.** reportable
- db_table: effect_subject_bloodresultsfbc
- column: lymphocyte_diff_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**33.0.** Are any of the above results abnormal?

&nbsp;&nbsp;&nbsp;&nbsp; *Abnormal results present at baseline or continuing from baseline not included.*
- db_table: effect_subject_bloodresultsfbc
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**34.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included*
- db_table: effect_subject_bloodresultsfbc
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**35.0.** summary
- db_table: effect_subject_bloodresultsfbc
- column: summary
- type: TextField
---


#### Blood Result: Chemistry
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_bloodresultschem
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_bloodresultschem
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Requisition and Result Date**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_bloodresultschem
- column: requisition
- type: ForeignKey
---

**4.0.** Result assay date and time
- db_table: effect_subject_bloodresultschem
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: ALT**

**5.0.** ALT
- db_table: effect_subject_bloodresultschem
- column: alt_value
- type: DecimalField
---

**6.0.** units
- db_table: effect_subject_bloodresultschem
- column: alt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *IU/L*
---

**7.0.** abnormal
- db_table: effect_subject_bloodresultschem
- column: alt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: effect_subject_bloodresultschem
- column: alt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: CREATININE**

**9.0.** Creatinine
- db_table: effect_subject_bloodresultschem
- column: creatinine_value
- type: DecimalField
---

**10.0.** units
- db_table: effect_subject_bloodresultschem
- column: creatinine_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `umol/L`: *μmol/L (micromoles/L)*
---

**11.0.** abnormal
- db_table: effect_subject_bloodresultschem
- column: creatinine_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: effect_subject_bloodresultschem
- column: creatinine_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Calculated eGFR**

**13.0.** eGFR
- db_table: effect_subject_bloodresultschem
- column: egfr_value
- type: DecimalField
---

**14.0.** units
- db_table: effect_subject_bloodresultschem
- column: egfr_units
- type: CharField
- length: 15
- responses:
  - `mL/min/1.73m2`: *mL/min/1.73m2*
---

**15.0.** Grade
- db_table: effect_subject_bloodresultschem
- column: egfr_grade
- type: IntegerField
---

**Section: ALBUMIN**

**16.0.** Serum albumin
- db_table: effect_subject_bloodresultschem
- column: albumin_value
- type: DecimalField
---

**17.0.** units
- db_table: effect_subject_bloodresultschem
- column: albumin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
  - `g/L`: *g/L*
---

**18.0.** abnormal
- db_table: effect_subject_bloodresultschem
- column: albumin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**19.0.** reportable
- db_table: effect_subject_bloodresultschem
- column: albumin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: ALP**

**20.0.** ALP
- db_table: effect_subject_bloodresultschem
- column: alp_value
- type: DecimalField
---

**21.0.** units
- db_table: effect_subject_bloodresultschem
- column: alp_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *IU/L*
---

**22.0.** abnormal
- db_table: effect_subject_bloodresultschem
- column: alp_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**23.0.** reportable
- db_table: effect_subject_bloodresultschem
- column: alp_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: AST**

**24.0.** AST
- db_table: effect_subject_bloodresultschem
- column: ast_value
- type: DecimalField
---

**25.0.** units
- db_table: effect_subject_bloodresultschem
- column: ast_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *IU/L*
---

**26.0.** abnormal
- db_table: effect_subject_bloodresultschem
- column: ast_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**27.0.** reportable
- db_table: effect_subject_bloodresultschem
- column: ast_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: C-Reactive Protein**

**28.0.** C-reactive protein
- db_table: effect_subject_bloodresultschem
- column: crp_value
- type: DecimalField
---

**29.0.** units
- db_table: effect_subject_bloodresultschem
- column: crp_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
  - `umol/L`: *μmol/L (micromoles/L)*
---

**30.0.** abnormal
- db_table: effect_subject_bloodresultschem
- column: crp_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**31.0.** reportable
- db_table: effect_subject_bloodresultschem
- column: crp_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: MAGNESIUM**

**32.0.** Magnesium
- db_table: effect_subject_bloodresultschem
- column: magnesium_value
- type: DecimalField
---

**33.0.** units
- db_table: effect_subject_bloodresultschem
- column: magnesium_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
  - `mg/dL`: *mg/dL*
---

**34.0.** abnormal
- db_table: effect_subject_bloodresultschem
- column: magnesium_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**35.0.** reportable
- db_table: effect_subject_bloodresultschem
- column: magnesium_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: POTASSIUM**

**36.0.** Potassium
- db_table: effect_subject_bloodresultschem
- column: potassium_value
- type: DecimalField
---

**37.0.** units
- db_table: effect_subject_bloodresultschem
- column: potassium_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**38.0.** abnormal
- db_table: effect_subject_bloodresultschem
- column: potassium_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**39.0.** reportable
- db_table: effect_subject_bloodresultschem
- column: potassium_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: GGT**

**40.0.** GGT
- db_table: effect_subject_bloodresultschem
- column: ggt_value
- type: DecimalField
---

**41.0.** units
- db_table: effect_subject_bloodresultschem
- column: ggt_units
- type: CharField
- length: 15
- responses:
  - `IU/L`: *IU/L*
---

**42.0.** abnormal
- db_table: effect_subject_bloodresultschem
- column: ggt_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**43.0.** reportable
- db_table: effect_subject_bloodresultschem
- column: ggt_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: UREA**

**44.0.** Urea (BUN)
- db_table: effect_subject_bloodresultschem
- column: urea_value
- type: DecimalField
---

**45.0.** units
- db_table: effect_subject_bloodresultschem
- column: urea_units
- type: CharField
- length: 15
- responses:
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**46.0.** abnormal
- db_table: effect_subject_bloodresultschem
- column: urea_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**47.0.** reportable
- db_table: effect_subject_bloodresultschem
- column: urea_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Total Bilirubin**

**48.0.** Total Bilirubin
- db_table: effect_subject_bloodresultschem
- column: tbil_value
- type: DecimalField
---

**49.0.** units
- db_table: effect_subject_bloodresultschem
- column: tbil_units
- type: CharField
- length: 15
- responses:
  - `mg/dL`: *mg/dL*
---

**50.0.** abnormal
- db_table: effect_subject_bloodresultschem
- column: tbil_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**51.0.** reportable
- db_table: effect_subject_bloodresultschem
- column: tbil_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**52.0.** Are any of the above results abnormal?

&nbsp;&nbsp;&nbsp;&nbsp; *Abnormal results present at baseline or continuing from baseline not included.*
- db_table: effect_subject_bloodresultschem
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**53.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included*
- db_table: effect_subject_bloodresultschem
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**54.0.** summary
- db_table: effect_subject_bloodresultschem
- column: summary
- type: TextField
---

**Section: Action**

**55.0.** action identifier
- db_table: effect_subject_bloodresultschem
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**56.0.** action item
- db_table: effect_subject_bloodresultschem
- column: action_item
- type: ForeignKey
---

**57.0.** parent action item
- db_table: effect_subject_bloodresultschem
- column: parent_action_item
- type: ForeignKey
---

**58.0.** related action item
- db_table: effect_subject_bloodresultschem
- column: related_action_item
- type: ForeignKey
---


#### Chest X-Ray
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_chestxray
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_chestxray
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Chest x-ray**

**3.0.** Was a chest x-ray performed?
- db_table: effect_subject_chestxray
- column: chest_xray
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, date performed?
- db_table: effect_subject_chestxray
- column: chest_xray_date
- type: DateField
- format: YYYY-MM-DD
---

**5.0.** If YES, indicate results?
- db_table: effect_subject_chestxray
- column: chest_xray_results
- type: ManyToManyField
- responses: *Select all that apply*
  - `NORMAL`: *Normal*
  - `lymphadenopathy`: *Lymphadenopathy*
  - `consolidation`: *Consolidation*
  - `miliary_tb`: *Miliary TB*
  - `infiltrates`: *Infiltrates*
  - `OTHER`: *Other, please specify below ...*
---

**5.1.** If other, please specify ...
- db_table: effect_subject_chestxray
- column: chest_xray_results_other
- type: TextField
---

**6.0.** Any additional comment
- db_table: effect_subject_chestxray
- column: comment
- type: TextField
---


#### Lumbar Puncture/Csf
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_lpcsf
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_lpcsf
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: LP**

**3.0.** Reason for LP
- db_table: effect_subject_lpcsf
- column: reason_for_lp
- type: CharField
- length: 50
- responses:
  - `scheduled_per_protocol`: *Scheduled per protocol*
  - `clincal_deterioration`: *Suspected Cryptococcal meningitis / Suspected IRIS*
---

**4.0.** LP Date and Time
- db_table: effect_subject_lpcsf
- column: lp_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**5.0.** Was the opening pressure measured
- db_table: effect_subject_lpcsf
- column: opening_pressure_measured
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** opening pressure

&nbsp;&nbsp;&nbsp;&nbsp; *Units cm of H<sub>2</sub>O*
- db_table: effect_subject_lpcsf
- column: opening_pressure
- type: IntegerField
---

**7.0.** closing pressure

&nbsp;&nbsp;&nbsp;&nbsp; *Units cm of H<sub>2</sub>O*
- db_table: effect_subject_lpcsf
- column: closing_pressure
- type: IntegerField
---

**8.0.** CSF amount removed

&nbsp;&nbsp;&nbsp;&nbsp; *Units ml*
- db_table: effect_subject_lpcsf
- column: csf_amount_removed
- type: IntegerField
---

**Section: CSF**

**9.0.** CSF positive for cryptococcal meningitis?
- db_table: effect_subject_lpcsf
- column: csf_positive
- type: CharField
- length: 18
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `awaiting_results`: *Awaiting results*
---

**10.0.** india ink
- db_table: effect_subject_lpcsf
- column: india_ink
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**11.0.** CrAg LFA
- db_table: effect_subject_lpcsf
- column: csf_crag_lfa
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**12.0.** SQ CrAg
- db_table: effect_subject_lpcsf
- column: sq_crag
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**13.0.** SQ CrAg
- db_table: effect_subject_lpcsf
- column: sq_crag_pos
- type: CharField
- length: 15
- responses:
  - `high`: *High*
  - `low`: *Low*
  - `N/A`: *Not applicable*
---

**14.0.** Was the CRF CrAg titre done
- db_table: effect_subject_lpcsf
- column: crf_crag_titre_done
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** crf crag titre
- db_table: effect_subject_lpcsf
- column: crf_crag_titre
- type: IntegerField
---

**Section: CSF culture**

**16.0.** CSF Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_lpcsf
- column: csf_requisition
- type: ForeignKey
---

**17.0.** CSF Result Report Date and Time
- db_table: effect_subject_lpcsf
- column: csf_culture_assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**18.0.** CSF Result: Other organism (non-Cryptococcus)

&nbsp;&nbsp;&nbsp;&nbsp; *Complete after getting the results.*
- db_table: effect_subject_lpcsf
- column: csf_culture
- type: CharField
- length: 18
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `awaiting_results`: *Awaiting results*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**19.0.** If YES, specify organism:
- db_table: effect_subject_lpcsf
- column: other_csf_culture
- type: CharField
- length: 75
- responses: *free text*
---

**20.0.** Total CSF WBC cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup>*
- db_table: effect_subject_lpcsf
- column: csf_wbc_cell_count
- type: IntegerField
---

**21.0.** Differential lymphocyte cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup> or %*
- db_table: effect_subject_lpcsf
- column: differential_lymphocyte_count
- type: IntegerField
---

**22.0.** differential lymphocyte unit
- db_table: effect_subject_lpcsf
- column: differential_lymphocyte_unit
- type: CharField
- length: 6
- responses:
  - `mm3`: *mm<sup>3</sup>*
  - `%`: *%*
---

**23.0.** Differential neutrophil cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup> or %*
- db_table: effect_subject_lpcsf
- column: differential_neutrophil_count
- type: IntegerField
---

**24.0.** differential neutrophil unit
- db_table: effect_subject_lpcsf
- column: differential_neutrophil_unit
- type: CharField
- length: 6
- responses:
  - `mm3`: *mm<sup>3</sup>*
  - `%`: *%*
---

**25.0.** CSF glucose:

&nbsp;&nbsp;&nbsp;&nbsp; *Units in mmol/L or mg/dL*
- db_table: effect_subject_lpcsf
- column: csf_glucose
- type: DecimalField
---

**26.0.** CSF glucose units:
- db_table: effect_subject_lpcsf
- column: csf_glucose_units
- type: CharField
- length: 6
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**27.0.** CSF protein:

&nbsp;&nbsp;&nbsp;&nbsp; *Units in g/L*
- db_table: effect_subject_lpcsf
- column: csf_protein
- type: DecimalField
---

**28.0.** CSF CrAg:
- db_table: effect_subject_lpcsf
- column: csf_crag
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `IND`: *Indeterminate*
---


#### Tb Diagnostics
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_tbdiagnostics
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_tbdiagnostics
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Urinary LAM**

**3.0.** Urinary LAM performed?
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** urinary lam date
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_date
- type: DateField
- format: YYYY-MM-DD
---

**5.0.** Urinary LAM result
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_result
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---

**6.0.** If Urinary LAM is positive, grade
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_result_grade
- type: CharField
- length: 25
- responses:
  - `1`: *1+ (low)*
  - `2`: *2+*
  - `3`: *3+*
  - `4`: *4+*
  - `5`: *5+ (high)*
  - `unknown`: *Unknown / Grade not reported*
  - `N/A`: *Not applicable*
---

**Section: Sputum requisition**

**7.0.** Sputum requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_tbdiagnostics
- column: sputum_requisition
- type: ForeignKey
---

**Section: Sputum Gene-Xpert**

**8.0.** Sputum Gene-Xpert performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**9.0.** Sputum Gene-Xpert date
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_date
- type: DateField
- format: YYYY-MM-DD
---

**10.0.** Sputum Gene-Xpert results
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_result
- type: CharField
- length: 45
- responses:
  - `POS`: *MTB Positive*
  - `NEG`: *MTB Negative*
  - `IND`: *Indeterminate*
  - `N/A`: *Not applicable*
---

**Section: Sputum culture**

**11.0.** Sputum culture performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**12.0.** sputum culture date
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_date
- type: DateField
- format: YYYY-MM-DD
---

**13.0.** Sputum culture results
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_result
- type: CharField
- length: 10
- responses:
  - `POS`: *MTB Positive*
  - `NEG`: *MTB Negative*
  - `IND`: *Indeterminate / contaminated*
  - `N/A`: *Not applicable*
---

**Section: Sputum AFB**

**14.0.** Sputum AFB microscopy performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** Sputum AFB date
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_date
- type: DateField
- format: YYYY-MM-DD
---

**16.0.** Sputum AFB results
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_result
- type: CharField
- length: 10
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---

**Section: Comment**

**17.0.** Any additional comment
- db_table: effect_subject_tbdiagnostics
- column: comment
- type: TextField
---


#### Health Economics
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_healtheconomics
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_healtheconomics
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Education**

**3.0.** What is your occupation/profession?
- db_table: effect_subject_healtheconomics
- column: occupation
- type: CharField
- length: 50
- responses: *free text*
---

**4.0.** How many years of education did you compete?
- db_table: effect_subject_healtheconomics
- column: education_years
- type: IntegerField
---

**5.0.** What is your highest education certificate?
- db_table: effect_subject_healtheconomics
- column: educational_attainment
- type: CharField
- length: 50
- responses:
  - `no_schooling_completed`: *No schooling completed*
  - `nursery_to_8th_grade`: *Nursery school to 8th grade*
  - `some_high_school_no_diploma`: *Some high school, no diploma*
  - `high_school_grad_diploma_or_equiv`: *High school graduate, diploma or the equivalent (for example: GED)*
  - `some_college_no_degree`: *Some college credit, no degree*
  - `trade_technical_vocational_training`: *Trade/technical/vocational training*
  - `associate_degree`: *Associate degree*
  - `bachelors_degree`: *Bachelor's degree*
  - `masters_degree`: *Master's degree*
  - `professional_degree`: *Professional degree*
  - `doctorate_degree`: *Doctorate degree*
---

**6.0.** Did you go to primary/elementary school?
- db_table: effect_subject_healtheconomics
- column: primary_school
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** If YES, for how many years?
- db_table: effect_subject_healtheconomics
- column: primary_school_years
- type: IntegerField
---

**8.0.** Did you go to secondary school?
- db_table: effect_subject_healtheconomics
- column: secondary_school
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** If YES, for how many years?
- db_table: effect_subject_healtheconomics
- column: secondary_school_years
- type: IntegerField
---

**10.0.** Did you go to higher education?
- db_table: effect_subject_healtheconomics
- column: higher_education
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If YES, for how many years?
- db_table: effect_subject_healtheconomics
- column: higher_education_years
- type: IntegerField
---

**Section: Income**

**12.0.** Do you receive any welfare or social service support?
- db_table: effect_subject_healtheconomics
- column: welfare
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**13.0.** What is the total income in your household per month?

&nbsp;&nbsp;&nbsp;&nbsp; *In rands or shillings*
- db_table: effect_subject_healtheconomics
- column: monthly_household_income
- type: IntegerField
---

**14.0.** Are you the person who earns the highest income in your household?
- db_table: effect_subject_healtheconomics
- column: highest_earner
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**15.0.** If NO, what is the profession of the person who earns the highest income?
- db_table: effect_subject_healtheconomics
- column: profession_highest_earner
- type: CharField
- length: 50
- responses: *free text*
---

**Section: General expenditure**

**16.0.** How much does your household spend on food in a month?

&nbsp;&nbsp;&nbsp;&nbsp; *In rands or shillings*
- db_table: effect_subject_healtheconomics
- column: food_month
- type: IntegerField
---

**17.0.** How much does your household spend on rent (or house loan/mortgage) and utilities in a month?

&nbsp;&nbsp;&nbsp;&nbsp; *In rands or shillings*
- db_table: effect_subject_healtheconomics
- column: accommodation_month
- type: IntegerField
---

**18.0.** How much have you spent on large items (e.g., furniture, electrical items, cars) in the last year?

&nbsp;&nbsp;&nbsp;&nbsp; *In rands or shillings*
- db_table: effect_subject_healtheconomics
- column: large_items_year
- type: IntegerField
---


#### Clinical Note
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_clinicalnote
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_clinicalnote
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Clinical note**

**3.0.** Are there any comments on the clinical care or assessment plan
- db_table: effect_subject_clinicalnote
- column: has_comment
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** Comments
- db_table: effect_subject_clinicalnote
- column: comments
- type: TextField
---


#### Adherence: Day 1
Adherence CRF completed at baseline (in-person).
*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_adherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_adherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Adherence counselling**

**3.0.** Has appropriate adherence counselling been given as per the trial SOP?
- db_table: effect_subject_adherence
- column: adherence_counselling
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: adherence_counselling_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**5.0.** Was an adherence diary issued to the participant?
- db_table: effect_subject_adherence
- column: diary_issued
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: diary_issued_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Adherence narrative**

**7.0.** Medication adherence narrative:
- db_table: effect_subject_adherence
- column: adherence_narrative
- type: TextField
---


#### Requisitions

* fbc

* chemistry

### 1003

#### Vital Signs
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_vitalsigns
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_vitalsigns
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vital signs**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: effect_subject_vitalsigns
- column: weight
- type: DecimalField
---

**4.0.** Is the weight estimated or measured?
- db_table: effect_subject_vitalsigns
- column: weight_measured_or_est
- type: CharField
- length: 25
- responses:
  - `measured`: *Measured (weighed)*
  - `estimated`: *Estimated*
---

**5.0.** Blood pressure: systolic

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: effect_subject_vitalsigns
- column: sys_blood_pressure
- type: IntegerField
---

**6.0.** Blood pressure: diastolic

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: effect_subject_vitalsigns
- column: dia_blood_pressure
- type: IntegerField
---

**7.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: effect_subject_vitalsigns
- column: heart_rate
- type: IntegerField
---

**8.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: effect_subject_vitalsigns
- column: respiratory_rate
- type: IntegerField
---

**9.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celsius*
- db_table: effect_subject_vitalsigns
- column: temperature
- type: DecimalField
---

**10.0.** Abnormal lung exam:
- db_table: effect_subject_vitalsigns
- column: abnormal_lung_exam
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Action**

**11.0.** action identifier
- db_table: effect_subject_vitalsigns
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**12.0.** action item
- db_table: effect_subject_vitalsigns
- column: action_item
- type: ForeignKey
---

**13.0.** parent action item
- db_table: effect_subject_vitalsigns
- column: parent_action_item
- type: ForeignKey
---

**14.0.** related action item
- db_table: effect_subject_vitalsigns
- column: related_action_item
- type: ForeignKey
---

**Section: Reporting**

**15.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_vitalsigns
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**16.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_vitalsigns
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Mental Status
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_mentalstatus
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_mentalstatus
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Mental status**

**3.0.** Recent seizure (<72 hours)?
- db_table: effect_subject_mentalstatus
- column: recent_seizure
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** Behaviour change?
- db_table: effect_subject_mentalstatus
- column: behaviour_change
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**5.0.** Confusion?
- db_table: effect_subject_mentalstatus
- column: confusion
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Does the participant require help from anybody for everyday activities?

&nbsp;&nbsp;&nbsp;&nbsp; *Answer only at scheduled Week 10 and Month 6 visits*
- db_table: effect_subject_mentalstatus
- column: require_help
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.1.** Has the illness left the participant with any other problems?

&nbsp;&nbsp;&nbsp;&nbsp; *Answer only at scheduled Week 10 and Month 6 visits*
- db_table: effect_subject_mentalstatus
- column: any_other_problems
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**7.0.** Modified Rankin Score
- db_table: effect_subject_mentalstatus
- column: modified_rankin_score
- type: CharField
- length: 15
- responses:
  - `0`: *[0] No symptoms*
  - `1`: *[1] No significant disability. Able to carry out usual activities, despite some symptoms.*
  - `2`: *[2] Slight disability. Able to look after own affairs without assistance, but unable to carry out all previous activities.*
  - `3`: *[3] Moderate disability. Requires some help, but able to walk unassisted.*
  - `4`: *[4] Moderately severe disability. Unable to attend to own bodily needs without assistance, and unable to walk unassisted.*
  - `5`: *[5] Severe disability. Requires constant nursing care and attention, bedridden, incontinent.*
  - `6`: *[6] Dead*
---

**8.0.** ECOG score
- db_table: effect_subject_mentalstatus
- column: ecog_score
- type: CharField
- length: 15
- responses:
  - `0`: *[0] Fully active, able to carry on all pre-disease performance without restriction*
  - `1`: *[1] Restricted in physically strenuous activity but ambulatory and able to carry out work of a light or sedentary nature, e.g., light house work, office work*
  - `2`: *[2] Ambulatory and capable of all self-care but unable to carry out any work activities; up and about more than 50% of waking hours *
  - `3`: *[3] Capable of only limited self-care; confined to bed or chair more than 50% of waking hours*
  - `4`: *[4] Completely disabled; cannot carry on any self-care; totally confined to bed or chair*
  - `5`: *[5] Deceased*
---

**9.0.** Glasgow Coma Score

&nbsp;&nbsp;&nbsp;&nbsp; */15*
- db_table: effect_subject_mentalstatus
- column: glasgow_coma_score
- type: IntegerField
---

**Section: Reporting**

**10.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_mentalstatus
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_mentalstatus
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Signs And Symptoms
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_signsandsymptoms
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_signsandsymptoms
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Signs and symptoms**

**3.0.** Are there any signs or symptoms to report, since last contact with trial team?
- db_table: effect_subject_signsandsymptoms
- column: any_sx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `unknown`: *Unknown*
---

**4.0.** Is participant currently experiencing any of the following signs/symptoms?
- db_table: effect_subject_signsandsymptoms
- column: current_sx
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `cough`: *Cough*
  - `diarrhoea`: *Diarrhoea*
  - `double_vision`: *Double vision*
  - `drowsiness`: *Drowsiness*
  - `fever`: *Fever*
  - `focal_weakness`: *Focal weakness*
  - `headache`: *Headache*
  - `hearing_loss`: *Hearing loss*
  - `jaundice`: *Jaundice*
  - `nausea`: *Nausea*
  - `night_sweats`: *Night sweats*
  - `CN_VI_palsy_left`: *Neuro - Cranial Nerve VI palsy (left)*
  - `CN_VI_palsy_right`: *Neuro - Cranial Nerve VI palsy (right)*
  - `CN_VII_palsy_left`: *Neuro - Cranial Nerve VII palsy (left)*
  - `CN_VII_palsy_right`: *Neuro - Cranial Nerve VII palsy (right)*
  - `cn_palsy_left_other`: *Neuro - Other cranial nerve palsy (left), please specify below ...*
  - `cn_palsy_right_other`: *Neuro - Other cranial nerve palsy (right), please specify below ...*
  - `focal_seizures_left`: *Neuro - Focal seizures (left)*
  - `focal_seizures_right`: *Neuro - Focal seizures (right)*
  - `hemiplegia_left`: *Neuro - Hemiplegia (left)*
  - `hemiplegia_right`: *Neuro - Hemiplegia (right)*
  - `meningism`: *Neuro - Meningism*
  - `papilloedema`: *Neuro - Papilloedema*
  - `visual_field_disturbance`: *Neuro - Visual field disturbance*
  - `focal_neurologic_deficit_other`: *Neuro - Other focal neurologic deficit, please specify below ...*
  - `shortness_of_breath`: *Shortness of breath*
  - `skin_lesions`: *Skin lesions*
  - `visual_loss`: *Visual loss*
  - `vomiting`: *Vomiting*
  - `weight_loss`: *Weight loss*
  - `OTHER`: *Other sign(s)/symptom(s), please specify below ...*
---

**4.1.** If other, please specify ...

&nbsp;&nbsp;&nbsp;&nbsp; *If more than one, separate each with a comma (,).*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_other
- type: TextField
---

**5.0.** Are any of the signs or symptoms related to cryptococcal meningitis (CM)?
- db_table: effect_subject_signsandsymptoms
- column: cm_sx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.0.** For these signs/symptoms, were any Grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.</br>*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_gte_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `cough`: *Cough*
  - `diarrhoea`: *Diarrhoea*
  - `double_vision`: *Double vision*
  - `drowsiness`: *Drowsiness*
  - `fever`: *Fever*
  - `focal_weakness`: *Focal weakness*
  - `headache`: *Headache*
  - `hearing_loss`: *Hearing loss*
  - `jaundice`: *Jaundice*
  - `nausea`: *Nausea*
  - `night_sweats`: *Night sweats*
  - `CN_VI_palsy_left`: *Neuro - Cranial Nerve VI palsy (left)*
  - `CN_VI_palsy_right`: *Neuro - Cranial Nerve VI palsy (right)*
  - `CN_VII_palsy_left`: *Neuro - Cranial Nerve VII palsy (left)*
  - `CN_VII_palsy_right`: *Neuro - Cranial Nerve VII palsy (right)*
  - `cn_palsy_left_other`: *Neuro - Other cranial nerve palsy (left), please specify below ...*
  - `cn_palsy_right_other`: *Neuro - Other cranial nerve palsy (right), please specify below ...*
  - `focal_seizures_left`: *Neuro - Focal seizures (left)*
  - `focal_seizures_right`: *Neuro - Focal seizures (right)*
  - `hemiplegia_left`: *Neuro - Hemiplegia (left)*
  - `hemiplegia_right`: *Neuro - Hemiplegia (right)*
  - `meningism`: *Neuro - Meningism*
  - `papilloedema`: *Neuro - Papilloedema*
  - `visual_field_disturbance`: *Neuro - Visual field disturbance*
  - `focal_neurologic_deficit_other`: *Neuro - Other focal neurologic deficit, please specify below ...*
  - `shortness_of_breath`: *Shortness of breath*
  - `skin_lesions`: *Skin lesions*
  - `visual_loss`: *Visual loss*
  - `vomiting`: *Vomiting*
  - `weight_loss`: *Weight loss*
  - `OTHER`: *Other sign(s)/symptom(s), please specify below ...*
---

**6.1.** If other, please specify ...

&nbsp;&nbsp;&nbsp;&nbsp; *If more than one, separate each with a comma (,).*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_gte_g3_other
- type: TextField
---

**Section: Additional details**

**7.0.** If participant currently has headache, for what duration have they had it for

&nbsp;&nbsp;&nbsp;&nbsp; *In days and/or hours.  Note: 1 day equivalent to 24 hours.</br> Format is `DDdHHh`, `DDd` or `HHh`. For example 1d23h, 15d9h ... or 20d, or 5h ...*
- db_table: effect_subject_signsandsymptoms
- column: headache_duration
- type: CharField
- length: 7
- responses: *free text*
---

**7.1.** If other cranial nerve palsy (left), please specify ...
- db_table: effect_subject_signsandsymptoms
- column: cn_palsy_left_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.2.** If other cranial nerve palsy (right), please specify ...
- db_table: effect_subject_signsandsymptoms
- column: cn_palsy_right_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.3.** If other focal neurologic deficit, please specify ...
- db_table: effect_subject_signsandsymptoms
- column: focal_neurologic_deficit_other
- type: CharField
- length: 35
- responses: *free text*
---

**8.0.** If visual field loss, please provide details ...
- db_table: effect_subject_signsandsymptoms
- column: visual_field_loss
- type: TextField
---

**Section: Investigations**

**9.0.** Was an X-ray performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'Chest X-ray' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: xray_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**10.0.** Was a lumbar puncture performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'Lumbar Puncture/CSF' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: lp_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Was a urinary LAM performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'TB Diagnostics' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: urinary_lam_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Reporting**

**12.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_signsandsymptoms
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_signsandsymptoms
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Calculated values**

**14.0.** calculated headache duration
- db_table: effect_subject_signsandsymptoms
- column: calculated_headache_duration
- type: DurationField
---

**Section: Action**

**15.0.** action identifier
- db_table: effect_subject_signsandsymptoms
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**16.0.** action item
- db_table: effect_subject_signsandsymptoms
- column: action_item
- type: ForeignKey
---

**17.0.** parent action item
- db_table: effect_subject_signsandsymptoms
- column: parent_action_item
- type: ForeignKey
---

**18.0.** related action item
- db_table: effect_subject_signsandsymptoms
- column: related_action_item
- type: ForeignKey
---


#### Significant Diagnoses
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_diagnoses
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_diagnoses
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Gastrointestinal side effects**

**3.0.** Has the participant experienced any gastrointestinal side effects?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete SAE report where appropriate*
- db_table: effect_subject_diagnoses
- column: gi_side_effects
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, please give details
- db_table: effect_subject_diagnoses
- column: gi_side_effects_details
- type: TextField
---

**Section: Diagnoses**

**5.0.** Are there any new significant diagnoses to report since last visit?
- db_table: effect_subject_diagnoses
- column: has_diagnoses
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Please select all diagnoses that are relevant
- db_table: effect_subject_diagnoses
- column: diagnoses
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `bacteraemia`: *Bacteraemia*
  - `bacterial_pneumonia`: *Bacterial pneumonia*
  - `cm`: *Cryptococcal meningitis*
  - `diarrhoeal_wasting`: *Diarrhoeal wasting*
  - `kaposi_sarcoma`: *Kaposi’s sarcoma*
  - `malaria`: *Malaria*
  - `tb_extrapulmonary`: *TB extrapulmonary*
  - `tb_pulmonary`: *TB pulmonary*
  - `OTHER`: *Other, please specify below ...*
---

**6.1.** If other, please specify ...
- db_table: effect_subject_diagnoses
- column: diagnoses_other
- type: TextField
- length: 150
---

**Section: Reporting**

**7.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_diagnoses
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_diagnoses
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Chest X-Ray
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_chestxray
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_chestxray
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Chest x-ray**

**3.0.** Was a chest x-ray performed?
- db_table: effect_subject_chestxray
- column: chest_xray
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, date performed?
- db_table: effect_subject_chestxray
- column: chest_xray_date
- type: DateField
- format: YYYY-MM-DD
---

**5.0.** If YES, indicate results?
- db_table: effect_subject_chestxray
- column: chest_xray_results
- type: ManyToManyField
- responses: *Select all that apply*
  - `NORMAL`: *Normal*
  - `lymphadenopathy`: *Lymphadenopathy*
  - `consolidation`: *Consolidation*
  - `miliary_tb`: *Miliary TB*
  - `infiltrates`: *Infiltrates*
  - `OTHER`: *Other, please specify below ...*
---

**5.1.** If other, please specify ...
- db_table: effect_subject_chestxray
- column: chest_xray_results_other
- type: TextField
---

**6.0.** Any additional comment
- db_table: effect_subject_chestxray
- column: comment
- type: TextField
---


#### Lumbar Puncture/Csf
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_lpcsf
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_lpcsf
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: LP**

**3.0.** Reason for LP
- db_table: effect_subject_lpcsf
- column: reason_for_lp
- type: CharField
- length: 50
- responses:
  - `scheduled_per_protocol`: *Scheduled per protocol*
  - `clincal_deterioration`: *Suspected Cryptococcal meningitis / Suspected IRIS*
---

**4.0.** LP Date and Time
- db_table: effect_subject_lpcsf
- column: lp_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**5.0.** Was the opening pressure measured
- db_table: effect_subject_lpcsf
- column: opening_pressure_measured
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** opening pressure

&nbsp;&nbsp;&nbsp;&nbsp; *Units cm of H<sub>2</sub>O*
- db_table: effect_subject_lpcsf
- column: opening_pressure
- type: IntegerField
---

**7.0.** closing pressure

&nbsp;&nbsp;&nbsp;&nbsp; *Units cm of H<sub>2</sub>O*
- db_table: effect_subject_lpcsf
- column: closing_pressure
- type: IntegerField
---

**8.0.** CSF amount removed

&nbsp;&nbsp;&nbsp;&nbsp; *Units ml*
- db_table: effect_subject_lpcsf
- column: csf_amount_removed
- type: IntegerField
---

**Section: CSF**

**9.0.** CSF positive for cryptococcal meningitis?
- db_table: effect_subject_lpcsf
- column: csf_positive
- type: CharField
- length: 18
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `awaiting_results`: *Awaiting results*
---

**10.0.** india ink
- db_table: effect_subject_lpcsf
- column: india_ink
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**11.0.** CrAg LFA
- db_table: effect_subject_lpcsf
- column: csf_crag_lfa
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**12.0.** SQ CrAg
- db_table: effect_subject_lpcsf
- column: sq_crag
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**13.0.** SQ CrAg
- db_table: effect_subject_lpcsf
- column: sq_crag_pos
- type: CharField
- length: 15
- responses:
  - `high`: *High*
  - `low`: *Low*
  - `N/A`: *Not applicable*
---

**14.0.** Was the CRF CrAg titre done
- db_table: effect_subject_lpcsf
- column: crf_crag_titre_done
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** crf crag titre
- db_table: effect_subject_lpcsf
- column: crf_crag_titre
- type: IntegerField
---

**Section: CSF culture**

**16.0.** CSF Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_lpcsf
- column: csf_requisition
- type: ForeignKey
---

**17.0.** CSF Result Report Date and Time
- db_table: effect_subject_lpcsf
- column: csf_culture_assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**18.0.** CSF Result: Other organism (non-Cryptococcus)

&nbsp;&nbsp;&nbsp;&nbsp; *Complete after getting the results.*
- db_table: effect_subject_lpcsf
- column: csf_culture
- type: CharField
- length: 18
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `awaiting_results`: *Awaiting results*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**19.0.** If YES, specify organism:
- db_table: effect_subject_lpcsf
- column: other_csf_culture
- type: CharField
- length: 75
- responses: *free text*
---

**20.0.** Total CSF WBC cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup>*
- db_table: effect_subject_lpcsf
- column: csf_wbc_cell_count
- type: IntegerField
---

**21.0.** Differential lymphocyte cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup> or %*
- db_table: effect_subject_lpcsf
- column: differential_lymphocyte_count
- type: IntegerField
---

**22.0.** differential lymphocyte unit
- db_table: effect_subject_lpcsf
- column: differential_lymphocyte_unit
- type: CharField
- length: 6
- responses:
  - `mm3`: *mm<sup>3</sup>*
  - `%`: *%*
---

**23.0.** Differential neutrophil cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup> or %*
- db_table: effect_subject_lpcsf
- column: differential_neutrophil_count
- type: IntegerField
---

**24.0.** differential neutrophil unit
- db_table: effect_subject_lpcsf
- column: differential_neutrophil_unit
- type: CharField
- length: 6
- responses:
  - `mm3`: *mm<sup>3</sup>*
  - `%`: *%*
---

**25.0.** CSF glucose:

&nbsp;&nbsp;&nbsp;&nbsp; *Units in mmol/L or mg/dL*
- db_table: effect_subject_lpcsf
- column: csf_glucose
- type: DecimalField
---

**26.0.** CSF glucose units:
- db_table: effect_subject_lpcsf
- column: csf_glucose_units
- type: CharField
- length: 6
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**27.0.** CSF protein:

&nbsp;&nbsp;&nbsp;&nbsp; *Units in g/L*
- db_table: effect_subject_lpcsf
- column: csf_protein
- type: DecimalField
---

**28.0.** CSF CrAg:
- db_table: effect_subject_lpcsf
- column: csf_crag
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `IND`: *Indeterminate*
---


#### Tb Diagnostics
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_tbdiagnostics
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_tbdiagnostics
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Urinary LAM**

**3.0.** Urinary LAM performed?
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** urinary lam date
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_date
- type: DateField
- format: YYYY-MM-DD
---

**5.0.** Urinary LAM result
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_result
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---

**6.0.** If Urinary LAM is positive, grade
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_result_grade
- type: CharField
- length: 25
- responses:
  - `1`: *1+ (low)*
  - `2`: *2+*
  - `3`: *3+*
  - `4`: *4+*
  - `5`: *5+ (high)*
  - `unknown`: *Unknown / Grade not reported*
  - `N/A`: *Not applicable*
---

**Section: Sputum requisition**

**7.0.** Sputum requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_tbdiagnostics
- column: sputum_requisition
- type: ForeignKey
---

**Section: Sputum Gene-Xpert**

**8.0.** Sputum Gene-Xpert performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**9.0.** Sputum Gene-Xpert date
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_date
- type: DateField
- format: YYYY-MM-DD
---

**10.0.** Sputum Gene-Xpert results
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_result
- type: CharField
- length: 45
- responses:
  - `POS`: *MTB Positive*
  - `NEG`: *MTB Negative*
  - `IND`: *Indeterminate*
  - `N/A`: *Not applicable*
---

**Section: Sputum culture**

**11.0.** Sputum culture performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**12.0.** sputum culture date
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_date
- type: DateField
- format: YYYY-MM-DD
---

**13.0.** Sputum culture results
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_result
- type: CharField
- length: 10
- responses:
  - `POS`: *MTB Positive*
  - `NEG`: *MTB Negative*
  - `IND`: *Indeterminate / contaminated*
  - `N/A`: *Not applicable*
---

**Section: Sputum AFB**

**14.0.** Sputum AFB microscopy performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** Sputum AFB date
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_date
- type: DateField
- format: YYYY-MM-DD
---

**16.0.** Sputum AFB results
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_result
- type: CharField
- length: 10
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---

**Section: Comment**

**17.0.** Any additional comment
- db_table: effect_subject_tbdiagnostics
- column: comment
- type: TextField
---


#### Adherence: On Study
Adherence CRF completed at d3 and d9 (telephone).
*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_adherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_adherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Adherence counselling**

**3.0.** Has appropriate adherence counselling been given as per the trial SOP?
- db_table: effect_subject_adherence
- column: adherence_counselling
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: adherence_counselling_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Missed doses**

**5.0.** Have any Fluconazole doses been missed since the last visit?
- db_table: effect_subject_adherence
- column: flucon_doses_missed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `unknown`: *Unknown*
---

**6.0.** If YES, number of Fluconazole doses missed since last visit:

&nbsp;&nbsp;&nbsp;&nbsp; *This should be measured in single doses (1 dose per day)*
- db_table: effect_subject_adherence
- column: flucon_doses_missed_number
- type: IntegerField
---

**7.0.** Have any Flucytosine doses been missed since the last visit?
- db_table: effect_subject_adherence
- column: flucyt_doses_missed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `unknown`: *Unknown*
---

**8.0.** If YES, number of Flucytosine doses missed since last visit:

&nbsp;&nbsp;&nbsp;&nbsp; *This should be measured in single doses (4 doses per day)*
- db_table: effect_subject_adherence
- column: flucyt_doses_missed_number
- type: IntegerField
---

**Section: Adherence narrative**

**9.0.** Medication adherence narrative:
- db_table: effect_subject_adherence
- column: adherence_narrative
- type: TextField
---


#### Requisitions

### 1009

#### Vital Signs
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_vitalsigns
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_vitalsigns
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vital signs**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: effect_subject_vitalsigns
- column: weight
- type: DecimalField
---

**4.0.** Is the weight estimated or measured?
- db_table: effect_subject_vitalsigns
- column: weight_measured_or_est
- type: CharField
- length: 25
- responses:
  - `measured`: *Measured (weighed)*
  - `estimated`: *Estimated*
---

**5.0.** Blood pressure: systolic

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: effect_subject_vitalsigns
- column: sys_blood_pressure
- type: IntegerField
---

**6.0.** Blood pressure: diastolic

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: effect_subject_vitalsigns
- column: dia_blood_pressure
- type: IntegerField
---

**7.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: effect_subject_vitalsigns
- column: heart_rate
- type: IntegerField
---

**8.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: effect_subject_vitalsigns
- column: respiratory_rate
- type: IntegerField
---

**9.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celsius*
- db_table: effect_subject_vitalsigns
- column: temperature
- type: DecimalField
---

**10.0.** Abnormal lung exam:
- db_table: effect_subject_vitalsigns
- column: abnormal_lung_exam
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Action**

**11.0.** action identifier
- db_table: effect_subject_vitalsigns
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**12.0.** action item
- db_table: effect_subject_vitalsigns
- column: action_item
- type: ForeignKey
---

**13.0.** parent action item
- db_table: effect_subject_vitalsigns
- column: parent_action_item
- type: ForeignKey
---

**14.0.** related action item
- db_table: effect_subject_vitalsigns
- column: related_action_item
- type: ForeignKey
---

**Section: Reporting**

**15.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_vitalsigns
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**16.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_vitalsigns
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Mental Status
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_mentalstatus
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_mentalstatus
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Mental status**

**3.0.** Recent seizure (<72 hours)?
- db_table: effect_subject_mentalstatus
- column: recent_seizure
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** Behaviour change?
- db_table: effect_subject_mentalstatus
- column: behaviour_change
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**5.0.** Confusion?
- db_table: effect_subject_mentalstatus
- column: confusion
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Does the participant require help from anybody for everyday activities?

&nbsp;&nbsp;&nbsp;&nbsp; *Answer only at scheduled Week 10 and Month 6 visits*
- db_table: effect_subject_mentalstatus
- column: require_help
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.1.** Has the illness left the participant with any other problems?

&nbsp;&nbsp;&nbsp;&nbsp; *Answer only at scheduled Week 10 and Month 6 visits*
- db_table: effect_subject_mentalstatus
- column: any_other_problems
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**7.0.** Modified Rankin Score
- db_table: effect_subject_mentalstatus
- column: modified_rankin_score
- type: CharField
- length: 15
- responses:
  - `0`: *[0] No symptoms*
  - `1`: *[1] No significant disability. Able to carry out usual activities, despite some symptoms.*
  - `2`: *[2] Slight disability. Able to look after own affairs without assistance, but unable to carry out all previous activities.*
  - `3`: *[3] Moderate disability. Requires some help, but able to walk unassisted.*
  - `4`: *[4] Moderately severe disability. Unable to attend to own bodily needs without assistance, and unable to walk unassisted.*
  - `5`: *[5] Severe disability. Requires constant nursing care and attention, bedridden, incontinent.*
  - `6`: *[6] Dead*
---

**8.0.** ECOG score
- db_table: effect_subject_mentalstatus
- column: ecog_score
- type: CharField
- length: 15
- responses:
  - `0`: *[0] Fully active, able to carry on all pre-disease performance without restriction*
  - `1`: *[1] Restricted in physically strenuous activity but ambulatory and able to carry out work of a light or sedentary nature, e.g., light house work, office work*
  - `2`: *[2] Ambulatory and capable of all self-care but unable to carry out any work activities; up and about more than 50% of waking hours *
  - `3`: *[3] Capable of only limited self-care; confined to bed or chair more than 50% of waking hours*
  - `4`: *[4] Completely disabled; cannot carry on any self-care; totally confined to bed or chair*
  - `5`: *[5] Deceased*
---

**9.0.** Glasgow Coma Score

&nbsp;&nbsp;&nbsp;&nbsp; */15*
- db_table: effect_subject_mentalstatus
- column: glasgow_coma_score
- type: IntegerField
---

**Section: Reporting**

**10.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_mentalstatus
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_mentalstatus
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Signs And Symptoms
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_signsandsymptoms
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_signsandsymptoms
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Signs and symptoms**

**3.0.** Are there any signs or symptoms to report, since last contact with trial team?
- db_table: effect_subject_signsandsymptoms
- column: any_sx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `unknown`: *Unknown*
---

**4.0.** Is participant currently experiencing any of the following signs/symptoms?
- db_table: effect_subject_signsandsymptoms
- column: current_sx
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `cough`: *Cough*
  - `diarrhoea`: *Diarrhoea*
  - `double_vision`: *Double vision*
  - `drowsiness`: *Drowsiness*
  - `fever`: *Fever*
  - `focal_weakness`: *Focal weakness*
  - `headache`: *Headache*
  - `hearing_loss`: *Hearing loss*
  - `jaundice`: *Jaundice*
  - `nausea`: *Nausea*
  - `night_sweats`: *Night sweats*
  - `CN_VI_palsy_left`: *Neuro - Cranial Nerve VI palsy (left)*
  - `CN_VI_palsy_right`: *Neuro - Cranial Nerve VI palsy (right)*
  - `CN_VII_palsy_left`: *Neuro - Cranial Nerve VII palsy (left)*
  - `CN_VII_palsy_right`: *Neuro - Cranial Nerve VII palsy (right)*
  - `cn_palsy_left_other`: *Neuro - Other cranial nerve palsy (left), please specify below ...*
  - `cn_palsy_right_other`: *Neuro - Other cranial nerve palsy (right), please specify below ...*
  - `focal_seizures_left`: *Neuro - Focal seizures (left)*
  - `focal_seizures_right`: *Neuro - Focal seizures (right)*
  - `hemiplegia_left`: *Neuro - Hemiplegia (left)*
  - `hemiplegia_right`: *Neuro - Hemiplegia (right)*
  - `meningism`: *Neuro - Meningism*
  - `papilloedema`: *Neuro - Papilloedema*
  - `visual_field_disturbance`: *Neuro - Visual field disturbance*
  - `focal_neurologic_deficit_other`: *Neuro - Other focal neurologic deficit, please specify below ...*
  - `shortness_of_breath`: *Shortness of breath*
  - `skin_lesions`: *Skin lesions*
  - `visual_loss`: *Visual loss*
  - `vomiting`: *Vomiting*
  - `weight_loss`: *Weight loss*
  - `OTHER`: *Other sign(s)/symptom(s), please specify below ...*
---

**4.1.** If other, please specify ...

&nbsp;&nbsp;&nbsp;&nbsp; *If more than one, separate each with a comma (,).*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_other
- type: TextField
---

**5.0.** Are any of the signs or symptoms related to cryptococcal meningitis (CM)?
- db_table: effect_subject_signsandsymptoms
- column: cm_sx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.0.** For these signs/symptoms, were any Grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.</br>*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_gte_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `cough`: *Cough*
  - `diarrhoea`: *Diarrhoea*
  - `double_vision`: *Double vision*
  - `drowsiness`: *Drowsiness*
  - `fever`: *Fever*
  - `focal_weakness`: *Focal weakness*
  - `headache`: *Headache*
  - `hearing_loss`: *Hearing loss*
  - `jaundice`: *Jaundice*
  - `nausea`: *Nausea*
  - `night_sweats`: *Night sweats*
  - `CN_VI_palsy_left`: *Neuro - Cranial Nerve VI palsy (left)*
  - `CN_VI_palsy_right`: *Neuro - Cranial Nerve VI palsy (right)*
  - `CN_VII_palsy_left`: *Neuro - Cranial Nerve VII palsy (left)*
  - `CN_VII_palsy_right`: *Neuro - Cranial Nerve VII palsy (right)*
  - `cn_palsy_left_other`: *Neuro - Other cranial nerve palsy (left), please specify below ...*
  - `cn_palsy_right_other`: *Neuro - Other cranial nerve palsy (right), please specify below ...*
  - `focal_seizures_left`: *Neuro - Focal seizures (left)*
  - `focal_seizures_right`: *Neuro - Focal seizures (right)*
  - `hemiplegia_left`: *Neuro - Hemiplegia (left)*
  - `hemiplegia_right`: *Neuro - Hemiplegia (right)*
  - `meningism`: *Neuro - Meningism*
  - `papilloedema`: *Neuro - Papilloedema*
  - `visual_field_disturbance`: *Neuro - Visual field disturbance*
  - `focal_neurologic_deficit_other`: *Neuro - Other focal neurologic deficit, please specify below ...*
  - `shortness_of_breath`: *Shortness of breath*
  - `skin_lesions`: *Skin lesions*
  - `visual_loss`: *Visual loss*
  - `vomiting`: *Vomiting*
  - `weight_loss`: *Weight loss*
  - `OTHER`: *Other sign(s)/symptom(s), please specify below ...*
---

**6.1.** If other, please specify ...

&nbsp;&nbsp;&nbsp;&nbsp; *If more than one, separate each with a comma (,).*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_gte_g3_other
- type: TextField
---

**Section: Additional details**

**7.0.** If participant currently has headache, for what duration have they had it for

&nbsp;&nbsp;&nbsp;&nbsp; *In days and/or hours.  Note: 1 day equivalent to 24 hours.</br> Format is `DDdHHh`, `DDd` or `HHh`. For example 1d23h, 15d9h ... or 20d, or 5h ...*
- db_table: effect_subject_signsandsymptoms
- column: headache_duration
- type: CharField
- length: 7
- responses: *free text*
---

**7.1.** If other cranial nerve palsy (left), please specify ...
- db_table: effect_subject_signsandsymptoms
- column: cn_palsy_left_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.2.** If other cranial nerve palsy (right), please specify ...
- db_table: effect_subject_signsandsymptoms
- column: cn_palsy_right_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.3.** If other focal neurologic deficit, please specify ...
- db_table: effect_subject_signsandsymptoms
- column: focal_neurologic_deficit_other
- type: CharField
- length: 35
- responses: *free text*
---

**8.0.** If visual field loss, please provide details ...
- db_table: effect_subject_signsandsymptoms
- column: visual_field_loss
- type: TextField
---

**Section: Investigations**

**9.0.** Was an X-ray performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'Chest X-ray' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: xray_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**10.0.** Was a lumbar puncture performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'Lumbar Puncture/CSF' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: lp_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Was a urinary LAM performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'TB Diagnostics' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: urinary_lam_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Reporting**

**12.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_signsandsymptoms
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_signsandsymptoms
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Calculated values**

**14.0.** calculated headache duration
- db_table: effect_subject_signsandsymptoms
- column: calculated_headache_duration
- type: DurationField
---

**Section: Action**

**15.0.** action identifier
- db_table: effect_subject_signsandsymptoms
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**16.0.** action item
- db_table: effect_subject_signsandsymptoms
- column: action_item
- type: ForeignKey
---

**17.0.** parent action item
- db_table: effect_subject_signsandsymptoms
- column: parent_action_item
- type: ForeignKey
---

**18.0.** related action item
- db_table: effect_subject_signsandsymptoms
- column: related_action_item
- type: ForeignKey
---


#### Significant Diagnoses
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_diagnoses
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_diagnoses
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Gastrointestinal side effects**

**3.0.** Has the participant experienced any gastrointestinal side effects?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete SAE report where appropriate*
- db_table: effect_subject_diagnoses
- column: gi_side_effects
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, please give details
- db_table: effect_subject_diagnoses
- column: gi_side_effects_details
- type: TextField
---

**Section: Diagnoses**

**5.0.** Are there any new significant diagnoses to report since last visit?
- db_table: effect_subject_diagnoses
- column: has_diagnoses
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Please select all diagnoses that are relevant
- db_table: effect_subject_diagnoses
- column: diagnoses
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `bacteraemia`: *Bacteraemia*
  - `bacterial_pneumonia`: *Bacterial pneumonia*
  - `cm`: *Cryptococcal meningitis*
  - `diarrhoeal_wasting`: *Diarrhoeal wasting*
  - `kaposi_sarcoma`: *Kaposi’s sarcoma*
  - `malaria`: *Malaria*
  - `tb_extrapulmonary`: *TB extrapulmonary*
  - `tb_pulmonary`: *TB pulmonary*
  - `OTHER`: *Other, please specify below ...*
---

**6.1.** If other, please specify ...
- db_table: effect_subject_diagnoses
- column: diagnoses_other
- type: TextField
- length: 150
---

**Section: Reporting**

**7.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_diagnoses
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_diagnoses
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Chest X-Ray
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_chestxray
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_chestxray
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Chest x-ray**

**3.0.** Was a chest x-ray performed?
- db_table: effect_subject_chestxray
- column: chest_xray
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, date performed?
- db_table: effect_subject_chestxray
- column: chest_xray_date
- type: DateField
- format: YYYY-MM-DD
---

**5.0.** If YES, indicate results?
- db_table: effect_subject_chestxray
- column: chest_xray_results
- type: ManyToManyField
- responses: *Select all that apply*
  - `NORMAL`: *Normal*
  - `lymphadenopathy`: *Lymphadenopathy*
  - `consolidation`: *Consolidation*
  - `miliary_tb`: *Miliary TB*
  - `infiltrates`: *Infiltrates*
  - `OTHER`: *Other, please specify below ...*
---

**5.1.** If other, please specify ...
- db_table: effect_subject_chestxray
- column: chest_xray_results_other
- type: TextField
---

**6.0.** Any additional comment
- db_table: effect_subject_chestxray
- column: comment
- type: TextField
---


#### Lumbar Puncture/Csf
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_lpcsf
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_lpcsf
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: LP**

**3.0.** Reason for LP
- db_table: effect_subject_lpcsf
- column: reason_for_lp
- type: CharField
- length: 50
- responses:
  - `scheduled_per_protocol`: *Scheduled per protocol*
  - `clincal_deterioration`: *Suspected Cryptococcal meningitis / Suspected IRIS*
---

**4.0.** LP Date and Time
- db_table: effect_subject_lpcsf
- column: lp_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**5.0.** Was the opening pressure measured
- db_table: effect_subject_lpcsf
- column: opening_pressure_measured
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** opening pressure

&nbsp;&nbsp;&nbsp;&nbsp; *Units cm of H<sub>2</sub>O*
- db_table: effect_subject_lpcsf
- column: opening_pressure
- type: IntegerField
---

**7.0.** closing pressure

&nbsp;&nbsp;&nbsp;&nbsp; *Units cm of H<sub>2</sub>O*
- db_table: effect_subject_lpcsf
- column: closing_pressure
- type: IntegerField
---

**8.0.** CSF amount removed

&nbsp;&nbsp;&nbsp;&nbsp; *Units ml*
- db_table: effect_subject_lpcsf
- column: csf_amount_removed
- type: IntegerField
---

**Section: CSF**

**9.0.** CSF positive for cryptococcal meningitis?
- db_table: effect_subject_lpcsf
- column: csf_positive
- type: CharField
- length: 18
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `awaiting_results`: *Awaiting results*
---

**10.0.** india ink
- db_table: effect_subject_lpcsf
- column: india_ink
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**11.0.** CrAg LFA
- db_table: effect_subject_lpcsf
- column: csf_crag_lfa
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**12.0.** SQ CrAg
- db_table: effect_subject_lpcsf
- column: sq_crag
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**13.0.** SQ CrAg
- db_table: effect_subject_lpcsf
- column: sq_crag_pos
- type: CharField
- length: 15
- responses:
  - `high`: *High*
  - `low`: *Low*
  - `N/A`: *Not applicable*
---

**14.0.** Was the CRF CrAg titre done
- db_table: effect_subject_lpcsf
- column: crf_crag_titre_done
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** crf crag titre
- db_table: effect_subject_lpcsf
- column: crf_crag_titre
- type: IntegerField
---

**Section: CSF culture**

**16.0.** CSF Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_lpcsf
- column: csf_requisition
- type: ForeignKey
---

**17.0.** CSF Result Report Date and Time
- db_table: effect_subject_lpcsf
- column: csf_culture_assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**18.0.** CSF Result: Other organism (non-Cryptococcus)

&nbsp;&nbsp;&nbsp;&nbsp; *Complete after getting the results.*
- db_table: effect_subject_lpcsf
- column: csf_culture
- type: CharField
- length: 18
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `awaiting_results`: *Awaiting results*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**19.0.** If YES, specify organism:
- db_table: effect_subject_lpcsf
- column: other_csf_culture
- type: CharField
- length: 75
- responses: *free text*
---

**20.0.** Total CSF WBC cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup>*
- db_table: effect_subject_lpcsf
- column: csf_wbc_cell_count
- type: IntegerField
---

**21.0.** Differential lymphocyte cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup> or %*
- db_table: effect_subject_lpcsf
- column: differential_lymphocyte_count
- type: IntegerField
---

**22.0.** differential lymphocyte unit
- db_table: effect_subject_lpcsf
- column: differential_lymphocyte_unit
- type: CharField
- length: 6
- responses:
  - `mm3`: *mm<sup>3</sup>*
  - `%`: *%*
---

**23.0.** Differential neutrophil cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup> or %*
- db_table: effect_subject_lpcsf
- column: differential_neutrophil_count
- type: IntegerField
---

**24.0.** differential neutrophil unit
- db_table: effect_subject_lpcsf
- column: differential_neutrophil_unit
- type: CharField
- length: 6
- responses:
  - `mm3`: *mm<sup>3</sup>*
  - `%`: *%*
---

**25.0.** CSF glucose:

&nbsp;&nbsp;&nbsp;&nbsp; *Units in mmol/L or mg/dL*
- db_table: effect_subject_lpcsf
- column: csf_glucose
- type: DecimalField
---

**26.0.** CSF glucose units:
- db_table: effect_subject_lpcsf
- column: csf_glucose_units
- type: CharField
- length: 6
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**27.0.** CSF protein:

&nbsp;&nbsp;&nbsp;&nbsp; *Units in g/L*
- db_table: effect_subject_lpcsf
- column: csf_protein
- type: DecimalField
---

**28.0.** CSF CrAg:
- db_table: effect_subject_lpcsf
- column: csf_crag
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `IND`: *Indeterminate*
---


#### Tb Diagnostics
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_tbdiagnostics
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_tbdiagnostics
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Urinary LAM**

**3.0.** Urinary LAM performed?
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** urinary lam date
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_date
- type: DateField
- format: YYYY-MM-DD
---

**5.0.** Urinary LAM result
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_result
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---

**6.0.** If Urinary LAM is positive, grade
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_result_grade
- type: CharField
- length: 25
- responses:
  - `1`: *1+ (low)*
  - `2`: *2+*
  - `3`: *3+*
  - `4`: *4+*
  - `5`: *5+ (high)*
  - `unknown`: *Unknown / Grade not reported*
  - `N/A`: *Not applicable*
---

**Section: Sputum requisition**

**7.0.** Sputum requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_tbdiagnostics
- column: sputum_requisition
- type: ForeignKey
---

**Section: Sputum Gene-Xpert**

**8.0.** Sputum Gene-Xpert performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**9.0.** Sputum Gene-Xpert date
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_date
- type: DateField
- format: YYYY-MM-DD
---

**10.0.** Sputum Gene-Xpert results
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_result
- type: CharField
- length: 45
- responses:
  - `POS`: *MTB Positive*
  - `NEG`: *MTB Negative*
  - `IND`: *Indeterminate*
  - `N/A`: *Not applicable*
---

**Section: Sputum culture**

**11.0.** Sputum culture performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**12.0.** sputum culture date
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_date
- type: DateField
- format: YYYY-MM-DD
---

**13.0.** Sputum culture results
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_result
- type: CharField
- length: 10
- responses:
  - `POS`: *MTB Positive*
  - `NEG`: *MTB Negative*
  - `IND`: *Indeterminate / contaminated*
  - `N/A`: *Not applicable*
---

**Section: Sputum AFB**

**14.0.** Sputum AFB microscopy performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** Sputum AFB date
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_date
- type: DateField
- format: YYYY-MM-DD
---

**16.0.** Sputum AFB results
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_result
- type: CharField
- length: 10
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---

**Section: Comment**

**17.0.** Any additional comment
- db_table: effect_subject_tbdiagnostics
- column: comment
- type: TextField
---


#### Adherence: On Study
Adherence CRF completed at d3 and d9 (telephone).
*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_adherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_adherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Adherence counselling**

**3.0.** Has appropriate adherence counselling been given as per the trial SOP?
- db_table: effect_subject_adherence
- column: adherence_counselling
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: adherence_counselling_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Missed doses**

**5.0.** Have any Fluconazole doses been missed since the last visit?
- db_table: effect_subject_adherence
- column: flucon_doses_missed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `unknown`: *Unknown*
---

**6.0.** If YES, number of Fluconazole doses missed since last visit:

&nbsp;&nbsp;&nbsp;&nbsp; *This should be measured in single doses (1 dose per day)*
- db_table: effect_subject_adherence
- column: flucon_doses_missed_number
- type: IntegerField
---

**7.0.** Have any Flucytosine doses been missed since the last visit?
- db_table: effect_subject_adherence
- column: flucyt_doses_missed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `unknown`: *Unknown*
---

**8.0.** If YES, number of Flucytosine doses missed since last visit:

&nbsp;&nbsp;&nbsp;&nbsp; *This should be measured in single doses (4 doses per day)*
- db_table: effect_subject_adherence
- column: flucyt_doses_missed_number
- type: IntegerField
---

**Section: Adherence narrative**

**9.0.** Medication adherence narrative:
- db_table: effect_subject_adherence
- column: adherence_narrative
- type: TextField
---


#### Requisitions

### 1014

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Modifications**

**3.0.** Have there been any modifications to study medication since the last report?
- db_table: effect_subject_studymedication
- column: modifications
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** Reason for dose change

&nbsp;&nbsp;&nbsp;&nbsp; *Select all that apply.*
- db_table: effect_subject_studymedication
- column: modifications_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `per_protocol`: *Per protocol*
  - `renal_adjustment`: *Renal adjustment*
  - `toxicity`: *Toxicity*
  - `OTHER`: *Other, please specify below ...*
---

**4.1.** If other reason, please provide details ...
- db_table: effect_subject_studymedication
- column: modifications_reason_other
- type: TextField
- length: 250
---

**Section: Fluconazole**

**5.0.** Have there been any modifications to fluconazole dose since the last report?
- db_table: effect_subject_studymedication
- column: flucon_modified
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.0.** Date and time first fluconazole dose administered
- db_table: effect_subject_studymedication
- column: flucon_dose_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**7.0.** Fluconazole dose

&nbsp;&nbsp;&nbsp;&nbsp; *in mg/d*
- db_table: effect_subject_studymedication
- column: flucon_dose
- type: IntegerField
---

**8.0.** First fluconazole dose administered
- db_table: effect_subject_studymedication
- column: flucon_next_dose
- type: CharField
- length: 15
- responses:
  - `today`: *Today*
  - `tomorrow`: *Tomorrow*
  - `N/A`: *Not applicable*
---

**9.0.** Fluconazole notes (if any)
- db_table: effect_subject_studymedication
- column: flucon_notes
- type: TextField
- length: 250
---

**Section: Flucytosine**

**10.0.** Have there been any modifications to flucytosine dose since the last report?
- db_table: effect_subject_studymedication
- column: flucyt_modified
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Date and time first flucytosine dose administered
- db_table: effect_subject_studymedication
- column: flucyt_dose_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**12.0.** Flucytosine dose prescribed

&nbsp;&nbsp;&nbsp;&nbsp; *in mg/d*
- db_table: effect_subject_studymedication
- column: flucyt_dose
- type: IntegerField
---

**13.0.** Dose at 04:00

&nbsp;&nbsp;&nbsp;&nbsp; *in mg*
- db_table: effect_subject_studymedication
- column: flucyt_dose_0400
- type: IntegerField
---

**14.0.** Dose at 10:00

&nbsp;&nbsp;&nbsp;&nbsp; *in mg*
- db_table: effect_subject_studymedication
- column: flucyt_dose_1000
- type: IntegerField
---

**15.0.** Dose at 16:00

&nbsp;&nbsp;&nbsp;&nbsp; *in mg*
- db_table: effect_subject_studymedication
- column: flucyt_dose_1600
- type: IntegerField
---

**16.0.** Dose at 22:00

&nbsp;&nbsp;&nbsp;&nbsp; *in mg*
- db_table: effect_subject_studymedication
- column: flucyt_dose_2200
- type: IntegerField
---

**17.0.** First flucytosine dose administered
- db_table: effect_subject_studymedication
- column: flucyt_next_dose
- type: CharField
- length: 5
- responses:
  - `0400`: *at 04:00*
  - `1000`: *at 10:00*
  - `1600`: *at 16:00*
  - `2200`: *at 22:00*
  - `N/A`: *Not applicable*
---

**18.0.** Flucytosine notes (if any)
- db_table: effect_subject_studymedication
- column: flucyt_notes
- type: TextField
- length: 250
---


#### Vital Signs
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_vitalsigns
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_vitalsigns
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vital signs**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: effect_subject_vitalsigns
- column: weight
- type: DecimalField
---

**4.0.** Is the weight estimated or measured?
- db_table: effect_subject_vitalsigns
- column: weight_measured_or_est
- type: CharField
- length: 25
- responses:
  - `measured`: *Measured (weighed)*
  - `estimated`: *Estimated*
---

**5.0.** Blood pressure: systolic

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: effect_subject_vitalsigns
- column: sys_blood_pressure
- type: IntegerField
---

**6.0.** Blood pressure: diastolic

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: effect_subject_vitalsigns
- column: dia_blood_pressure
- type: IntegerField
---

**7.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: effect_subject_vitalsigns
- column: heart_rate
- type: IntegerField
---

**8.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: effect_subject_vitalsigns
- column: respiratory_rate
- type: IntegerField
---

**9.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celsius*
- db_table: effect_subject_vitalsigns
- column: temperature
- type: DecimalField
---

**10.0.** Abnormal lung exam:
- db_table: effect_subject_vitalsigns
- column: abnormal_lung_exam
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Action**

**11.0.** action identifier
- db_table: effect_subject_vitalsigns
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**12.0.** action item
- db_table: effect_subject_vitalsigns
- column: action_item
- type: ForeignKey
---

**13.0.** parent action item
- db_table: effect_subject_vitalsigns
- column: parent_action_item
- type: ForeignKey
---

**14.0.** related action item
- db_table: effect_subject_vitalsigns
- column: related_action_item
- type: ForeignKey
---

**Section: Reporting**

**15.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_vitalsigns
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**16.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_vitalsigns
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Mental Status
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_mentalstatus
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_mentalstatus
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Mental status**

**3.0.** Recent seizure (<72 hours)?
- db_table: effect_subject_mentalstatus
- column: recent_seizure
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** Behaviour change?
- db_table: effect_subject_mentalstatus
- column: behaviour_change
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**5.0.** Confusion?
- db_table: effect_subject_mentalstatus
- column: confusion
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Does the participant require help from anybody for everyday activities?

&nbsp;&nbsp;&nbsp;&nbsp; *Answer only at scheduled Week 10 and Month 6 visits*
- db_table: effect_subject_mentalstatus
- column: require_help
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.1.** Has the illness left the participant with any other problems?

&nbsp;&nbsp;&nbsp;&nbsp; *Answer only at scheduled Week 10 and Month 6 visits*
- db_table: effect_subject_mentalstatus
- column: any_other_problems
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**7.0.** Modified Rankin Score
- db_table: effect_subject_mentalstatus
- column: modified_rankin_score
- type: CharField
- length: 15
- responses:
  - `0`: *[0] No symptoms*
  - `1`: *[1] No significant disability. Able to carry out usual activities, despite some symptoms.*
  - `2`: *[2] Slight disability. Able to look after own affairs without assistance, but unable to carry out all previous activities.*
  - `3`: *[3] Moderate disability. Requires some help, but able to walk unassisted.*
  - `4`: *[4] Moderately severe disability. Unable to attend to own bodily needs without assistance, and unable to walk unassisted.*
  - `5`: *[5] Severe disability. Requires constant nursing care and attention, bedridden, incontinent.*
  - `6`: *[6] Dead*
---

**8.0.** ECOG score
- db_table: effect_subject_mentalstatus
- column: ecog_score
- type: CharField
- length: 15
- responses:
  - `0`: *[0] Fully active, able to carry on all pre-disease performance without restriction*
  - `1`: *[1] Restricted in physically strenuous activity but ambulatory and able to carry out work of a light or sedentary nature, e.g., light house work, office work*
  - `2`: *[2] Ambulatory and capable of all self-care but unable to carry out any work activities; up and about more than 50% of waking hours *
  - `3`: *[3] Capable of only limited self-care; confined to bed or chair more than 50% of waking hours*
  - `4`: *[4] Completely disabled; cannot carry on any self-care; totally confined to bed or chair*
  - `5`: *[5] Deceased*
---

**9.0.** Glasgow Coma Score

&nbsp;&nbsp;&nbsp;&nbsp; */15*
- db_table: effect_subject_mentalstatus
- column: glasgow_coma_score
- type: IntegerField
---

**Section: Reporting**

**10.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_mentalstatus
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_mentalstatus
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Signs And Symptoms
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_signsandsymptoms
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_signsandsymptoms
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Signs and symptoms**

**3.0.** Are there any signs or symptoms to report, since last contact with trial team?
- db_table: effect_subject_signsandsymptoms
- column: any_sx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `unknown`: *Unknown*
---

**4.0.** Is participant currently experiencing any of the following signs/symptoms?
- db_table: effect_subject_signsandsymptoms
- column: current_sx
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `cough`: *Cough*
  - `diarrhoea`: *Diarrhoea*
  - `double_vision`: *Double vision*
  - `drowsiness`: *Drowsiness*
  - `fever`: *Fever*
  - `focal_weakness`: *Focal weakness*
  - `headache`: *Headache*
  - `hearing_loss`: *Hearing loss*
  - `jaundice`: *Jaundice*
  - `nausea`: *Nausea*
  - `night_sweats`: *Night sweats*
  - `CN_VI_palsy_left`: *Neuro - Cranial Nerve VI palsy (left)*
  - `CN_VI_palsy_right`: *Neuro - Cranial Nerve VI palsy (right)*
  - `CN_VII_palsy_left`: *Neuro - Cranial Nerve VII palsy (left)*
  - `CN_VII_palsy_right`: *Neuro - Cranial Nerve VII palsy (right)*
  - `cn_palsy_left_other`: *Neuro - Other cranial nerve palsy (left), please specify below ...*
  - `cn_palsy_right_other`: *Neuro - Other cranial nerve palsy (right), please specify below ...*
  - `focal_seizures_left`: *Neuro - Focal seizures (left)*
  - `focal_seizures_right`: *Neuro - Focal seizures (right)*
  - `hemiplegia_left`: *Neuro - Hemiplegia (left)*
  - `hemiplegia_right`: *Neuro - Hemiplegia (right)*
  - `meningism`: *Neuro - Meningism*
  - `papilloedema`: *Neuro - Papilloedema*
  - `visual_field_disturbance`: *Neuro - Visual field disturbance*
  - `focal_neurologic_deficit_other`: *Neuro - Other focal neurologic deficit, please specify below ...*
  - `shortness_of_breath`: *Shortness of breath*
  - `skin_lesions`: *Skin lesions*
  - `visual_loss`: *Visual loss*
  - `vomiting`: *Vomiting*
  - `weight_loss`: *Weight loss*
  - `OTHER`: *Other sign(s)/symptom(s), please specify below ...*
---

**4.1.** If other, please specify ...

&nbsp;&nbsp;&nbsp;&nbsp; *If more than one, separate each with a comma (,).*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_other
- type: TextField
---

**5.0.** Are any of the signs or symptoms related to cryptococcal meningitis (CM)?
- db_table: effect_subject_signsandsymptoms
- column: cm_sx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.0.** For these signs/symptoms, were any Grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.</br>*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_gte_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `cough`: *Cough*
  - `diarrhoea`: *Diarrhoea*
  - `double_vision`: *Double vision*
  - `drowsiness`: *Drowsiness*
  - `fever`: *Fever*
  - `focal_weakness`: *Focal weakness*
  - `headache`: *Headache*
  - `hearing_loss`: *Hearing loss*
  - `jaundice`: *Jaundice*
  - `nausea`: *Nausea*
  - `night_sweats`: *Night sweats*
  - `CN_VI_palsy_left`: *Neuro - Cranial Nerve VI palsy (left)*
  - `CN_VI_palsy_right`: *Neuro - Cranial Nerve VI palsy (right)*
  - `CN_VII_palsy_left`: *Neuro - Cranial Nerve VII palsy (left)*
  - `CN_VII_palsy_right`: *Neuro - Cranial Nerve VII palsy (right)*
  - `cn_palsy_left_other`: *Neuro - Other cranial nerve palsy (left), please specify below ...*
  - `cn_palsy_right_other`: *Neuro - Other cranial nerve palsy (right), please specify below ...*
  - `focal_seizures_left`: *Neuro - Focal seizures (left)*
  - `focal_seizures_right`: *Neuro - Focal seizures (right)*
  - `hemiplegia_left`: *Neuro - Hemiplegia (left)*
  - `hemiplegia_right`: *Neuro - Hemiplegia (right)*
  - `meningism`: *Neuro - Meningism*
  - `papilloedema`: *Neuro - Papilloedema*
  - `visual_field_disturbance`: *Neuro - Visual field disturbance*
  - `focal_neurologic_deficit_other`: *Neuro - Other focal neurologic deficit, please specify below ...*
  - `shortness_of_breath`: *Shortness of breath*
  - `skin_lesions`: *Skin lesions*
  - `visual_loss`: *Visual loss*
  - `vomiting`: *Vomiting*
  - `weight_loss`: *Weight loss*
  - `OTHER`: *Other sign(s)/symptom(s), please specify below ...*
---

**6.1.** If other, please specify ...

&nbsp;&nbsp;&nbsp;&nbsp; *If more than one, separate each with a comma (,).*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_gte_g3_other
- type: TextField
---

**Section: Additional details**

**7.0.** If participant currently has headache, for what duration have they had it for

&nbsp;&nbsp;&nbsp;&nbsp; *In days and/or hours.  Note: 1 day equivalent to 24 hours.</br> Format is `DDdHHh`, `DDd` or `HHh`. For example 1d23h, 15d9h ... or 20d, or 5h ...*
- db_table: effect_subject_signsandsymptoms
- column: headache_duration
- type: CharField
- length: 7
- responses: *free text*
---

**7.1.** If other cranial nerve palsy (left), please specify ...
- db_table: effect_subject_signsandsymptoms
- column: cn_palsy_left_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.2.** If other cranial nerve palsy (right), please specify ...
- db_table: effect_subject_signsandsymptoms
- column: cn_palsy_right_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.3.** If other focal neurologic deficit, please specify ...
- db_table: effect_subject_signsandsymptoms
- column: focal_neurologic_deficit_other
- type: CharField
- length: 35
- responses: *free text*
---

**8.0.** If visual field loss, please provide details ...
- db_table: effect_subject_signsandsymptoms
- column: visual_field_loss
- type: TextField
---

**Section: Investigations**

**9.0.** Was an X-ray performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'Chest X-ray' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: xray_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**10.0.** Was a lumbar puncture performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'Lumbar Puncture/CSF' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: lp_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Was a urinary LAM performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'TB Diagnostics' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: urinary_lam_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Reporting**

**12.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_signsandsymptoms
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_signsandsymptoms
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Calculated values**

**14.0.** calculated headache duration
- db_table: effect_subject_signsandsymptoms
- column: calculated_headache_duration
- type: DurationField
---

**Section: Action**

**15.0.** action identifier
- db_table: effect_subject_signsandsymptoms
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**16.0.** action item
- db_table: effect_subject_signsandsymptoms
- column: action_item
- type: ForeignKey
---

**17.0.** parent action item
- db_table: effect_subject_signsandsymptoms
- column: parent_action_item
- type: ForeignKey
---

**18.0.** related action item
- db_table: effect_subject_signsandsymptoms
- column: related_action_item
- type: ForeignKey
---


#### Significant Diagnoses
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_diagnoses
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_diagnoses
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Gastrointestinal side effects**

**3.0.** Has the participant experienced any gastrointestinal side effects?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete SAE report where appropriate*
- db_table: effect_subject_diagnoses
- column: gi_side_effects
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, please give details
- db_table: effect_subject_diagnoses
- column: gi_side_effects_details
- type: TextField
---

**Section: Diagnoses**

**5.0.** Are there any new significant diagnoses to report since last visit?
- db_table: effect_subject_diagnoses
- column: has_diagnoses
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Please select all diagnoses that are relevant
- db_table: effect_subject_diagnoses
- column: diagnoses
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `bacteraemia`: *Bacteraemia*
  - `bacterial_pneumonia`: *Bacterial pneumonia*
  - `cm`: *Cryptococcal meningitis*
  - `diarrhoeal_wasting`: *Diarrhoeal wasting*
  - `kaposi_sarcoma`: *Kaposi’s sarcoma*
  - `malaria`: *Malaria*
  - `tb_extrapulmonary`: *TB extrapulmonary*
  - `tb_pulmonary`: *TB pulmonary*
  - `OTHER`: *Other, please specify below ...*
---

**6.1.** If other, please specify ...
- db_table: effect_subject_diagnoses
- column: diagnoses_other
- type: TextField
- length: 150
---

**Section: Reporting**

**7.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_diagnoses
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_diagnoses
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Arv Treatment
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_arvtreatment
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_arvtreatment
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: ARV Treatment**

**3.0.** Is the participant currently on an ART regimen?

&nbsp;&nbsp;&nbsp;&nbsp; *If ART regimen is on hold, answer YES and clarify below*
- db_table: effect_subject_arvtreatment
- column: on_arv_regimen
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, on an ART regimen, has the participant adhered to this ART regimen?

&nbsp;&nbsp;&nbsp;&nbsp; *In the opinion of the clinician, is the participant at least 90% adherent*
- db_table: effect_subject_arvtreatment
- column: adherent
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**5.0.** Has ART been held/stopped this clinical episode?
- db_table: effect_subject_arvtreatment
- column: arv_regimen_stopped
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.0.** Date held or stopped?
- db_table: effect_subject_arvtreatment
- column: arv_regimen_stopped_date
- type: DateField
- format: YYYY-MM-DD
---

**7.0.** Has the participant's ART regimen changed since the last study assessment

&nbsp;&nbsp;&nbsp;&nbsp; *Also applies if ART started/re-started since enrolment, including at this visit.*
- db_table: effect_subject_arvtreatment
- column: arv_regimen_changed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.0.** Current ART regimen?

&nbsp;&nbsp;&nbsp;&nbsp; *Required if on an ART regimen*
- db_table: effect_subject_arvtreatment
- column: arv_regimen
- type: ForeignKey
---

**9.0.** Start date of the changed ART regimen?
- db_table: effect_subject_arvtreatment
- column: arv_regimen_start_date
- type: DateField
- format: YYYY-MM-DD
---


#### Participant Treatment
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_participanttreatment
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_participanttreatment
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Cryptococcal meningitis**

**3.0.** LP completed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete laboratory results*
- db_table: effect_subject_participanttreatment
- column: lp_completed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** Cryptococcal meningitis confirmed?
- db_table: effect_subject_participanttreatment
- column: cm_confirmed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**5.0.** Cryptococcal meningitis treatment administered?
- db_table: effect_subject_participanttreatment
- column: on_cm_tx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.0.** If YES, treatment given?
- db_table: effect_subject_participanttreatment
- column: cm_tx_given
- type: CharField
- length: 15
- responses:
  - `1w_amb_5fc`: *1 week AmB + 5FC*
  - `OTHER`: *Other, please specify below ...*
  - `N/A`: *Not applicable*
---

**6.1.** If other, please specify ...
- db_table: effect_subject_participanttreatment
- column: cm_tx_given_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Tuberculosis**

**7.0.** Has the participant been put on TB preventive therapy?

&nbsp;&nbsp;&nbsp;&nbsp; *Select NO if started pre-enrolment or on day 1, and captured on day 1. Select YES if started today.*
- db_table: effect_subject_participanttreatment
- column: on_tb_tx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** If YES, give date
- db_table: effect_subject_participanttreatment
- column: tb_tx_date
- type: DateField
- format: YYYY-MM-DD
---

**9.0.** If YES, is this date estimated?

&nbsp;&nbsp;&nbsp;&nbsp; *If the exact date is not known, please indicate which part of the date is estimated.*
- db_table: effect_subject_participanttreatment
- column: tb_tx_date_estimated
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `not_estimated`: *No*
  - `D`: *Yes, estimated the Day*
  - `MD`: *Yes, estimated Month and Day*
  - `YMD`: *Yes, estimated Year, Month and Day*
---

**10.0.** If YES, which treatment?
- db_table: effect_subject_participanttreatment
- column: tb_tx_given
- type: ManyToManyField
- responses: *Select all that apply*
  - `AM`: *Am - Amikacin*
  - `BDQ`: *BDQ - Bedaquiline*
  - `CFZ`: *CFZ - Clofazimine*
  - `DLM`: *DLM - Delamanid*
  - `E`: *E - Ethambutol*
  - `H`: *H - Isoniazid*
  - `HR`: *HR - Isoniazid + Rifampicin*
  - `HRZE`: *HRZE - Isoniazid + Rifampicin + Pyrazinamide + Ethambutol*
  - `LFX`: *LFX - Levofloxacin*
  - `LZD`: *LZD - Linezolid*
  - `MPM`: *Mpm - Meropenem*
  - `PAS`: *PAS - Para-aminosalicylic acid*
  - `PTO`: *PTO - Prothionamide*
  - `S`: *S - Streptomycin*
  - `TRD`: *TRD - Terizidone*
  - `Z`: *Z - Pyrazinamide*
  - `OTHER`: *Other, please specify below ...*
---

**10.1.** If other, please specify ...
- db_table: effect_subject_participanttreatment
- column: tb_tx_given_other
- type: CharField
- length: 35
- responses: *free text*
---

**11.0.** If NO, give reason
- db_table: effect_subject_participanttreatment
- column: tb_tx_reason_no
- type: CharField
- length: 30
- responses:
  - `deferred_local_clinic`: *Deferred to local clinic*
  - `contraindicated`: *Contraindicated*
  - `OTHER`: *Other, please specify below ...*
  - `N/A`: *Not applicable*
---

**11.1.** If other, please specify ...
- db_table: effect_subject_participanttreatment
- column: tb_tx_reason_no_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Steroids**

**12.0.** Were steroids administered to the participant?
- db_table: effect_subject_participanttreatment
- column: on_steroids
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**13.0.** If YES, give date
- db_table: effect_subject_participanttreatment
- column: steroids_date
- type: DateField
- format: YYYY-MM-DD
---

**14.0.** If YES, is this date estimated?

&nbsp;&nbsp;&nbsp;&nbsp; *If the exact date is not known, please indicate which part of the date is estimated.*
- db_table: effect_subject_participanttreatment
- column: steroids_date_estimated
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `not_estimated`: *No*
  - `D`: *Yes, estimated the Day*
  - `MD`: *Yes, estimated Month and Day*
  - `YMD`: *Yes, estimated Year, Month and Day*
---

**15.0.** If YES, which steroids?
- db_table: effect_subject_participanttreatment
- column: steroids_given
- type: CharField
- length: 35
- responses:
  - `oral_prednisolone`: *Oral prednisolone*
  - `iv_dexamethasone`: *IV Dexamethasone*
  - `OTHER`: *Other, please specify below ...*
  - `N/A`: *Not applicable*
---

**15.1.** If other, please specify ...
- db_table: effect_subject_participanttreatment
- column: steroids_given_other
- type: CharField
- length: 35
- responses: *free text*
---

**16.0.** Length of steroid course?

&nbsp;&nbsp;&nbsp;&nbsp; *in days*
- db_table: effect_subject_participanttreatment
- column: steroids_course
- type: IntegerField
---

**Section: Co-trimixazole**

**17.0.** Has the participant been prescribed co-trimoxazole?

&nbsp;&nbsp;&nbsp;&nbsp; *Select YES if currently on co-trimoxazole, or prescribed today.*
- db_table: effect_subject_participanttreatment
- column: on_co_trimoxazole
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**18.0.** If YES, give date
- db_table: effect_subject_participanttreatment
- column: co_trimoxazole_date
- type: DateField
- format: YYYY-MM-DD
---

**19.0.** If YES, is this date estimated?

&nbsp;&nbsp;&nbsp;&nbsp; *If the exact date is not known, please indicate which part of the date is estimated.*
- db_table: effect_subject_participanttreatment
- column: co_trimoxazole_date_estimated
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `not_estimated`: *No*
  - `D`: *Yes, estimated the Day*
  - `MD`: *Yes, estimated Month and Day*
  - `YMD`: *Yes, estimated Year, Month and Day*
---

**20.0.** If NO, give reason
- db_table: effect_subject_participanttreatment
- column: co_trimoxazole_reason_no
- type: CharField
- length: 30
- responses:
  - `deferred_local_clinic`: *Deferred to local clinic*
  - `contraindicated`: *Contraindicated*
  - `OTHER`: *Other, please specify below ...*
  - `N/A`: *Not applicable*
---

**20.1.** If other, please specify ...
- db_table: effect_subject_participanttreatment
- column: co_trimoxazole_reason_no_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Antibiotics**

**21.0.** Has the participant been prescribed antibiotics?
- db_table: effect_subject_participanttreatment
- column: on_antibiotics
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**22.0.** If YES, give date
- db_table: effect_subject_participanttreatment
- column: antibiotics_date
- type: DateField
- format: YYYY-MM-DD
---

**23.0.** If YES, is this date estimated?

&nbsp;&nbsp;&nbsp;&nbsp; *If the exact date is not known, please indicate which part of the date is estimated.*
- db_table: effect_subject_participanttreatment
- column: antibiotics_date_estimated
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `not_estimated`: *No*
  - `D`: *Yes, estimated the Day*
  - `MD`: *Yes, estimated Month and Day*
  - `YMD`: *Yes, estimated Year, Month and Day*
---

**24.0.** If YES, which antibiotics?
- db_table: effect_subject_participanttreatment
- column: antibiotics_given
- type: ManyToManyField
- responses: *Select all that apply*
  - `amoxicillin`: *Amoxicillin*
  - `ampicillin`: *Ampicillin*
  - `flucloxacillin`: *Flucloxacillin*
  - `doxycycline`: *Doxycycline*
  - `ceftriaxone`: *Ceftriaxone*
  - `ciprofloxacin`: *Ciprofloxacin (NB avoid on concomitant high dose fluconazole)*
  - `coamoxiclav`: *Coamoxiclav (amoxicillin/clavulanate)*
  - `erythromycin`: *Erythromycin (NB contra-indicated on concomitant high dose fluconazole)*
  - `gentamicin`: *Gentamicin*
  - `OTHER`: *Other antibiotic, (NB avoid with concomitant high dose fluconazole), please specify below ...*
---

**24.1.** If other, please specify ...
- db_table: effect_subject_participanttreatment
- column: antibiotics_given_other
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Other drugs**

**24.2.** Has the participant been prescribed any other drugs/interventions?
- db_table: effect_subject_participanttreatment
- column: on_other_drugs
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**25.0.** If YES, give date
- db_table: effect_subject_participanttreatment
- column: other_drugs_date
- type: DateField
- format: YYYY-MM-DD
---

**26.0.** If YES, is this date estimated?

&nbsp;&nbsp;&nbsp;&nbsp; *If the exact date is not known, please indicate which part of the date is estimated.*
- db_table: effect_subject_participanttreatment
- column: other_drugs_date_estimated
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `not_estimated`: *No*
  - `D`: *Yes, estimated the Day*
  - `MD`: *Yes, estimated Month and Day*
  - `YMD`: *Yes, estimated Year, Month and Day*
---

**27.0.** If YES, which drugs/interventions?
- db_table: effect_subject_participanttreatment
- column: other_drugs_given
- type: ManyToManyField
- responses: *Select all that apply*
  - `k`: *K*
  - `mg`: *Mg*
  - `sodium`: *Sodium*
  - `vitamins`: *Vitamins*
  - `anticonvulsants`: *Anticonvulsants*
  - `antimalarials`: *Antimalarials*
  - `OTHER`: *Other drug/intervention, please specify below ...*
---

**27.1.** If other, please specify ...
- db_table: effect_subject_participanttreatment
- column: other_drugs_given_other
- type: CharField
- length: 35
- responses: *free text*
---


#### Blood Result: Fbc
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_bloodresultsfbc
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_bloodresultsfbc
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Requisition and Result Date**

**3.0.** Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_bloodresultsfbc
- column: requisition
- type: ForeignKey
---

**4.0.** Result assay date and time
- db_table: effect_subject_bloodresultsfbc
- column: assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Haemoglobin**

**5.0.** Haemoglobin
- db_table: effect_subject_bloodresultsfbc
- column: haemoglobin_value
- type: DecimalField
---

**6.0.** units
- db_table: effect_subject_bloodresultsfbc
- column: haemoglobin_units
- type: CharField
- length: 15
- responses:
  - `g/dL`: *g/dL*
---

**7.0.** abnormal
- db_table: effect_subject_bloodresultsfbc
- column: haemoglobin_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** reportable
- db_table: effect_subject_bloodresultsfbc
- column: haemoglobin_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: WBC**

**9.0.** WBC
- db_table: effect_subject_bloodresultsfbc
- column: wbc_value
- type: DecimalField
---

**10.0.** units
- db_table: effect_subject_bloodresultsfbc
- column: wbc_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**11.0.** abnormal
- db_table: effect_subject_bloodresultsfbc
- column: wbc_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** reportable
- db_table: effect_subject_bloodresultsfbc
- column: wbc_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Platelets**

**13.0.** Platelets
- db_table: effect_subject_bloodresultsfbc
- column: platelets_value
- type: DecimalField
---

**14.0.** units
- db_table: effect_subject_bloodresultsfbc
- column: platelets_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
  - `cells/mm^3`: *cells/mm<sup>3</sup>*
---

**15.0.** abnormal
- db_table: effect_subject_bloodresultsfbc
- column: platelets_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**16.0.** reportable
- db_table: effect_subject_bloodresultsfbc
- column: platelets_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Neutrophil absolute count**

**17.0.** Neutrophil (abs)
- db_table: effect_subject_bloodresultsfbc
- column: neutrophil_value
- type: DecimalField
---

**18.0.** units
- db_table: effect_subject_bloodresultsfbc
- column: neutrophil_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
---

**19.0.** abnormal
- db_table: effect_subject_bloodresultsfbc
- column: neutrophil_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**20.0.** reportable
- db_table: effect_subject_bloodresultsfbc
- column: neutrophil_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Neutrophils differential count**

**21.0.** Neutrophil (diff)
- db_table: effect_subject_bloodresultsfbc
- column: neutrophil_diff_value
- type: DecimalField
---

**22.0.** units
- db_table: effect_subject_bloodresultsfbc
- column: neutrophil_diff_units
- type: CharField
- length: 15
- responses:
  - `%`: *%*
---

**23.0.** abnormal
- db_table: effect_subject_bloodresultsfbc
- column: neutrophil_diff_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**24.0.** reportable
- db_table: effect_subject_bloodresultsfbc
- column: neutrophil_diff_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Lymphocyte absolute count**

**25.0.** Lymphocyte (abs)
- db_table: effect_subject_bloodresultsfbc
- column: lymphocyte_value
- type: DecimalField
---

**26.0.** units
- db_table: effect_subject_bloodresultsfbc
- column: lymphocyte_units
- type: CharField
- length: 15
- responses:
  - `10^9/L`: *10^9/L*
---

**27.0.** abnormal
- db_table: effect_subject_bloodresultsfbc
- column: lymphocyte_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**28.0.** reportable
- db_table: effect_subject_bloodresultsfbc
- column: lymphocyte_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Lymphocyte differential count**

**29.0.** Lymphocyte (diff)
- db_table: effect_subject_bloodresultsfbc
- column: lymphocyte_diff_value
- type: DecimalField
---

**30.0.** units
- db_table: effect_subject_bloodresultsfbc
- column: lymphocyte_diff_units
- type: CharField
- length: 15
- responses:
  - `%`: *%*
---

**31.0.** abnormal
- db_table: effect_subject_bloodresultsfbc
- column: lymphocyte_diff_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**32.0.** reportable
- db_table: effect_subject_bloodresultsfbc
- column: lymphocyte_diff_reportable
- type: CharField
- length: 25
- responses:
  - `N/A`: *Not applicable*
  - `3`: *Yes, grade 3*
  - `4`: *Yes, grade 4*
  - `No`: *Not reportable*
  - `Already reported`: *Already reported*
  - `present_at_baseline`: *Present at baseline*
---

**Section: Conclusion**

**33.0.** Are any of the above results abnormal?

&nbsp;&nbsp;&nbsp;&nbsp; *Abnormal results present at baseline or continuing from baseline not included.*
- db_table: effect_subject_bloodresultsfbc
- column: results_abnormal
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**34.0.** If any results are abnormal, are results within grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, this value will open Adverse Event Form. Grade 3 and 4 results present at baseline or continuing from baseline not included*
- db_table: effect_subject_bloodresultsfbc
- column: results_reportable
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Summary**

**35.0.** summary
- db_table: effect_subject_bloodresultsfbc
- column: summary
- type: TextField
---


#### Chest X-Ray
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_chestxray
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_chestxray
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Chest x-ray**

**3.0.** Was a chest x-ray performed?
- db_table: effect_subject_chestxray
- column: chest_xray
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, date performed?
- db_table: effect_subject_chestxray
- column: chest_xray_date
- type: DateField
- format: YYYY-MM-DD
---

**5.0.** If YES, indicate results?
- db_table: effect_subject_chestxray
- column: chest_xray_results
- type: ManyToManyField
- responses: *Select all that apply*
  - `NORMAL`: *Normal*
  - `lymphadenopathy`: *Lymphadenopathy*
  - `consolidation`: *Consolidation*
  - `miliary_tb`: *Miliary TB*
  - `infiltrates`: *Infiltrates*
  - `OTHER`: *Other, please specify below ...*
---

**5.1.** If other, please specify ...
- db_table: effect_subject_chestxray
- column: chest_xray_results_other
- type: TextField
---

**6.0.** Any additional comment
- db_table: effect_subject_chestxray
- column: comment
- type: TextField
---


#### Lumbar Puncture/Csf
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_lpcsf
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_lpcsf
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: LP**

**3.0.** Reason for LP
- db_table: effect_subject_lpcsf
- column: reason_for_lp
- type: CharField
- length: 50
- responses:
  - `scheduled_per_protocol`: *Scheduled per protocol*
  - `clincal_deterioration`: *Suspected Cryptococcal meningitis / Suspected IRIS*
---

**4.0.** LP Date and Time
- db_table: effect_subject_lpcsf
- column: lp_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**5.0.** Was the opening pressure measured
- db_table: effect_subject_lpcsf
- column: opening_pressure_measured
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** opening pressure

&nbsp;&nbsp;&nbsp;&nbsp; *Units cm of H<sub>2</sub>O*
- db_table: effect_subject_lpcsf
- column: opening_pressure
- type: IntegerField
---

**7.0.** closing pressure

&nbsp;&nbsp;&nbsp;&nbsp; *Units cm of H<sub>2</sub>O*
- db_table: effect_subject_lpcsf
- column: closing_pressure
- type: IntegerField
---

**8.0.** CSF amount removed

&nbsp;&nbsp;&nbsp;&nbsp; *Units ml*
- db_table: effect_subject_lpcsf
- column: csf_amount_removed
- type: IntegerField
---

**Section: CSF**

**9.0.** CSF positive for cryptococcal meningitis?
- db_table: effect_subject_lpcsf
- column: csf_positive
- type: CharField
- length: 18
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `awaiting_results`: *Awaiting results*
---

**10.0.** india ink
- db_table: effect_subject_lpcsf
- column: india_ink
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**11.0.** CrAg LFA
- db_table: effect_subject_lpcsf
- column: csf_crag_lfa
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**12.0.** SQ CrAg
- db_table: effect_subject_lpcsf
- column: sq_crag
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**13.0.** SQ CrAg
- db_table: effect_subject_lpcsf
- column: sq_crag_pos
- type: CharField
- length: 15
- responses:
  - `high`: *High*
  - `low`: *Low*
  - `N/A`: *Not applicable*
---

**14.0.** Was the CRF CrAg titre done
- db_table: effect_subject_lpcsf
- column: crf_crag_titre_done
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** crf crag titre
- db_table: effect_subject_lpcsf
- column: crf_crag_titre
- type: IntegerField
---

**Section: CSF culture**

**16.0.** CSF Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_lpcsf
- column: csf_requisition
- type: ForeignKey
---

**17.0.** CSF Result Report Date and Time
- db_table: effect_subject_lpcsf
- column: csf_culture_assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**18.0.** CSF Result: Other organism (non-Cryptococcus)

&nbsp;&nbsp;&nbsp;&nbsp; *Complete after getting the results.*
- db_table: effect_subject_lpcsf
- column: csf_culture
- type: CharField
- length: 18
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `awaiting_results`: *Awaiting results*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**19.0.** If YES, specify organism:
- db_table: effect_subject_lpcsf
- column: other_csf_culture
- type: CharField
- length: 75
- responses: *free text*
---

**20.0.** Total CSF WBC cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup>*
- db_table: effect_subject_lpcsf
- column: csf_wbc_cell_count
- type: IntegerField
---

**21.0.** Differential lymphocyte cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup> or %*
- db_table: effect_subject_lpcsf
- column: differential_lymphocyte_count
- type: IntegerField
---

**22.0.** differential lymphocyte unit
- db_table: effect_subject_lpcsf
- column: differential_lymphocyte_unit
- type: CharField
- length: 6
- responses:
  - `mm3`: *mm<sup>3</sup>*
  - `%`: *%*
---

**23.0.** Differential neutrophil cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup> or %*
- db_table: effect_subject_lpcsf
- column: differential_neutrophil_count
- type: IntegerField
---

**24.0.** differential neutrophil unit
- db_table: effect_subject_lpcsf
- column: differential_neutrophil_unit
- type: CharField
- length: 6
- responses:
  - `mm3`: *mm<sup>3</sup>*
  - `%`: *%*
---

**25.0.** CSF glucose:

&nbsp;&nbsp;&nbsp;&nbsp; *Units in mmol/L or mg/dL*
- db_table: effect_subject_lpcsf
- column: csf_glucose
- type: DecimalField
---

**26.0.** CSF glucose units:
- db_table: effect_subject_lpcsf
- column: csf_glucose_units
- type: CharField
- length: 6
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**27.0.** CSF protein:

&nbsp;&nbsp;&nbsp;&nbsp; *Units in g/L*
- db_table: effect_subject_lpcsf
- column: csf_protein
- type: DecimalField
---

**28.0.** CSF CrAg:
- db_table: effect_subject_lpcsf
- column: csf_crag
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `IND`: *Indeterminate*
---


#### Tb Diagnostics
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_tbdiagnostics
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_tbdiagnostics
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Urinary LAM**

**3.0.** Urinary LAM performed?
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** urinary lam date
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_date
- type: DateField
- format: YYYY-MM-DD
---

**5.0.** Urinary LAM result
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_result
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---

**6.0.** If Urinary LAM is positive, grade
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_result_grade
- type: CharField
- length: 25
- responses:
  - `1`: *1+ (low)*
  - `2`: *2+*
  - `3`: *3+*
  - `4`: *4+*
  - `5`: *5+ (high)*
  - `unknown`: *Unknown / Grade not reported*
  - `N/A`: *Not applicable*
---

**Section: Sputum requisition**

**7.0.** Sputum requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_tbdiagnostics
- column: sputum_requisition
- type: ForeignKey
---

**Section: Sputum Gene-Xpert**

**8.0.** Sputum Gene-Xpert performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**9.0.** Sputum Gene-Xpert date
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_date
- type: DateField
- format: YYYY-MM-DD
---

**10.0.** Sputum Gene-Xpert results
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_result
- type: CharField
- length: 45
- responses:
  - `POS`: *MTB Positive*
  - `NEG`: *MTB Negative*
  - `IND`: *Indeterminate*
  - `N/A`: *Not applicable*
---

**Section: Sputum culture**

**11.0.** Sputum culture performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**12.0.** sputum culture date
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_date
- type: DateField
- format: YYYY-MM-DD
---

**13.0.** Sputum culture results
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_result
- type: CharField
- length: 10
- responses:
  - `POS`: *MTB Positive*
  - `NEG`: *MTB Negative*
  - `IND`: *Indeterminate / contaminated*
  - `N/A`: *Not applicable*
---

**Section: Sputum AFB**

**14.0.** Sputum AFB microscopy performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** Sputum AFB date
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_date
- type: DateField
- format: YYYY-MM-DD
---

**16.0.** Sputum AFB results
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_result
- type: CharField
- length: 10
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---

**Section: Comment**

**17.0.** Any additional comment
- db_table: effect_subject_tbdiagnostics
- column: comment
- type: TextField
---


#### Clinical Note
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_clinicalnote
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_clinicalnote
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Clinical note**

**3.0.** Are there any comments on the clinical care or assessment plan
- db_table: effect_subject_clinicalnote
- column: has_comment
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** Comments
- db_table: effect_subject_clinicalnote
- column: comments
- type: TextField
---


#### Adherence: Day 14
Adherence CRF completed at d14 (in-person).
*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_adherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_adherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Adherence counselling**

**3.0.** Has appropriate adherence counselling been given as per the trial SOP?
- db_table: effect_subject_adherence
- column: adherence_counselling
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: adherence_counselling_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Missed doses**

**5.0.** Have any Fluconazole doses been missed since the last visit?
- db_table: effect_subject_adherence
- column: flucon_doses_missed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `unknown`: *Unknown*
---

**6.0.** If YES, number of Fluconazole doses missed since last visit:

&nbsp;&nbsp;&nbsp;&nbsp; *This should be measured in single doses (1 dose per day)*
- db_table: effect_subject_adherence
- column: flucon_doses_missed_number
- type: IntegerField
---

**7.0.** Have any Flucytosine doses been missed since the last visit?
- db_table: effect_subject_adherence
- column: flucyt_doses_missed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `unknown`: *Unknown*
---

**8.0.** If YES, number of Flucytosine doses missed since last visit:

&nbsp;&nbsp;&nbsp;&nbsp; *This should be measured in single doses (4 doses per day)*
- db_table: effect_subject_adherence
- column: flucyt_doses_missed_number
- type: IntegerField
---

**Section: Medication reconciliation and adherence diary review**

**9.0.** Was a medication reconciliation conducted?
- db_table: effect_subject_adherence
- column: medication_reconciliation
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: medication_reconciliation_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**11.0.** Was participant adherence diary received and stored in participant records?
- db_table: effect_subject_adherence
- column: diary_returned
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: diary_returned_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**13.0.** Did the participant adherence diary match the medication reconciliation?
- db_table: effect_subject_adherence
- column: diary_match_medication
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**14.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: diary_match_medication_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Adherence narrative**

**15.0.** Medication adherence narrative:
- db_table: effect_subject_adherence
- column: adherence_narrative
- type: TextField
---


#### Requisitions

* fbc

### 1028

#### Vital Signs
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_vitalsigns
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_vitalsigns
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vital signs**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: effect_subject_vitalsigns
- column: weight
- type: DecimalField
---

**4.0.** Is the weight estimated or measured?
- db_table: effect_subject_vitalsigns
- column: weight_measured_or_est
- type: CharField
- length: 25
- responses:
  - `measured`: *Measured (weighed)*
  - `estimated`: *Estimated*
---

**5.0.** Blood pressure: systolic

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: effect_subject_vitalsigns
- column: sys_blood_pressure
- type: IntegerField
---

**6.0.** Blood pressure: diastolic

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: effect_subject_vitalsigns
- column: dia_blood_pressure
- type: IntegerField
---

**7.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: effect_subject_vitalsigns
- column: heart_rate
- type: IntegerField
---

**8.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: effect_subject_vitalsigns
- column: respiratory_rate
- type: IntegerField
---

**9.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celsius*
- db_table: effect_subject_vitalsigns
- column: temperature
- type: DecimalField
---

**10.0.** Abnormal lung exam:
- db_table: effect_subject_vitalsigns
- column: abnormal_lung_exam
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Action**

**11.0.** action identifier
- db_table: effect_subject_vitalsigns
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**12.0.** action item
- db_table: effect_subject_vitalsigns
- column: action_item
- type: ForeignKey
---

**13.0.** parent action item
- db_table: effect_subject_vitalsigns
- column: parent_action_item
- type: ForeignKey
---

**14.0.** related action item
- db_table: effect_subject_vitalsigns
- column: related_action_item
- type: ForeignKey
---

**Section: Reporting**

**15.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_vitalsigns
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**16.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_vitalsigns
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Mental Status
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_mentalstatus
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_mentalstatus
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Mental status**

**3.0.** Recent seizure (<72 hours)?
- db_table: effect_subject_mentalstatus
- column: recent_seizure
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** Behaviour change?
- db_table: effect_subject_mentalstatus
- column: behaviour_change
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**5.0.** Confusion?
- db_table: effect_subject_mentalstatus
- column: confusion
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Does the participant require help from anybody for everyday activities?

&nbsp;&nbsp;&nbsp;&nbsp; *Answer only at scheduled Week 10 and Month 6 visits*
- db_table: effect_subject_mentalstatus
- column: require_help
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.1.** Has the illness left the participant with any other problems?

&nbsp;&nbsp;&nbsp;&nbsp; *Answer only at scheduled Week 10 and Month 6 visits*
- db_table: effect_subject_mentalstatus
- column: any_other_problems
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**7.0.** Modified Rankin Score
- db_table: effect_subject_mentalstatus
- column: modified_rankin_score
- type: CharField
- length: 15
- responses:
  - `0`: *[0] No symptoms*
  - `1`: *[1] No significant disability. Able to carry out usual activities, despite some symptoms.*
  - `2`: *[2] Slight disability. Able to look after own affairs without assistance, but unable to carry out all previous activities.*
  - `3`: *[3] Moderate disability. Requires some help, but able to walk unassisted.*
  - `4`: *[4] Moderately severe disability. Unable to attend to own bodily needs without assistance, and unable to walk unassisted.*
  - `5`: *[5] Severe disability. Requires constant nursing care and attention, bedridden, incontinent.*
  - `6`: *[6] Dead*
---

**8.0.** ECOG score
- db_table: effect_subject_mentalstatus
- column: ecog_score
- type: CharField
- length: 15
- responses:
  - `0`: *[0] Fully active, able to carry on all pre-disease performance without restriction*
  - `1`: *[1] Restricted in physically strenuous activity but ambulatory and able to carry out work of a light or sedentary nature, e.g., light house work, office work*
  - `2`: *[2] Ambulatory and capable of all self-care but unable to carry out any work activities; up and about more than 50% of waking hours *
  - `3`: *[3] Capable of only limited self-care; confined to bed or chair more than 50% of waking hours*
  - `4`: *[4] Completely disabled; cannot carry on any self-care; totally confined to bed or chair*
  - `5`: *[5] Deceased*
---

**9.0.** Glasgow Coma Score

&nbsp;&nbsp;&nbsp;&nbsp; */15*
- db_table: effect_subject_mentalstatus
- column: glasgow_coma_score
- type: IntegerField
---

**Section: Reporting**

**10.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_mentalstatus
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_mentalstatus
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Signs And Symptoms
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_signsandsymptoms
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_signsandsymptoms
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Signs and symptoms**

**3.0.** Are there any signs or symptoms to report, since last contact with trial team?
- db_table: effect_subject_signsandsymptoms
- column: any_sx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `unknown`: *Unknown*
---

**4.0.** Is participant currently experiencing any of the following signs/symptoms?
- db_table: effect_subject_signsandsymptoms
- column: current_sx
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `cough`: *Cough*
  - `diarrhoea`: *Diarrhoea*
  - `double_vision`: *Double vision*
  - `drowsiness`: *Drowsiness*
  - `fever`: *Fever*
  - `focal_weakness`: *Focal weakness*
  - `headache`: *Headache*
  - `hearing_loss`: *Hearing loss*
  - `jaundice`: *Jaundice*
  - `nausea`: *Nausea*
  - `night_sweats`: *Night sweats*
  - `CN_VI_palsy_left`: *Neuro - Cranial Nerve VI palsy (left)*
  - `CN_VI_palsy_right`: *Neuro - Cranial Nerve VI palsy (right)*
  - `CN_VII_palsy_left`: *Neuro - Cranial Nerve VII palsy (left)*
  - `CN_VII_palsy_right`: *Neuro - Cranial Nerve VII palsy (right)*
  - `cn_palsy_left_other`: *Neuro - Other cranial nerve palsy (left), please specify below ...*
  - `cn_palsy_right_other`: *Neuro - Other cranial nerve palsy (right), please specify below ...*
  - `focal_seizures_left`: *Neuro - Focal seizures (left)*
  - `focal_seizures_right`: *Neuro - Focal seizures (right)*
  - `hemiplegia_left`: *Neuro - Hemiplegia (left)*
  - `hemiplegia_right`: *Neuro - Hemiplegia (right)*
  - `meningism`: *Neuro - Meningism*
  - `papilloedema`: *Neuro - Papilloedema*
  - `visual_field_disturbance`: *Neuro - Visual field disturbance*
  - `focal_neurologic_deficit_other`: *Neuro - Other focal neurologic deficit, please specify below ...*
  - `shortness_of_breath`: *Shortness of breath*
  - `skin_lesions`: *Skin lesions*
  - `visual_loss`: *Visual loss*
  - `vomiting`: *Vomiting*
  - `weight_loss`: *Weight loss*
  - `OTHER`: *Other sign(s)/symptom(s), please specify below ...*
---

**4.1.** If other, please specify ...

&nbsp;&nbsp;&nbsp;&nbsp; *If more than one, separate each with a comma (,).*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_other
- type: TextField
---

**5.0.** Are any of the signs or symptoms related to cryptococcal meningitis (CM)?
- db_table: effect_subject_signsandsymptoms
- column: cm_sx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.0.** For these signs/symptoms, were any Grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.</br>*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_gte_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `cough`: *Cough*
  - `diarrhoea`: *Diarrhoea*
  - `double_vision`: *Double vision*
  - `drowsiness`: *Drowsiness*
  - `fever`: *Fever*
  - `focal_weakness`: *Focal weakness*
  - `headache`: *Headache*
  - `hearing_loss`: *Hearing loss*
  - `jaundice`: *Jaundice*
  - `nausea`: *Nausea*
  - `night_sweats`: *Night sweats*
  - `CN_VI_palsy_left`: *Neuro - Cranial Nerve VI palsy (left)*
  - `CN_VI_palsy_right`: *Neuro - Cranial Nerve VI palsy (right)*
  - `CN_VII_palsy_left`: *Neuro - Cranial Nerve VII palsy (left)*
  - `CN_VII_palsy_right`: *Neuro - Cranial Nerve VII palsy (right)*
  - `cn_palsy_left_other`: *Neuro - Other cranial nerve palsy (left), please specify below ...*
  - `cn_palsy_right_other`: *Neuro - Other cranial nerve palsy (right), please specify below ...*
  - `focal_seizures_left`: *Neuro - Focal seizures (left)*
  - `focal_seizures_right`: *Neuro - Focal seizures (right)*
  - `hemiplegia_left`: *Neuro - Hemiplegia (left)*
  - `hemiplegia_right`: *Neuro - Hemiplegia (right)*
  - `meningism`: *Neuro - Meningism*
  - `papilloedema`: *Neuro - Papilloedema*
  - `visual_field_disturbance`: *Neuro - Visual field disturbance*
  - `focal_neurologic_deficit_other`: *Neuro - Other focal neurologic deficit, please specify below ...*
  - `shortness_of_breath`: *Shortness of breath*
  - `skin_lesions`: *Skin lesions*
  - `visual_loss`: *Visual loss*
  - `vomiting`: *Vomiting*
  - `weight_loss`: *Weight loss*
  - `OTHER`: *Other sign(s)/symptom(s), please specify below ...*
---

**6.1.** If other, please specify ...

&nbsp;&nbsp;&nbsp;&nbsp; *If more than one, separate each with a comma (,).*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_gte_g3_other
- type: TextField
---

**Section: Additional details**

**7.0.** If participant currently has headache, for what duration have they had it for

&nbsp;&nbsp;&nbsp;&nbsp; *In days and/or hours.  Note: 1 day equivalent to 24 hours.</br> Format is `DDdHHh`, `DDd` or `HHh`. For example 1d23h, 15d9h ... or 20d, or 5h ...*
- db_table: effect_subject_signsandsymptoms
- column: headache_duration
- type: CharField
- length: 7
- responses: *free text*
---

**7.1.** If other cranial nerve palsy (left), please specify ...
- db_table: effect_subject_signsandsymptoms
- column: cn_palsy_left_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.2.** If other cranial nerve palsy (right), please specify ...
- db_table: effect_subject_signsandsymptoms
- column: cn_palsy_right_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.3.** If other focal neurologic deficit, please specify ...
- db_table: effect_subject_signsandsymptoms
- column: focal_neurologic_deficit_other
- type: CharField
- length: 35
- responses: *free text*
---

**8.0.** If visual field loss, please provide details ...
- db_table: effect_subject_signsandsymptoms
- column: visual_field_loss
- type: TextField
---

**Section: Investigations**

**9.0.** Was an X-ray performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'Chest X-ray' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: xray_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**10.0.** Was a lumbar puncture performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'Lumbar Puncture/CSF' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: lp_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Was a urinary LAM performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'TB Diagnostics' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: urinary_lam_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Reporting**

**12.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_signsandsymptoms
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_signsandsymptoms
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Calculated values**

**14.0.** calculated headache duration
- db_table: effect_subject_signsandsymptoms
- column: calculated_headache_duration
- type: DurationField
---

**Section: Action**

**15.0.** action identifier
- db_table: effect_subject_signsandsymptoms
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**16.0.** action item
- db_table: effect_subject_signsandsymptoms
- column: action_item
- type: ForeignKey
---

**17.0.** parent action item
- db_table: effect_subject_signsandsymptoms
- column: parent_action_item
- type: ForeignKey
---

**18.0.** related action item
- db_table: effect_subject_signsandsymptoms
- column: related_action_item
- type: ForeignKey
---


#### Significant Diagnoses
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_diagnoses
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_diagnoses
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Gastrointestinal side effects**

**3.0.** Has the participant experienced any gastrointestinal side effects?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete SAE report where appropriate*
- db_table: effect_subject_diagnoses
- column: gi_side_effects
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, please give details
- db_table: effect_subject_diagnoses
- column: gi_side_effects_details
- type: TextField
---

**Section: Diagnoses**

**5.0.** Are there any new significant diagnoses to report since last visit?
- db_table: effect_subject_diagnoses
- column: has_diagnoses
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Please select all diagnoses that are relevant
- db_table: effect_subject_diagnoses
- column: diagnoses
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `bacteraemia`: *Bacteraemia*
  - `bacterial_pneumonia`: *Bacterial pneumonia*
  - `cm`: *Cryptococcal meningitis*
  - `diarrhoeal_wasting`: *Diarrhoeal wasting*
  - `kaposi_sarcoma`: *Kaposi’s sarcoma*
  - `malaria`: *Malaria*
  - `tb_extrapulmonary`: *TB extrapulmonary*
  - `tb_pulmonary`: *TB pulmonary*
  - `OTHER`: *Other, please specify below ...*
---

**6.1.** If other, please specify ...
- db_table: effect_subject_diagnoses
- column: diagnoses_other
- type: TextField
- length: 150
---

**Section: Reporting**

**7.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_diagnoses
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_diagnoses
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Chest X-Ray
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_chestxray
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_chestxray
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Chest x-ray**

**3.0.** Was a chest x-ray performed?
- db_table: effect_subject_chestxray
- column: chest_xray
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, date performed?
- db_table: effect_subject_chestxray
- column: chest_xray_date
- type: DateField
- format: YYYY-MM-DD
---

**5.0.** If YES, indicate results?
- db_table: effect_subject_chestxray
- column: chest_xray_results
- type: ManyToManyField
- responses: *Select all that apply*
  - `NORMAL`: *Normal*
  - `lymphadenopathy`: *Lymphadenopathy*
  - `consolidation`: *Consolidation*
  - `miliary_tb`: *Miliary TB*
  - `infiltrates`: *Infiltrates*
  - `OTHER`: *Other, please specify below ...*
---

**5.1.** If other, please specify ...
- db_table: effect_subject_chestxray
- column: chest_xray_results_other
- type: TextField
---

**6.0.** Any additional comment
- db_table: effect_subject_chestxray
- column: comment
- type: TextField
---


#### Lumbar Puncture/Csf
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_lpcsf
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_lpcsf
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: LP**

**3.0.** Reason for LP
- db_table: effect_subject_lpcsf
- column: reason_for_lp
- type: CharField
- length: 50
- responses:
  - `scheduled_per_protocol`: *Scheduled per protocol*
  - `clincal_deterioration`: *Suspected Cryptococcal meningitis / Suspected IRIS*
---

**4.0.** LP Date and Time
- db_table: effect_subject_lpcsf
- column: lp_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**5.0.** Was the opening pressure measured
- db_table: effect_subject_lpcsf
- column: opening_pressure_measured
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** opening pressure

&nbsp;&nbsp;&nbsp;&nbsp; *Units cm of H<sub>2</sub>O*
- db_table: effect_subject_lpcsf
- column: opening_pressure
- type: IntegerField
---

**7.0.** closing pressure

&nbsp;&nbsp;&nbsp;&nbsp; *Units cm of H<sub>2</sub>O*
- db_table: effect_subject_lpcsf
- column: closing_pressure
- type: IntegerField
---

**8.0.** CSF amount removed

&nbsp;&nbsp;&nbsp;&nbsp; *Units ml*
- db_table: effect_subject_lpcsf
- column: csf_amount_removed
- type: IntegerField
---

**Section: CSF**

**9.0.** CSF positive for cryptococcal meningitis?
- db_table: effect_subject_lpcsf
- column: csf_positive
- type: CharField
- length: 18
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `awaiting_results`: *Awaiting results*
---

**10.0.** india ink
- db_table: effect_subject_lpcsf
- column: india_ink
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**11.0.** CrAg LFA
- db_table: effect_subject_lpcsf
- column: csf_crag_lfa
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**12.0.** SQ CrAg
- db_table: effect_subject_lpcsf
- column: sq_crag
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**13.0.** SQ CrAg
- db_table: effect_subject_lpcsf
- column: sq_crag_pos
- type: CharField
- length: 15
- responses:
  - `high`: *High*
  - `low`: *Low*
  - `N/A`: *Not applicable*
---

**14.0.** Was the CRF CrAg titre done
- db_table: effect_subject_lpcsf
- column: crf_crag_titre_done
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** crf crag titre
- db_table: effect_subject_lpcsf
- column: crf_crag_titre
- type: IntegerField
---

**Section: CSF culture**

**16.0.** CSF Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_lpcsf
- column: csf_requisition
- type: ForeignKey
---

**17.0.** CSF Result Report Date and Time
- db_table: effect_subject_lpcsf
- column: csf_culture_assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**18.0.** CSF Result: Other organism (non-Cryptococcus)

&nbsp;&nbsp;&nbsp;&nbsp; *Complete after getting the results.*
- db_table: effect_subject_lpcsf
- column: csf_culture
- type: CharField
- length: 18
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `awaiting_results`: *Awaiting results*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**19.0.** If YES, specify organism:
- db_table: effect_subject_lpcsf
- column: other_csf_culture
- type: CharField
- length: 75
- responses: *free text*
---

**20.0.** Total CSF WBC cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup>*
- db_table: effect_subject_lpcsf
- column: csf_wbc_cell_count
- type: IntegerField
---

**21.0.** Differential lymphocyte cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup> or %*
- db_table: effect_subject_lpcsf
- column: differential_lymphocyte_count
- type: IntegerField
---

**22.0.** differential lymphocyte unit
- db_table: effect_subject_lpcsf
- column: differential_lymphocyte_unit
- type: CharField
- length: 6
- responses:
  - `mm3`: *mm<sup>3</sup>*
  - `%`: *%*
---

**23.0.** Differential neutrophil cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup> or %*
- db_table: effect_subject_lpcsf
- column: differential_neutrophil_count
- type: IntegerField
---

**24.0.** differential neutrophil unit
- db_table: effect_subject_lpcsf
- column: differential_neutrophil_unit
- type: CharField
- length: 6
- responses:
  - `mm3`: *mm<sup>3</sup>*
  - `%`: *%*
---

**25.0.** CSF glucose:

&nbsp;&nbsp;&nbsp;&nbsp; *Units in mmol/L or mg/dL*
- db_table: effect_subject_lpcsf
- column: csf_glucose
- type: DecimalField
---

**26.0.** CSF glucose units:
- db_table: effect_subject_lpcsf
- column: csf_glucose_units
- type: CharField
- length: 6
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**27.0.** CSF protein:

&nbsp;&nbsp;&nbsp;&nbsp; *Units in g/L*
- db_table: effect_subject_lpcsf
- column: csf_protein
- type: DecimalField
---

**28.0.** CSF CrAg:
- db_table: effect_subject_lpcsf
- column: csf_crag
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `IND`: *Indeterminate*
---


#### Tb Diagnostics
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_tbdiagnostics
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_tbdiagnostics
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Urinary LAM**

**3.0.** Urinary LAM performed?
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** urinary lam date
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_date
- type: DateField
- format: YYYY-MM-DD
---

**5.0.** Urinary LAM result
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_result
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---

**6.0.** If Urinary LAM is positive, grade
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_result_grade
- type: CharField
- length: 25
- responses:
  - `1`: *1+ (low)*
  - `2`: *2+*
  - `3`: *3+*
  - `4`: *4+*
  - `5`: *5+ (high)*
  - `unknown`: *Unknown / Grade not reported*
  - `N/A`: *Not applicable*
---

**Section: Sputum requisition**

**7.0.** Sputum requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_tbdiagnostics
- column: sputum_requisition
- type: ForeignKey
---

**Section: Sputum Gene-Xpert**

**8.0.** Sputum Gene-Xpert performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**9.0.** Sputum Gene-Xpert date
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_date
- type: DateField
- format: YYYY-MM-DD
---

**10.0.** Sputum Gene-Xpert results
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_result
- type: CharField
- length: 45
- responses:
  - `POS`: *MTB Positive*
  - `NEG`: *MTB Negative*
  - `IND`: *Indeterminate*
  - `N/A`: *Not applicable*
---

**Section: Sputum culture**

**11.0.** Sputum culture performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**12.0.** sputum culture date
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_date
- type: DateField
- format: YYYY-MM-DD
---

**13.0.** Sputum culture results
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_result
- type: CharField
- length: 10
- responses:
  - `POS`: *MTB Positive*
  - `NEG`: *MTB Negative*
  - `IND`: *Indeterminate / contaminated*
  - `N/A`: *Not applicable*
---

**Section: Sputum AFB**

**14.0.** Sputum AFB microscopy performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** Sputum AFB date
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_date
- type: DateField
- format: YYYY-MM-DD
---

**16.0.** Sputum AFB results
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_result
- type: CharField
- length: 10
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---

**Section: Comment**

**17.0.** Any additional comment
- db_table: effect_subject_tbdiagnostics
- column: comment
- type: TextField
---


#### Adherence: Day 14+
Adherence CRF completed after d14 (telephone).
*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_adherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_adherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Adherence counselling**

**3.0.** Has appropriate adherence counselling been given as per the trial SOP?
- db_table: effect_subject_adherence
- column: adherence_counselling
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: adherence_counselling_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Adherence summary**

**5.0.** Has the participant linked up with their local clinic?
- db_table: effect_subject_adherence
- column: linked_local_clinic
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: linked_local_clinic_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**7.0.** Is the participant receiving Fluconazole?
- db_table: effect_subject_adherence
- column: on_flucon
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: on_flucon_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**9.0.** Is the participant receiving ARVs?
- db_table: effect_subject_adherence
- column: on_arv
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: on_arv_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**11.0.** In the clinician’s opinion, is the participant 90% adherent to fluconazole?
- db_table: effect_subject_adherence
- column: opinion_flucon_adherent
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** In the clinician’s opinion, is the participant 90% adherent to ART?
- db_table: effect_subject_adherence
- column: opinion_arv_adherent
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**13.0.** Medication adherence narrative:
- db_table: effect_subject_adherence
- column: adherence_narrative
- type: TextField
---


#### Requisitions

### 1070

#### Study Medication
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_studymedication
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_studymedication
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Modifications**

**3.0.** Have there been any modifications to study medication since the last report?
- db_table: effect_subject_studymedication
- column: modifications
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** Reason for dose change

&nbsp;&nbsp;&nbsp;&nbsp; *Select all that apply.*
- db_table: effect_subject_studymedication
- column: modifications_reason
- type: ManyToManyField
- responses: *Select all that apply*
  - `per_protocol`: *Per protocol*
  - `renal_adjustment`: *Renal adjustment*
  - `toxicity`: *Toxicity*
  - `OTHER`: *Other, please specify below ...*
---

**4.1.** If other reason, please provide details ...
- db_table: effect_subject_studymedication
- column: modifications_reason_other
- type: TextField
- length: 250
---

**Section: Fluconazole**

**5.0.** Have there been any modifications to fluconazole dose since the last report?
- db_table: effect_subject_studymedication
- column: flucon_modified
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.0.** Date and time first fluconazole dose administered
- db_table: effect_subject_studymedication
- column: flucon_dose_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**7.0.** Fluconazole dose

&nbsp;&nbsp;&nbsp;&nbsp; *in mg/d*
- db_table: effect_subject_studymedication
- column: flucon_dose
- type: IntegerField
---

**8.0.** First fluconazole dose administered
- db_table: effect_subject_studymedication
- column: flucon_next_dose
- type: CharField
- length: 15
- responses:
  - `today`: *Today*
  - `tomorrow`: *Tomorrow*
  - `N/A`: *Not applicable*
---

**9.0.** Fluconazole notes (if any)
- db_table: effect_subject_studymedication
- column: flucon_notes
- type: TextField
- length: 250
---

**Section: Flucytosine**

**10.0.** Have there been any modifications to flucytosine dose since the last report?
- db_table: effect_subject_studymedication
- column: flucyt_modified
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Date and time first flucytosine dose administered
- db_table: effect_subject_studymedication
- column: flucyt_dose_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**12.0.** Flucytosine dose prescribed

&nbsp;&nbsp;&nbsp;&nbsp; *in mg/d*
- db_table: effect_subject_studymedication
- column: flucyt_dose
- type: IntegerField
---

**13.0.** Dose at 04:00

&nbsp;&nbsp;&nbsp;&nbsp; *in mg*
- db_table: effect_subject_studymedication
- column: flucyt_dose_0400
- type: IntegerField
---

**14.0.** Dose at 10:00

&nbsp;&nbsp;&nbsp;&nbsp; *in mg*
- db_table: effect_subject_studymedication
- column: flucyt_dose_1000
- type: IntegerField
---

**15.0.** Dose at 16:00

&nbsp;&nbsp;&nbsp;&nbsp; *in mg*
- db_table: effect_subject_studymedication
- column: flucyt_dose_1600
- type: IntegerField
---

**16.0.** Dose at 22:00

&nbsp;&nbsp;&nbsp;&nbsp; *in mg*
- db_table: effect_subject_studymedication
- column: flucyt_dose_2200
- type: IntegerField
---

**17.0.** First flucytosine dose administered
- db_table: effect_subject_studymedication
- column: flucyt_next_dose
- type: CharField
- length: 5
- responses:
  - `0400`: *at 04:00*
  - `1000`: *at 10:00*
  - `1600`: *at 16:00*
  - `2200`: *at 22:00*
  - `N/A`: *Not applicable*
---

**18.0.** Flucytosine notes (if any)
- db_table: effect_subject_studymedication
- column: flucyt_notes
- type: TextField
- length: 250
---


#### Vital Signs
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_vitalsigns
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_vitalsigns
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vital signs**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: effect_subject_vitalsigns
- column: weight
- type: DecimalField
---

**4.0.** Is the weight estimated or measured?
- db_table: effect_subject_vitalsigns
- column: weight_measured_or_est
- type: CharField
- length: 25
- responses:
  - `measured`: *Measured (weighed)*
  - `estimated`: *Estimated*
---

**5.0.** Blood pressure: systolic

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: effect_subject_vitalsigns
- column: sys_blood_pressure
- type: IntegerField
---

**6.0.** Blood pressure: diastolic

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: effect_subject_vitalsigns
- column: dia_blood_pressure
- type: IntegerField
---

**7.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: effect_subject_vitalsigns
- column: heart_rate
- type: IntegerField
---

**8.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: effect_subject_vitalsigns
- column: respiratory_rate
- type: IntegerField
---

**9.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celsius*
- db_table: effect_subject_vitalsigns
- column: temperature
- type: DecimalField
---

**10.0.** Abnormal lung exam:
- db_table: effect_subject_vitalsigns
- column: abnormal_lung_exam
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Action**

**11.0.** action identifier
- db_table: effect_subject_vitalsigns
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**12.0.** action item
- db_table: effect_subject_vitalsigns
- column: action_item
- type: ForeignKey
---

**13.0.** parent action item
- db_table: effect_subject_vitalsigns
- column: parent_action_item
- type: ForeignKey
---

**14.0.** related action item
- db_table: effect_subject_vitalsigns
- column: related_action_item
- type: ForeignKey
---

**Section: Reporting**

**15.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_vitalsigns
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**16.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_vitalsigns
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Mental Status
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_mentalstatus
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_mentalstatus
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Mental status**

**3.0.** Recent seizure (<72 hours)?
- db_table: effect_subject_mentalstatus
- column: recent_seizure
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** Behaviour change?
- db_table: effect_subject_mentalstatus
- column: behaviour_change
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**5.0.** Confusion?
- db_table: effect_subject_mentalstatus
- column: confusion
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Does the participant require help from anybody for everyday activities?

&nbsp;&nbsp;&nbsp;&nbsp; *Answer only at scheduled Week 10 and Month 6 visits*
- db_table: effect_subject_mentalstatus
- column: require_help
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.1.** Has the illness left the participant with any other problems?

&nbsp;&nbsp;&nbsp;&nbsp; *Answer only at scheduled Week 10 and Month 6 visits*
- db_table: effect_subject_mentalstatus
- column: any_other_problems
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**7.0.** Modified Rankin Score
- db_table: effect_subject_mentalstatus
- column: modified_rankin_score
- type: CharField
- length: 15
- responses:
  - `0`: *[0] No symptoms*
  - `1`: *[1] No significant disability. Able to carry out usual activities, despite some symptoms.*
  - `2`: *[2] Slight disability. Able to look after own affairs without assistance, but unable to carry out all previous activities.*
  - `3`: *[3] Moderate disability. Requires some help, but able to walk unassisted.*
  - `4`: *[4] Moderately severe disability. Unable to attend to own bodily needs without assistance, and unable to walk unassisted.*
  - `5`: *[5] Severe disability. Requires constant nursing care and attention, bedridden, incontinent.*
  - `6`: *[6] Dead*
---

**8.0.** ECOG score
- db_table: effect_subject_mentalstatus
- column: ecog_score
- type: CharField
- length: 15
- responses:
  - `0`: *[0] Fully active, able to carry on all pre-disease performance without restriction*
  - `1`: *[1] Restricted in physically strenuous activity but ambulatory and able to carry out work of a light or sedentary nature, e.g., light house work, office work*
  - `2`: *[2] Ambulatory and capable of all self-care but unable to carry out any work activities; up and about more than 50% of waking hours *
  - `3`: *[3] Capable of only limited self-care; confined to bed or chair more than 50% of waking hours*
  - `4`: *[4] Completely disabled; cannot carry on any self-care; totally confined to bed or chair*
  - `5`: *[5] Deceased*
---

**9.0.** Glasgow Coma Score

&nbsp;&nbsp;&nbsp;&nbsp; */15*
- db_table: effect_subject_mentalstatus
- column: glasgow_coma_score
- type: IntegerField
---

**Section: Reporting**

**10.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_mentalstatus
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_mentalstatus
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Signs And Symptoms
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_signsandsymptoms
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_signsandsymptoms
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Signs and symptoms**

**3.0.** Are there any signs or symptoms to report, since last contact with trial team?
- db_table: effect_subject_signsandsymptoms
- column: any_sx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `unknown`: *Unknown*
---

**4.0.** Is participant currently experiencing any of the following signs/symptoms?
- db_table: effect_subject_signsandsymptoms
- column: current_sx
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `cough`: *Cough*
  - `diarrhoea`: *Diarrhoea*
  - `double_vision`: *Double vision*
  - `drowsiness`: *Drowsiness*
  - `fever`: *Fever*
  - `focal_weakness`: *Focal weakness*
  - `headache`: *Headache*
  - `hearing_loss`: *Hearing loss*
  - `jaundice`: *Jaundice*
  - `nausea`: *Nausea*
  - `night_sweats`: *Night sweats*
  - `CN_VI_palsy_left`: *Neuro - Cranial Nerve VI palsy (left)*
  - `CN_VI_palsy_right`: *Neuro - Cranial Nerve VI palsy (right)*
  - `CN_VII_palsy_left`: *Neuro - Cranial Nerve VII palsy (left)*
  - `CN_VII_palsy_right`: *Neuro - Cranial Nerve VII palsy (right)*
  - `cn_palsy_left_other`: *Neuro - Other cranial nerve palsy (left), please specify below ...*
  - `cn_palsy_right_other`: *Neuro - Other cranial nerve palsy (right), please specify below ...*
  - `focal_seizures_left`: *Neuro - Focal seizures (left)*
  - `focal_seizures_right`: *Neuro - Focal seizures (right)*
  - `hemiplegia_left`: *Neuro - Hemiplegia (left)*
  - `hemiplegia_right`: *Neuro - Hemiplegia (right)*
  - `meningism`: *Neuro - Meningism*
  - `papilloedema`: *Neuro - Papilloedema*
  - `visual_field_disturbance`: *Neuro - Visual field disturbance*
  - `focal_neurologic_deficit_other`: *Neuro - Other focal neurologic deficit, please specify below ...*
  - `shortness_of_breath`: *Shortness of breath*
  - `skin_lesions`: *Skin lesions*
  - `visual_loss`: *Visual loss*
  - `vomiting`: *Vomiting*
  - `weight_loss`: *Weight loss*
  - `OTHER`: *Other sign(s)/symptom(s), please specify below ...*
---

**4.1.** If other, please specify ...

&nbsp;&nbsp;&nbsp;&nbsp; *If more than one, separate each with a comma (,).*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_other
- type: TextField
---

**5.0.** Are any of the signs or symptoms related to cryptococcal meningitis (CM)?
- db_table: effect_subject_signsandsymptoms
- column: cm_sx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.0.** For these signs/symptoms, were any Grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.</br>*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_gte_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `cough`: *Cough*
  - `diarrhoea`: *Diarrhoea*
  - `double_vision`: *Double vision*
  - `drowsiness`: *Drowsiness*
  - `fever`: *Fever*
  - `focal_weakness`: *Focal weakness*
  - `headache`: *Headache*
  - `hearing_loss`: *Hearing loss*
  - `jaundice`: *Jaundice*
  - `nausea`: *Nausea*
  - `night_sweats`: *Night sweats*
  - `CN_VI_palsy_left`: *Neuro - Cranial Nerve VI palsy (left)*
  - `CN_VI_palsy_right`: *Neuro - Cranial Nerve VI palsy (right)*
  - `CN_VII_palsy_left`: *Neuro - Cranial Nerve VII palsy (left)*
  - `CN_VII_palsy_right`: *Neuro - Cranial Nerve VII palsy (right)*
  - `cn_palsy_left_other`: *Neuro - Other cranial nerve palsy (left), please specify below ...*
  - `cn_palsy_right_other`: *Neuro - Other cranial nerve palsy (right), please specify below ...*
  - `focal_seizures_left`: *Neuro - Focal seizures (left)*
  - `focal_seizures_right`: *Neuro - Focal seizures (right)*
  - `hemiplegia_left`: *Neuro - Hemiplegia (left)*
  - `hemiplegia_right`: *Neuro - Hemiplegia (right)*
  - `meningism`: *Neuro - Meningism*
  - `papilloedema`: *Neuro - Papilloedema*
  - `visual_field_disturbance`: *Neuro - Visual field disturbance*
  - `focal_neurologic_deficit_other`: *Neuro - Other focal neurologic deficit, please specify below ...*
  - `shortness_of_breath`: *Shortness of breath*
  - `skin_lesions`: *Skin lesions*
  - `visual_loss`: *Visual loss*
  - `vomiting`: *Vomiting*
  - `weight_loss`: *Weight loss*
  - `OTHER`: *Other sign(s)/symptom(s), please specify below ...*
---

**6.1.** If other, please specify ...

&nbsp;&nbsp;&nbsp;&nbsp; *If more than one, separate each with a comma (,).*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_gte_g3_other
- type: TextField
---

**Section: Additional details**

**7.0.** If participant currently has headache, for what duration have they had it for

&nbsp;&nbsp;&nbsp;&nbsp; *In days and/or hours.  Note: 1 day equivalent to 24 hours.</br> Format is `DDdHHh`, `DDd` or `HHh`. For example 1d23h, 15d9h ... or 20d, or 5h ...*
- db_table: effect_subject_signsandsymptoms
- column: headache_duration
- type: CharField
- length: 7
- responses: *free text*
---

**7.1.** If other cranial nerve palsy (left), please specify ...
- db_table: effect_subject_signsandsymptoms
- column: cn_palsy_left_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.2.** If other cranial nerve palsy (right), please specify ...
- db_table: effect_subject_signsandsymptoms
- column: cn_palsy_right_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.3.** If other focal neurologic deficit, please specify ...
- db_table: effect_subject_signsandsymptoms
- column: focal_neurologic_deficit_other
- type: CharField
- length: 35
- responses: *free text*
---

**8.0.** If visual field loss, please provide details ...
- db_table: effect_subject_signsandsymptoms
- column: visual_field_loss
- type: TextField
---

**Section: Investigations**

**9.0.** Was an X-ray performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'Chest X-ray' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: xray_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**10.0.** Was a lumbar puncture performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'Lumbar Puncture/CSF' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: lp_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Was a urinary LAM performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'TB Diagnostics' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: urinary_lam_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Reporting**

**12.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_signsandsymptoms
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_signsandsymptoms
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Calculated values**

**14.0.** calculated headache duration
- db_table: effect_subject_signsandsymptoms
- column: calculated_headache_duration
- type: DurationField
---

**Section: Action**

**15.0.** action identifier
- db_table: effect_subject_signsandsymptoms
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**16.0.** action item
- db_table: effect_subject_signsandsymptoms
- column: action_item
- type: ForeignKey
---

**17.0.** parent action item
- db_table: effect_subject_signsandsymptoms
- column: parent_action_item
- type: ForeignKey
---

**18.0.** related action item
- db_table: effect_subject_signsandsymptoms
- column: related_action_item
- type: ForeignKey
---


#### Significant Diagnoses
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_diagnoses
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_diagnoses
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Gastrointestinal side effects**

**3.0.** Has the participant experienced any gastrointestinal side effects?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete SAE report where appropriate*
- db_table: effect_subject_diagnoses
- column: gi_side_effects
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, please give details
- db_table: effect_subject_diagnoses
- column: gi_side_effects_details
- type: TextField
---

**Section: Diagnoses**

**5.0.** Are there any new significant diagnoses to report since last visit?
- db_table: effect_subject_diagnoses
- column: has_diagnoses
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Please select all diagnoses that are relevant
- db_table: effect_subject_diagnoses
- column: diagnoses
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `bacteraemia`: *Bacteraemia*
  - `bacterial_pneumonia`: *Bacterial pneumonia*
  - `cm`: *Cryptococcal meningitis*
  - `diarrhoeal_wasting`: *Diarrhoeal wasting*
  - `kaposi_sarcoma`: *Kaposi’s sarcoma*
  - `malaria`: *Malaria*
  - `tb_extrapulmonary`: *TB extrapulmonary*
  - `tb_pulmonary`: *TB pulmonary*
  - `OTHER`: *Other, please specify below ...*
---

**6.1.** If other, please specify ...
- db_table: effect_subject_diagnoses
- column: diagnoses_other
- type: TextField
- length: 150
---

**Section: Reporting**

**7.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_diagnoses
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_diagnoses
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Chest X-Ray
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_chestxray
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_chestxray
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Chest x-ray**

**3.0.** Was a chest x-ray performed?
- db_table: effect_subject_chestxray
- column: chest_xray
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, date performed?
- db_table: effect_subject_chestxray
- column: chest_xray_date
- type: DateField
- format: YYYY-MM-DD
---

**5.0.** If YES, indicate results?
- db_table: effect_subject_chestxray
- column: chest_xray_results
- type: ManyToManyField
- responses: *Select all that apply*
  - `NORMAL`: *Normal*
  - `lymphadenopathy`: *Lymphadenopathy*
  - `consolidation`: *Consolidation*
  - `miliary_tb`: *Miliary TB*
  - `infiltrates`: *Infiltrates*
  - `OTHER`: *Other, please specify below ...*
---

**5.1.** If other, please specify ...
- db_table: effect_subject_chestxray
- column: chest_xray_results_other
- type: TextField
---

**6.0.** Any additional comment
- db_table: effect_subject_chestxray
- column: comment
- type: TextField
---


#### Lumbar Puncture/Csf
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_lpcsf
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_lpcsf
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: LP**

**3.0.** Reason for LP
- db_table: effect_subject_lpcsf
- column: reason_for_lp
- type: CharField
- length: 50
- responses:
  - `scheduled_per_protocol`: *Scheduled per protocol*
  - `clincal_deterioration`: *Suspected Cryptococcal meningitis / Suspected IRIS*
---

**4.0.** LP Date and Time
- db_table: effect_subject_lpcsf
- column: lp_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**5.0.** Was the opening pressure measured
- db_table: effect_subject_lpcsf
- column: opening_pressure_measured
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** opening pressure

&nbsp;&nbsp;&nbsp;&nbsp; *Units cm of H<sub>2</sub>O*
- db_table: effect_subject_lpcsf
- column: opening_pressure
- type: IntegerField
---

**7.0.** closing pressure

&nbsp;&nbsp;&nbsp;&nbsp; *Units cm of H<sub>2</sub>O*
- db_table: effect_subject_lpcsf
- column: closing_pressure
- type: IntegerField
---

**8.0.** CSF amount removed

&nbsp;&nbsp;&nbsp;&nbsp; *Units ml*
- db_table: effect_subject_lpcsf
- column: csf_amount_removed
- type: IntegerField
---

**Section: CSF**

**9.0.** CSF positive for cryptococcal meningitis?
- db_table: effect_subject_lpcsf
- column: csf_positive
- type: CharField
- length: 18
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `awaiting_results`: *Awaiting results*
---

**10.0.** india ink
- db_table: effect_subject_lpcsf
- column: india_ink
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**11.0.** CrAg LFA
- db_table: effect_subject_lpcsf
- column: csf_crag_lfa
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**12.0.** SQ CrAg
- db_table: effect_subject_lpcsf
- column: sq_crag
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**13.0.** SQ CrAg
- db_table: effect_subject_lpcsf
- column: sq_crag_pos
- type: CharField
- length: 15
- responses:
  - `high`: *High*
  - `low`: *Low*
  - `N/A`: *Not applicable*
---

**14.0.** Was the CRF CrAg titre done
- db_table: effect_subject_lpcsf
- column: crf_crag_titre_done
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** crf crag titre
- db_table: effect_subject_lpcsf
- column: crf_crag_titre
- type: IntegerField
---

**Section: CSF culture**

**16.0.** CSF Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_lpcsf
- column: csf_requisition
- type: ForeignKey
---

**17.0.** CSF Result Report Date and Time
- db_table: effect_subject_lpcsf
- column: csf_culture_assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**18.0.** CSF Result: Other organism (non-Cryptococcus)

&nbsp;&nbsp;&nbsp;&nbsp; *Complete after getting the results.*
- db_table: effect_subject_lpcsf
- column: csf_culture
- type: CharField
- length: 18
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `awaiting_results`: *Awaiting results*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**19.0.** If YES, specify organism:
- db_table: effect_subject_lpcsf
- column: other_csf_culture
- type: CharField
- length: 75
- responses: *free text*
---

**20.0.** Total CSF WBC cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup>*
- db_table: effect_subject_lpcsf
- column: csf_wbc_cell_count
- type: IntegerField
---

**21.0.** Differential lymphocyte cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup> or %*
- db_table: effect_subject_lpcsf
- column: differential_lymphocyte_count
- type: IntegerField
---

**22.0.** differential lymphocyte unit
- db_table: effect_subject_lpcsf
- column: differential_lymphocyte_unit
- type: CharField
- length: 6
- responses:
  - `mm3`: *mm<sup>3</sup>*
  - `%`: *%*
---

**23.0.** Differential neutrophil cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup> or %*
- db_table: effect_subject_lpcsf
- column: differential_neutrophil_count
- type: IntegerField
---

**24.0.** differential neutrophil unit
- db_table: effect_subject_lpcsf
- column: differential_neutrophil_unit
- type: CharField
- length: 6
- responses:
  - `mm3`: *mm<sup>3</sup>*
  - `%`: *%*
---

**25.0.** CSF glucose:

&nbsp;&nbsp;&nbsp;&nbsp; *Units in mmol/L or mg/dL*
- db_table: effect_subject_lpcsf
- column: csf_glucose
- type: DecimalField
---

**26.0.** CSF glucose units:
- db_table: effect_subject_lpcsf
- column: csf_glucose_units
- type: CharField
- length: 6
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**27.0.** CSF protein:

&nbsp;&nbsp;&nbsp;&nbsp; *Units in g/L*
- db_table: effect_subject_lpcsf
- column: csf_protein
- type: DecimalField
---

**28.0.** CSF CrAg:
- db_table: effect_subject_lpcsf
- column: csf_crag
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `IND`: *Indeterminate*
---


#### Tb Diagnostics
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_tbdiagnostics
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_tbdiagnostics
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Urinary LAM**

**3.0.** Urinary LAM performed?
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** urinary lam date
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_date
- type: DateField
- format: YYYY-MM-DD
---

**5.0.** Urinary LAM result
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_result
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---

**6.0.** If Urinary LAM is positive, grade
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_result_grade
- type: CharField
- length: 25
- responses:
  - `1`: *1+ (low)*
  - `2`: *2+*
  - `3`: *3+*
  - `4`: *4+*
  - `5`: *5+ (high)*
  - `unknown`: *Unknown / Grade not reported*
  - `N/A`: *Not applicable*
---

**Section: Sputum requisition**

**7.0.** Sputum requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_tbdiagnostics
- column: sputum_requisition
- type: ForeignKey
---

**Section: Sputum Gene-Xpert**

**8.0.** Sputum Gene-Xpert performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**9.0.** Sputum Gene-Xpert date
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_date
- type: DateField
- format: YYYY-MM-DD
---

**10.0.** Sputum Gene-Xpert results
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_result
- type: CharField
- length: 45
- responses:
  - `POS`: *MTB Positive*
  - `NEG`: *MTB Negative*
  - `IND`: *Indeterminate*
  - `N/A`: *Not applicable*
---

**Section: Sputum culture**

**11.0.** Sputum culture performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**12.0.** sputum culture date
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_date
- type: DateField
- format: YYYY-MM-DD
---

**13.0.** Sputum culture results
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_result
- type: CharField
- length: 10
- responses:
  - `POS`: *MTB Positive*
  - `NEG`: *MTB Negative*
  - `IND`: *Indeterminate / contaminated*
  - `N/A`: *Not applicable*
---

**Section: Sputum AFB**

**14.0.** Sputum AFB microscopy performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** Sputum AFB date
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_date
- type: DateField
- format: YYYY-MM-DD
---

**16.0.** Sputum AFB results
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_result
- type: CharField
- length: 10
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---

**Section: Comment**

**17.0.** Any additional comment
- db_table: effect_subject_tbdiagnostics
- column: comment
- type: TextField
---


#### Adherence: Day 14+
Adherence CRF completed after d14 (telephone).
*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_adherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_adherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Adherence counselling**

**3.0.** Has appropriate adherence counselling been given as per the trial SOP?
- db_table: effect_subject_adherence
- column: adherence_counselling
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: adherence_counselling_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Adherence summary**

**5.0.** Has the participant linked up with their local clinic?
- db_table: effect_subject_adherence
- column: linked_local_clinic
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: linked_local_clinic_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**7.0.** Is the participant receiving Fluconazole?
- db_table: effect_subject_adherence
- column: on_flucon
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: on_flucon_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**9.0.** Is the participant receiving ARVs?
- db_table: effect_subject_adherence
- column: on_arv
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: on_arv_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**11.0.** In the clinician’s opinion, is the participant 90% adherent to fluconazole?
- db_table: effect_subject_adherence
- column: opinion_flucon_adherent
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** In the clinician’s opinion, is the participant 90% adherent to ART?
- db_table: effect_subject_adherence
- column: opinion_arv_adherent
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**13.0.** Medication adherence narrative:
- db_table: effect_subject_adherence
- column: adherence_narrative
- type: TextField
---


#### Requisitions

### 1112

#### Vital Signs
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_vitalsigns
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_vitalsigns
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vital signs**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: effect_subject_vitalsigns
- column: weight
- type: DecimalField
---

**4.0.** Is the weight estimated or measured?
- db_table: effect_subject_vitalsigns
- column: weight_measured_or_est
- type: CharField
- length: 25
- responses:
  - `measured`: *Measured (weighed)*
  - `estimated`: *Estimated*
---

**5.0.** Blood pressure: systolic

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: effect_subject_vitalsigns
- column: sys_blood_pressure
- type: IntegerField
---

**6.0.** Blood pressure: diastolic

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: effect_subject_vitalsigns
- column: dia_blood_pressure
- type: IntegerField
---

**7.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: effect_subject_vitalsigns
- column: heart_rate
- type: IntegerField
---

**8.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: effect_subject_vitalsigns
- column: respiratory_rate
- type: IntegerField
---

**9.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celsius*
- db_table: effect_subject_vitalsigns
- column: temperature
- type: DecimalField
---

**10.0.** Abnormal lung exam:
- db_table: effect_subject_vitalsigns
- column: abnormal_lung_exam
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Action**

**11.0.** action identifier
- db_table: effect_subject_vitalsigns
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**12.0.** action item
- db_table: effect_subject_vitalsigns
- column: action_item
- type: ForeignKey
---

**13.0.** parent action item
- db_table: effect_subject_vitalsigns
- column: parent_action_item
- type: ForeignKey
---

**14.0.** related action item
- db_table: effect_subject_vitalsigns
- column: related_action_item
- type: ForeignKey
---

**Section: Reporting**

**15.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_vitalsigns
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**16.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_vitalsigns
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Mental Status
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_mentalstatus
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_mentalstatus
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Mental status**

**3.0.** Recent seizure (<72 hours)?
- db_table: effect_subject_mentalstatus
- column: recent_seizure
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** Behaviour change?
- db_table: effect_subject_mentalstatus
- column: behaviour_change
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**5.0.** Confusion?
- db_table: effect_subject_mentalstatus
- column: confusion
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Does the participant require help from anybody for everyday activities?

&nbsp;&nbsp;&nbsp;&nbsp; *Answer only at scheduled Week 10 and Month 6 visits*
- db_table: effect_subject_mentalstatus
- column: require_help
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.1.** Has the illness left the participant with any other problems?

&nbsp;&nbsp;&nbsp;&nbsp; *Answer only at scheduled Week 10 and Month 6 visits*
- db_table: effect_subject_mentalstatus
- column: any_other_problems
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**7.0.** Modified Rankin Score
- db_table: effect_subject_mentalstatus
- column: modified_rankin_score
- type: CharField
- length: 15
- responses:
  - `0`: *[0] No symptoms*
  - `1`: *[1] No significant disability. Able to carry out usual activities, despite some symptoms.*
  - `2`: *[2] Slight disability. Able to look after own affairs without assistance, but unable to carry out all previous activities.*
  - `3`: *[3] Moderate disability. Requires some help, but able to walk unassisted.*
  - `4`: *[4] Moderately severe disability. Unable to attend to own bodily needs without assistance, and unable to walk unassisted.*
  - `5`: *[5] Severe disability. Requires constant nursing care and attention, bedridden, incontinent.*
  - `6`: *[6] Dead*
---

**8.0.** ECOG score
- db_table: effect_subject_mentalstatus
- column: ecog_score
- type: CharField
- length: 15
- responses:
  - `0`: *[0] Fully active, able to carry on all pre-disease performance without restriction*
  - `1`: *[1] Restricted in physically strenuous activity but ambulatory and able to carry out work of a light or sedentary nature, e.g., light house work, office work*
  - `2`: *[2] Ambulatory and capable of all self-care but unable to carry out any work activities; up and about more than 50% of waking hours *
  - `3`: *[3] Capable of only limited self-care; confined to bed or chair more than 50% of waking hours*
  - `4`: *[4] Completely disabled; cannot carry on any self-care; totally confined to bed or chair*
  - `5`: *[5] Deceased*
---

**9.0.** Glasgow Coma Score

&nbsp;&nbsp;&nbsp;&nbsp; */15*
- db_table: effect_subject_mentalstatus
- column: glasgow_coma_score
- type: IntegerField
---

**Section: Reporting**

**10.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_mentalstatus
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_mentalstatus
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Signs And Symptoms
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_signsandsymptoms
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_signsandsymptoms
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Signs and symptoms**

**3.0.** Are there any signs or symptoms to report, since last contact with trial team?
- db_table: effect_subject_signsandsymptoms
- column: any_sx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `unknown`: *Unknown*
---

**4.0.** Is participant currently experiencing any of the following signs/symptoms?
- db_table: effect_subject_signsandsymptoms
- column: current_sx
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `cough`: *Cough*
  - `diarrhoea`: *Diarrhoea*
  - `double_vision`: *Double vision*
  - `drowsiness`: *Drowsiness*
  - `fever`: *Fever*
  - `focal_weakness`: *Focal weakness*
  - `headache`: *Headache*
  - `hearing_loss`: *Hearing loss*
  - `jaundice`: *Jaundice*
  - `nausea`: *Nausea*
  - `night_sweats`: *Night sweats*
  - `CN_VI_palsy_left`: *Neuro - Cranial Nerve VI palsy (left)*
  - `CN_VI_palsy_right`: *Neuro - Cranial Nerve VI palsy (right)*
  - `CN_VII_palsy_left`: *Neuro - Cranial Nerve VII palsy (left)*
  - `CN_VII_palsy_right`: *Neuro - Cranial Nerve VII palsy (right)*
  - `cn_palsy_left_other`: *Neuro - Other cranial nerve palsy (left), please specify below ...*
  - `cn_palsy_right_other`: *Neuro - Other cranial nerve palsy (right), please specify below ...*
  - `focal_seizures_left`: *Neuro - Focal seizures (left)*
  - `focal_seizures_right`: *Neuro - Focal seizures (right)*
  - `hemiplegia_left`: *Neuro - Hemiplegia (left)*
  - `hemiplegia_right`: *Neuro - Hemiplegia (right)*
  - `meningism`: *Neuro - Meningism*
  - `papilloedema`: *Neuro - Papilloedema*
  - `visual_field_disturbance`: *Neuro - Visual field disturbance*
  - `focal_neurologic_deficit_other`: *Neuro - Other focal neurologic deficit, please specify below ...*
  - `shortness_of_breath`: *Shortness of breath*
  - `skin_lesions`: *Skin lesions*
  - `visual_loss`: *Visual loss*
  - `vomiting`: *Vomiting*
  - `weight_loss`: *Weight loss*
  - `OTHER`: *Other sign(s)/symptom(s), please specify below ...*
---

**4.1.** If other, please specify ...

&nbsp;&nbsp;&nbsp;&nbsp; *If more than one, separate each with a comma (,).*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_other
- type: TextField
---

**5.0.** Are any of the signs or symptoms related to cryptococcal meningitis (CM)?
- db_table: effect_subject_signsandsymptoms
- column: cm_sx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.0.** For these signs/symptoms, were any Grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.</br>*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_gte_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `cough`: *Cough*
  - `diarrhoea`: *Diarrhoea*
  - `double_vision`: *Double vision*
  - `drowsiness`: *Drowsiness*
  - `fever`: *Fever*
  - `focal_weakness`: *Focal weakness*
  - `headache`: *Headache*
  - `hearing_loss`: *Hearing loss*
  - `jaundice`: *Jaundice*
  - `nausea`: *Nausea*
  - `night_sweats`: *Night sweats*
  - `CN_VI_palsy_left`: *Neuro - Cranial Nerve VI palsy (left)*
  - `CN_VI_palsy_right`: *Neuro - Cranial Nerve VI palsy (right)*
  - `CN_VII_palsy_left`: *Neuro - Cranial Nerve VII palsy (left)*
  - `CN_VII_palsy_right`: *Neuro - Cranial Nerve VII palsy (right)*
  - `cn_palsy_left_other`: *Neuro - Other cranial nerve palsy (left), please specify below ...*
  - `cn_palsy_right_other`: *Neuro - Other cranial nerve palsy (right), please specify below ...*
  - `focal_seizures_left`: *Neuro - Focal seizures (left)*
  - `focal_seizures_right`: *Neuro - Focal seizures (right)*
  - `hemiplegia_left`: *Neuro - Hemiplegia (left)*
  - `hemiplegia_right`: *Neuro - Hemiplegia (right)*
  - `meningism`: *Neuro - Meningism*
  - `papilloedema`: *Neuro - Papilloedema*
  - `visual_field_disturbance`: *Neuro - Visual field disturbance*
  - `focal_neurologic_deficit_other`: *Neuro - Other focal neurologic deficit, please specify below ...*
  - `shortness_of_breath`: *Shortness of breath*
  - `skin_lesions`: *Skin lesions*
  - `visual_loss`: *Visual loss*
  - `vomiting`: *Vomiting*
  - `weight_loss`: *Weight loss*
  - `OTHER`: *Other sign(s)/symptom(s), please specify below ...*
---

**6.1.** If other, please specify ...

&nbsp;&nbsp;&nbsp;&nbsp; *If more than one, separate each with a comma (,).*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_gte_g3_other
- type: TextField
---

**Section: Additional details**

**7.0.** If participant currently has headache, for what duration have they had it for

&nbsp;&nbsp;&nbsp;&nbsp; *In days and/or hours.  Note: 1 day equivalent to 24 hours.</br> Format is `DDdHHh`, `DDd` or `HHh`. For example 1d23h, 15d9h ... or 20d, or 5h ...*
- db_table: effect_subject_signsandsymptoms
- column: headache_duration
- type: CharField
- length: 7
- responses: *free text*
---

**7.1.** If other cranial nerve palsy (left), please specify ...
- db_table: effect_subject_signsandsymptoms
- column: cn_palsy_left_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.2.** If other cranial nerve palsy (right), please specify ...
- db_table: effect_subject_signsandsymptoms
- column: cn_palsy_right_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.3.** If other focal neurologic deficit, please specify ...
- db_table: effect_subject_signsandsymptoms
- column: focal_neurologic_deficit_other
- type: CharField
- length: 35
- responses: *free text*
---

**8.0.** If visual field loss, please provide details ...
- db_table: effect_subject_signsandsymptoms
- column: visual_field_loss
- type: TextField
---

**Section: Investigations**

**9.0.** Was an X-ray performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'Chest X-ray' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: xray_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**10.0.** Was a lumbar puncture performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'Lumbar Puncture/CSF' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: lp_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Was a urinary LAM performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'TB Diagnostics' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: urinary_lam_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Reporting**

**12.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_signsandsymptoms
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_signsandsymptoms
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Calculated values**

**14.0.** calculated headache duration
- db_table: effect_subject_signsandsymptoms
- column: calculated_headache_duration
- type: DurationField
---

**Section: Action**

**15.0.** action identifier
- db_table: effect_subject_signsandsymptoms
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**16.0.** action item
- db_table: effect_subject_signsandsymptoms
- column: action_item
- type: ForeignKey
---

**17.0.** parent action item
- db_table: effect_subject_signsandsymptoms
- column: parent_action_item
- type: ForeignKey
---

**18.0.** related action item
- db_table: effect_subject_signsandsymptoms
- column: related_action_item
- type: ForeignKey
---


#### Significant Diagnoses
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_diagnoses
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_diagnoses
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Gastrointestinal side effects**

**3.0.** Has the participant experienced any gastrointestinal side effects?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete SAE report where appropriate*
- db_table: effect_subject_diagnoses
- column: gi_side_effects
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, please give details
- db_table: effect_subject_diagnoses
- column: gi_side_effects_details
- type: TextField
---

**Section: Diagnoses**

**5.0.** Are there any new significant diagnoses to report since last visit?
- db_table: effect_subject_diagnoses
- column: has_diagnoses
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Please select all diagnoses that are relevant
- db_table: effect_subject_diagnoses
- column: diagnoses
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `bacteraemia`: *Bacteraemia*
  - `bacterial_pneumonia`: *Bacterial pneumonia*
  - `cm`: *Cryptococcal meningitis*
  - `diarrhoeal_wasting`: *Diarrhoeal wasting*
  - `kaposi_sarcoma`: *Kaposi’s sarcoma*
  - `malaria`: *Malaria*
  - `tb_extrapulmonary`: *TB extrapulmonary*
  - `tb_pulmonary`: *TB pulmonary*
  - `OTHER`: *Other, please specify below ...*
---

**6.1.** If other, please specify ...
- db_table: effect_subject_diagnoses
- column: diagnoses_other
- type: TextField
- length: 150
---

**Section: Reporting**

**7.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_diagnoses
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_diagnoses
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Chest X-Ray
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_chestxray
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_chestxray
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Chest x-ray**

**3.0.** Was a chest x-ray performed?
- db_table: effect_subject_chestxray
- column: chest_xray
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, date performed?
- db_table: effect_subject_chestxray
- column: chest_xray_date
- type: DateField
- format: YYYY-MM-DD
---

**5.0.** If YES, indicate results?
- db_table: effect_subject_chestxray
- column: chest_xray_results
- type: ManyToManyField
- responses: *Select all that apply*
  - `NORMAL`: *Normal*
  - `lymphadenopathy`: *Lymphadenopathy*
  - `consolidation`: *Consolidation*
  - `miliary_tb`: *Miliary TB*
  - `infiltrates`: *Infiltrates*
  - `OTHER`: *Other, please specify below ...*
---

**5.1.** If other, please specify ...
- db_table: effect_subject_chestxray
- column: chest_xray_results_other
- type: TextField
---

**6.0.** Any additional comment
- db_table: effect_subject_chestxray
- column: comment
- type: TextField
---


#### Lumbar Puncture/Csf
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_lpcsf
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_lpcsf
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: LP**

**3.0.** Reason for LP
- db_table: effect_subject_lpcsf
- column: reason_for_lp
- type: CharField
- length: 50
- responses:
  - `scheduled_per_protocol`: *Scheduled per protocol*
  - `clincal_deterioration`: *Suspected Cryptococcal meningitis / Suspected IRIS*
---

**4.0.** LP Date and Time
- db_table: effect_subject_lpcsf
- column: lp_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**5.0.** Was the opening pressure measured
- db_table: effect_subject_lpcsf
- column: opening_pressure_measured
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** opening pressure

&nbsp;&nbsp;&nbsp;&nbsp; *Units cm of H<sub>2</sub>O*
- db_table: effect_subject_lpcsf
- column: opening_pressure
- type: IntegerField
---

**7.0.** closing pressure

&nbsp;&nbsp;&nbsp;&nbsp; *Units cm of H<sub>2</sub>O*
- db_table: effect_subject_lpcsf
- column: closing_pressure
- type: IntegerField
---

**8.0.** CSF amount removed

&nbsp;&nbsp;&nbsp;&nbsp; *Units ml*
- db_table: effect_subject_lpcsf
- column: csf_amount_removed
- type: IntegerField
---

**Section: CSF**

**9.0.** CSF positive for cryptococcal meningitis?
- db_table: effect_subject_lpcsf
- column: csf_positive
- type: CharField
- length: 18
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `awaiting_results`: *Awaiting results*
---

**10.0.** india ink
- db_table: effect_subject_lpcsf
- column: india_ink
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**11.0.** CrAg LFA
- db_table: effect_subject_lpcsf
- column: csf_crag_lfa
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**12.0.** SQ CrAg
- db_table: effect_subject_lpcsf
- column: sq_crag
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**13.0.** SQ CrAg
- db_table: effect_subject_lpcsf
- column: sq_crag_pos
- type: CharField
- length: 15
- responses:
  - `high`: *High*
  - `low`: *Low*
  - `N/A`: *Not applicable*
---

**14.0.** Was the CRF CrAg titre done
- db_table: effect_subject_lpcsf
- column: crf_crag_titre_done
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** crf crag titre
- db_table: effect_subject_lpcsf
- column: crf_crag_titre
- type: IntegerField
---

**Section: CSF culture**

**16.0.** CSF Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_lpcsf
- column: csf_requisition
- type: ForeignKey
---

**17.0.** CSF Result Report Date and Time
- db_table: effect_subject_lpcsf
- column: csf_culture_assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**18.0.** CSF Result: Other organism (non-Cryptococcus)

&nbsp;&nbsp;&nbsp;&nbsp; *Complete after getting the results.*
- db_table: effect_subject_lpcsf
- column: csf_culture
- type: CharField
- length: 18
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `awaiting_results`: *Awaiting results*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**19.0.** If YES, specify organism:
- db_table: effect_subject_lpcsf
- column: other_csf_culture
- type: CharField
- length: 75
- responses: *free text*
---

**20.0.** Total CSF WBC cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup>*
- db_table: effect_subject_lpcsf
- column: csf_wbc_cell_count
- type: IntegerField
---

**21.0.** Differential lymphocyte cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup> or %*
- db_table: effect_subject_lpcsf
- column: differential_lymphocyte_count
- type: IntegerField
---

**22.0.** differential lymphocyte unit
- db_table: effect_subject_lpcsf
- column: differential_lymphocyte_unit
- type: CharField
- length: 6
- responses:
  - `mm3`: *mm<sup>3</sup>*
  - `%`: *%*
---

**23.0.** Differential neutrophil cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup> or %*
- db_table: effect_subject_lpcsf
- column: differential_neutrophil_count
- type: IntegerField
---

**24.0.** differential neutrophil unit
- db_table: effect_subject_lpcsf
- column: differential_neutrophil_unit
- type: CharField
- length: 6
- responses:
  - `mm3`: *mm<sup>3</sup>*
  - `%`: *%*
---

**25.0.** CSF glucose:

&nbsp;&nbsp;&nbsp;&nbsp; *Units in mmol/L or mg/dL*
- db_table: effect_subject_lpcsf
- column: csf_glucose
- type: DecimalField
---

**26.0.** CSF glucose units:
- db_table: effect_subject_lpcsf
- column: csf_glucose_units
- type: CharField
- length: 6
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**27.0.** CSF protein:

&nbsp;&nbsp;&nbsp;&nbsp; *Units in g/L*
- db_table: effect_subject_lpcsf
- column: csf_protein
- type: DecimalField
---

**28.0.** CSF CrAg:
- db_table: effect_subject_lpcsf
- column: csf_crag
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `IND`: *Indeterminate*
---


#### Tb Diagnostics
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_tbdiagnostics
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_tbdiagnostics
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Urinary LAM**

**3.0.** Urinary LAM performed?
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** urinary lam date
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_date
- type: DateField
- format: YYYY-MM-DD
---

**5.0.** Urinary LAM result
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_result
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---

**6.0.** If Urinary LAM is positive, grade
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_result_grade
- type: CharField
- length: 25
- responses:
  - `1`: *1+ (low)*
  - `2`: *2+*
  - `3`: *3+*
  - `4`: *4+*
  - `5`: *5+ (high)*
  - `unknown`: *Unknown / Grade not reported*
  - `N/A`: *Not applicable*
---

**Section: Sputum requisition**

**7.0.** Sputum requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_tbdiagnostics
- column: sputum_requisition
- type: ForeignKey
---

**Section: Sputum Gene-Xpert**

**8.0.** Sputum Gene-Xpert performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**9.0.** Sputum Gene-Xpert date
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_date
- type: DateField
- format: YYYY-MM-DD
---

**10.0.** Sputum Gene-Xpert results
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_result
- type: CharField
- length: 45
- responses:
  - `POS`: *MTB Positive*
  - `NEG`: *MTB Negative*
  - `IND`: *Indeterminate*
  - `N/A`: *Not applicable*
---

**Section: Sputum culture**

**11.0.** Sputum culture performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**12.0.** sputum culture date
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_date
- type: DateField
- format: YYYY-MM-DD
---

**13.0.** Sputum culture results
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_result
- type: CharField
- length: 10
- responses:
  - `POS`: *MTB Positive*
  - `NEG`: *MTB Negative*
  - `IND`: *Indeterminate / contaminated*
  - `N/A`: *Not applicable*
---

**Section: Sputum AFB**

**14.0.** Sputum AFB microscopy performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** Sputum AFB date
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_date
- type: DateField
- format: YYYY-MM-DD
---

**16.0.** Sputum AFB results
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_result
- type: CharField
- length: 10
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---

**Section: Comment**

**17.0.** Any additional comment
- db_table: effect_subject_tbdiagnostics
- column: comment
- type: TextField
---


#### Adherence: Day 14+
Adherence CRF completed after d14 (telephone).
*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_adherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_adherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Adherence counselling**

**3.0.** Has appropriate adherence counselling been given as per the trial SOP?
- db_table: effect_subject_adherence
- column: adherence_counselling
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: adherence_counselling_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Adherence summary**

**5.0.** Has the participant linked up with their local clinic?
- db_table: effect_subject_adherence
- column: linked_local_clinic
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: linked_local_clinic_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**7.0.** Is the participant receiving Fluconazole?
- db_table: effect_subject_adherence
- column: on_flucon
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: on_flucon_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**9.0.** Is the participant receiving ARVs?
- db_table: effect_subject_adherence
- column: on_arv
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: on_arv_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**11.0.** In the clinician’s opinion, is the participant 90% adherent to fluconazole?
- db_table: effect_subject_adherence
- column: opinion_flucon_adherent
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** In the clinician’s opinion, is the participant 90% adherent to ART?
- db_table: effect_subject_adherence
- column: opinion_arv_adherent
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**13.0.** Medication adherence narrative:
- db_table: effect_subject_adherence
- column: adherence_narrative
- type: TextField
---


#### Requisitions

### 1168

#### Vital Signs
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_vitalsigns
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_vitalsigns
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Vital signs**

**3.0.** Weight:

&nbsp;&nbsp;&nbsp;&nbsp; *in kg*
- db_table: effect_subject_vitalsigns
- column: weight
- type: DecimalField
---

**4.0.** Is the weight estimated or measured?
- db_table: effect_subject_vitalsigns
- column: weight_measured_or_est
- type: CharField
- length: 25
- responses:
  - `measured`: *Measured (weighed)*
  - `estimated`: *Estimated*
---

**5.0.** Blood pressure: systolic

&nbsp;&nbsp;&nbsp;&nbsp; *in mm. format SYS, e.g. 120*
- db_table: effect_subject_vitalsigns
- column: sys_blood_pressure
- type: IntegerField
---

**6.0.** Blood pressure: diastolic

&nbsp;&nbsp;&nbsp;&nbsp; *in Hg. format DIA, e.g. 80*
- db_table: effect_subject_vitalsigns
- column: dia_blood_pressure
- type: IntegerField
---

**7.0.** Heart rate:

&nbsp;&nbsp;&nbsp;&nbsp; *BPM*
- db_table: effect_subject_vitalsigns
- column: heart_rate
- type: IntegerField
---

**8.0.** Respiratory rate:

&nbsp;&nbsp;&nbsp;&nbsp; *breaths/min*
- db_table: effect_subject_vitalsigns
- column: respiratory_rate
- type: IntegerField
---

**9.0.** Temperature:

&nbsp;&nbsp;&nbsp;&nbsp; *in degrees Celsius*
- db_table: effect_subject_vitalsigns
- column: temperature
- type: DecimalField
---

**10.0.** Abnormal lung exam:
- db_table: effect_subject_vitalsigns
- column: abnormal_lung_exam
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**Section: Action**

**11.0.** action identifier
- db_table: effect_subject_vitalsigns
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**12.0.** action item
- db_table: effect_subject_vitalsigns
- column: action_item
- type: ForeignKey
---

**13.0.** parent action item
- db_table: effect_subject_vitalsigns
- column: parent_action_item
- type: ForeignKey
---

**14.0.** related action item
- db_table: effect_subject_vitalsigns
- column: related_action_item
- type: ForeignKey
---

**Section: Reporting**

**15.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_vitalsigns
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**16.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_vitalsigns
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Mental Status
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_mentalstatus
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_mentalstatus
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Mental status**

**3.0.** Recent seizure (<72 hours)?
- db_table: effect_subject_mentalstatus
- column: recent_seizure
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** Behaviour change?
- db_table: effect_subject_mentalstatus
- column: behaviour_change
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**5.0.** Confusion?
- db_table: effect_subject_mentalstatus
- column: confusion
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Does the participant require help from anybody for everyday activities?

&nbsp;&nbsp;&nbsp;&nbsp; *Answer only at scheduled Week 10 and Month 6 visits*
- db_table: effect_subject_mentalstatus
- column: require_help
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.1.** Has the illness left the participant with any other problems?

&nbsp;&nbsp;&nbsp;&nbsp; *Answer only at scheduled Week 10 and Month 6 visits*
- db_table: effect_subject_mentalstatus
- column: any_other_problems
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**7.0.** Modified Rankin Score
- db_table: effect_subject_mentalstatus
- column: modified_rankin_score
- type: CharField
- length: 15
- responses:
  - `0`: *[0] No symptoms*
  - `1`: *[1] No significant disability. Able to carry out usual activities, despite some symptoms.*
  - `2`: *[2] Slight disability. Able to look after own affairs without assistance, but unable to carry out all previous activities.*
  - `3`: *[3] Moderate disability. Requires some help, but able to walk unassisted.*
  - `4`: *[4] Moderately severe disability. Unable to attend to own bodily needs without assistance, and unable to walk unassisted.*
  - `5`: *[5] Severe disability. Requires constant nursing care and attention, bedridden, incontinent.*
  - `6`: *[6] Dead*
---

**8.0.** ECOG score
- db_table: effect_subject_mentalstatus
- column: ecog_score
- type: CharField
- length: 15
- responses:
  - `0`: *[0] Fully active, able to carry on all pre-disease performance without restriction*
  - `1`: *[1] Restricted in physically strenuous activity but ambulatory and able to carry out work of a light or sedentary nature, e.g., light house work, office work*
  - `2`: *[2] Ambulatory and capable of all self-care but unable to carry out any work activities; up and about more than 50% of waking hours *
  - `3`: *[3] Capable of only limited self-care; confined to bed or chair more than 50% of waking hours*
  - `4`: *[4] Completely disabled; cannot carry on any self-care; totally confined to bed or chair*
  - `5`: *[5] Deceased*
---

**9.0.** Glasgow Coma Score

&nbsp;&nbsp;&nbsp;&nbsp; */15*
- db_table: effect_subject_mentalstatus
- column: glasgow_coma_score
- type: IntegerField
---

**Section: Reporting**

**10.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_mentalstatus
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_mentalstatus
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Signs And Symptoms
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_signsandsymptoms
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_signsandsymptoms
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Signs and symptoms**

**3.0.** Are there any signs or symptoms to report, since last contact with trial team?
- db_table: effect_subject_signsandsymptoms
- column: any_sx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `unknown`: *Unknown*
---

**4.0.** Is participant currently experiencing any of the following signs/symptoms?
- db_table: effect_subject_signsandsymptoms
- column: current_sx
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `cough`: *Cough*
  - `diarrhoea`: *Diarrhoea*
  - `double_vision`: *Double vision*
  - `drowsiness`: *Drowsiness*
  - `fever`: *Fever*
  - `focal_weakness`: *Focal weakness*
  - `headache`: *Headache*
  - `hearing_loss`: *Hearing loss*
  - `jaundice`: *Jaundice*
  - `nausea`: *Nausea*
  - `night_sweats`: *Night sweats*
  - `CN_VI_palsy_left`: *Neuro - Cranial Nerve VI palsy (left)*
  - `CN_VI_palsy_right`: *Neuro - Cranial Nerve VI palsy (right)*
  - `CN_VII_palsy_left`: *Neuro - Cranial Nerve VII palsy (left)*
  - `CN_VII_palsy_right`: *Neuro - Cranial Nerve VII palsy (right)*
  - `cn_palsy_left_other`: *Neuro - Other cranial nerve palsy (left), please specify below ...*
  - `cn_palsy_right_other`: *Neuro - Other cranial nerve palsy (right), please specify below ...*
  - `focal_seizures_left`: *Neuro - Focal seizures (left)*
  - `focal_seizures_right`: *Neuro - Focal seizures (right)*
  - `hemiplegia_left`: *Neuro - Hemiplegia (left)*
  - `hemiplegia_right`: *Neuro - Hemiplegia (right)*
  - `meningism`: *Neuro - Meningism*
  - `papilloedema`: *Neuro - Papilloedema*
  - `visual_field_disturbance`: *Neuro - Visual field disturbance*
  - `focal_neurologic_deficit_other`: *Neuro - Other focal neurologic deficit, please specify below ...*
  - `shortness_of_breath`: *Shortness of breath*
  - `skin_lesions`: *Skin lesions*
  - `visual_loss`: *Visual loss*
  - `vomiting`: *Vomiting*
  - `weight_loss`: *Weight loss*
  - `OTHER`: *Other sign(s)/symptom(s), please specify below ...*
---

**4.1.** If other, please specify ...

&nbsp;&nbsp;&nbsp;&nbsp; *If more than one, separate each with a comma (,).*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_other
- type: TextField
---

**5.0.** Are any of the signs or symptoms related to cryptococcal meningitis (CM)?
- db_table: effect_subject_signsandsymptoms
- column: cm_sx
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**6.0.** For these signs/symptoms, were any Grade 3 or above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.</br>*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_gte_g3
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `cough`: *Cough*
  - `diarrhoea`: *Diarrhoea*
  - `double_vision`: *Double vision*
  - `drowsiness`: *Drowsiness*
  - `fever`: *Fever*
  - `focal_weakness`: *Focal weakness*
  - `headache`: *Headache*
  - `hearing_loss`: *Hearing loss*
  - `jaundice`: *Jaundice*
  - `nausea`: *Nausea*
  - `night_sweats`: *Night sweats*
  - `CN_VI_palsy_left`: *Neuro - Cranial Nerve VI palsy (left)*
  - `CN_VI_palsy_right`: *Neuro - Cranial Nerve VI palsy (right)*
  - `CN_VII_palsy_left`: *Neuro - Cranial Nerve VII palsy (left)*
  - `CN_VII_palsy_right`: *Neuro - Cranial Nerve VII palsy (right)*
  - `cn_palsy_left_other`: *Neuro - Other cranial nerve palsy (left), please specify below ...*
  - `cn_palsy_right_other`: *Neuro - Other cranial nerve palsy (right), please specify below ...*
  - `focal_seizures_left`: *Neuro - Focal seizures (left)*
  - `focal_seizures_right`: *Neuro - Focal seizures (right)*
  - `hemiplegia_left`: *Neuro - Hemiplegia (left)*
  - `hemiplegia_right`: *Neuro - Hemiplegia (right)*
  - `meningism`: *Neuro - Meningism*
  - `papilloedema`: *Neuro - Papilloedema*
  - `visual_field_disturbance`: *Neuro - Visual field disturbance*
  - `focal_neurologic_deficit_other`: *Neuro - Other focal neurologic deficit, please specify below ...*
  - `shortness_of_breath`: *Shortness of breath*
  - `skin_lesions`: *Skin lesions*
  - `visual_loss`: *Visual loss*
  - `vomiting`: *Vomiting*
  - `weight_loss`: *Weight loss*
  - `OTHER`: *Other sign(s)/symptom(s), please specify below ...*
---

**6.1.** If other, please specify ...

&nbsp;&nbsp;&nbsp;&nbsp; *If more than one, separate each with a comma (,).*
- db_table: effect_subject_signsandsymptoms
- column: current_sx_gte_g3_other
- type: TextField
---

**Section: Additional details**

**7.0.** If participant currently has headache, for what duration have they had it for

&nbsp;&nbsp;&nbsp;&nbsp; *In days and/or hours.  Note: 1 day equivalent to 24 hours.</br> Format is `DDdHHh`, `DDd` or `HHh`. For example 1d23h, 15d9h ... or 20d, or 5h ...*
- db_table: effect_subject_signsandsymptoms
- column: headache_duration
- type: CharField
- length: 7
- responses: *free text*
---

**7.1.** If other cranial nerve palsy (left), please specify ...
- db_table: effect_subject_signsandsymptoms
- column: cn_palsy_left_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.2.** If other cranial nerve palsy (right), please specify ...
- db_table: effect_subject_signsandsymptoms
- column: cn_palsy_right_other
- type: CharField
- length: 35
- responses: *free text*
---

**7.3.** If other focal neurologic deficit, please specify ...
- db_table: effect_subject_signsandsymptoms
- column: focal_neurologic_deficit_other
- type: CharField
- length: 35
- responses: *free text*
---

**8.0.** If visual field loss, please provide details ...
- db_table: effect_subject_signsandsymptoms
- column: visual_field_loss
- type: TextField
---

**Section: Investigations**

**9.0.** Was an X-ray performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'Chest X-ray' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: xray_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**10.0.** Was a lumbar puncture performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'Lumbar Puncture/CSF' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: lp_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**11.0.** Was a urinary LAM performed?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete 'TB Diagnostics' CRF.*
- db_table: effect_subject_signsandsymptoms
- column: urinary_lam_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Reporting**

**12.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_signsandsymptoms
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**13.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_signsandsymptoms
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**Section: Calculated values**

**14.0.** calculated headache duration
- db_table: effect_subject_signsandsymptoms
- column: calculated_headache_duration
- type: DurationField
---

**Section: Action**

**15.0.** action identifier
- db_table: effect_subject_signsandsymptoms
- column: action_identifier
- type: CharField
- length: 50
- responses: *free text*
---

**16.0.** action item
- db_table: effect_subject_signsandsymptoms
- column: action_item
- type: ForeignKey
---

**17.0.** parent action item
- db_table: effect_subject_signsandsymptoms
- column: parent_action_item
- type: ForeignKey
---

**18.0.** related action item
- db_table: effect_subject_signsandsymptoms
- column: related_action_item
- type: ForeignKey
---


#### Significant Diagnoses
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_diagnoses
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_diagnoses
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Gastrointestinal side effects**

**3.0.** Has the participant experienced any gastrointestinal side effects?

&nbsp;&nbsp;&nbsp;&nbsp; *If YES, complete SAE report where appropriate*
- db_table: effect_subject_diagnoses
- column: gi_side_effects
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, please give details
- db_table: effect_subject_diagnoses
- column: gi_side_effects_details
- type: TextField
---

**Section: Diagnoses**

**5.0.** Are there any new significant diagnoses to report since last visit?
- db_table: effect_subject_diagnoses
- column: has_diagnoses
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** Please select all diagnoses that are relevant
- db_table: effect_subject_diagnoses
- column: diagnoses
- type: ManyToManyField
- responses: *Select all that apply*
  - `N/A`: *--Not applicable*
  - `bacteraemia`: *Bacteraemia*
  - `bacterial_pneumonia`: *Bacterial pneumonia*
  - `cm`: *Cryptococcal meningitis*
  - `diarrhoeal_wasting`: *Diarrhoeal wasting*
  - `kaposi_sarcoma`: *Kaposi’s sarcoma*
  - `malaria`: *Malaria*
  - `tb_extrapulmonary`: *TB extrapulmonary*
  - `tb_pulmonary`: *TB pulmonary*
  - `OTHER`: *Other, please specify below ...*
---

**6.1.** If other, please specify ...
- db_table: effect_subject_diagnoses
- column: diagnoses_other
- type: TextField
- length: 150
---

**Section: Reporting**

**7.0.** Are any of the above Grade 3 or above, and NEWLY reportable?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is NEWLY reportable (or present at baseline).<br/>If YES (and not baseline), complete AE Initial report.*
- db_table: effect_subject_diagnoses
- column: reportable_as_ae
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**8.0.** Has the participant been NEWLY admitted due to any of the above?

&nbsp;&nbsp;&nbsp;&nbsp; *Only answer YES if this is a NEW admission (or already admitted at baseline).<br/>If YES (and not baseline), complete Hospitalization and AE Initial reports.*
- db_table: effect_subject_diagnoses
- column: patient_admitted
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---


#### Chest X-Ray
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_chestxray
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_chestxray
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Chest x-ray**

**3.0.** Was a chest x-ray performed?
- db_table: effect_subject_chestxray
- column: chest_xray
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If YES, date performed?
- db_table: effect_subject_chestxray
- column: chest_xray_date
- type: DateField
- format: YYYY-MM-DD
---

**5.0.** If YES, indicate results?
- db_table: effect_subject_chestxray
- column: chest_xray_results
- type: ManyToManyField
- responses: *Select all that apply*
  - `NORMAL`: *Normal*
  - `lymphadenopathy`: *Lymphadenopathy*
  - `consolidation`: *Consolidation*
  - `miliary_tb`: *Miliary TB*
  - `infiltrates`: *Infiltrates*
  - `OTHER`: *Other, please specify below ...*
---

**5.1.** If other, please specify ...
- db_table: effect_subject_chestxray
- column: chest_xray_results_other
- type: TextField
---

**6.0.** Any additional comment
- db_table: effect_subject_chestxray
- column: comment
- type: TextField
---


#### Lumbar Puncture/Csf
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_lpcsf
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_lpcsf
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: LP**

**3.0.** Reason for LP
- db_table: effect_subject_lpcsf
- column: reason_for_lp
- type: CharField
- length: 50
- responses:
  - `scheduled_per_protocol`: *Scheduled per protocol*
  - `clincal_deterioration`: *Suspected Cryptococcal meningitis / Suspected IRIS*
---

**4.0.** LP Date and Time
- db_table: effect_subject_lpcsf
- column: lp_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**5.0.** Was the opening pressure measured
- db_table: effect_subject_lpcsf
- column: opening_pressure_measured
- type: CharField
- length: 25
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** opening pressure

&nbsp;&nbsp;&nbsp;&nbsp; *Units cm of H<sub>2</sub>O*
- db_table: effect_subject_lpcsf
- column: opening_pressure
- type: IntegerField
---

**7.0.** closing pressure

&nbsp;&nbsp;&nbsp;&nbsp; *Units cm of H<sub>2</sub>O*
- db_table: effect_subject_lpcsf
- column: closing_pressure
- type: IntegerField
---

**8.0.** CSF amount removed

&nbsp;&nbsp;&nbsp;&nbsp; *Units ml*
- db_table: effect_subject_lpcsf
- column: csf_amount_removed
- type: IntegerField
---

**Section: CSF**

**9.0.** CSF positive for cryptococcal meningitis?
- db_table: effect_subject_lpcsf
- column: csf_positive
- type: CharField
- length: 18
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `awaiting_results`: *Awaiting results*
---

**10.0.** india ink
- db_table: effect_subject_lpcsf
- column: india_ink
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**11.0.** CrAg LFA
- db_table: effect_subject_lpcsf
- column: csf_crag_lfa
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**12.0.** SQ CrAg
- db_table: effect_subject_lpcsf
- column: sq_crag
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**13.0.** SQ CrAg
- db_table: effect_subject_lpcsf
- column: sq_crag_pos
- type: CharField
- length: 15
- responses:
  - `high`: *High*
  - `low`: *Low*
  - `N/A`: *Not applicable*
---

**14.0.** Was the CRF CrAg titre done
- db_table: effect_subject_lpcsf
- column: crf_crag_titre_done
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** crf crag titre
- db_table: effect_subject_lpcsf
- column: crf_crag_titre
- type: IntegerField
---

**Section: CSF culture**

**16.0.** CSF Requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_lpcsf
- column: csf_requisition
- type: ForeignKey
---

**17.0.** CSF Result Report Date and Time
- db_table: effect_subject_lpcsf
- column: csf_culture_assay_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**18.0.** CSF Result: Other organism (non-Cryptococcus)

&nbsp;&nbsp;&nbsp;&nbsp; *Complete after getting the results.*
- db_table: effect_subject_lpcsf
- column: csf_culture
- type: CharField
- length: 18
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `awaiting_results`: *Awaiting results*
  - `not_done`: *Not done*
  - `N/A`: *Not applicable*
---

**19.0.** If YES, specify organism:
- db_table: effect_subject_lpcsf
- column: other_csf_culture
- type: CharField
- length: 75
- responses: *free text*
---

**20.0.** Total CSF WBC cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup>*
- db_table: effect_subject_lpcsf
- column: csf_wbc_cell_count
- type: IntegerField
---

**21.0.** Differential lymphocyte cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup> or %*
- db_table: effect_subject_lpcsf
- column: differential_lymphocyte_count
- type: IntegerField
---

**22.0.** differential lymphocyte unit
- db_table: effect_subject_lpcsf
- column: differential_lymphocyte_unit
- type: CharField
- length: 6
- responses:
  - `mm3`: *mm<sup>3</sup>*
  - `%`: *%*
---

**23.0.** Differential neutrophil cell count:

&nbsp;&nbsp;&nbsp;&nbsp; *acceptable units are mm<sup>3</sup> or %*
- db_table: effect_subject_lpcsf
- column: differential_neutrophil_count
- type: IntegerField
---

**24.0.** differential neutrophil unit
- db_table: effect_subject_lpcsf
- column: differential_neutrophil_unit
- type: CharField
- length: 6
- responses:
  - `mm3`: *mm<sup>3</sup>*
  - `%`: *%*
---

**25.0.** CSF glucose:

&nbsp;&nbsp;&nbsp;&nbsp; *Units in mmol/L or mg/dL*
- db_table: effect_subject_lpcsf
- column: csf_glucose
- type: DecimalField
---

**26.0.** CSF glucose units:
- db_table: effect_subject_lpcsf
- column: csf_glucose_units
- type: CharField
- length: 6
- responses:
  - `mg/dL`: *mg/dL*
  - `mmol/L`: *mmol/L (millimoles/L)*
---

**27.0.** CSF protein:

&nbsp;&nbsp;&nbsp;&nbsp; *Units in g/L*
- db_table: effect_subject_lpcsf
- column: csf_protein
- type: DecimalField
---

**28.0.** CSF CrAg:
- db_table: effect_subject_lpcsf
- column: csf_crag
- type: CharField
- length: 15
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `IND`: *Indeterminate*
---


#### Tb Diagnostics
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_tbdiagnostics
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_tbdiagnostics
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Urinary LAM**

**3.0.** Urinary LAM performed?
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** urinary lam date
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_date
- type: DateField
- format: YYYY-MM-DD
---

**5.0.** Urinary LAM result
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_result
- type: CharField
- length: 25
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---

**6.0.** If Urinary LAM is positive, grade
- db_table: effect_subject_tbdiagnostics
- column: urinary_lam_result_grade
- type: CharField
- length: 25
- responses:
  - `1`: *1+ (low)*
  - `2`: *2+*
  - `3`: *3+*
  - `4`: *4+*
  - `5`: *5+ (high)*
  - `unknown`: *Unknown / Grade not reported*
  - `N/A`: *Not applicable*
---

**Section: Sputum requisition**

**7.0.** Sputum requisition

&nbsp;&nbsp;&nbsp;&nbsp; *Start typing the requisition identifier or select one from this visit*
- db_table: effect_subject_tbdiagnostics
- column: sputum_requisition
- type: ForeignKey
---

**Section: Sputum Gene-Xpert**

**8.0.** Sputum Gene-Xpert performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**9.0.** Sputum Gene-Xpert date
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_date
- type: DateField
- format: YYYY-MM-DD
---

**10.0.** Sputum Gene-Xpert results
- db_table: effect_subject_tbdiagnostics
- column: sputum_genexpert_result
- type: CharField
- length: 45
- responses:
  - `POS`: *MTB Positive*
  - `NEG`: *MTB Negative*
  - `IND`: *Indeterminate*
  - `N/A`: *Not applicable*
---

**Section: Sputum culture**

**11.0.** Sputum culture performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_performed
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**12.0.** sputum culture date
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_date
- type: DateField
- format: YYYY-MM-DD
---

**13.0.** Sputum culture results
- db_table: effect_subject_tbdiagnostics
- column: sputum_culture_result
- type: CharField
- length: 10
- responses:
  - `POS`: *MTB Positive*
  - `NEG`: *MTB Negative*
  - `IND`: *Indeterminate / contaminated*
  - `N/A`: *Not applicable*
---

**Section: Sputum AFB**

**14.0.** Sputum AFB microscopy performed?
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_performed
- type: CharField
- length: 5
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
  - `N/A`: *Not applicable*
---

**15.0.** Sputum AFB date
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_date
- type: DateField
- format: YYYY-MM-DD
---

**16.0.** Sputum AFB results
- db_table: effect_subject_tbdiagnostics
- column: sputum_afb_result
- type: CharField
- length: 10
- responses:
  - `POS`: *Positive*
  - `NEG`: *Negative*
  - `N/A`: *Not applicable*
---

**Section: Comment**

**17.0.** Any additional comment
- db_table: effect_subject_tbdiagnostics
- column: comment
- type: TextField
---


#### Health Economics
*[missing model class docstring]*


*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_healtheconomics
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_healtheconomics
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Education**

**3.0.** What is your occupation/profession?
- db_table: effect_subject_healtheconomics
- column: occupation
- type: CharField
- length: 50
- responses: *free text*
---

**4.0.** How many years of education did you compete?
- db_table: effect_subject_healtheconomics
- column: education_years
- type: IntegerField
---

**5.0.** What is your highest education certificate?
- db_table: effect_subject_healtheconomics
- column: educational_attainment
- type: CharField
- length: 50
- responses:
  - `no_schooling_completed`: *No schooling completed*
  - `nursery_to_8th_grade`: *Nursery school to 8th grade*
  - `some_high_school_no_diploma`: *Some high school, no diploma*
  - `high_school_grad_diploma_or_equiv`: *High school graduate, diploma or the equivalent (for example: GED)*
  - `some_college_no_degree`: *Some college credit, no degree*
  - `trade_technical_vocational_training`: *Trade/technical/vocational training*
  - `associate_degree`: *Associate degree*
  - `bachelors_degree`: *Bachelor's degree*
  - `masters_degree`: *Master's degree*
  - `professional_degree`: *Professional degree*
  - `doctorate_degree`: *Doctorate degree*
---

**6.0.** Did you go to primary/elementary school?
- db_table: effect_subject_healtheconomics
- column: primary_school
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**7.0.** If YES, for how many years?
- db_table: effect_subject_healtheconomics
- column: primary_school_years
- type: IntegerField
---

**8.0.** Did you go to secondary school?
- db_table: effect_subject_healtheconomics
- column: secondary_school
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**9.0.** If YES, for how many years?
- db_table: effect_subject_healtheconomics
- column: secondary_school_years
- type: IntegerField
---

**10.0.** Did you go to higher education?
- db_table: effect_subject_healtheconomics
- column: higher_education
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**11.0.** If YES, for how many years?
- db_table: effect_subject_healtheconomics
- column: higher_education_years
- type: IntegerField
---

**Section: Income**

**12.0.** Do you receive any welfare or social service support?
- db_table: effect_subject_healtheconomics
- column: welfare
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**13.0.** What is the total income in your household per month?

&nbsp;&nbsp;&nbsp;&nbsp; *In rands or shillings*
- db_table: effect_subject_healtheconomics
- column: monthly_household_income
- type: IntegerField
---

**14.0.** Are you the person who earns the highest income in your household?
- db_table: effect_subject_healtheconomics
- column: highest_earner
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**15.0.** If NO, what is the profession of the person who earns the highest income?
- db_table: effect_subject_healtheconomics
- column: profession_highest_earner
- type: CharField
- length: 50
- responses: *free text*
---

**Section: General expenditure**

**16.0.** How much does your household spend on food in a month?

&nbsp;&nbsp;&nbsp;&nbsp; *In rands or shillings*
- db_table: effect_subject_healtheconomics
- column: food_month
- type: IntegerField
---

**17.0.** How much does your household spend on rent (or house loan/mortgage) and utilities in a month?

&nbsp;&nbsp;&nbsp;&nbsp; *In rands or shillings*
- db_table: effect_subject_healtheconomics
- column: accommodation_month
- type: IntegerField
---

**18.0.** How much have you spent on large items (e.g., furniture, electrical items, cars) in the last year?

&nbsp;&nbsp;&nbsp;&nbsp; *In rands or shillings*
- db_table: effect_subject_healtheconomics
- column: large_items_year
- type: IntegerField
---


#### Adherence: Day 14+
Adherence CRF completed after d14 (telephone).
*Instructions*: Please complete the form below. Required questions are in bold. When all required questions are complete click SAVE or, if available, SAVE NEXT. Based on your responses, additional questions may be required or some answers may need to be corrected.


**Section: Main**

**1.0.** subject visit
- db_table: effect_subject_adherence
- column: subject_visit
- type: OneToOneField
---

**2.0.** Report Date

&nbsp;&nbsp;&nbsp;&nbsp; *If reporting today, use today's date/time, otherwise use the date/time this information was reported.*
- db_table: effect_subject_adherence
- column: report_datetime
- type: DateTimeField
- format: YYYY-MM-DD HH:MM:SS.sss (tz=UTC)
---

**Section: Adherence counselling**

**3.0.** Has appropriate adherence counselling been given as per the trial SOP?
- db_table: effect_subject_adherence
- column: adherence_counselling
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**4.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: adherence_counselling_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**Section: Adherence summary**

**5.0.** Has the participant linked up with their local clinic?
- db_table: effect_subject_adherence
- column: linked_local_clinic
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**6.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: linked_local_clinic_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**7.0.** Is the participant receiving Fluconazole?
- db_table: effect_subject_adherence
- column: on_flucon
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**8.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: on_flucon_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**9.0.** Is the participant receiving ARVs?
- db_table: effect_subject_adherence
- column: on_arv
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**10.0.** If NO, please specify reason ...
- db_table: effect_subject_adherence
- column: on_arv_reason_no
- type: CharField
- length: 35
- responses: *free text*
---

**11.0.** In the clinician’s opinion, is the participant 90% adherent to fluconazole?
- db_table: effect_subject_adherence
- column: opinion_flucon_adherent
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**12.0.** In the clinician’s opinion, is the participant 90% adherent to ART?
- db_table: effect_subject_adherence
- column: opinion_arv_adherent
- type: CharField
- length: 15
- responses:
  - `Yes`: *Yes*
  - `No`: *No*
---

**13.0.** Medication adherence narrative:
- db_table: effect_subject_adherence
- column: adherence_narrative
- type: TextField
---


#### Requisitions



*Rendered on 2024-04-10 15:43*


