# Generated by Django 4.2.6 on 2024-03-01 16:31

from django.db import migrations
from django.db.migrations import RunPython
from tqdm import tqdm


def update_instance_model_names(apps, schema_editor):
    aka_consent_v1_model_names = [
        "effect_consent.subjectconsent",
        "effect_consent.subjectconsentug",
    ]
    consent_v1_model_name = "effect_consent.subjectconsentv1"
    print(
        "\nUpdating consent instances with outdated model names: "
        f"'{aka_consent_v1_model_names}' to '{consent_v1_model_name}' ..."
    )

    model_cls = apps.get_model("effect_consent.subjectconsent")
    total = model_cls.objects.count()
    update_count = 0
    skip_count = 0
    for obj in tqdm(model_cls.objects.all(), total=total):
        if obj.model_name in aka_consent_v1_model_names:
            print(
                f" * Updating '{obj.subject_identifier}' consent model name "
                f"from '{obj.model_name}' to '{consent_v1_model_name}'"
            )
            obj.model_name = consent_v1_model_name
            obj.save()
            update_count += 1
        else:
            print(
                f" * Skipping '{obj.subject_identifier}' "
                f"with consent model name '{obj.model_name}'"
            )
            skip_count += 1
    print(f"Updated {update_count} model names. Skipped {skip_count} model names.")


class Migration(migrations.Migration):

    dependencies = [
        ("effect_consent", "0018_alter_historicalsubjectconsent_options_and_more"),
    ]

    operations = [RunPython(update_instance_model_names)]
